# AltairCare - Healthcare AI WebApp

![AltairCare Logo](https://user-images.githubusercontent.com/83681204/132836093-c80aca67-b58d-420b-8155-23d1e54d46ac.jpg)

## Welcome to AltairCare!

Artificial intelligence is a rapidly advancing field that is revolutionizing various industries, including agriculture, banking, healthcare, and travel. In the healthcare sector, AI has garnered significant attention from tech giants like Microsoft, Google, Apple, and IBM. Why? Because AI simplifies the lives of patients, doctors, and hospital administrators by automating tasks traditionally performed by humans. This not only saves time but also reduces costs. AI also enables the delivery of medical services in remote and inaccessible areas and can diagnose diseases in their early stages, significantly improving the chances of recovery.

Introducing AltairCare, an innovative healthcare AI web application that leverages machine learning and deep learning algorithms to provide users with highly accurate disease prediction models. With AltairCare, users can assess their risk of developing various diseases, including:

- Liver Disease
- Pneumonia
- Kidney Disease
- Diabetes
- Stroke
- Heart Disease

![Disease Prediction](https://user-images.githubusercontent.com/83681204/132843407-0d59dca9-d0cc-4a3d-a75b-6d995aca761e.jpg)

## Explore Disease Pages

Each disease has its dedicated page within AltairCare, offering an overview of the condition, common symptoms, and detailed information about the prediction model, including the required input parameters.

### Disease Page:

![Disease Page](https://user-images.githubusercontent.com/83681204/159312257-c9382514-bf8a-4dd2-afc6-777e2e0f812d.png)

### Prediction Page:

![Prediction Page](https://user-images.githubusercontent.com/83681204/159312337-8a8f8932-473b-4c66-a7f2-c63f1b045c5b.png)

## Access the Data

All the datasets used to train our predictive models are available on Kaggle, ensuring transparency and reproducibility.

## Libraries Used

We have employed various powerful libraries to bring AltairCare to life:

- **Flask**: For robust backend web development.
- **Scikit-learn & TensorFlow**: For training the disease prediction models.
- **SQLAlchemy**: For efficient handling of SQLite databases.

## How to Run This Project

Want to try AltairCare locally? Follow these simple steps:

### Clone this Repository:

```sh
git clone https://github.com/vikasharma005/Healthcare_AI_WebApp.git
cd Healthcare-AI-WebApp
```

### Install Requirements:

```sh
pip install -r requirements.txt
```

### Start the Local Server:

```sh
python wsgi.py
```

AltairCare is not just a web app; it's a leap into the future of healthcare. Explore, predict, and empower yourself with the latest in AI-driven healthcare technology. Your well-being is just a click away!

## Author

<div id="header" align="center">
  <img src="https://media.giphy.com/media/M9gbBd9nbDrOTu1Mqx/giphy.gif" width="100"/>
</div>

<h3 align="center">Hi there 👋, I'm Vikas</h3>
<h4 align="center">Just learning New Skills😀</h4>

<div id="socials" align="center">
  <a href="https://www.linkedin.com/in/vikas-sharma005">
    <img src="https://user-images.githubusercontent.com/76098066/186728913-a66ef85f-4644-4e3a-b847-98309c8cff42.svg">
  </a>
  <a href="https://www.instagram.com/_thisisvikas">
    <img src="https://user-images.githubusercontent.com/76098066/186728908-f1a9919a-f4b2-4262-9515-683e77f8aabf.svg">
  </a>
  <a href="https://twitter.com/hitechvikas05">
    <img src="https://user-images.githubusercontent.com/76098066/186728901-a4d90f01-2cdf-45c1-a1b3-73467c3d2698.svg">
  </a>
</div>

You can find more about me and my projects on my [GitHub profile](https://github.com/vikasharma005).


***Disclaimer: AltairCare is designed for informational purposes only and should not be considered a substitute for professional medical advice or diagnosis. Always consult with a healthcare professional for any medical concerns.***
