# README

## Aprende Vim \(de la manera más inteligente\)

### ¿De qué trata esto?

Hay muchos lugares donde aprender a usar el editor Vim: la herramienta `vimtutor` es un buen lugar para comenzar y los manuales de la ayuda de Vim `:help` tienen todas las referencias que vayas a poder necesitar.

Sin embargo, el usuario o usuaria medio necesita algo más de lo que ofrece `vimtutor` y algo menos que el manual de `:help`. Esta guía trata de cerrar esa brecha destacando solo las funcionalidades más importantes para aprender las partes más útiles de Vim en el menor tiempo posible.

Esta guía está escrita tanto para principiantes como para personas que utilicen Vim de una manera más avanzada. Comienza con conceptos amplios y simples y acaba con conceptos específicos y avanzados. Si ya crees que eres una persona con conocimientos avanzados, te recomendaría que igualmente leyeras esta guía desde el principio hasta el fin, porque ¡aprenderás algo nuevo!

### ¿Cómo leer y seguir esta guía?

Para aprender a andar en bicicleta no sirve solo con leer cómo andar en bicicleta, hay que montarse en una y practicar. Para aprender sobre Vim pasa algo similar. No sirve solo con leer esta u otras guías, hay que practicar a la vez que lees.

Esta guía es mejor leerla y a la vez practicar los ejemplos, para interiorizar mejor el contenido de lo que se explica. Y practicando obtendremos los conocimientos de manera natural y progresiva. 

Puedes seguir esta guía clonando el [reposito de GitHub](https://github.com/victorhck/Aprende-Vim) en tu equipo y abriendo los artículos en formato MarkDown en el propio Vim o [en la web propia](https://victorhck.gitbook.io/aprende-vim/) en el navegador, mientras pruebas lo aprendido en Vim.

### Cómo surgió la idea

Es una traducción de la guía original en inglés creada por **Igor Irianto** que puedes encontrar en:
* [https://github.com/iggredible/Learn-Vim](https://github.com/iggredible/Learn-Vim) 

La idea que originó todo, fue la de traducir la guía del inglés al español para difundir y dar a conocer este potente editor de texto que es Vim. Además de interés personal de aprender más en profundidad este gran editor de texto.

Traducciones, correcciones y mejoras son bienvenidas. No dudes en hacer un PR o abrir un _issue_ en el repositorio en [GitHub.](https://github.com/victorhck/Aprende-Vim/)

Además de esta extensa guía, también he creado __otros materiales relacionados con Vim__, como:

* [Estos artículos sobre Vim en mi blog](https://victorhckinthefreeworld.com/tag/vim/)
* [Guía de consulta rápida sobre Vim](https://victorhck.gitlab.io/comandos_vim/articulos.html)

## Índice de contenidos

#### Prólogo

* [Cap 0     - Lee esto primero](cap00_lee_esto_primero.md)

#### Parte 1: Aprendiendo Vim de la manera más inteligente

* [Cap 1  - Arrancando Vim](cap01_empezando_en_vim.md)
* [Cap 2  - _Buffers_, ventanas y pestañas](cap02_buffers_ventanas_pestanas.md)
* [Cap 3  - Abriendo y buscando archivos](cap03_abriendo_y_buscando_archivos.md)
* [Cap 4  - La gramática de Vim](cap04_gramatica_vim.md)
* [Cap 5  - Moviéndote en un archivo](cap05_moviendote_en_un_archivo.md)
* [Cap 6  - El modo insertar](cap06_modo_insertar.md)
* [Cap 7  - El comando del punto](cap07_el_comando_del_punto.md)
* [Cap 8  - Registros](cap08_registros.md)
* [Cap 9  - Macros](cap09_macros.md)
* [Cap 10 - Deshacer](cap10_deshacer.md)
* [Cap 11 - El modo visual](cap11_modo_visual.md)
* [Cap 12 - Buscar y sustituir](cap12_buscar_y_sustituir.md)
* [Cap 13 - El comando global](cap13_el_comando_global.md)
* [Cap 14 - Comandos externos](cap14_comandos_externos.md)
* [Cap 15 - El modo de línea de comandos](cap15_modo_linea_comandos.md)
* [Cap 16 - Etiquetas](cap16_etiquetas.md)
* [Cap 17 - Plegado de texto (Fold)](cap17_plegado.md)
* [Cap 18 - Git](cap18_git.md)
* [Cap 19 - Compilar](cap19_compilar.md)
* [Cap 20 - Vistas, sesiones y Viminfo](cap20_vistas_sesiones_viminfo.md)
* [Cap 21 - Operaciones en múltiples archivos](cap21_operaciones_múltiples_archivos.md)
* [Cap 22 - Vimgrep](cap22_vimgrep.md)

#### Parte 2: Personaliza Vim de la manera más inteligente

* [Cap 23 - Vimrc](cap23_vimrc.md)
* [Cap 24 - El gestor de complementos de Vim](cap24_paquetes_vim.md)
* [Cap 25 - Ejecutables en Vim](cap25_ejecutables_vim.md)

#### Parte 3: Aprende Vimscript de la manera más inteligente

* [Cap 26 - Tipos básicos de datos en Vimscript](cap26_tipos_basicos_datos_en_vimscript.md)
* [Cap 27 - Condicionales y bucles en Vimscript](cap27_condicionales_y_bucles_vimscript.md)
* [Cap 28 - Ámbito de las variables en Vimscript](cap28_ambito_variables_vimscript.md)
* [Cap 29 - Funciones en Vimscript](cap29_funciones_vimscript.md)
* [Cap 30 - Ejemplo de cómo escribir tu propio complemento en Vim](cap30_ejemplo_cómo_escribir_un_complemento.md)

## Licencia y derechos de autor

El materia original en inglés es autoría de ©2020-2021 [Igor Irianto.](https://github.com/iggredible/Learn-Vim) publicado bajo una licencia [Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International](http://creativecommons.org/licenses/by-nc-sa/4.0/).

La traducción en español, es mía junto con las [diferentes personas](https://github.com/victorhck/learn-Vim-es/graphs/contributors) que colaboren en este repositorio. Al colaborar en este repositorio estás de acuerdo en compartir tu trabajo con la licencia utilizada para el repositorio completo.

Si creas tu propia versión utilizando esta traducción, por favor da crédito al repositorio desde el que creas tu versión para respetar la licencia:

Este trabajo está publicado bajo una licencia [Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International](http://creativecommons.org/licenses/by-nc-sa/4.0/).

## Colaborar

Si esta guía te ha resultado de utilidad, puedes invitarme a una cerveza 🍺 como agradecimiento ❤️ por los más de 500 _commits_ e incontables horas en la traducción de esta guía y en las correcciones y mejoras aportadas a la guía en inglés:

* [LiberaPay](https://liberapay.com/victorhck)
