# Contributing to Vespper

Hey there! Thanks for considering a contribution to Vespper! We really appreciate it, you're awesome! ❤️

Here’s how you can help out:

1. Submit and Vote on Ideas: Share your cool ideas and vote on others.
2. Create and Comment on Issues: Jump into discussions and help solve problems.
3. Open a Pull Request (PR): We love seeing your GitHub pull requests.

This guide will walk you through our development process, where to get help and other handy resources. We want to make it easy for you to get involved, whether it’s updating our docs, improving the app, or fixing some bugs.

Got questions? We are hanging out on [Slack](https://join.slack.com/t/vesppercommunity/signup), ready to help.

If you’re short on time for coding, no worries! You can still support Vespper in other ways:

- ⭐ Star the project on GitHub
- 🐦 Tweet about us
- 📄 Mention Vespper in your project’s readme
- 💡 Submit and vote on Ideas
- 📝 Create and comment on Issues
- 🗣️ Talk about us at local meetups or with friends and colleagues

Every bit of support helps us grow. Thanks a ton!

## Table of Contents

- [Making a change](#making-a-change)
- [Overview](#overview)
  - [Architecture](#architecture)
  - [Database](#database)
  - [Authentication](#authentication)
  - [Repository Structure](#repository-structure)
- [Development Setup](#development-setup)
  - [Prerequisites](#prerequisites)
  - [Using the environment](#using-the-environment)
- [Conventions](#conventions)
  - [Code style](#code-style)
  - [Commit messages](#commit-messages)

## Making a change

Before diving into changes, it’s a good idea to open an issue first. Discussing your ideas beforehand helps everyone stay on the same page.

Once we've talked it over and your code is ready, make sure all the tests pass, and then open your pull request.

A good starting point is to check out the open issues. Look for the "good first issue" label for some easier stuff to tackle first.

## Overview

This section contains some high-level information about the project.

### Architecture

Here is a diagram that shows the high-level architecture.

<div align="center">
    <img src="./assets/architecture.jpg" alt="Architecture" />
</div>

### Database

We use MongoDB as our main database, and mongoose as our ORM. These are the main schemas we have right now:

- User
- Organization
- Vendor
- Integration
- Webhook
- Index

To view more details about the DB schemas, go to the `packages/db` folder.

### Authentication

We use the open-source [Ory Stack](https://www.ory.sh/) to authenticate requests to our API. For more information about Ory, visit the [official docs](https://www.ory.sh/docs/welcome).

### Repository Structure

We work in a monorepo manner using [yarn](https://yarnpkg.com/) and [nx](https://nx.dev/) to manage the dependencies and build process. The main folders are `services` and `packages`.

**Packages**

- `db` - contains all the db schemas and models
- `utils` - contains re-useable code that is shared between services.
- `scripts` - contains some helpful TypeScript scripts that we can use.

**Services**

- `api` - the main service. Contains our REST API, with the logic of incident analysis.
- `slackbot` - the slackbot code. Contains the logic of our Slack app.
- `dashboard` - the web ui code. Contains the code of the web app, which allows users to configure their organization.
- `data-processor` - contains the data processor code. This service is used to build the knowledge base that is needed in order to perform an extensive investigation with rich context.
- `log-parser` - performs simple log aggregation/clustering.

**Other important folders/files**

- `.github` - contains our CI code
- `config` - contains some config files for some of the base services (ory kratos, vault, postgres)
- `docker-compose.yml` - the main file which spins up the system. It uses a main `.env` (that is generated by `.env.example`) and propagate some of the values to the underlying services.

## Development Setup

### Prerequisites

To work on Vespper, you need to have the following pieces of software:

- **Docker & Docker Compose** - The app works with Docker containers. To run it, you need to have [Docker Desktop](https://docs.docker.com/desktop/), which comes with Docker CLI, Docker Engine and Docker Compose.
- **NVM** - [NVM](https://github.com/nvm-sh/nvm) is node version manager. It makes installing Node.js super easy and allows to jump between versions on the same machine.
- **Node.js** - The Node.js runtime. We use version 20.11.1 at the moment. After you install nvm, please run `nvm install 20.11.1` and then `nvm use 20.11.1`.
- **Yarn** - Yarn is our package manager. Head over to [the docs](https://classic.yarnpkg.com/lang/en/docs/install/#mac-stable) to install yarn globall.
- **Nx CLI** - We use Nx as our monorepo manager tool. It's responsible for running CI/build jobs. Install the CLI globally by running this command: `yarn global add nx@latest`

Additionally, if you want to work on our Python services (currently only the `data-processor`), you'd need to have the following things:

- **pyenv** - The famous Python version manager. It's like NVM but for Python. Head over to [the docs](https://github.com/pyenv/pyenv?tab=readme-ov-file#automatic-installer) and install it. We recommend using their automatic installer script.
- **python** - Python runtime. We use version 3.10.5. Once you install pyenv, run `pyenv install 3.10.5`.
- **poetry** - Poetry package manager. Head over to [the docs](https://python-poetry.org/docs/#installing-with-the-official-installer) to see how to install. We recommend installing it using the automatic installer.

### Using the environment

1. Install dependencies:
   ```bash
   yarn install
   ```
2. Create a `.env` file as described in the [quickstart guide](https://github.com/vespperhq/vespper?tab=readme-ov-file#quick-installation-%EF%B8%8F).
3. Run the infrastructure services using docker:
   ```bash
   docker compose --profile infra up
   ```
4. Run the dev jobs of the services. For example:
   ```bash
   nx dev api
   ```
   Alternatively:
   ```bash
   nx dev dashboard
   nx dev slackbot
   nx dev data-processor
   nx dev log-parser
   ```

That's it. Now you can make changes and work with the code. If you have any problems, please write to us on Slack, in #tech-support. The different ports are listed in the `.env` file.

### Debugging

Sometimes, you might want to debug a service using a debugger. In that case, you can use our VS Code configuration.

Simply go to your Run and Debug tab, select the service you want to debug (API: Debug, Slackbot: Debug, etc.) and hit the green play button.

### Switching between Docker containers & local code

Sometimes you'd want some of the services to run in docker compose, while others will run locally (e.g. Slackbot).

To switch between the two, you can simply stop the docker contaienr and run `nx dev <service>`. Our reverse proxy (envoy) takes care
of routing the requests to the available service (either locally or in docker).

## Conventions

### Code style

We use [prettier](https://prettier.io/) as our code style formatter.

### Commit messages

On the main branch, we follow [conventional commits](https://www.conventionalcommits.org/en/v1.0.0/). All pull requests and branches are squash-merged to maintain a clean and readable history. This approach ensures the addition of a conventional commit message when merging contributions.
