## PyTorch Learning - Jupyter Notebooks

### Table of Contents
- [Basics](#pytorch-basics)
- [Vision](#visionimage-ml-models)
- [Audio](#audio)
- [Optimizations & Distributed Training](#optimizations--distributed-training)

### PyTorch Basics

- [PyTorch internals](http://blog.ezyang.com/2019/05/pytorch-internals/)

|Topic|Name|Description|
|---|---|---|---|
|Basics|[Tensor Operations](1-basics/1-tensor-operations.ipynb)|?|
|Basics|[Autograd 1](1-basics/2-autograd.ipynb) & [Autograd 2](1-basics/3-autograd-in-training.ipynb)|?|
|Basics|[Build Neural Networks from Scratch - 1](1-basics/5-nn-from-scratch.py)|?|
|Basics|[Build Neural Networks from Scratch - 2](1-basics/6-nn-without-torch.nn.ipynb)|?|
|Basics|[Datasets & Dataloaders](1-basics/9-datasets-dataloaders.ipynb)|?|
|Basics|[Build Neural Networks - Sample 1](1-basics/10-build-nn-sample1.ipynb)|?|
|Basics|[Build Neural Networks - Sample 2](1-basics/11-build-nn-sample2.ipynb)|?|
|Basics|[Build Neural Networks - FashionMNIST - Sample 1](1-basics/12-build-nn-fashion-dataset-1.ipynb)|?|
|Basics|[Build Neural Networks - FashionMNIST - Sample 2](1-basics/13-build-nn-fashion-dataset-2.ipynb)|?|
|Basics|[Dense Neural Network](1-basics/14-dense-nn.ipynb)|?|

### Vision/Image ML Models

-[How to visualise filters in a CNN with PyTorch](https://stackoverflow.com/questions/55594969/how-to-visualise-filters-in-a-cnn-with-pytorch)

- [Clothing Dataset](https://github.com/alexeygrigorev/clothing-dataset)
- [MS COCO Dataset](https://huggingface.co/datasets/ChristophSchuhmann/MS_COCO_2017_URL_TEXT)

|Topic|Name|Description|
|---|---|---|---|
|Vision|[CNN (Convolution Neural Network) - CIFAR10 Dataset](2-vision/1-cnn-cifar10.ipynb)|?|
|Vision|[CNN (Convolution Neural Network) - FashionMNIST Dataset](2-vision/2-cnn-fashion-mnist.ipynb)|?|
|Vision|[Transfer Learning - Computer Vision](2-vision/4-transfer-learning-computer-vision.ipynb)|?|
|Vision|[Object Detection](2-vision/5-object-detection-transfer-learning.ipynb)|?|
|Vision|[Image Segmentation](2-vision/6-image-segmentation-transfer-learning.ipynb)|?|
|Vision|[MultiOutput CNN](2-vision/10-multioutput-cnn-in-pytorch.ipynb)|?|
|Vision|[Vision Transformer - Timm Model](2-vision/15-vision-transformer-timm.ipynb)|?|
|Vision|[FLAVA Multimodal - Vision Q&A](2-vision/16-vision-qa-multimodal-FLAVA.ipynb)|?|

### Audio

|Topic|Name|Description|
|---|---|---|---|
|Audio|[Introduction to Spectrogram](3-audio/1-intro-to-spectogram.ipynb)|?|
|Audio|[Audio Manipulation with Torchaudio](3-audio/2-audio-manipulation-with-torchaudio.ipynb)|?|
|Audio|[Audio Classification](3-audio/3-audio-classification.ipynb)|?|
|Audio|[Audio Transcription](3-audio/4-audio-transcription.ipynb)|?|
|Audio|[Speech Recognition with Wav2Vec2](3-audio/5-speech-recognition-with-wav2Vec2.ipynb)|?|

### External Audio Colab Notebooks

- TorchAudio's I/O: Inspect audio data, load them into PyTorch Tensors and save PyTorch Tensors: https://colab.research.google.com/github/pytorch/audio/blob/gh-pages/main/_downloads/4d63e50ab0e70c0e96fd6641e0823ce8/audio_io_tutorial.ipynb
- Speech Recognition with Wav2Vec2: https://colab.research.google.com/github/pytorch/audio/blob/gh-pages/main/_downloads/ca83af2ea8d7db05fb63211d515b7fde/speech_recognition_pipeline_tutorial.ipynb
- OpenAI Whishper Model on LibriSpeech dataset: https://colab.research.google.com/github/openai/whisper/blob/master/notebooks/LibriSpeech.ipynb

### Optimizations & Distributed Training

|Topic|Name|Description|
|---|---|---|---|
|Optimizations|[Tensor RT](4-optimizations/1-tensorrt.ipynb)|?|
|Optimizations|[Optimizing Vision Transformer](4-optimizations/2-optimizing-vision-transformer-for-deployment.ipynb)|?|
||[Quantized Transfer Learning](4-optimizations/3-quantized_transfer_learning.ipynb)|?|

- Data Parallel Training: https://colab.research.google.com/github/pytorch/tutorials/blob/gh-pages/_downloads/8976a0b7cba4d8c4bc2a28205b91a7da/ddp_pipeline.ipynb
- Model Parallel Training: https://colab.research.google.com/github/pytorch/tutorials/blob/gh-pages/_downloads/03a48646520c277662581e858e680809/model_parallel_tutorial.ipynb

### Weights & Biases

- Weights & Biases: https://colab.research.google.com/github/wandb/examples/blob/master/colabs/pytorch/Simple_PyTorch_Integration.ipynb


