<?php

declare(strict_types=1);

use App\Models\NotificationStream;

it('returns true if stream type is email', function (): void {
    $notificationStream = NotificationStream::factory()->email()->create();
    expect($notificationStream->isEmail())->toBeTrue();
});

it('returns false if the stream type is not email', function (): void {
    $notificationStream = NotificationStream::factory()->discord()->create();
    expect($notificationStream->isEmail())->toBeFalse();
});

it('returns true if stream type is discord', function (): void {
    $notificationStream = NotificationStream::factory()->discord()->create();
    expect($notificationStream->isDiscord())->toBeTrue();
});

it('returns false if the stream type is not discord', function (): void {
    $notificationStream = NotificationStream::factory()->email()->create();
    expect($notificationStream->isDiscord())->toBeFalse();
});

it('returns true if stream type is slack', function (): void {
    $notificationStream = NotificationStream::factory()->slack()->create();
    expect($notificationStream->isSlack())->toBeTrue();
});

it('returns false if the stream type is not slack', function (): void {
    $notificationStream = NotificationStream::factory()->email()->create();
    expect($notificationStream->isSlack())->toBeFalse();
});

it('returns true if stream type is teams', function (): void {
    $notificationStream = NotificationStream::factory()->teams()->create();
    expect($notificationStream->isTeams())->toBeTrue();
});

it('returns false if the stream type is not teams', function (): void {
    $notificationStream = NotificationStream::factory()->email()->create();
    expect($notificationStream->isTeams())->toBeFalse();
});

it('returns true if stream type is pushover', function (): void {
    $notificationStream = NotificationStream::factory()->pushover()->create();
    expect($notificationStream->isPushover())->toBeTrue();
});

it('returns false if the stream type is not pushover', function (): void {
    $notificationStream = NotificationStream::factory()->email()->create();
    expect($notificationStream->isPushover())->toBeFalse();
});

it('returns correct formatted type for email', function (): void {
    $notificationStream = NotificationStream::factory()->email()->create();
    expect($notificationStream->formatted_type)->toBe('Email');
});

it('returns correct formatted type for discord', function (): void {
    $notificationStream = NotificationStream::factory()->discord()->create();
    expect($notificationStream->formatted_type)->toBe('Discord Webhook');
});

it('returns true if stream type is telegram', function (): void {
    $notificationStream = NotificationStream::factory()->telegram()->create();
    expect($notificationStream->isTelegram())->toBeTrue();
});

it('returns false if the stream type is not telegram', function (): void {
    $notificationStream = NotificationStream::factory()->email()->create();
    expect($notificationStream->isTelegram())->toBeFalse();
});

it('returns correct formatted type for slack', function (): void {
    $notificationStream = NotificationStream::factory()->slack()->create();
    expect($notificationStream->formatted_type)->toBe('Slack Webhook');
});

it('returns correct formatted type for microsoft teams', function (): void {
    $notificationStream = NotificationStream::factory()->teams()->create();
    expect($notificationStream->formatted_type)->toBe('Teams Webhook');
});

it('returns correct formatted type for pushover', function (): void {
    $notificationStream = NotificationStream::factory()->pushover()->create();
    expect($notificationStream->formatted_type)->toBe('Pushover');
});

it('returns correct formatted type for telegram', function (): void {
    $notificationStream = NotificationStream::factory()->telegram()->create();
    expect($notificationStream->formatted_type)->toBe('Telegram');
});

it('returns correct type icon for email', function (): void {
    $notificationStream = NotificationStream::factory()->email()->create();
    expect($notificationStream->type_icon)->toBe('M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z');
});

it('returns correct type icon for discord', function (): void {
    $notificationStream = NotificationStream::factory()->discord()->create();
    expect($notificationStream->type_icon)->toBe('M20.317 4.3698a19.7913 19.7913 0 00-4.8851-1.5152.0741.0741 0 00-.0785.0371c-.211.3753-.4447.8648-.6083 1.2495-1.8447-.2762-3.68-.2762-5.4868 0-.1636-.3933-.4058-.8742-.6177-1.2495a.077.077 0 00-.0785-.037 19.7363 19.7363 0 00-4.8852 1.515.0699.0699 0 00-.0321.0277C.5334 9.0458-.319 13.5799.0992 18.0578a.0824.0824 0 00.0312.0561c2.0528 1.5076 4.0413 2.4228 5.9929 3.0294a.0777.0777 0 00.0842-.0276c.4616-.6304.8731-1.2952 1.226-1.9942a.076.076 0 00-.0416-.1057c-.6528-.2476-1.2743-.5495-1.8722-.8923a.077.077 0 01-.0076-.1277c.1258-.0943.2517-.1923.3718-.2914a.0743.0743 0 01.0776-.0105c3.9278 1.7933 8.18 1.7933 12.0614 0a.0739.0739 0 01.0785.0095c.1202.099.246.1981.3728.2924a.077.077 0 01-.0066.1276 12.2986 12.2986 0 01-1.873.8914.0766.0766 0 00-.0407.1067c.3604.698.7719 1.3628 1.225 1.9932a.076.076 0 00.0842.0286c1.961-.6067 3.9495-1.5219 6.0023-3.0294a.077.077 0 00.0313-.0552c.5004-5.177-.8382-9.6739-3.5485-13.6604a.061.061 0 00-.0312-.0286zM8.02 15.3312c-1.1825 0-2.1569-1.0857-2.1569-2.419 0-1.3332.9555-2.4189 2.157-2.4189 1.2108 0 2.1757 1.0952 2.1568 2.419 0 1.3332-.9555 2.4189-2.1569 2.4189zm7.9748 0c-1.1825 0-2.1569-1.0857-2.1569-2.419 0-1.3332.9554-2.4189 2.1569-2.4189 1.2108 0 2.1757 1.0952 2.1568 2.419 0 1.3332-.946 2.4189-2.1568 2.4189Z');
});

it('returns correct type icon for slack', function (): void {
    $notificationStream = NotificationStream::factory()->slack()->create();
    expect($notificationStream->type_icon)->toBe('M5.042 15.165a2.528 2.528 0 0 1-2.52 2.523A2.528 2.528 0 0 1 0 15.165a2.527 2.527 0 0 1 2.522-2.52h2.52v2.52zM6.313 15.165a2.527 2.527 0 0 1 2.521-2.52 2.527 2.527 0 0 1 2.521 2.52v6.313A2.528 2.528 0 0 1 8.834 24a2.528 2.528 0 0 1-2.521-2.522v-6.313zM8.834 5.042a2.528 2.528 0 0 1-2.521-2.52A2.528 2.528 0 0 1 8.834 0a2.528 2.528 0 0 1 2.521 2.522v2.52H8.834zM8.834 6.313a2.528 2.528 0 0 1 2.521 2.521 2.528 2.528 0 0 1-2.521 2.521H2.522A2.528 2.528 0 0 1 0 8.834a2.528 2.528 0 0 1 2.522-2.521h6.312zM18.956 8.834a2.528 2.528 0 0 1 2.522-2.521A2.528 2.528 0 0 1 24 8.834a2.528 2.528 0 0 1-2.522 2.521h-2.522V8.834zM17.688 8.834a2.528 2.528 0 0 1-2.523 2.521 2.527 2.527 0 0 1-2.52-2.521V2.522A2.527 2.527 0 0 1 15.165 0a2.528 2.528 0 0 1 2.523 2.522v6.312zM15.165 18.956a2.528 2.528 0 0 1 2.523 2.522A2.528 2.528 0 0 1 15.165 24a2.527 2.527 0 0 1-2.52-2.522v-2.522h2.52zM15.165 17.688a2.527 2.527 0 0 1-2.52-2.523 2.526 2.526 0 0 1 2.52-2.52h6.313A2.527 2.527 0 0 1 24 15.165a2.528 2.528 0 0 1-2.522 2.523h-6.313z');
});

it('returns correct type icon for teams', function (): void {
    $notificationStream = NotificationStream::factory()->teams()->create();
    expect($notificationStream->type_icon)->toBe('M 12.5 2 A 3 3 0 0 0 9.7089844 6.09375 C 9.4804148 6.0378189 9.2455412 6 9 6 L 4 6 C 2.346 6 1 7.346 1 9 L 1 14 C 1 15.654 2.346 17 4 17 L 9 17 C 10.654 17 12 15.654 12 14 L 12 9 C 12 8.6159715 11.921192 8.2518913 11.789062 7.9140625 A 3 3 0 0 0 12.5 8 A 3 3 0 0 0 12.5 2 z M 19 4 A 2 2 0 0 0 19 8 A 2 2 0 0 0 19 4 z M 4.5 9 L 8.5 9 C 8.776 9 9 9.224 9 9.5 C 9 9.776 8.776 10 8.5 10 L 7 10 L 7 14 C 7 14.276 6.776 14.5 6.5 14.5 C 6.224 14.5 6 14.276 6 14 L 6 10 L 4.5 10 C 4.224 10 4 9.776 4 9.5 C 4 9.224 4.224 9 4.5 9 z M 15 9 C 14.448 9 14 9.448 14 10 L 14 14 C 14 16.761 11.761 19 9 19 C 8.369 19 8.0339375 19.755703 8.4609375 20.220703 C 9.4649375 21.313703 10.903 22 12.5 22 C 15.24 22 17.529453 20.040312 17.939453 17.320312 C 17.979453 17.050312 18 16.78 18 16.5 L 18 11 C 18 9.9 17.1 9 16 9 L 15 9 z M 20.888672 9 C 20.322672 9 19.870625 9.46625 19.890625 10.03125 C 19.963625 12.09325 20 16.5 20 16.5 C 20 16.618 19.974547 16.859438 19.935547 17.148438 C 19.812547 18.048438 20.859594 18.653266 21.558594 18.072266 C 22.439594 17.340266 23 16.237 23 15 L 23 11 C 23 9.9 22.1 9 21 9 L 20.888672 9 z');
});

it('returns correct type icon for pushover', function (): void {
    $notificationStream = NotificationStream::factory()->pushover()->create();
    expect($notificationStream->type_icon)->toBe('M11.6685 21.0473c5.2435.1831 9.6426-3.9191 9.8257-9.1627.1831-5.24355-3.9191-9.64267-9.1626-9.82578-5.24355-.18311-9.64265 3.91918-9.82576 9.16268-.18311 5.2435 3.91916 9.6427 9.16266 9.8258zM11.8206 8.47095l1.9374-.1867-2.0265 4.17345c.331-.0144.6576-.1144.9816-.3018.324-.1873.6257-.4274.9014-.7186.2775-.291.5191-.6168.7267-.9791.2075-.3603.3593-.7189.457-1.0701.0577-.2189.0892-.4295.0926-.6317s-.0442-.3822-.1409-.5378c-.0967-.1556-.2463-.2834-.4508-.3833-.2044-.1-.4828-.1561-.8389-.1686-.4153-.0145-.8256.038-1.2309.1594-.4071.1213-.7848.3049-1.1369.5507-.352.2458-.66.5562-.9274.933-.2676.3769-.4646.8082-.5911 1.2939-.0483.1598-.0768.2869-.0895.3849s-.0174.1776-.014.2408c.0015.0632.009.1136.0208.1474.0119.0339.0218.0676.028.1031-.4321-.015-.7443-.1132-.9366-.2926-.1924-.1794-.23-.4852-.1149-.9119.1177-.4452.3625-.8637.7364-1.2572.374-.3936.8129-.73655 1.3188-1.02705.5059-.29055 1.0559-.51825 1.6501-.67945.5942-.1612 1.1704-.2321 1.7285-.2126.4914.0172.9006.102 1.2295.2527.329.1508.5839.3453.7614.5799.1775.2346.2849.5057.3207.8114.0358.3057.0099.6223-.0777.9497-.1066.3936-.2967.7879-.5685 1.18135s-.609.7455-1.0079 1.0565c-.4008.3128-.8551.5605-1.3666.7469-.5096.1846-1.049.2679-1.6164.248l-.0631-.0022-1.7377 3.5597-1.82655-.0638z');
});

it('returns correct type icon for telegram', function (): void {
    $notificationStream = NotificationStream::factory()->telegram()->create();
    expect($notificationStream->type_icon)->toBe('M 18.632812 1.714844 L 0.519531 8.722656 C 0.507812 8.726562 0.5 8.730469 0.488281 8.738281 C 0.34375 8.820312 -0.683594 9.445312 0.761719 10.007812 L 0.777344 10.015625 L 5.089844 11.40625 C 5.15625 11.429688 5.230469 11.421875 5.289062 11.382812 L 15.984375 4.710938 C 16.011719 4.695312 16.042969 4.683594 16.070312 4.675781 C 16.222656 4.652344 16.648438 4.605469 16.378906 4.949219 C 16.070312 5.339844 8.765625 11.890625 7.953125 12.617188 C 7.90625 12.65625 7.878906 12.714844 7.875 12.777344 L 7.519531 16.996094 C 7.519531 17.085938 7.558594 17.167969 7.628906 17.21875 C 7.730469 17.28125 7.859375 17.273438 7.949219 17.195312 L 10.511719 14.902344 C 10.59375 14.828125 10.71875 14.824219 10.808594 14.890625 L 15.28125 18.132812 L 15.292969 18.144531 C 15.402344 18.210938 16.570312 18.890625 16.910156 17.371094 L 19.996094 2.699219 C 20 2.652344 20.042969 2.140625 19.675781 1.839844 C 19.292969 1.523438 18.75 1.683594 18.667969 1.699219 C 18.65625 1.703125 18.644531 1.707031 18.632812 1.714844 Z M 18.632812 1.714844');
});

it('returns default type icon for unknown type', function (): void {
    $notificationStream = NotificationStream::factory()->create(['type' => 'unknown']);
    expect($notificationStream->type_icon)->toBe('M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-6h2v6zm0-8h-2V7h2v2z');
});

it('returns true when successful backup notifications are enabled', function (): void {
    $notificationStream = NotificationStream::factory()->successEnabled()->create();

    expect($notificationStream->hasSuccessfulBackupNotificationsEnabled())->toBeTrue();
});

it('returns false when successful backup notifications are disabled', function (): void {
    $notificationStream = NotificationStream::factory()->successDisabled()->create();

    expect($notificationStream->hasSuccessfulBackupNotificationsEnabled())->toBeFalse();
});

it('returns true when failed backup notifications are enabled', function (): void {
    $notificationStream = NotificationStream::factory()->failureEnabled()->create();

    expect($notificationStream->hasFailedBackupNotificationsEnabled())->toBeTrue();
});

it('returns false when failed backup notifications are disabled', function (): void {
    $notificationStream = NotificationStream::factory()->failureDisabled()->create();

    expect($notificationStream->hasFailedBackupNotificationsEnabled())->toBeFalse();
});
