![Vanguard Backup Banner](https://raw.githubusercontent.com/vanguardbackup/assets/main/git-banner.png)

<p align="center">
  <a href="https://opensource.org/license/agpl-v3">
    <img src="https://img.shields.io/github/license/vanguardbackup/vanguard?style=for-the-badge&logo=opensourceinitiative&logoColor=ffffff" alt="License: AGPLv3">
  </a>
  <a href="https://github.com/vanguardbackup/vanguard/actions/workflows/main-ci.yml">
    <img src="https://img.shields.io/github/actions/workflow/status/vanguardbackup/vanguard/main-ci.yml?style=for-the-badge&logo=githubactions&logoColor=ffffff&label=CI%20Pipeline" alt="CI Pipeline">
  </a>
  <a href="https://github.com/vanguardbackup/vanguard/releases">
    <img src="https://img.shields.io/github/v/release/vanguardbackup/vanguard?style=for-the-badge&logo=github&logoColor=ffffff" alt="GitHub Release">
  </a>
  <a href="https://laravel.com">
    <img src="https://img.shields.io/badge/laravel-%23FF2D20.svg?style=for-the-badge&logo=laravel&logoColor=white" alt="Laravel">
  </a>
</p>

## About Vanguard

Vanguard is an open-source Laravel project that provides an easy-to-use solution for backing up your files and databases. Designed with simplicity and efficiency in mind, Vanguard offers official support for modern Ubuntu and Debian servers.

<p align="center">
<img src="https://raw.githubusercontent.com/vanguardbackup/assets/main/screenshots/backup-tasks.png" width="900" alt="Screenshot">
</p>

## Key Features

- Intuitive user interface with flexible backup scheduling
- File and database backup support
- Multichannel notifications (Email, Discord, Slack, Pushover)
- OAuth login (GitHub, GitLab, Bitbucket) and two-factor authentication
- REST API for integration and automation
- Multi-language support and encrypted data storage
- Comprehensive backup statistics and reporting

## Getting Started

For detailed installation instructions and system requirements, please visit our [official documentation](https://docs.vanguardbackup.com/installation).

Quick start:
1. Clone the repository
2. Follow the step-by-step guide in our [documentation](https://docs.vanguardbackup.com/installation)

## Vanguard Ecosystem

Explore our related projects:

- [Marketing](https://github.com/vanguardbackup/marketing) - Our website at https://vanguardbackup.com
- [Docs](https://github.com/vanguardbackup/docs) - Official documentation at https://docs.vanguardbackup.com
- [Mobile](https://github.com/vanguardbackup/mobile) - Mobile application
- [PHP SDK](https://github.com/vanguardbackup/vanguard-php-sdk) - PHP SDK for Vanguard's API
- [Feedback API](https://github.com/vanguardbackup/feedback-api) - API for experimental features feedback
- [Assets](https://github.com/vanguardbackup/assets) - Brand image assets

## Community and Support

### Contributing

We welcome contributions! Please read our [CONTRIBUTING.md](CONTRIBUTING.md) file for guidelines on how to contribute.

### Get Involved

- **Ask Questions**: Use our [Discussions forum](https://github.com/orgs/vanguardbackup/discussions)
- **Report Issues**: Open an issue in the relevant repository
- **Suggest Features**: [Create a post](https://github.com/vanguardbackup/vanguard/discussions/new?category=ideas) in our discussions section

### Contact Us

- **Email**: [hello@vanguardbackup.com](mailto:hello@vanguardbackup.com)
- **Website**: [https://vanguardbackup.com](https://vanguardbackup.com)
- **Documentation**: [https://docs.vanguardbackup.com](https://docs.vanguardbackup.com)

## License

Vanguard is open-sourced software licensed under the [AGPLv3 licence](https://opensource.org/license/agpl-v3).
