![WebDev Logo](http://www.azinovatechnologies.com/blog/wp-content/uploads/2016/03/web-development.jpg)
***
# Description
***
A full-stack web developer should have skills in both front-end design/development and back-end/server coding. We can expect a full-stack developer to design, code, implement and maintain a fully functional modern interactive website on his/her own.
Here i want to give you some information about the technologies, frameworks and some other useful stuff, one has to know for being a Full stack developer.
***
# Front End
***
- [HTML](http://www.w3schools.com/html/default.asp) - A markup language for describing web documents.
- [CSS](http://www.w3schools.com/css/default.asp) - A style sheet language used for describing the look and formatting of a document written in a markup language.
- [Java Script](http://www.w3schools.com/js/default.asp) - A programming language of the Web.
***
### CSS Frameworks
***
- [Bootstrap](http://getbootstrap.com/) - HTML, CSS, and JS framework for developing responsive, mobile first projects on the web.
- [Semantic UI](http://semantic-ui.com/)
- [Foundation](http://foundation.zurb.com/) - The most advanced responsive front-end framework in the world.
- [ElastiCSS](http://elasticss.com/) - A simple css framework to layout web-based interfaces.
- [Less](http://lesscss.org/) - A CSS pre-processor, meaning that it extends the CSS language.
- [Sass](http://sass-lang.com/) - Most mature, stable, and powerful professional grade CSS extension language in the world.
- [Grid System](http://www.thegridsystem.org/) - The grid system is an aid, not a guarantee.
- [material-ui](http://www.material-ui.com/#/)
- [Angular Material Design](https://material.angularjs.org/#/) - An implementation of Material Design in Angular.js.
- [Materialize CSS](http://materializecss.com/) - A modern responsive front-end framework based on Material Design.
- [Polymer](https://www.polymer-project.org/) - Polymer brings an implementation of material design to the web.
- [Quantum UI](http://quantumui.org/) - The most powerful NATIVE AngularJS and Bootstrap CSS based UI components make developer life easy.
- [Stylus](http://learnboost.github.io/stylus/) - Expressive, dynamic, robust CSS
- [Sizzle JS](http://sizzlejs.com/) - A pure JS CSS selector engine designed to be easily dropped in to a host library.
- [Gumby](http://gumbyframework.com/)
- [Kube](http://imperavi.com/kube/) - Kube is one of the world's most advanced and flexible frameworks.
- [Skeleton](http://getskeleton.com/) - A dead simple, responsive boilerplate.
- [tuktuk](http://tuktuk.tapquo.com/) - A new smart kid on the Responsive block.
- [lessframework](http://lessframework.com/) - An adaptive CSS grid system.
- [getuikit](http://getuikit.com/) - A lightweight and modular front-end framework for developing fast and powerful web interfaces.
- [yaml](http://www.yaml.de/) - A modular CSS framework for truly flexible, accessible and responsive websites
- [responsivebp](http://responsivebp.com/) - A powerful, accessible, developer friendly framework for building responsive websites
- [schema](http://danmalarkey.github.io/schema/) - A modular, front end framework to easily and quickly help you jumpstart your process in building complex interfaces for the web right out the box.
- [tacit](http://yegor256.github.io/tacit/)
- [unsemantic](http://unsemantic.com/)
- [basegui](http://basegui.de/) - A lightweight and robust CSS framework for prototyping and production code.
- [groundworkcss](https://groundworkcss.github.io/)
- [weepower](https://www.weepower.com/) - Blueprint for modern web development
- [fluidable](http://fluidable.com/) - Fluidable is a mobile first, responsive grid system.
- [ink](http://ink.sapo.pt/) - Create responsive web interfaces quick and efficiently.
- [cascade](http://cascade-framework.com/) - Putting back the C in CSS
- [kickoff](http://trykickoff.github.io/index.html) - A lightweight front-end framework for creating scalable, responsive sites.
- [metroui](http://metroui.org.ua/) - The front-end framework for developing projects on the web in Windows Metro Style.
- [bulma](http://bulma.io/) - A modern CSS framework based on Flexbox
- [leaf](http://getleaf.com/) - A CSS framework based on Google's material design
- [getessence](http://getessence.io/) - Build it on one, use it on all
- [Baseguide](http://basegui.de/) - A lightweight and robust CSS framework for prototyping and production code.
- [siimple](http://siimple.juanes.xyz/) - Minimal CSS framework for flat and clean designs.
- [Responsive cat](http://www.responsivecat.com/) - CSS Micro framework
- [topcoat](http://topcoat.io/) - CSS for clean and fast web apps.
- [inuitcss](http://inuitcss.com/)
- [muellergridsystem](http://muellergridsystem.com/)
- [golden-grid-system](http://www.jonikorpi.com/golden-grid-system/) - A folding grid system for responsive design (2011).
- [gridiculo](http://gridiculo.us/)
- [toast](http://daneden.me/toast) - Insane, no-nonsense CSS grid
- [getskeleton](http://getskeleton.com/)- A dead simple, responsive boilerplate.
- [bootflat](http://bootflat.github.io/) - BOOTFLAT is an open source Flat UI KIT based on Bootstrap 3.3.0 CSS framework. 
- [jeet](http://jeet.gs/) - A grid system for human
- [Simple-Grid](http://thisisdallas.github.io/Simple-Grid/)
- [getleaf](http://getleaf.com/) - A CSS framework based on Google's material design
- [responsivecat](http://www.responsivecat.com/) - CSS Micro framework
- [sculpt](https://www.heartinternet.uk/sculpt)
- [turretcss](http://turretcss.com/) - A styles and browser behaviour normalisation framework for rapid development of responsive and accessible websites.
- [concisecss](http://concisecss.com/) - A framework written in SASS that’s lightweight and easy-to-use.
- [modestgrid](http://modestgrid.com/) - An easy to customise grid framework that allows for the rapid development of responsive websites.
- [responsivegridsystem](http://www.responsivegridsystem.com/) -  It's a quick, easy & flexible way to create a responsive web site.
- [Clarity](https://vmware.github.io/clarity/index.html) - Clarity Design System
***
### JavaScript Frameworks
***
- [jQuery](http://jquery.com/) - jQuery is a fast, small, and feature-rich JavaScript library.
    - [jQuery UI](http://jqueryui.com/)
    - [jQuery Mobile](http://jquerymobile.com/) - A Touch-Optimized Web Framework.
- [AngularJS v1](https://angularjs.org/) - HTML enhanced for web apps.
- [AngularJS v2](https://angular.io/) - One framework. Mobile & desktop.
- [Ember JS](http://emberjs.com/) - A framework for creating ambitious web applications.
- [Ext JS](http://www.sencha.com/products/extjs/) - An immense step forward in the evolution of an amazing framework.
- [Backbone JS](http://backbonejs.org/) - An open-source component of DocumentCloud.
- [Knockout JS](http://knockoutjs.com/) - Simplify dynamic JavaScript UIs with the Model-View-View Model (MVVM) pattern
- [React JS](https://facebook.github.io/react/) - A declarative, efficient, and flexible JavaScript library for building user interfaces.
- [react-native](https://facebook.github.io/react-native/) - Learn once, write anywhere: build mobile apps with React.
- [electrode](http://www.electrode.io/) - UNIVERSAL REACT/NODE APPLICATION PLATFORM
- [coffeescript](http://coffeescript.org/) - CoffeeScript is a little language that compiles into JavaScript
- [Prototype](http://prototypejs.org/) - It takes the complexity out of client-side web programming.
- [GWT](http://www.gwtproject.org/) - GWT is used by many products at Google, including Google AdWords and Google Wallet.
- [MooTools](http://mootools.net/) - A collection of JS utilities designed for the intermediate to advanced JS developer.
- [Famo](https://famo.us/) - The ultimate web platform for developers and designers.
- [Ample SDK](http://www.amplesdk.com/)
- [Dojo Toolkit](http://dojotoolkit.org/) - Dojo saves you time and scales with your development process, using web standards as its platform.
- [Echo](http://echo.nextapp.com/site/) - An open-source framework for developing rich web applications.
- [Vanilla JS](http://vanilla-js.com/) - A fast, lightweight, cross-platform framework for building incredible, powerful JS applications.
- [Cappuccino](http://www.cappuccino-project.org/) -  A framework which makes it easy to create advanced web apps.
- [sailsjs](http://sailsjs.org/) - The web framework of your dreams.
- [cocoon JS](https://www.ludei.com/cocoonjs/)
- [vuejs](http://vuejs.org/) - A library for building modern web interfaces.
- [threejs](http://threejs.org/) - A JavaScript 3D Library which makes WebGL simpler.
- [webrxjs](http://webrxjs.org/)
- [mithril](http://mithril.js.org/) - A Javascript Framework for Building Brilliant Applications
- [aurelia](http://aurelia.io/) - A JavaScript client framework for mobile, desktop and web leveraging simple conventions and empowering creativity.
- [keystonejs](http://keystonejs.com/) - The open source framework for developing database-driven websites, applications and APIs in Node.js. Built on Express and MongoDB.
- [stapes](http://hay.github.io/stapes/) - Meet the little Javascript framework that does just enough
- [sanestack](http://sanestack.com/) - A Javascript Fullstack and CLI that lets you rapidly create production-ready web apps using Sails and Ember. Get Docker support, generators and more.
- [montagejs](http://montagestudio.com/montagejs/) - A modern frontend HTML5 framework that supports creating single-page applications—fast.
- [ractivejs](http://www.ractivejs.org/) - The diamond age of web development
- [Omniscient](http://omniscientjs.github.io/) - Do fast top-down rendering of views while thinking functional programming.
***
### Hybrid Mobile App Frameworks
***
- [apache cordova](https://cordova.apache.org/) - Apache Cordova is a platform for building native mobile applications using HTML, CSS and JavaScript
- [Ionic Framework](http://ionicframework.com/) - Open source front-end SDK for developing hybrid mobile apps with HTML5.
- [onsen ui](http://onsen.io/) - The Answer to Cordova UI Development.
- [Mobile Angular UI](http://mobileangularui.com/) - Build HTML5 Mobile Apps with Bootstrap and Angular JS.
- [Meteor](https://www.meteor.com/) - A complete open source platform for building web and mobile apps in pure JavaScript.
- [intel-xdk](https://software.intel.com/en-us/intel-xdk) - Easy Path to HTML5 App Development, Fast Path to Multi-OS App Stores
- [appcelerator](http://www.appcelerator.com/product/) - Native apps. Mobile APIs. Real-time analytics. One Platform.
- [sencha touch](http://www.sencha.com/products/touch/) - The leading cross-platform mobile web application framework based on HTML5 and JavaScript for creating universal mobile apps
- [kendo-ui](http://www.telerik.com/kendo-ui) - Everything for building web and mobile apps with HTML5 and JavaScript.
- [phonegap](http://phonegap.com/) - Easily create apps using the web technologies you know and love: HTML, CSS, and JavaScript.
- [xamarin](http://xamarin.com/)
- [Appgyver](http://www.appgyver.com/)
    - [Supersonic](http://docs.appgyver.com/supersonic/) - Build beautiful data-driven apps with real native performance.
    - [Steroids](http://www.appgyver.com/steroids) - The missing tooling for hybrid apps.
    - [Composer](http://www.appgyver.com/composer) - The insanely fast way to bootstrap your HTML5 hybrid apps.
- [framework7](http://framework7.io/) - Full Featured HTML Framework For Building iOS & Android Apps
- [monaca](https://monaca.io/) - Mobile App Development Fast, Easy and Flexible.

### Design Tools

- [User Interface Design Tools](http://www.tripwiremagazine.com/2012/03/user-interface-design-tools.html)
- [Graphic Design Tools](http://www.creativebloq.com/graphic-design/underrated-tools-graphic-designers-12121495)
***
# Back End
***
- [Java](http://docs.oracle.com/javase/tutorial/java/)
- [Node JS](http://nodejs.org/) - A platform built on Chrome's JS runtime for easily building fast, scalable network apps.
- [php](http://php.net/) - A popular general-purpose scripting language that is especially suited to web development.
- [python](https://www.python.org/) - Lets you work quickly and integrate systems more effectively.
- [ruby](https://www.ruby-lang.org/en/) - A dynamic, open source programming language with a focus on simplicity and productivity.
***
### Node.js Frameworks
***
- [Express JS](http://expressjs.com/) - Fast, unopinionated, minimalist web framework for Node.js
- [hapijs](http://hapijs.com/) - A rich framework for building applications and services
- [Socket Stream](http://www.socketstream.org/) - A framework for Real time Web Apps.
- [Sails JS](http://sailsjs.org/) - It makes it easy to build custom, enterprise-grade Node.js apps.
- [Total JS](https://www.totaljs.com/?language=en) - Free web application framework for Node.js
- [koa JS](http://koajs.com/) - Next generation web framework for node.js
- [LoopBack](http://loopback.io/) - Powerful framework for creating APIs and easily connecting to backend data sources.
- [Geddy JS](http://geddyjs.org/) - A simple, structured web framework for Node.
- [Partial JS](http://www.partialjs.com/) - Web application framework for node.js
- [node-restify](http://mcavage.me/node-restify/) - A node.js module built specifically to enable you to build correct REST web services.
- [getraddish](http://getraddish.com/) - Raddish is a NodeJS Framework incorporating the power of MVC and DCI in a single framework.
- [restberry](http://restberry.com/) - Framework for setting up RESTful APIs with NodeJS. Define your models then setup your CRUD API without needing to write any code.
- [gugamarket](http://pliik.github.io/gugamarket/) - Gugamarket REST API framework
- [facet](http://facet.github.io/platform/) - Extensible, framework agnostic JSON API platform for Node.js
- [Locomotive JS](http://locomotivejs.org/) - Powerful MVC web framework for Node.js.
- [Flatiron JS](http://flatironjs.org/) - An adaptable framework for building modern web applications.
- [trails](https://github.com/trailsjs/trails) - Modern Web Application Framework for Node.js
- [dietjs](http://dietjs.com/) - A tiny, fast and modular node.js web framework. Good for making fast & scalable apps and apis.
- [compoundjs](http://compoundjs.com/)
- [adonisjs](http://adonisjs.com/) - Practical. Reliable. Productive
- [rhapsodyjs](http://rhapsodyjs.github.io/) - A NodeJS HMVC framework for epic apps!
- [strapi](http://strapi.io/) - Build powerful back-end with no effort.
- [derbyjs](http://derbyjs.com/) - A full-stack framework for writing modern web applications.
- [actionherojs](http://www.actionherojs.com/) - The Reusable, Scalable, and Quick node.js API Server!
- [frisbyjs](http://frisbyjs.com/) - A REST API testing framework built on node.js and Jasmine that makes testing API endpoints easy, fast, and fun. Read below for a quick overview, or check out the API documentation.
- [senecajs](http://senecajs.org/) - Design, develop and organize your code
***    
# Data Base
***
- [Mongo DB](http://www.mongodb.org/) - The only database that harnesses the innovations of NoSQL.
- [MySQL](http://www.mysql.com/)
- [Oracle](http://www.oracle.com/us/products/database/nosql/overview/index.html)
- [PostgreSQL](http://www.postgresql.org/)
- [IndexedDB](https://www.w3.org/TR/IndexedDB/)
- [webdatabase](https://www.w3.org/TR/webdatabase/)
- [parse](https://www.parse.com/)
- [mlab](https://mlab.com/)
- [couchbase](http://www.couchbase.com/)
- [aerospike](http://www.aerospike.com/) - High performance NoSQL database delivering speed at scale
- [flickerjs](http://flickerstudio.github.io/flickerjs/) - Super fast and simple web framework for node.js
- [IBM DB2](https://www.ibm.com/analytics/us/en/technology/db2/) - No-boundaries database software for the digital, cloud and cognitive era
- [sqlite](https://sqlite.org/) - SQLite is a self-contained, high-reliability, embedded, full-featured, public-domain, SQL database engine.
- [couchdb](http://couchdb.apache.org/) - Seamless multi-master sync, that scales from Big Data to Mobile, with an Intuitive HTTP/JSON API and designed for Reliability.
- [cassandra](http://cassandra.apache.org/) - Manage massive amounts of data, fast, without losing sleep
- [orientdb](http://orientdb.com/orientdb/) - The World's First Distributed Multi-Model NoSQL Database with a Graph Database Engine
- [Amazon SimpleDB](https://aws.amazon.com/simpledb/)
- [Amazon DynamoDB](https://aws.amazon.com/dynamodb/)
- [CLOUD SQL](https://cloud.google.com/sql/) - A fully-managed MySQL database service.
- [sql database](https://azure.microsoft.com/en-us/services/sql-database/?b=16.50)
- [Database.com](http://www.salesforce.com/platform/database/) - Welcome to the world’s most trusted and secure cloud database.
- [cleardb](http://w2.cleardb.net/)
- [pouchdb](https://pouchdb.com/) - PouchDB is an open-source JavaScript database inspired by Apache CouchDB that is designed to run well within the browser.
- [taffydb](http://www.taffydb.com/) - The JavaScript Database
***
# Hosting
***
- [amazon aws](https://aws.amazon.com/)
- [microsoft azure](https://azure.microsoft.com/en-us/)
- [joyent](https://www.joyent.com/)
- [rackspace](https://www.rackspace.com/cloud)
- [softlayer](http://www.softlayer.com/)
- [heroku](https://www.heroku.com/)
- [cloudways](https://www.cloudways.com/en/)
- [wiredtree](https://www.wiredtree.com/)
***
## Charts and Graphs
***
- [highcharts](http://www.highcharts.com/) - Make your data come alive
- [d3js](https://d3js.org/) - A JavaScript library for manipulating documents based on data.
- [nvd3](https://github.com/novus/nvd3) - A reusable charting library written in d3.js
- [angular-nvd3](http://krispo.github.io/angular-nvd3/#/) - An AngularJS directive for NVD3 re-usable charting library (based on D3).
- [chartjs](http://www.chartjs.org/) - Simple, clean and engaging charts for designers and developers
- [angular-chart](http://jtblin.github.io/angular-chart.js/) - Reactive, responsive, beautiful charts for AngularJS based on Chart.js
- [angular-google-chart](http://angular-google-chart.github.io/angular-google-chart/) - Angular Google Chart
- [google chart](https://developers.google.com/chart/) - Interactive charts for browsers and mobile devices.
- [chartist-js](http://gionkunz.github.io/chartist-js/) - SIMPLE RESPONSIVE CHARTS
- [n3-charts](http://n3-charts.github.io/line-chart/#/home) - Awesome charts for Angular
- [Chartkick](http://chartkick.com/) - Create beautiful Javascript charts with one line of Ruby
- [zingchart](https://www.zingchart.com/) - All your dataviz needs in one library
- [fusioncharts](http://www.fusioncharts.com/) - JavaScript charts for web & mobile
- [flotcharts](http://www.flotcharts.org/) - Attractive JavaScript plotting for jQuery
- [amcharts](https://www.amcharts.com/) - JavaScript Charts & Maps
- [ejschart](http://www.ejschart.com/index.php) - EJSCharts is the open source solution for home and business data representation and customization.
- [uvCharts](http://imaginea.github.io/uvCharts/) - Just one API function to learn and master, for all your charting needs.
- [plotly](https://plot.ly/javascript/) - The open source JavaScript graphing library that powers plotly
***
## Useful Libraries / Plugins
***
- [Moment JS](http://momentjs.com/) - Parse, validate, manipulate, and display dates in JavaScript.
- [Moment JS Timezone](http://momentjs.com/timezone/) - Parse and display dates in any timezone.
- [is.js](http://arasatasaygin.github.io/is.js/) - Check types, regexps, presence, time and more.
- [underscorejs](http://underscorejs.org/) - JavaScript library that provides a whole mess of useful functional programming helpers without extending any built-in objects.
- [lodash](https://lodash.com/) - A modern JavaScript utility library delivering modularity, performance, & extras.
- [redux](http://redux.js.org) - Predictable state container for JavaScript apps
- [vuex](https://vuex.vuejs.org/) - Centralized State Management for Vue.js.
- [riotjs](http://riotjs.com/)
- [wintersmith](http://wintersmith.io/) - Flexible, minimalistic, multi-platform static site generator built on top of node.js.
- [feathersjs](http://feathersjs.com/) - A minimalist real-time framework for tomorrow's apps.
- [seedsjs](http://seedsjs.com/) - Full-stack ember framework
- [horizon](http://horizon.io/) - A realtime, open-source backend for JavaScript apps.
- [krakenjs](http://krakenjs.com/) - Give your node.js express apps some extra arms
- [tower](http://tower.github.io/) - Small components for building apps, manipulating data, and automating a distributed infrastructure.
- [Impress](https://github.com/metarhia/Impress) - Impress Application Server for node.js
- [rendr](https://github.com/rendrjs/rendr) - Render your Backbone.js apps on the client and the server, using Node.js.
- [sequelizejs](http://docs.sequelizejs.com/en/v3/) - Sequelize is a promise-based ORM for Node.js and io.js.
- [virgilio](http://icemobilelab.github.io/virgilio/) - Bunyan is the logging framework we use.
- [shps](https://shps.io/) - SHPS is a homepage management system which assists you with making a homepage or web application in general! SHPS comes as a core system (no Admin GUI or additional features) which can be extended with many useful plugins.
- [cylonjs](https://cylonjs.com/) - Next generation robotics framework with support for 43 different platforms Get Started
- [falcor](http://netflix.github.io/falcor/) - A JavaScript library for efficient data fetching
- [restful.js](https://github.com/marmelab/restful.js) - A pure JS client for interacting with server-side RESTful resources. Think Restangular without Angular.
- [fetch](https://github.github.io/fetch/) - A window.fetch JavaScript polyfill.
- [postcss](http://postcss.org/) - A tool for transforming CSS with JavaScript

***
# API Docs
***
- [api blueprint](https://apiblueprint.org/) - API Documentation with powerful tooling.
- [apidocjs](http://apidocjs.com/) - Inline Documentation for RESTful web APIs
- [swagger](http://swagger.io/) - The World's Most Popular Framework for APIs.
- [apiary](https://apiary.io/) - Collaborative design, instant API mock, generated documentation, integrated code samples, debugging and automated testing.
- [django-rest-framework](http://www.django-rest-framework.org/topics/documenting-your-api/)
- [miredot](http://www.miredot.com/index.html) - The most advanced REST API documentation generator for Java.
***
# Module bundlers
***
- [webpack](https://webpack.github.io/) - MODULE BUNDLER
- [lasso](https://github.com/lasso-js/lasso) - Advanced JavaScript module bundler, asset pipeline and optimizer
- [jspm](http://jspm.io/) - Frictionless browser package management
- [browserify](http://browserify.org/) - Browserify lets you require('modules') in the browser by bundling up all of your dependencies.
- [systemjs](https://github.com/systemjs/builder) - SystemJS build tool
- [rollupjs](http://rollupjs.org/) - the next-generation JavaScript module bundler
***
# Other Programming Languages
***
- [golang](https://golang.org/) - An open source programming language that makes it easy to build simple, reliable, and efficient software.
- [Objective-C](https://developer.apple.com/library/content/documentation/Cocoa/Conceptual/ProgrammingWithObjectiveC/Introduction/Introduction.html) - Objective-C is the primary programming language you use when writing software for OS X and iOS
- [swift](https://developer.apple.com/swift/) - The powerful programming language that is also easy to learn.
***
# Icons
***
- [fontawesome](http://fontawesome.io/) - The iconic font and CSS toolkit
- [Material icons](https://design.google.com/icons/) - Material icons
- [material-design-iconic-font](http://zavoloklom.github.io/material-design-iconic-font/)
- [bootstrap icons](http://getbootstrap.com/components/)
- [glyphicons](http://glyphicons.com/)
- [bootstrapicons](http://www.bootstrapicons.com/)
- [flaticon](http://www.flaticon.com/packs)
- [iconfinder](https://www.iconfinder.com/)
- [thenounproject](https://thenounproject.com/)
- [freepik](http://www.freepik.com/free-vectors/icons)
- [modernuiicons](http://modernuiicons.com/)
- [metrize-icons](http://www.alessioatzeni.com/metrize-icons/)
- [social-media-icons-pack](http://www.fontfabric.com/social-media-icons-pack/)
***
# Testing
***
- [Karma](http://karma-runner.github.io/0.12/index.html) - A test runner that fits all our needs.
- [Jasmine](http://jasmine.github.io/) - A behavior-driven development framework for testing JavaScript code.
- [Protractor](http://angular.github.io/protractor/#/) - An end-to-end test framework for AngularJS applications. 
- [Selenium](http://www.seleniumhq.org/) - A portable software testing framework for web applications.  
- [QUnit JS](http://qunitjs.com/) - A JavaScript Unit Testing framework.  
***
## No Backend Solutions
***
- [Backendless](http://backendless.com/)
- [Deployd](http://deployd.com/)
- [Firebase](https://www.firebase.com/)
- [Hood](http://hood.ie/)
- [Kinvey](http://www.kinvey.com/)
- [Parse](https://parse.com/)
- [Remotestorage](https://remotestorage.io/)
- [Sockethub](http://sockethub.org/)
- [Unhosted](https://unhosted.org/)
- [Staticapps](http://www.staticapps.org/)
- [backand](https://www.backand.com/)
***
## JavaScript game engines
***
- [cocos 3D](http://cocos3d.org/) - Create amazing 3D apps & games for mobile.
- [impactjs](http://impactjs.com/) - The awesomest way to create even more awesome html5 games!
- [threejs](http://threejs.org/)
- [createjs](http://createjs.com/)
- [phaser](http://phaser.io/)
- [craftyjs](http://craftyjs.com/) - A flexible framework for Javascript games
- [pandajs](http://www.pandajs.net/) - Free HTML5 game engine for mobile and desktop games.
- [pixijs](https://github.com/pixijs/pixi.js) - Super fast HTML 5 2D rendering engine that uses webGL with canvas fallback.
- [BabylonJS](https://github.com/BabylonJS/Babylon.js) - A complete JavaScript framework for building 3D games with HTML 5 and WebGL
- [melonJS](https://github.com/melonjs/melonJS) - A fresh & lightweight javascript game engine
- [turbulenz](http://turbulenz.com)
- [compilgames](http://www.compilgames.net/)
- [PhysicsJS](http://wellcaffeinated.net/PhysicsJS/)
- [stage.js](http://piqnt.com/stage.js)
- [goojs](https://goocreate.com/) - MAKE GAMES AND VR FOR THE BROWSER
- [whitestormjs](http://whitestormjs.xyz/) - A framework for 3D web apps built with Three.js technology.
- [qiciengine](http://www.qiciengine.com/)
- [lychee](https://lychee.js.org/#!vision)
***
## Emulators
***
- [Android](https://developer.android.com/sdk/index.html)
- [Genymotion](https://www.genymotion.com/)
- [ios-sim](https://github.com/phonegap/ios-sim)
***
## Wireframing Tools
***
- [mockflow](https://www.mockflow.com/)
- [moqups](https://moqups.com/)
- [justinmind](http://www.justinmind.com/)
- [balsamiq](https://balsamiq.com/products/mockups/)
- [wireframe](https://wireframe.cc/)
- [gomockingbird](https://gomockingbird.com/home)
- [cacoo](https://cacoo.com/lang/en/home)
- [axure](http://www.axure.com/) - DESIGN THE RIGHT SOLUTION
- [uxpin](https://www.uxpin.com/)
- [pidoco](https://pidoco.com/en)
- [iplotz](http://iplotz.com/)
- [pidoco](https://pidoco.com/en)
- [visio](http://visio.microsoft.com/)
- [penultimate](https://evernote.com/penultimate/)
- [indesign](http://www.adobe.com/in/products/indesign.html)
- [pencil](http://pencil.evolus.vn/Default.html)
- [omnigroup](http://www.omnigroup.com/)
- [framebox](http://framebox.org/)
- [iphonemockup](http://iphonemockup.lkmc.ch/)
- [lumzy](http://www.lumzy.com/)
- [omnigroup](http://www.omnigroup.com/)
- [gliffy](https://www.gliffy.com/) - Make Diagramming a Team Sport
- [protoshare](http://www.protoshare.com/)
- [OmniGraffle](http://www.omnigroup.com/)
- [flairbuilder](http://www.flairbuilder.com/)
- [fluidui](https://www.fluidui.com/)
- [Adobe InDesign CC](http://www.adobe.com/in/products/indesign.html?sdid=952G4XMS&92X1519156X7d616cf9ee5c084828c2931ed182bb81)
- [hotgloo](https://www.hotgloo.com/) - NEXT LEVEL WIREFRAMING & PROTOTYPING TOOL
- [mockplus](https://www.mockplus.com/) - PROTOTYPE FASTER. SMARTER. EASIER.
- [lovelycharts](http://lovelycharts.com/)
- [simplediagrams](http://www.simplediagrams.com/)
- [flinto](https://www.flinto.com/) - App Prototyping Tools for Designers
- [wireframesketcher](http://wireframesketcher.com/)
- [talltree](http://wireframe.talltree.us/default.asp)
***
## IDEs
***
- [JetBrains webstorm](http://www.jetbrains.com/webstorm/)
- [Microsoft Visual Studio](https://www.visualstudio.com/en-us/downloads/download-visual-studio-vs.aspx)
- [Microsoft Visual Studio Code](https://code.visualstudio.com/Download)
- [NetBeans](https://netbeans.org/)
- [Sublime Text](http://www.sublimetext.com/)
- [Brackets](http://brackets.io/)
- [Eclips](http://www.eclipse.org/)
- [Xamarin](https://xamarin.com/studio)
- [Aptana](http://www.aptana.com/)
- [Light Table](http://lighttable.com/)
- [Zend](http://www.zend.com/en/products/studio)
- [icecoder](https://icecoder.net/)
- [superpowers](http://superpowers-html5.com/)
***
## Online Code Editors
***
- [JS Fiddle](http://jsfiddle.net/)
- [Plunker](http://plnkr.co/edit/?p=preview)
- [play.ionic.io](http://play.ionic.io/app/582271e8b8f0)
- [Collabedit](http://collabedit.com/)
- [Codepen](http://codepen.io/)
- [Dabblet](http://dabblet.com/)
- [Thimble](https://thimble.webmaker.org/en-US/)
- [js bin](http://jsbin.com/)
- [codeanywhere](https://codeanywhere.com/)
- [ionic-atom](https://atom.io/packages/ionic-atom)
***
## Plugins List
***
- [AngularJS Modules](http://ngmodules.org/) - Find Modules for AngularJS
- [ionic Market](http://market.ionic.io/plugins)
- [gulpjs](http://gulpjs.com/plugins/)
- [jquery-plugins](http://tutorialzine.com/2013/04/50-amazing-jquery-plugins/)
- [noodl.io](http://www.seipel-ibisevic.com/noodl/) - By Developers, For Developers.
- [codecanyon](http://codecanyon.net/)
***
## Repository hosting service
***
- [github](https://github.com/)
- [bitbucket](https://bitbucket.org/)
- [gitlab](https://about.gitlab.com/)
- [codebasehq](https://www.codebasehq.com/)
- [beanstalk](http://beanstalkapp.com/)
- [assembla](https://www.assembla.com/home)
- [fogcreek](https://www.fogcreek.com/kiln/)
- [cloudforge](http://www.cloudforge.com/)
- [fogcreek](https://www.fogcreek.com/kiln/)
- [planio](https://plan.io/)
- [perforce](http://www.perforce.com/)
- [rhodecode](https://rhodecode.com/)
- [unfuddle](https://unfuddle.com/)
***
## Showcase & Inspiration
***
- [Materialup](http://www.materialup.com/) - Daily showcase of the best Material Design concepts, apps and tools!
- [Behance](https://www.behance.net/) - A place to show and tell, promote, discover, and explore design.
- [beta.pttrns](http://beta.pttrns.com/) - The finest collection of mobile design patterns, resources and inspiration.
- [ui8](https://ui8.net/) - Carefully crafted ui design assets.
- [One Page Love](https://onepagelove.com/) - The ultimate showcase of beautiful One Page Websites, Templates and Resources. 
- [Awwwards](http://www.awwwards.com/) - The awards for design, creativity and innovation on the Internet. 
- [Dribbble](https://dribbble.com/) - What are you working on? Dribbble is show and tell for designers. 
- [abduzeedo](http://abduzeedo.com/) - A collection of visual inspiration and useful tutorials.
- [Appgyver](http://www.appgyver.com/showcase) - Built with Appgyver.
- [siteinspire](http://www.siteinspire.com/) - A showcase of the finest web and interactive design.
- [thedesigninspiration](http://thedesigninspiration.com/)
- [designspiration](http://designspiration.net/)
- [thebestdesigns](https://www.thebestdesigns.com/) - Featuring the best of web design.
***
## Market Places & Themes
***
- [ionic market](http://market.ionic.io/)
- [ionicthemes](https://ionicthemes.com/)
- [bootswatch](http://bootswatch.com/)
- [themeforest](http://themeforest.net/)
- [templatemonster](http://www.templatemonster.com/)
- [nimbusthemes](http://www.nimbusthemes.com/)
- [themetrust](http://themetrust.com/)
- [themeshift](http://themeshift.com/)
- [thethemefoundry](https://thethemefoundry.com/)
- [organicthemes](http://organicthemes.com/)
- [elegantthemes](http://www.elegantthemes.com/)
- [graphpaperpress](https://graphpaperpress.com/)
- [prothemedesign](https://prothemedesign.com/)
- [obox-design](http://www.obox-design.com/)
- [woothemes](https://www.woothemes.com/)
***
##  Other Stuff
***
- [nvm](https://github.com/creationix/nvm) - Node Version Manager
- [Web RTC](http://www.webrtc.org/) - A free, open project that provides browsers and mobile applications with Real-Time Communications (RTC) capabilities via simple APIs
- [Grunt JS](http://gruntjs.com/) - The JavaScript Task Runner.
- [Bower](http://bower.io/) - A package manager for the web.
- [Yeoman](http://yeoman.io/) - The web's scaffolding tool for modern web apps.
- [Gulp JS](http://gulpjs.com/) - Automate and enhance your workflow.
- [Slush JS](http://slushjs.github.io/#/) - The streaming scaffolding system.
- [Nuget](https://www.nuget.org/) - NuGet is the package manager for the Microsoft development platform including .NET.
- [Web APIs](https://developer.mozilla.org/en-US/docs/Web/Reference/API)
- [Testling](https://ci.testling.com/) - Run your browser tests on every push.
- [Ionicons](http://ionicons.com/)
- [Font Awesome](http://fortawesome.github.io/Font-Awesome/)
- [babeljs](https://babeljs.io/) - Babel is a JavaScript compiler.
- [leafletjs](http://leafletjs.com/) - An open-source JavaScript library for mobile-friendly interactive maps.
***
## License
***
- [MIT](https://github.com/vaibhavpacharya/Full-Stack-Web-Development/blob/master/LICENSE)
***
## Contribute
***
I understand, there are so many other technologies and frameworks other than what i mentioned here.
Please suggest any other, you feel missing and useful. Please make a pull request or raise an issue regarding the modifications or suggestions.
***
## Contact Me
***
- **Gmail**			:	vaibhav.ach@gmail.com
- **Facebook**		:	https://www.facebook.com/vaibhav.acharya.18
- **Twitter**		:	https://twitter.com/IAmVaibhav1993
- **Github**		:	https://github.com/vaibhavpacharya

*[Back to top](#description)*
