# Friend's App



Welcome to the Friend's App repository! This social media platform offers unique features not available on other platforms, and we invite you to contribute to its growth.

## Table of Contents

- [Introduction](#introduction)
- [Getting Started](#getting-started)
  - [Prerequisites](#prerequisites)
  - [Installation](#installation)
- [Features](#features)
- [Contributing](#contributing)
  - [How to Contribute](#how-to-contribute)
  - [Community Guidelines](#community-guidelines)
- [Resources](#resources)
- [License](#license)

## Introduction

Friend's App is a social media platform aimed at connecting people and fostering meaningful interactions. We believe in the power of open-source collaboration to make the app even better.

## Getting Started:

- **Star** this repository if you find it useful!

- **Fork** this repository if you want to contribute!

- **Pull requests** are welcome. Please follow our **CONTRIBUTING.md**

### Prerequisites

Before you start contributing, please ensure you have the following prerequisites:

- [Angular](https://angular.io/guide/setup-local)
- [Spring Boot](https://spring.io/projects/spring-boot)
- [MongoDB](https://www.mongodb.com/try/download/community)

### Installation

Follow these steps to set up Friend's App on your local machine:

1. Clone the repository:

   ```bash
   git clone https://github.com/your-username/friends-app.git

2. Change to the project directory:

   ```bash
   cd friends-app
   
3. Install dependencies:

   ```bash
   # Angular frontend
   cd frontend
   npm install

   # Spring Boot backend
   cd ../backend
   mvn install


4. Start the app:

   ```bash
   # Start Angular frontend
    cd ../frontend
    ng serve

    # Start Spring Boot backend
    cd ../backend
    mvn spring-boot:run
   
Now you should have the Friend's App running locally.
