## Publications and Videos

🐙 **userver** related publications, announcements and videos.


## Introductions
* 🎥 [Microservices on C++, or why we made our own framework](https://youtu.be/WkcmNOmwAH8)
* 🎥 Writing a new service with database and cache from scratch (ru):
  [Эффективные и высоконагруженные сервисы на C++](https://youtu.be/qrGZARf2Wno?t=2034)
* 🎥 Writing a new gRPC server and client with userver (ru):
  [gRPC + userver = 🔥❤️](https://www.youtube.com/watch?v=3jTTrbvxPKc).
* 🎥 Why there's a need in the C++ framework and introduction into component system, configs, gRPC, lifetimes
  and other basics (ru):
  [Сервисы на userver](https://disk.yandex.ru/d/N8lQtMaWqLqn_g)


## Announcements

### Release 2.0
* 📖 Introducing userver 2.0, overview of safety and freestanding features (ru):
  [userver 2.0 — большой релиз фреймворка для IO-bound программ](https://habr.com/ru/companies/yandex/articles/813115/)


### Release 1.0.0
* 📖 Introducing userver 1.0, overview of safety and freestanding features
  [userver 1.0: Releasing a Framework for IO-Bound Programs](https://medium.com/yandex/userver-1-0-releasing-a-framework-for-io-bound-programs-7898c275d226)
* 📖 Introducing userver 1.0, overview of safety and freestanding features (ru):
  [userver 1.0 — релиз фреймворка для IO-bound программ](https://habr.com/ru/companies/yandex/articles/760244/)


### Beta
* 📖 [Introducing Beta of userver, an Open-Source Framework for Creating Microservices](https://medium.com/yandex/introducing-beta-of-userver-an-open-source-framework-for-creating-microservices-d5d9c4204dc2)
* 📖 Introducing Beta of userver (ru): [Яндекс выложил в опенсорс бету фреймворка userver](https://habr.com/ru/company/yandex/blog/674902/)
* 🎥 Overview of userver features (ru): [Анонс с подробностями доступных технологий](https://youtu.be/qrGZARf2Wno?t=786)


## Technologies overview
* 📖 Generic async engine implementation (ru): [Анатомия асинхронных фреймворков в С++ и других языках](https://habr.com/ru/company/yandex/blog/647853/)
* 🎥 Generic async engine implementation (ru): [Анатомия асинхронных движков](https://youtu.be/MiE22pTvnPs)
* 🎥 Mutex implementation in userver (ru): [Реализация мьютекса в userver](https://www.youtube.com/watch?v=myaEpjYyx3I)
* 🎥 Description of utils::FastPimpl, formats::parse::To and logging implementation (ru): [C++ трюки из Такси](https://youtu.be/_AkF8SpUV3k)
* 🎥 Description of utils::LazyPrvalue, utils::FixedArray, utils::TrivialBiMap, ODR-detection in PostgreSQL [C++ трюки из userver](https://www.youtube.com/watch?v=FcQC19CX-AY)
* 🎥 Description of cache::LruSet implementation and optimizations (ru): [Ещё чуть быстрее делаем свой контейнер](https://youtu.be/60XhYzkXu1M)
* 🎥 Monolithic vs. Microservices architecture and how userver works around their issues (ru):
  [Монолит vs Микросервисы, и Как эффективно работать с последними в C++](https://youtu.be/5QtAFKgS938)
* 📖 Retries, exponential backoff, jitter, rate limits, circuit breakers, deadline propagations and other
  important features for stability (ru): [Хороший ретрай, плохой ретрай, или История одного падения](https://habr.com/ru/companies/yandex/articles/762678/)
* 📖 Dirty C++ tricks from userver and Boost (ru): [Грязные трюки C++ из userver и Boost](https://habr.com/ru/companies/yandex/articles/852244/)
* 📖 [Story of website design at Behance](https://www.behance.net/gallery/185906583/Userver-C)


## Fun
* 📖 Half a year in open-source (ru): [userver — что мы узнали за полгода в open-source](https://habr.com/ru/companies/yandex/articles/729588/)

----------

@htmlonly <div class="bottom-nav"> @endhtmlonly
⇦ @ref scripts/docs/en/userver/build/userver.md |
@htmlonly </div> @endhtmlonly
