# userver: Samples

A directory with samples:

* clickhouse_service - Clickhouse usage sample.
* config_service - Dynamic Config Service stub. See [uservice-dynconf](https://github.com/userver-framework/uservice-dynconf) for a fully functional dynamic configs service. [Documentation](https://userver.tech/d4/d95/md_en_2userver_2tutorial_2config__service.html)
* flatbuf_service - some service that uses FlatBuffers over HTTP. [Documentation](https://userver.tech/d8/d91/md_en_2userver_2tutorial_2flatbuf__service.html)
* grpc_service - gRPC client and server usage sample. [Documentation](https://userver.tech/d6/daa/md_en_2userver_2tutorial_2grpc__service.html)
* hello_service - introduction service that says "Hello world". [Documentation](https://userver.tech/da/d16/md_en_2userver_2tutorial_2hello__service.html)
* http_caching - sample implementation of low-level caching component. [Documentation](https://userver.tech/dc/d8a/md_en_2userver_2tutorial_2http__caching.html)
* mongo_service - sample service that uses MongoDB. [Documentation](https://userver.tech/d5/d81/md_en_2userver_2tutorial_2mongo__service.html)
* mongo-support - distlock using MongoDB
* multipart_service - sample on how to receive files and deal with multipart/form-data requests
* postgres_auth - custom "Bearer" authentication that uses PostgreSQL. [Documentation](https://userver.tech/da/d24/md_en_2userver_2tutorial_2auth__postgres.html)
* postgres_service - sample service that uses PostgreSQL. [Documentation](https://userver.tech/d4/d31/md_en_2userver_2tutorial_2postgres__service.html)
* postgres-support - distlock using PostgreSQL
* production_service - close to the production sample service. [Documentation](https://userver.tech/db/d69/md_en_2userver_2tutorial_2production__service.html)
* rabbitmq_service - RabbitMQ usage sample
* kafka_service - Kafka producer and consumer usage sample. [Documentation](https://userver.tech/d0/db8/md_en_2userver_2kafka.html)
* redis_service - sample service that uses Redis. [Documentation](https://userver.tech/d3/da2/md_en_2userver_2tutorial_2redis__service.html)
* static_service - HTTP server that server static data
* tcp_full_duplex_service - low-level TCP full-duplex server implementation. [Documentation](https://userver.tech/db/db9/md_en_2userver_2tutorial_2tcp__full.html)
* tcp_service - low-level TCP half-duplex server implementation. [Documentation](https://userver.tech/dc/d93/md_en_2userver_2tutorial_2tcp__service.html)
* testsuite-support - small samples of testsuite functionality. [Documentation](https://userver.tech/df/d07/md_en_2userver_2functional__testing.html)
* json2yaml - non coroutine console tool [Documentation](https://userver.tech/d2/dfc/md_en_2userver_2tutorial_2json__to__yaml.html)
