// Test was generated by userver/scripts/postgres/pg_sql_codes.py
#include <userver/utest/utest.hpp>

#include <userver/storages/postgres/exceptions.hpp>

USERVER_NAMESPACE_BEGIN

namespace pg = storages::postgres;

TEST(PostgreError, SqlStateSuccessfulCompletion) {
    // Class 00 — Successful Completion
    EXPECT_EQ(pg::SqlState::kSuccessfulCompletion, pg::SqlStateFromString("00000"));
    EXPECT_EQ(pg::SqlStateClass::kSuccessfulCompletion, pg::GetSqlStateClass(pg::SqlState::kSuccessfulCompletion));
}

TEST(PostgreError, SqlStateWarning) {
    // Class 01 — Warning
    EXPECT_EQ(pg::SqlState::kWarning, pg::SqlStateFromString("01000"));
    EXPECT_EQ(pg::SqlStateClass::kWarning, pg::GetSqlStateClass(pg::SqlState::kWarning));
    EXPECT_EQ(pg::SqlState::kDynamicResultSetsReturned, pg::SqlStateFromString("0100C"));
    EXPECT_EQ(pg::SqlStateClass::kWarning, pg::GetSqlStateClass(pg::SqlState::kDynamicResultSetsReturned));
    EXPECT_EQ(pg::SqlState::kImplicitZeroBitPadding, pg::SqlStateFromString("01008"));
    EXPECT_EQ(pg::SqlStateClass::kWarning, pg::GetSqlStateClass(pg::SqlState::kImplicitZeroBitPadding));
    EXPECT_EQ(pg::SqlState::kNullValueEliminatedInSetFunction, pg::SqlStateFromString("01003"));
    EXPECT_EQ(pg::SqlStateClass::kWarning, pg::GetSqlStateClass(pg::SqlState::kNullValueEliminatedInSetFunction));
    EXPECT_EQ(pg::SqlState::kPrivilegeNotGranted, pg::SqlStateFromString("01007"));
    EXPECT_EQ(pg::SqlStateClass::kWarning, pg::GetSqlStateClass(pg::SqlState::kPrivilegeNotGranted));
    EXPECT_EQ(pg::SqlState::kPrivilegeNotRevoked, pg::SqlStateFromString("01006"));
    EXPECT_EQ(pg::SqlStateClass::kWarning, pg::GetSqlStateClass(pg::SqlState::kPrivilegeNotRevoked));
    EXPECT_EQ(pg::SqlState::kStringDataRightTruncationWarn, pg::SqlStateFromString("01004"));
    EXPECT_EQ(pg::SqlStateClass::kWarning, pg::GetSqlStateClass(pg::SqlState::kStringDataRightTruncationWarn));
    EXPECT_EQ(pg::SqlState::kDeprecatedFeature, pg::SqlStateFromString("01P01"));
    EXPECT_EQ(pg::SqlStateClass::kWarning, pg::GetSqlStateClass(pg::SqlState::kDeprecatedFeature));
}

TEST(PostgreError, SqlStateNoData) {
    // Class 02 — No Data (this is also a warning class per the SQL standard)
    EXPECT_EQ(pg::SqlState::kNoData, pg::SqlStateFromString("02000"));
    EXPECT_EQ(pg::SqlStateClass::kNoData, pg::GetSqlStateClass(pg::SqlState::kNoData));
    EXPECT_EQ(pg::SqlState::kNoAdditionalDynamicResultSetsReturned, pg::SqlStateFromString("02001"));
    EXPECT_EQ(pg::SqlStateClass::kNoData, pg::GetSqlStateClass(pg::SqlState::kNoAdditionalDynamicResultSetsReturned));
}

TEST(PostgreError, SqlStateSqlStatementNotYetComplete) {
    // Class 03 — SQL Statement Not Yet Complete
    EXPECT_EQ(pg::SqlState::kSqlStatementNotYetComplete, pg::SqlStateFromString("03000"));
    EXPECT_EQ(
        pg::SqlStateClass::kSqlStatementNotYetComplete, pg::GetSqlStateClass(pg::SqlState::kSqlStatementNotYetComplete)
    );
}

TEST(PostgreError, SqlStateConnectionException) {
    // Class 08 — Connection Exception
    EXPECT_EQ(pg::SqlState::kConnectionException, pg::SqlStateFromString("08000"));
    EXPECT_EQ(pg::SqlStateClass::kConnectionException, pg::GetSqlStateClass(pg::SqlState::kConnectionException));
    EXPECT_EQ(pg::SqlState::kConnectionDoesNotExist, pg::SqlStateFromString("08003"));
    EXPECT_EQ(pg::SqlStateClass::kConnectionException, pg::GetSqlStateClass(pg::SqlState::kConnectionDoesNotExist));
    EXPECT_EQ(pg::SqlState::kConnectionFailure, pg::SqlStateFromString("08006"));
    EXPECT_EQ(pg::SqlStateClass::kConnectionException, pg::GetSqlStateClass(pg::SqlState::kConnectionFailure));
    EXPECT_EQ(pg::SqlState::kSqlclientUnableToEstablishSqlconnection, pg::SqlStateFromString("08001"));
    EXPECT_EQ(
        pg::SqlStateClass::kConnectionException,
        pg::GetSqlStateClass(pg::SqlState::kSqlclientUnableToEstablishSqlconnection)
    );
    EXPECT_EQ(pg::SqlState::kSqlserverRejectedEstablishmentOfSqlconnection, pg::SqlStateFromString("08004"));
    EXPECT_EQ(
        pg::SqlStateClass::kConnectionException,
        pg::GetSqlStateClass(pg::SqlState::kSqlserverRejectedEstablishmentOfSqlconnection)
    );
    EXPECT_EQ(pg::SqlState::kTransactionResolutionUnknown, pg::SqlStateFromString("08007"));
    EXPECT_EQ(
        pg::SqlStateClass::kConnectionException, pg::GetSqlStateClass(pg::SqlState::kTransactionResolutionUnknown)
    );
    EXPECT_EQ(pg::SqlState::kProtocolViolation, pg::SqlStateFromString("08P01"));
    EXPECT_EQ(pg::SqlStateClass::kConnectionException, pg::GetSqlStateClass(pg::SqlState::kProtocolViolation));
}

TEST(PostgreError, SqlStateTriggeredActionException) {
    // Class 09 — Triggered Action Exception
    EXPECT_EQ(pg::SqlState::kTriggeredActionException, pg::SqlStateFromString("09000"));
    EXPECT_EQ(
        pg::SqlStateClass::kTriggeredActionException, pg::GetSqlStateClass(pg::SqlState::kTriggeredActionException)
    );
}

TEST(PostgreError, SqlStateFeatureNotSupported) {
    // Class 0A — Feature Not Supported
    EXPECT_EQ(pg::SqlState::kFeatureNotSupported, pg::SqlStateFromString("0A000"));
    EXPECT_EQ(pg::SqlStateClass::kFeatureNotSupported, pg::GetSqlStateClass(pg::SqlState::kFeatureNotSupported));
}

TEST(PostgreError, SqlStateInvalidTransactionInitiation) {
    // Class 0B — Invalid Transaction Initiation
    EXPECT_EQ(pg::SqlState::kInvalidTransactionInitiation, pg::SqlStateFromString("0B000"));
    EXPECT_EQ(
        pg::SqlStateClass::kInvalidTransactionInitiation,
        pg::GetSqlStateClass(pg::SqlState::kInvalidTransactionInitiation)
    );
}

TEST(PostgreError, SqlStateLocatorException) {
    // Class 0F — Locator Exception
    EXPECT_EQ(pg::SqlState::kLocatorException, pg::SqlStateFromString("0F000"));
    EXPECT_EQ(pg::SqlStateClass::kLocatorException, pg::GetSqlStateClass(pg::SqlState::kLocatorException));
    EXPECT_EQ(pg::SqlState::kInvalidLocatorSpecification, pg::SqlStateFromString("0F001"));
    EXPECT_EQ(pg::SqlStateClass::kLocatorException, pg::GetSqlStateClass(pg::SqlState::kInvalidLocatorSpecification));
}

TEST(PostgreError, SqlStateInvalidGrantor) {
    // Class 0L — Invalid Grantor
    EXPECT_EQ(pg::SqlState::kInvalidGrantor, pg::SqlStateFromString("0L000"));
    EXPECT_EQ(pg::SqlStateClass::kInvalidGrantor, pg::GetSqlStateClass(pg::SqlState::kInvalidGrantor));
    EXPECT_EQ(pg::SqlState::kInvalidGrantOperation, pg::SqlStateFromString("0LP01"));
    EXPECT_EQ(pg::SqlStateClass::kInvalidGrantor, pg::GetSqlStateClass(pg::SqlState::kInvalidGrantOperation));
}

TEST(PostgreError, SqlStateInvalidRoleSpecification) {
    // Class 0P — Invalid Role Specification
    EXPECT_EQ(pg::SqlState::kInvalidRoleSpecification, pg::SqlStateFromString("0P000"));
    EXPECT_EQ(
        pg::SqlStateClass::kInvalidRoleSpecification, pg::GetSqlStateClass(pg::SqlState::kInvalidRoleSpecification)
    );
}

TEST(PostgreError, SqlStateDiagnosticsException) {
    // Class 0Z — Diagnostics Exception
    EXPECT_EQ(pg::SqlState::kDiagnosticsException, pg::SqlStateFromString("0Z000"));
    EXPECT_EQ(pg::SqlStateClass::kDiagnosticsException, pg::GetSqlStateClass(pg::SqlState::kDiagnosticsException));
    EXPECT_EQ(pg::SqlState::kStackedDiagnosticsAccessedWithoutActiveHandler, pg::SqlStateFromString("0Z002"));
    EXPECT_EQ(
        pg::SqlStateClass::kDiagnosticsException,
        pg::GetSqlStateClass(pg::SqlState::kStackedDiagnosticsAccessedWithoutActiveHandler)
    );
}

TEST(PostgreError, SqlStateCaseNotFound) {
    // Class 20 — Case Not Found
    EXPECT_EQ(pg::SqlState::kCaseNotFound, pg::SqlStateFromString("20000"));
    EXPECT_EQ(pg::SqlStateClass::kCaseNotFound, pg::GetSqlStateClass(pg::SqlState::kCaseNotFound));
}

TEST(PostgreError, SqlStateCardinalityViolation) {
    // Class 21 — Cardinality Violation
    EXPECT_EQ(pg::SqlState::kCardinalityViolation, pg::SqlStateFromString("21000"));
    EXPECT_EQ(pg::SqlStateClass::kCardinalityViolation, pg::GetSqlStateClass(pg::SqlState::kCardinalityViolation));
}

TEST(PostgreError, SqlStateDataException) {
    // Class 22 — Data Exception
    EXPECT_EQ(pg::SqlState::kDataException, pg::SqlStateFromString("22000"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kDataException));
    EXPECT_EQ(pg::SqlState::kArraySubscriptError, pg::SqlStateFromString("2202E"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kArraySubscriptError));
    EXPECT_EQ(pg::SqlState::kCharacterNotInRepertoire, pg::SqlStateFromString("22021"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kCharacterNotInRepertoire));
    EXPECT_EQ(pg::SqlState::kDatetimeFieldOverflow, pg::SqlStateFromString("22008"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kDatetimeFieldOverflow));
    EXPECT_EQ(pg::SqlState::kDivisionByZero, pg::SqlStateFromString("22012"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kDivisionByZero));
    EXPECT_EQ(pg::SqlState::kErrorInAssignment, pg::SqlStateFromString("22005"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kErrorInAssignment));
    EXPECT_EQ(pg::SqlState::kEscapeCharacterConflict, pg::SqlStateFromString("2200B"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kEscapeCharacterConflict));
    EXPECT_EQ(pg::SqlState::kIndicatorOverflow, pg::SqlStateFromString("22022"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kIndicatorOverflow));
    EXPECT_EQ(pg::SqlState::kIntervalFieldOverflow, pg::SqlStateFromString("22015"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kIntervalFieldOverflow));
    EXPECT_EQ(pg::SqlState::kInvalidArgumentForLogarithm, pg::SqlStateFromString("2201E"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidArgumentForLogarithm));
    EXPECT_EQ(pg::SqlState::kInvalidArgumentForNtileFunction, pg::SqlStateFromString("22014"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidArgumentForNtileFunction));
    EXPECT_EQ(pg::SqlState::kInvalidArgumentForNthValueFunction, pg::SqlStateFromString("22016"));
    EXPECT_EQ(
        pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidArgumentForNthValueFunction)
    );
    EXPECT_EQ(pg::SqlState::kInvalidArgumentForPowerFunction, pg::SqlStateFromString("2201F"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidArgumentForPowerFunction));
    EXPECT_EQ(pg::SqlState::kInvalidArgumentForWidthBucketFunction, pg::SqlStateFromString("2201G"));
    EXPECT_EQ(
        pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidArgumentForWidthBucketFunction)
    );
    EXPECT_EQ(pg::SqlState::kInvalidCharacterValueForCast, pg::SqlStateFromString("22018"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidCharacterValueForCast));
    EXPECT_EQ(pg::SqlState::kInvalidDatetimeFormat, pg::SqlStateFromString("22007"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidDatetimeFormat));
    EXPECT_EQ(pg::SqlState::kInvalidEscapeCharacter, pg::SqlStateFromString("22019"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidEscapeCharacter));
    EXPECT_EQ(pg::SqlState::kInvalidEscapeOctet, pg::SqlStateFromString("2200D"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidEscapeOctet));
    EXPECT_EQ(pg::SqlState::kInvalidEscapeSequence, pg::SqlStateFromString("22025"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidEscapeSequence));
    EXPECT_EQ(pg::SqlState::kNonstandardUseOfEscapeCharacter, pg::SqlStateFromString("22P06"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kNonstandardUseOfEscapeCharacter));
    EXPECT_EQ(pg::SqlState::kInvalidIndicatorParameterValue, pg::SqlStateFromString("22010"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidIndicatorParameterValue));
    EXPECT_EQ(pg::SqlState::kInvalidParameterValue, pg::SqlStateFromString("22023"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidParameterValue));
    EXPECT_EQ(pg::SqlState::kInvalidPrecedingOrFollowingSize, pg::SqlStateFromString("22013"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidPrecedingOrFollowingSize));
    EXPECT_EQ(pg::SqlState::kInvalidRegularExpression, pg::SqlStateFromString("2201B"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidRegularExpression));
    EXPECT_EQ(pg::SqlState::kInvalidRowCountInLimitClause, pg::SqlStateFromString("2201W"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidRowCountInLimitClause));
    EXPECT_EQ(pg::SqlState::kInvalidRowCountInResultOffsetClause, pg::SqlStateFromString("2201X"));
    EXPECT_EQ(
        pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidRowCountInResultOffsetClause)
    );
    EXPECT_EQ(pg::SqlState::kInvalidTablesampleArgument, pg::SqlStateFromString("2202H"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidTablesampleArgument));
    EXPECT_EQ(pg::SqlState::kInvalidTablesampleRepeat, pg::SqlStateFromString("2202G"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidTablesampleRepeat));
    EXPECT_EQ(pg::SqlState::kInvalidTimeZoneDisplacementValue, pg::SqlStateFromString("22009"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidTimeZoneDisplacementValue));
    EXPECT_EQ(pg::SqlState::kInvalidUseOfEscapeCharacter, pg::SqlStateFromString("2200C"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidUseOfEscapeCharacter));
    EXPECT_EQ(pg::SqlState::kMostSpecificTypeMismatch, pg::SqlStateFromString("2200G"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kMostSpecificTypeMismatch));
    EXPECT_EQ(pg::SqlState::kNullValueNotAllowed, pg::SqlStateFromString("22004"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kNullValueNotAllowed));
    EXPECT_EQ(pg::SqlState::kNullValueNoIndicatorParameter, pg::SqlStateFromString("22002"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kNullValueNoIndicatorParameter));
    EXPECT_EQ(pg::SqlState::kNumericValueOutOfRange, pg::SqlStateFromString("22003"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kNumericValueOutOfRange));
    EXPECT_EQ(pg::SqlState::kSequenceGeneratorLimitExceeded, pg::SqlStateFromString("2200H"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kSequenceGeneratorLimitExceeded));
    EXPECT_EQ(pg::SqlState::kStringDataLengthMismatch, pg::SqlStateFromString("22026"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kStringDataLengthMismatch));
    EXPECT_EQ(pg::SqlState::kStringDataRightTruncation, pg::SqlStateFromString("22001"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kStringDataRightTruncation));
    EXPECT_EQ(pg::SqlState::kSubstringError, pg::SqlStateFromString("22011"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kSubstringError));
    EXPECT_EQ(pg::SqlState::kTrimError, pg::SqlStateFromString("22027"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kTrimError));
    EXPECT_EQ(pg::SqlState::kUnterminatedCString, pg::SqlStateFromString("22024"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kUnterminatedCString));
    EXPECT_EQ(pg::SqlState::kZeroLengthCharacterString, pg::SqlStateFromString("2200F"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kZeroLengthCharacterString));
    EXPECT_EQ(pg::SqlState::kFloatingPointException, pg::SqlStateFromString("22P01"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kFloatingPointException));
    EXPECT_EQ(pg::SqlState::kInvalidTextRepresentation, pg::SqlStateFromString("22P02"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidTextRepresentation));
    EXPECT_EQ(pg::SqlState::kInvalidBinaryRepresentation, pg::SqlStateFromString("22P03"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidBinaryRepresentation));
    EXPECT_EQ(pg::SqlState::kBadCopyFileFormat, pg::SqlStateFromString("22P04"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kBadCopyFileFormat));
    EXPECT_EQ(pg::SqlState::kUntranslatableCharacter, pg::SqlStateFromString("22P05"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kUntranslatableCharacter));
    EXPECT_EQ(pg::SqlState::kNotAnXmlDocument, pg::SqlStateFromString("2200L"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kNotAnXmlDocument));
    EXPECT_EQ(pg::SqlState::kInvalidXmlDocument, pg::SqlStateFromString("2200M"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidXmlDocument));
    EXPECT_EQ(pg::SqlState::kInvalidXmlContent, pg::SqlStateFromString("2200N"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidXmlContent));
    EXPECT_EQ(pg::SqlState::kInvalidXmlComment, pg::SqlStateFromString("2200S"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidXmlComment));
    EXPECT_EQ(pg::SqlState::kInvalidXmlProcessingInstruction, pg::SqlStateFromString("2200T"));
}

TEST(PostgreError, SqlStateDataException2) {
    // Class 22 — Data Exception
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidXmlProcessingInstruction));
    EXPECT_EQ(pg::SqlState::kDuplicateJsonObjectKeyValue, pg::SqlStateFromString("22030"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kDuplicateJsonObjectKeyValue));
    EXPECT_EQ(pg::SqlState::kInvalidJsonText, pg::SqlStateFromString("22032"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidJsonText));
    EXPECT_EQ(pg::SqlState::kInvalidSqlJsonSubscript, pg::SqlStateFromString("22033"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kInvalidSqlJsonSubscript));
    EXPECT_EQ(pg::SqlState::kMoreThanOneSqlJsonItem, pg::SqlStateFromString("22034"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kMoreThanOneSqlJsonItem));
    EXPECT_EQ(pg::SqlState::kNoSqlJsonItem, pg::SqlStateFromString("22035"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kNoSqlJsonItem));
    EXPECT_EQ(pg::SqlState::kNonNumericSqlJsonItem, pg::SqlStateFromString("22036"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kNonNumericSqlJsonItem));
    EXPECT_EQ(pg::SqlState::kNonUniqueKeysInAJsonObject, pg::SqlStateFromString("22037"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kNonUniqueKeysInAJsonObject));
    EXPECT_EQ(pg::SqlState::kSingletonSqlJsonItemRequired, pg::SqlStateFromString("22038"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kSingletonSqlJsonItemRequired));
    EXPECT_EQ(pg::SqlState::kSqlJsonArrayNotFound, pg::SqlStateFromString("22039"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kSqlJsonArrayNotFound));
    EXPECT_EQ(pg::SqlState::kSqlJsonMemberNotFound, pg::SqlStateFromString("2203A"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kSqlJsonMemberNotFound));
    EXPECT_EQ(pg::SqlState::kSqlJsonNumberNotFound, pg::SqlStateFromString("2203B"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kSqlJsonNumberNotFound));
    EXPECT_EQ(pg::SqlState::kSqlJsonObjectNotFound, pg::SqlStateFromString("2203C"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kSqlJsonObjectNotFound));
    EXPECT_EQ(pg::SqlState::kTooManyJsonArrayElements, pg::SqlStateFromString("2203D"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kTooManyJsonArrayElements));
    EXPECT_EQ(pg::SqlState::kTooManyJsonObjectMembers, pg::SqlStateFromString("2203E"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kTooManyJsonObjectMembers));
    EXPECT_EQ(pg::SqlState::kSqlJsonScalarRequired, pg::SqlStateFromString("2203F"));
    EXPECT_EQ(pg::SqlStateClass::kDataException, pg::GetSqlStateClass(pg::SqlState::kSqlJsonScalarRequired));
}

TEST(PostgreError, SqlStateIntegrityConstraintViolation) {
    // Class 23 — Integrity Constraint Violation
    EXPECT_EQ(pg::SqlState::kIntegrityConstraintViolation, pg::SqlStateFromString("23000"));
    EXPECT_EQ(
        pg::SqlStateClass::kIntegrityConstraintViolation,
        pg::GetSqlStateClass(pg::SqlState::kIntegrityConstraintViolation)
    );
    EXPECT_EQ(pg::SqlState::kRestrictViolation, pg::SqlStateFromString("23001"));
    EXPECT_EQ(pg::SqlStateClass::kIntegrityConstraintViolation, pg::GetSqlStateClass(pg::SqlState::kRestrictViolation));
    EXPECT_EQ(pg::SqlState::kNotNullViolation, pg::SqlStateFromString("23502"));
    EXPECT_EQ(pg::SqlStateClass::kIntegrityConstraintViolation, pg::GetSqlStateClass(pg::SqlState::kNotNullViolation));
    EXPECT_EQ(pg::SqlState::kForeignKeyViolation, pg::SqlStateFromString("23503"));
    EXPECT_EQ(
        pg::SqlStateClass::kIntegrityConstraintViolation, pg::GetSqlStateClass(pg::SqlState::kForeignKeyViolation)
    );
    EXPECT_EQ(pg::SqlState::kUniqueViolation, pg::SqlStateFromString("23505"));
    EXPECT_EQ(pg::SqlStateClass::kIntegrityConstraintViolation, pg::GetSqlStateClass(pg::SqlState::kUniqueViolation));
    EXPECT_EQ(pg::SqlState::kCheckViolation, pg::SqlStateFromString("23514"));
    EXPECT_EQ(pg::SqlStateClass::kIntegrityConstraintViolation, pg::GetSqlStateClass(pg::SqlState::kCheckViolation));
    EXPECT_EQ(pg::SqlState::kExclusionViolation, pg::SqlStateFromString("23P01"));
    EXPECT_EQ(
        pg::SqlStateClass::kIntegrityConstraintViolation, pg::GetSqlStateClass(pg::SqlState::kExclusionViolation)
    );
}

TEST(PostgreError, SqlStateInvalidCursorState) {
    // Class 24 — Invalid Cursor State
    EXPECT_EQ(pg::SqlState::kInvalidCursorState, pg::SqlStateFromString("24000"));
    EXPECT_EQ(pg::SqlStateClass::kInvalidCursorState, pg::GetSqlStateClass(pg::SqlState::kInvalidCursorState));
}

TEST(PostgreError, SqlStateInvalidTransactionState) {
    // Class 25 — Invalid Transaction State
    EXPECT_EQ(pg::SqlState::kInvalidTransactionState, pg::SqlStateFromString("25000"));
    EXPECT_EQ(
        pg::SqlStateClass::kInvalidTransactionState, pg::GetSqlStateClass(pg::SqlState::kInvalidTransactionState)
    );
    EXPECT_EQ(pg::SqlState::kActiveSqlTransaction, pg::SqlStateFromString("25001"));
    EXPECT_EQ(pg::SqlStateClass::kInvalidTransactionState, pg::GetSqlStateClass(pg::SqlState::kActiveSqlTransaction));
    EXPECT_EQ(pg::SqlState::kBranchTransactionAlreadyActive, pg::SqlStateFromString("25002"));
    EXPECT_EQ(
        pg::SqlStateClass::kInvalidTransactionState, pg::GetSqlStateClass(pg::SqlState::kBranchTransactionAlreadyActive)
    );
    EXPECT_EQ(pg::SqlState::kHeldCursorRequiresSameIsolationLevel, pg::SqlStateFromString("25008"));
    EXPECT_EQ(
        pg::SqlStateClass::kInvalidTransactionState,
        pg::GetSqlStateClass(pg::SqlState::kHeldCursorRequiresSameIsolationLevel)
    );
    EXPECT_EQ(pg::SqlState::kInappropriateAccessModeForBranchTransaction, pg::SqlStateFromString("25003"));
    EXPECT_EQ(
        pg::SqlStateClass::kInvalidTransactionState,
        pg::GetSqlStateClass(pg::SqlState::kInappropriateAccessModeForBranchTransaction)
    );
    EXPECT_EQ(pg::SqlState::kInappropriateIsolationLevelForBranchTransaction, pg::SqlStateFromString("25004"));
    EXPECT_EQ(
        pg::SqlStateClass::kInvalidTransactionState,
        pg::GetSqlStateClass(pg::SqlState::kInappropriateIsolationLevelForBranchTransaction)
    );
    EXPECT_EQ(pg::SqlState::kNoActiveSqlTransactionForBranchTransaction, pg::SqlStateFromString("25005"));
    EXPECT_EQ(
        pg::SqlStateClass::kInvalidTransactionState,
        pg::GetSqlStateClass(pg::SqlState::kNoActiveSqlTransactionForBranchTransaction)
    );
    EXPECT_EQ(pg::SqlState::kReadOnlySqlTransaction, pg::SqlStateFromString("25006"));
    EXPECT_EQ(pg::SqlStateClass::kInvalidTransactionState, pg::GetSqlStateClass(pg::SqlState::kReadOnlySqlTransaction));
    EXPECT_EQ(pg::SqlState::kSchemaAndDataStatementMixingNotSupported, pg::SqlStateFromString("25007"));
    EXPECT_EQ(
        pg::SqlStateClass::kInvalidTransactionState,
        pg::GetSqlStateClass(pg::SqlState::kSchemaAndDataStatementMixingNotSupported)
    );
    EXPECT_EQ(pg::SqlState::kNoActiveSqlTransaction, pg::SqlStateFromString("25P01"));
    EXPECT_EQ(pg::SqlStateClass::kInvalidTransactionState, pg::GetSqlStateClass(pg::SqlState::kNoActiveSqlTransaction));
    EXPECT_EQ(pg::SqlState::kInFailedSqlTransaction, pg::SqlStateFromString("25P02"));
    EXPECT_EQ(pg::SqlStateClass::kInvalidTransactionState, pg::GetSqlStateClass(pg::SqlState::kInFailedSqlTransaction));
    EXPECT_EQ(pg::SqlState::kIdleInTransactionSessionTimeout, pg::SqlStateFromString("25P03"));
    EXPECT_EQ(
        pg::SqlStateClass::kInvalidTransactionState,
        pg::GetSqlStateClass(pg::SqlState::kIdleInTransactionSessionTimeout)
    );
}

TEST(PostgreError, SqlStateInvalidSqlStatementName) {
    // Class 26 — Invalid SQL Statement Name
    EXPECT_EQ(pg::SqlState::kInvalidSqlStatementName, pg::SqlStateFromString("26000"));
    EXPECT_EQ(
        pg::SqlStateClass::kInvalidSqlStatementName, pg::GetSqlStateClass(pg::SqlState::kInvalidSqlStatementName)
    );
}

TEST(PostgreError, SqlStateTriggeredDataChangeViolation) {
    // Class 27 — Triggered Data Change Violation
    EXPECT_EQ(pg::SqlState::kTriggeredDataChangeViolation, pg::SqlStateFromString("27000"));
    EXPECT_EQ(
        pg::SqlStateClass::kTriggeredDataChangeViolation,
        pg::GetSqlStateClass(pg::SqlState::kTriggeredDataChangeViolation)
    );
}

TEST(PostgreError, SqlStateInvalidAuthorizationSpecification) {
    // Class 28 — Invalid Authorization Specification
    EXPECT_EQ(pg::SqlState::kInvalidAuthorizationSpecification, pg::SqlStateFromString("28000"));
    EXPECT_EQ(
        pg::SqlStateClass::kInvalidAuthorizationSpecification,
        pg::GetSqlStateClass(pg::SqlState::kInvalidAuthorizationSpecification)
    );
    EXPECT_EQ(pg::SqlState::kInvalidPassword, pg::SqlStateFromString("28P01"));
    EXPECT_EQ(
        pg::SqlStateClass::kInvalidAuthorizationSpecification, pg::GetSqlStateClass(pg::SqlState::kInvalidPassword)
    );
}

TEST(PostgreError, SqlStateDependentPrivilegeDescriptorsStillExist) {
    // Class 2B — Dependent Privilege Descriptors Still Exist
    EXPECT_EQ(pg::SqlState::kDependentPrivilegeDescriptorsStillExist, pg::SqlStateFromString("2B000"));
    EXPECT_EQ(
        pg::SqlStateClass::kDependentPrivilegeDescriptorsStillExist,
        pg::GetSqlStateClass(pg::SqlState::kDependentPrivilegeDescriptorsStillExist)
    );
    EXPECT_EQ(pg::SqlState::kDependentObjectsStillExist, pg::SqlStateFromString("2BP01"));
    EXPECT_EQ(
        pg::SqlStateClass::kDependentPrivilegeDescriptorsStillExist,
        pg::GetSqlStateClass(pg::SqlState::kDependentObjectsStillExist)
    );
}

TEST(PostgreError, SqlStateInvalidTransactionTermination) {
    // Class 2D — Invalid Transaction Termination
    EXPECT_EQ(pg::SqlState::kInvalidTransactionTermination, pg::SqlStateFromString("2D000"));
    EXPECT_EQ(
        pg::SqlStateClass::kInvalidTransactionTermination,
        pg::GetSqlStateClass(pg::SqlState::kInvalidTransactionTermination)
    );
}

TEST(PostgreError, SqlStateSqlRoutineException) {
    // Class 2F — SQL Routine Exception
    EXPECT_EQ(pg::SqlState::kSqlRoutineException, pg::SqlStateFromString("2F000"));
    EXPECT_EQ(pg::SqlStateClass::kSqlRoutineException, pg::GetSqlStateClass(pg::SqlState::kSqlRoutineException));
    EXPECT_EQ(pg::SqlState::kFunctionExecutedNoReturnStatement, pg::SqlStateFromString("2F005"));
    EXPECT_EQ(
        pg::SqlStateClass::kSqlRoutineException, pg::GetSqlStateClass(pg::SqlState::kFunctionExecutedNoReturnStatement)
    );
    EXPECT_EQ(pg::SqlState::kModifyingSqlDataNotPermitted, pg::SqlStateFromString("2F002"));
    EXPECT_EQ(
        pg::SqlStateClass::kSqlRoutineException, pg::GetSqlStateClass(pg::SqlState::kModifyingSqlDataNotPermitted)
    );
    EXPECT_EQ(pg::SqlState::kProhibitedSqlStatementAttempted, pg::SqlStateFromString("2F003"));
    EXPECT_EQ(
        pg::SqlStateClass::kSqlRoutineException, pg::GetSqlStateClass(pg::SqlState::kProhibitedSqlStatementAttempted)
    );
    EXPECT_EQ(pg::SqlState::kReadingSqlDataNotPermitted, pg::SqlStateFromString("2F004"));
    EXPECT_EQ(pg::SqlStateClass::kSqlRoutineException, pg::GetSqlStateClass(pg::SqlState::kReadingSqlDataNotPermitted));
}

TEST(PostgreError, SqlStateInvalidCursorName) {
    // Class 34 — Invalid Cursor Name
    EXPECT_EQ(pg::SqlState::kInvalidCursorName, pg::SqlStateFromString("34000"));
    EXPECT_EQ(pg::SqlStateClass::kInvalidCursorName, pg::GetSqlStateClass(pg::SqlState::kInvalidCursorName));
}

TEST(PostgreError, SqlStateExternalRoutineException) {
    // Class 38 — External Routine Exception
    EXPECT_EQ(pg::SqlState::kExternalRoutineException, pg::SqlStateFromString("38000"));
    EXPECT_EQ(
        pg::SqlStateClass::kExternalRoutineException, pg::GetSqlStateClass(pg::SqlState::kExternalRoutineException)
    );
    EXPECT_EQ(pg::SqlState::kContainingSqlNotPermitted, pg::SqlStateFromString("38001"));
    EXPECT_EQ(
        pg::SqlStateClass::kExternalRoutineException, pg::GetSqlStateClass(pg::SqlState::kContainingSqlNotPermitted)
    );
    EXPECT_EQ(pg::SqlState::kModifyingSqlDataNotPermittedEx, pg::SqlStateFromString("38002"));
    EXPECT_EQ(
        pg::SqlStateClass::kExternalRoutineException,
        pg::GetSqlStateClass(pg::SqlState::kModifyingSqlDataNotPermittedEx)
    );
    EXPECT_EQ(pg::SqlState::kProhibitedSqlStatementAttemptedEx, pg::SqlStateFromString("38003"));
    EXPECT_EQ(
        pg::SqlStateClass::kExternalRoutineException,
        pg::GetSqlStateClass(pg::SqlState::kProhibitedSqlStatementAttemptedEx)
    );
    EXPECT_EQ(pg::SqlState::kReadingSqlDataNotPermittedEx, pg::SqlStateFromString("38004"));
    EXPECT_EQ(
        pg::SqlStateClass::kExternalRoutineException, pg::GetSqlStateClass(pg::SqlState::kReadingSqlDataNotPermittedEx)
    );
}

TEST(PostgreError, SqlStateExternalRoutineInvocationException) {
    // Class 39 — External Routine Invocation Exception
    EXPECT_EQ(pg::SqlState::kExternalRoutineInvocationException, pg::SqlStateFromString("39000"));
    EXPECT_EQ(
        pg::SqlStateClass::kExternalRoutineInvocationException,
        pg::GetSqlStateClass(pg::SqlState::kExternalRoutineInvocationException)
    );
    EXPECT_EQ(pg::SqlState::kInvalidSqlstateReturned, pg::SqlStateFromString("39001"));
    EXPECT_EQ(
        pg::SqlStateClass::kExternalRoutineInvocationException,
        pg::GetSqlStateClass(pg::SqlState::kInvalidSqlstateReturned)
    );
    EXPECT_EQ(pg::SqlState::kNullValueNotAllowedEx, pg::SqlStateFromString("39004"));
    EXPECT_EQ(
        pg::SqlStateClass::kExternalRoutineInvocationException,
        pg::GetSqlStateClass(pg::SqlState::kNullValueNotAllowedEx)
    );
    EXPECT_EQ(pg::SqlState::kTriggerProtocolViolated, pg::SqlStateFromString("39P01"));
    EXPECT_EQ(
        pg::SqlStateClass::kExternalRoutineInvocationException,
        pg::GetSqlStateClass(pg::SqlState::kTriggerProtocolViolated)
    );
    EXPECT_EQ(pg::SqlState::kSrfProtocolViolated, pg::SqlStateFromString("39P02"));
    EXPECT_EQ(
        pg::SqlStateClass::kExternalRoutineInvocationException, pg::GetSqlStateClass(pg::SqlState::kSrfProtocolViolated)
    );
    EXPECT_EQ(pg::SqlState::kEventTriggerProtocolViolated, pg::SqlStateFromString("39P03"));
    EXPECT_EQ(
        pg::SqlStateClass::kExternalRoutineInvocationException,
        pg::GetSqlStateClass(pg::SqlState::kEventTriggerProtocolViolated)
    );
}

TEST(PostgreError, SqlStateSavepointException) {
    // Class 3B — Savepoint Exception
    EXPECT_EQ(pg::SqlState::kSavepointException, pg::SqlStateFromString("3B000"));
    EXPECT_EQ(pg::SqlStateClass::kSavepointException, pg::GetSqlStateClass(pg::SqlState::kSavepointException));
    EXPECT_EQ(pg::SqlState::kInvalidSavepointSpecification, pg::SqlStateFromString("3B001"));
    EXPECT_EQ(
        pg::SqlStateClass::kSavepointException, pg::GetSqlStateClass(pg::SqlState::kInvalidSavepointSpecification)
    );
}

TEST(PostgreError, SqlStateInvalidCatalogName) {
    // Class 3D — Invalid Catalog Name
    EXPECT_EQ(pg::SqlState::kInvalidCatalogName, pg::SqlStateFromString("3D000"));
    EXPECT_EQ(pg::SqlStateClass::kInvalidCatalogName, pg::GetSqlStateClass(pg::SqlState::kInvalidCatalogName));
}

TEST(PostgreError, SqlStateInvalidSchemaName) {
    // Class 3F — Invalid Schema Name
    EXPECT_EQ(pg::SqlState::kInvalidSchemaName, pg::SqlStateFromString("3F000"));
    EXPECT_EQ(pg::SqlStateClass::kInvalidSchemaName, pg::GetSqlStateClass(pg::SqlState::kInvalidSchemaName));
}

TEST(PostgreError, SqlStateTransactionRollback) {
    // Class 40 — Transaction Rollback
    EXPECT_EQ(pg::SqlState::kTransactionRollback, pg::SqlStateFromString("40000"));
    EXPECT_EQ(pg::SqlStateClass::kTransactionRollback, pg::GetSqlStateClass(pg::SqlState::kTransactionRollback));
    EXPECT_EQ(pg::SqlState::kTransactionIntegrityConstraintViolation, pg::SqlStateFromString("40002"));
    EXPECT_EQ(
        pg::SqlStateClass::kTransactionRollback,
        pg::GetSqlStateClass(pg::SqlState::kTransactionIntegrityConstraintViolation)
    );
    EXPECT_EQ(pg::SqlState::kSerializationFailure, pg::SqlStateFromString("40001"));
    EXPECT_EQ(pg::SqlStateClass::kTransactionRollback, pg::GetSqlStateClass(pg::SqlState::kSerializationFailure));
    EXPECT_EQ(pg::SqlState::kStatementCompletionUnknown, pg::SqlStateFromString("40003"));
    EXPECT_EQ(pg::SqlStateClass::kTransactionRollback, pg::GetSqlStateClass(pg::SqlState::kStatementCompletionUnknown));
    EXPECT_EQ(pg::SqlState::kDeadlockDetected, pg::SqlStateFromString("40P01"));
    EXPECT_EQ(pg::SqlStateClass::kTransactionRollback, pg::GetSqlStateClass(pg::SqlState::kDeadlockDetected));
}

TEST(PostgreError, SqlStateSyntaxErrorOrAccessRuleViolation) {
    // Class 42 — Syntax Error or Access Rule Violation
    EXPECT_EQ(pg::SqlState::kSyntaxErrorOrAccessRuleViolation, pg::SqlStateFromString("42000"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation,
        pg::GetSqlStateClass(pg::SqlState::kSyntaxErrorOrAccessRuleViolation)
    );
    EXPECT_EQ(pg::SqlState::kSyntaxError, pg::SqlStateFromString("42601"));
    EXPECT_EQ(pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kSyntaxError));
    EXPECT_EQ(pg::SqlState::kInsufficientPrivilege, pg::SqlStateFromString("42501"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kInsufficientPrivilege)
    );
    EXPECT_EQ(pg::SqlState::kCannotCoerce, pg::SqlStateFromString("42846"));
    EXPECT_EQ(pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kCannotCoerce));
    EXPECT_EQ(pg::SqlState::kGroupingError, pg::SqlStateFromString("42803"));
    EXPECT_EQ(pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kGroupingError));
    EXPECT_EQ(pg::SqlState::kWindowingError, pg::SqlStateFromString("42P20"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kWindowingError)
    );
    EXPECT_EQ(pg::SqlState::kInvalidRecursion, pg::SqlStateFromString("42P19"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kInvalidRecursion)
    );
    EXPECT_EQ(pg::SqlState::kInvalidForeignKey, pg::SqlStateFromString("42830"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kInvalidForeignKey)
    );
    EXPECT_EQ(pg::SqlState::kInvalidName, pg::SqlStateFromString("42602"));
    EXPECT_EQ(pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kInvalidName));
    EXPECT_EQ(pg::SqlState::kNameTooLong, pg::SqlStateFromString("42622"));
    EXPECT_EQ(pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kNameTooLong));
    EXPECT_EQ(pg::SqlState::kReservedName, pg::SqlStateFromString("42939"));
    EXPECT_EQ(pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kReservedName));
    EXPECT_EQ(pg::SqlState::kDatatypeMismatch, pg::SqlStateFromString("42804"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kDatatypeMismatch)
    );
    EXPECT_EQ(pg::SqlState::kIndeterminateDatatype, pg::SqlStateFromString("42P18"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kIndeterminateDatatype)
    );
    EXPECT_EQ(pg::SqlState::kCollationMismatch, pg::SqlStateFromString("42P21"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kCollationMismatch)
    );
    EXPECT_EQ(pg::SqlState::kIndeterminateCollation, pg::SqlStateFromString("42P22"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation,
        pg::GetSqlStateClass(pg::SqlState::kIndeterminateCollation)
    );
    EXPECT_EQ(pg::SqlState::kWrongObjectType, pg::SqlStateFromString("42809"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kWrongObjectType)
    );
    EXPECT_EQ(pg::SqlState::kGeneratedAlways, pg::SqlStateFromString("428C9"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kGeneratedAlways)
    );
    EXPECT_EQ(pg::SqlState::kUndefinedColumn, pg::SqlStateFromString("42703"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kUndefinedColumn)
    );
    EXPECT_EQ(pg::SqlState::kUndefinedFunction, pg::SqlStateFromString("42883"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kUndefinedFunction)
    );
    EXPECT_EQ(pg::SqlState::kUndefinedTable, pg::SqlStateFromString("42P01"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kUndefinedTable)
    );
    EXPECT_EQ(pg::SqlState::kUndefinedParameter, pg::SqlStateFromString("42P02"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kUndefinedParameter)
    );
    EXPECT_EQ(pg::SqlState::kUndefinedObject, pg::SqlStateFromString("42704"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kUndefinedObject)
    );
    EXPECT_EQ(pg::SqlState::kDuplicateColumn, pg::SqlStateFromString("42701"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kDuplicateColumn)
    );
    EXPECT_EQ(pg::SqlState::kDuplicateCursor, pg::SqlStateFromString("42P03"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kDuplicateCursor)
    );
    EXPECT_EQ(pg::SqlState::kDuplicateDatabase, pg::SqlStateFromString("42P04"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kDuplicateDatabase)
    );
    EXPECT_EQ(pg::SqlState::kDuplicateFunction, pg::SqlStateFromString("42723"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kDuplicateFunction)
    );
    EXPECT_EQ(pg::SqlState::kDuplicatePreparedStatement, pg::SqlStateFromString("42P05"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation,
        pg::GetSqlStateClass(pg::SqlState::kDuplicatePreparedStatement)
    );
    EXPECT_EQ(pg::SqlState::kDuplicateSchema, pg::SqlStateFromString("42P06"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kDuplicateSchema)
    );
    EXPECT_EQ(pg::SqlState::kDuplicateTable, pg::SqlStateFromString("42P07"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kDuplicateTable)
    );
    EXPECT_EQ(pg::SqlState::kDuplicateAlias, pg::SqlStateFromString("42712"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kDuplicateAlias)
    );
    EXPECT_EQ(pg::SqlState::kDuplicateObject, pg::SqlStateFromString("42710"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kDuplicateObject)
    );
    EXPECT_EQ(pg::SqlState::kAmbiguousColumn, pg::SqlStateFromString("42702"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kAmbiguousColumn)
    );
    EXPECT_EQ(pg::SqlState::kAmbiguousFunction, pg::SqlStateFromString("42725"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kAmbiguousFunction)
    );
    EXPECT_EQ(pg::SqlState::kAmbiguousParameter, pg::SqlStateFromString("42P08"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kAmbiguousParameter)
    );
    EXPECT_EQ(pg::SqlState::kAmbiguousAlias, pg::SqlStateFromString("42P09"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation, pg::GetSqlStateClass(pg::SqlState::kAmbiguousAlias)
    );
    EXPECT_EQ(pg::SqlState::kInvalidColumnReference, pg::SqlStateFromString("42P10"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation,
        pg::GetSqlStateClass(pg::SqlState::kInvalidColumnReference)
    );
    EXPECT_EQ(pg::SqlState::kInvalidColumnDefinition, pg::SqlStateFromString("42611"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation,
        pg::GetSqlStateClass(pg::SqlState::kInvalidColumnDefinition)
    );
    EXPECT_EQ(pg::SqlState::kInvalidCursorDefinition, pg::SqlStateFromString("42P11"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation,
        pg::GetSqlStateClass(pg::SqlState::kInvalidCursorDefinition)
    );
    EXPECT_EQ(pg::SqlState::kInvalidDatabaseDefinition, pg::SqlStateFromString("42P12"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation,
        pg::GetSqlStateClass(pg::SqlState::kInvalidDatabaseDefinition)
    );
    EXPECT_EQ(pg::SqlState::kInvalidFunctionDefinition, pg::SqlStateFromString("42P13"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation,
        pg::GetSqlStateClass(pg::SqlState::kInvalidFunctionDefinition)
    );
    EXPECT_EQ(pg::SqlState::kInvalidPreparedStatementDefinition, pg::SqlStateFromString("42P14"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation,
        pg::GetSqlStateClass(pg::SqlState::kInvalidPreparedStatementDefinition)
    );
    EXPECT_EQ(pg::SqlState::kInvalidSchemaDefinition, pg::SqlStateFromString("42P15"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation,
        pg::GetSqlStateClass(pg::SqlState::kInvalidSchemaDefinition)
    );
    EXPECT_EQ(pg::SqlState::kInvalidTableDefinition, pg::SqlStateFromString("42P16"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation,
        pg::GetSqlStateClass(pg::SqlState::kInvalidTableDefinition)
    );
    EXPECT_EQ(pg::SqlState::kInvalidObjectDefinition, pg::SqlStateFromString("42P17"));
    EXPECT_EQ(
        pg::SqlStateClass::kSyntaxErrorOrAccessRuleViolation,
        pg::GetSqlStateClass(pg::SqlState::kInvalidObjectDefinition)
    );
}

TEST(PostgreError, SqlStateWithCheckOptionViolation) {
    // Class 44 — WITH CHECK OPTION Violation
    EXPECT_EQ(pg::SqlState::kWithCheckOptionViolation, pg::SqlStateFromString("44000"));
    EXPECT_EQ(
        pg::SqlStateClass::kWithCheckOptionViolation, pg::GetSqlStateClass(pg::SqlState::kWithCheckOptionViolation)
    );
}

TEST(PostgreError, SqlStateInsufficientResources) {
    // Class 53 — Insufficient Resources
    EXPECT_EQ(pg::SqlState::kInsufficientResources, pg::SqlStateFromString("53000"));
    EXPECT_EQ(pg::SqlStateClass::kInsufficientResources, pg::GetSqlStateClass(pg::SqlState::kInsufficientResources));
    EXPECT_EQ(pg::SqlState::kDiskFull, pg::SqlStateFromString("53100"));
    EXPECT_EQ(pg::SqlStateClass::kInsufficientResources, pg::GetSqlStateClass(pg::SqlState::kDiskFull));
    EXPECT_EQ(pg::SqlState::kOutOfMemory, pg::SqlStateFromString("53200"));
    EXPECT_EQ(pg::SqlStateClass::kInsufficientResources, pg::GetSqlStateClass(pg::SqlState::kOutOfMemory));
    EXPECT_EQ(pg::SqlState::kTooManyConnections, pg::SqlStateFromString("53300"));
    EXPECT_EQ(pg::SqlStateClass::kInsufficientResources, pg::GetSqlStateClass(pg::SqlState::kTooManyConnections));
    EXPECT_EQ(pg::SqlState::kConfigurationLimitExceeded, pg::SqlStateFromString("53400"));
    EXPECT_EQ(
        pg::SqlStateClass::kInsufficientResources, pg::GetSqlStateClass(pg::SqlState::kConfigurationLimitExceeded)
    );
}

TEST(PostgreError, SqlStateProgramLimitExceeded) {
    // Class 54 — Program Limit Exceeded
    EXPECT_EQ(pg::SqlState::kProgramLimitExceeded, pg::SqlStateFromString("54000"));
    EXPECT_EQ(pg::SqlStateClass::kProgramLimitExceeded, pg::GetSqlStateClass(pg::SqlState::kProgramLimitExceeded));
    EXPECT_EQ(pg::SqlState::kStatementTooComplex, pg::SqlStateFromString("54001"));
    EXPECT_EQ(pg::SqlStateClass::kProgramLimitExceeded, pg::GetSqlStateClass(pg::SqlState::kStatementTooComplex));
    EXPECT_EQ(pg::SqlState::kTooManyColumns, pg::SqlStateFromString("54011"));
    EXPECT_EQ(pg::SqlStateClass::kProgramLimitExceeded, pg::GetSqlStateClass(pg::SqlState::kTooManyColumns));
    EXPECT_EQ(pg::SqlState::kTooManyArguments, pg::SqlStateFromString("54023"));
    EXPECT_EQ(pg::SqlStateClass::kProgramLimitExceeded, pg::GetSqlStateClass(pg::SqlState::kTooManyArguments));
}

TEST(PostgreError, SqlStateObjectNotInPrerequisiteState) {
    // Class 55 — Object Not In Prerequisite State
    EXPECT_EQ(pg::SqlState::kObjectNotInPrerequisiteState, pg::SqlStateFromString("55000"));
    EXPECT_EQ(
        pg::SqlStateClass::kObjectNotInPrerequisiteState,
        pg::GetSqlStateClass(pg::SqlState::kObjectNotInPrerequisiteState)
    );
    EXPECT_EQ(pg::SqlState::kObjectInUse, pg::SqlStateFromString("55006"));
    EXPECT_EQ(pg::SqlStateClass::kObjectNotInPrerequisiteState, pg::GetSqlStateClass(pg::SqlState::kObjectInUse));
    EXPECT_EQ(pg::SqlState::kCantChangeRuntimeParam, pg::SqlStateFromString("55P02"));
    EXPECT_EQ(
        pg::SqlStateClass::kObjectNotInPrerequisiteState, pg::GetSqlStateClass(pg::SqlState::kCantChangeRuntimeParam)
    );
    EXPECT_EQ(pg::SqlState::kLockNotAvailable, pg::SqlStateFromString("55P03"));
    EXPECT_EQ(pg::SqlStateClass::kObjectNotInPrerequisiteState, pg::GetSqlStateClass(pg::SqlState::kLockNotAvailable));
    EXPECT_EQ(pg::SqlState::kUnsafeNewEnumValueUsage, pg::SqlStateFromString("55P04"));
    EXPECT_EQ(
        pg::SqlStateClass::kObjectNotInPrerequisiteState, pg::GetSqlStateClass(pg::SqlState::kUnsafeNewEnumValueUsage)
    );
}

TEST(PostgreError, SqlStateOperatorIntervention) {
    // Class 57 — Operator Intervention
    EXPECT_EQ(pg::SqlState::kOperatorIntervention, pg::SqlStateFromString("57000"));
    EXPECT_EQ(pg::SqlStateClass::kOperatorIntervention, pg::GetSqlStateClass(pg::SqlState::kOperatorIntervention));
    EXPECT_EQ(pg::SqlState::kQueryCancelled, pg::SqlStateFromString("57014"));
    EXPECT_EQ(pg::SqlStateClass::kOperatorIntervention, pg::GetSqlStateClass(pg::SqlState::kQueryCancelled));
    EXPECT_EQ(pg::SqlState::kAdminShutdown, pg::SqlStateFromString("57P01"));
    EXPECT_EQ(pg::SqlStateClass::kOperatorIntervention, pg::GetSqlStateClass(pg::SqlState::kAdminShutdown));
    EXPECT_EQ(pg::SqlState::kCrashShutdown, pg::SqlStateFromString("57P02"));
    EXPECT_EQ(pg::SqlStateClass::kOperatorIntervention, pg::GetSqlStateClass(pg::SqlState::kCrashShutdown));
    EXPECT_EQ(pg::SqlState::kCannotConnectNow, pg::SqlStateFromString("57P03"));
    EXPECT_EQ(pg::SqlStateClass::kOperatorIntervention, pg::GetSqlStateClass(pg::SqlState::kCannotConnectNow));
    EXPECT_EQ(pg::SqlState::kDatabaseDropped, pg::SqlStateFromString("57P04"));
    EXPECT_EQ(pg::SqlStateClass::kOperatorIntervention, pg::GetSqlStateClass(pg::SqlState::kDatabaseDropped));
}

TEST(PostgreError, SqlStateSystemError) {
    // Class 58 — System Error (errors external to
    EXPECT_EQ(pg::SqlState::kSystemError, pg::SqlStateFromString("58000"));
    EXPECT_EQ(pg::SqlStateClass::kSystemError, pg::GetSqlStateClass(pg::SqlState::kSystemError));
    EXPECT_EQ(pg::SqlState::kIoError, pg::SqlStateFromString("58030"));
    EXPECT_EQ(pg::SqlStateClass::kSystemError, pg::GetSqlStateClass(pg::SqlState::kIoError));
    EXPECT_EQ(pg::SqlState::kUndefinedFile, pg::SqlStateFromString("58P01"));
    EXPECT_EQ(pg::SqlStateClass::kSystemError, pg::GetSqlStateClass(pg::SqlState::kUndefinedFile));
    EXPECT_EQ(pg::SqlState::kDuplicateFile, pg::SqlStateFromString("58P02"));
    EXPECT_EQ(pg::SqlStateClass::kSystemError, pg::GetSqlStateClass(pg::SqlState::kDuplicateFile));
}

TEST(PostgreError, SqlStateSnapshotTooOld) {
    // Class 72 — Snapshot Failure
    EXPECT_EQ(pg::SqlState::kSnapshotTooOld, pg::SqlStateFromString("72000"));
    EXPECT_EQ(pg::SqlStateClass::kSnapshotTooOld, pg::GetSqlStateClass(pg::SqlState::kSnapshotTooOld));
}

TEST(PostgreError, SqlStateConfigFileError) {
    // Class F0 — Configuration File Error
    EXPECT_EQ(pg::SqlState::kConfigFileError, pg::SqlStateFromString("F0000"));
    EXPECT_EQ(pg::SqlStateClass::kConfigFileError, pg::GetSqlStateClass(pg::SqlState::kConfigFileError));
    EXPECT_EQ(pg::SqlState::kLockFileExists, pg::SqlStateFromString("F0001"));
    EXPECT_EQ(pg::SqlStateClass::kConfigFileError, pg::GetSqlStateClass(pg::SqlState::kLockFileExists));
}

TEST(PostgreError, SqlStateFdwError) {
    // Class HV — Foreign Data Wrapper Error (SQL/MED)
    EXPECT_EQ(pg::SqlState::kFdwError, pg::SqlStateFromString("HV000"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwError));
    EXPECT_EQ(pg::SqlState::kFdwColumnNameNotFound, pg::SqlStateFromString("HV005"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwColumnNameNotFound));
    EXPECT_EQ(pg::SqlState::kFdwDynamicParameterValueNeeded, pg::SqlStateFromString("HV002"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwDynamicParameterValueNeeded));
    EXPECT_EQ(pg::SqlState::kFdwFunctionSequenceError, pg::SqlStateFromString("HV010"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwFunctionSequenceError));
    EXPECT_EQ(pg::SqlState::kFdwInconsistentDescriptorInformation, pg::SqlStateFromString("HV021"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwInconsistentDescriptorInformation));
    EXPECT_EQ(pg::SqlState::kFdwInvalidAttributeValue, pg::SqlStateFromString("HV024"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwInvalidAttributeValue));
    EXPECT_EQ(pg::SqlState::kFdwInvalidColumnName, pg::SqlStateFromString("HV007"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwInvalidColumnName));
    EXPECT_EQ(pg::SqlState::kFdwInvalidColumnNumber, pg::SqlStateFromString("HV008"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwInvalidColumnNumber));
    EXPECT_EQ(pg::SqlState::kFdwInvalidDataType, pg::SqlStateFromString("HV004"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwInvalidDataType));
    EXPECT_EQ(pg::SqlState::kFdwInvalidDataTypeDescriptors, pg::SqlStateFromString("HV006"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwInvalidDataTypeDescriptors));
    EXPECT_EQ(pg::SqlState::kFdwInvalidDescriptorFieldIdentifier, pg::SqlStateFromString("HV091"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwInvalidDescriptorFieldIdentifier));
    EXPECT_EQ(pg::SqlState::kFdwInvalidHandle, pg::SqlStateFromString("HV00B"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwInvalidHandle));
    EXPECT_EQ(pg::SqlState::kFdwInvalidOptionIndex, pg::SqlStateFromString("HV00C"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwInvalidOptionIndex));
    EXPECT_EQ(pg::SqlState::kFdwInvalidOptionName, pg::SqlStateFromString("HV00D"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwInvalidOptionName));
    EXPECT_EQ(pg::SqlState::kFdwInvalidStringLengthOrBufferLength, pg::SqlStateFromString("HV090"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwInvalidStringLengthOrBufferLength));
    EXPECT_EQ(pg::SqlState::kFdwInvalidStringFormat, pg::SqlStateFromString("HV00A"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwInvalidStringFormat));
    EXPECT_EQ(pg::SqlState::kFdwInvalidUseOfNullPointer, pg::SqlStateFromString("HV009"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwInvalidUseOfNullPointer));
    EXPECT_EQ(pg::SqlState::kFdwTooManyHandles, pg::SqlStateFromString("HV014"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwTooManyHandles));
    EXPECT_EQ(pg::SqlState::kFdwOutOfMemory, pg::SqlStateFromString("HV001"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwOutOfMemory));
    EXPECT_EQ(pg::SqlState::kFdwNoSchemas, pg::SqlStateFromString("HV00P"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwNoSchemas));
    EXPECT_EQ(pg::SqlState::kFdwOptionNameNotFound, pg::SqlStateFromString("HV00J"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwOptionNameNotFound));
    EXPECT_EQ(pg::SqlState::kFdwReplyHandle, pg::SqlStateFromString("HV00K"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwReplyHandle));
    EXPECT_EQ(pg::SqlState::kFdwSchemaNotFound, pg::SqlStateFromString("HV00Q"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwSchemaNotFound));
    EXPECT_EQ(pg::SqlState::kFdwTableNotFound, pg::SqlStateFromString("HV00R"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwTableNotFound));
    EXPECT_EQ(pg::SqlState::kFdwUnableToCreateExecution, pg::SqlStateFromString("HV00L"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwUnableToCreateExecution));
    EXPECT_EQ(pg::SqlState::kFdwUnableToCreateReply, pg::SqlStateFromString("HV00M"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwUnableToCreateReply));
    EXPECT_EQ(pg::SqlState::kFdwUnableToEstablishConnection, pg::SqlStateFromString("HV00N"));
    EXPECT_EQ(pg::SqlStateClass::kFdwError, pg::GetSqlStateClass(pg::SqlState::kFdwUnableToEstablishConnection));
}

TEST(PostgreError, SqlStatePlpgsqlError) {
    // Class P0 — PL/pgSQL Error
    EXPECT_EQ(pg::SqlState::kPlpgsqlError, pg::SqlStateFromString("P0000"));
    EXPECT_EQ(pg::SqlStateClass::kPlpgsqlError, pg::GetSqlStateClass(pg::SqlState::kPlpgsqlError));
    EXPECT_EQ(pg::SqlState::kRaiseException, pg::SqlStateFromString("P0001"));
    EXPECT_EQ(pg::SqlStateClass::kPlpgsqlError, pg::GetSqlStateClass(pg::SqlState::kRaiseException));
    EXPECT_EQ(pg::SqlState::kNoDataFound, pg::SqlStateFromString("P0002"));
    EXPECT_EQ(pg::SqlStateClass::kPlpgsqlError, pg::GetSqlStateClass(pg::SqlState::kNoDataFound));
    EXPECT_EQ(pg::SqlState::kTooManyRows, pg::SqlStateFromString("P0003"));
    EXPECT_EQ(pg::SqlStateClass::kPlpgsqlError, pg::GetSqlStateClass(pg::SqlState::kTooManyRows));
    EXPECT_EQ(pg::SqlState::kAssertFailure, pg::SqlStateFromString("P0004"));
    EXPECT_EQ(pg::SqlStateClass::kPlpgsqlError, pg::GetSqlStateClass(pg::SqlState::kAssertFailure));
}

TEST(PostgreError, SqlStateInternalError) {
    // Class XX — Internal Error
    EXPECT_EQ(pg::SqlState::kInternalError, pg::SqlStateFromString("XX000"));
    EXPECT_EQ(pg::SqlStateClass::kInternalError, pg::GetSqlStateClass(pg::SqlState::kInternalError));
    EXPECT_EQ(pg::SqlState::kDataCorrupted, pg::SqlStateFromString("XX001"));
    EXPECT_EQ(pg::SqlStateClass::kInternalError, pg::GetSqlStateClass(pg::SqlState::kDataCorrupted));
    EXPECT_EQ(pg::SqlState::kIndexCorrupted, pg::SqlStateFromString("XX002"));
    EXPECT_EQ(pg::SqlStateClass::kInternalError, pg::GetSqlStateClass(pg::SqlState::kIndexCorrupted));
}

USERVER_NAMESPACE_END
