option(USERVER_PGO_GENERATE "Generate PGO profiles on run" OFF)
if(USERVER_PGO_GENERATE)
  message(STATUS "PGO: generate")
  if(CMAKE_CXX_COMPILER_ID STREQUAL "Clang")
    add_compile_options(-fprofile-instr-generate)
    add_link_options(-fprofile-instr-generate)
  elseif(CMAKE_CXX_COMPILER_ID STREQUAL "GNU")
    add_compile_options(-fprofile-generate)
    add_link_options(-fprofile-generate)
  else()
    message(FATAL_ERROR "Don't know how to setup PGO for current compiler (${CMAKE_CXX_COMPILER_ID})")
  endif()
endif()

set(USERVER_PGO_USE "" CACHE FILEPATH "Path to profile file for PGO")
if(USERVER_PGO_USE)
  message(STATUS "PGO: use ${USERVER_PGO_USE} profile")
  if(CMAKE_CXX_COMPILER_ID STREQUAL "Clang")
    add_compile_options(-fprofile-instr-use=${USERVER_PGO_USE})
    add_link_options(-fprofile-instr-use=${USERVER_PGO_USE})
  elseif(CMAKE_CXX_COMPILER_ID STREQUAL "GNU")
    add_compile_options(-fprofile-use)
    add_link_options(-fprofile-use)
  else()
    message(FATAL_ERROR "Don't know how to setup PGO for current compiler (${CMAKE_CXX_COMPILER_ID})")
  endif()
endif()
if(USERVER_PGO_GENERATE AND USERVER_PGO_USE)
  message(FATAL_ERROR "USERVER_PGO_GENERATE and USERVER_PGO_USE cannot be set simultaneously")
endif()
