# Security Policy

## Security Announcements

Security fixes will be announced by posting them in the
[security changelog](https://userver.tech/df/d3a/md_en_userver_security_changelog).


## Scope and Supported Versions

The following versions of userver are currently being supported with security
updates:

| Version | Supported |
|:-|:-|
| develop | ✔️ |


## Reporting a Vulnerability

We're extremely grateful for security researchers and users that report
vulnerabilities to the userver Open Source Community. All reports are
thoroughly investigated by developers.


🐙 userver is the part of the "The Yandex Bug Bounty" program. To report a
potential vulnerability or weakness in userver please send the
details about it to
[https://yandex.com/bugbounty/i/report/](https://yandex.com/bugbounty/i/report/).


### When Should I Report a Vulnerability?

- You think you discovered a potential security vulnerability in userver
- You are unsure how a vulnerability affects userver


### When Should I NOT Report a Vulnerability?

- You need help tuning userver components for security
- You need help applying security related updates
- Your issue is not security related


## Security Vulnerability Response

Each report is acknowledged and analyzed by userver maintainers within 5
working days. As the security issue moves from triage, to identified fix, to
release planning we will keep the reporter updated.


## Public Disclosure Timing

A public disclosure date is negotiated by the userver maintainers and the bug
submitter. We prefer to fully disclose the bug as soon as possible once a user
mitigation is available. It is reasonable to delay disclosure when the bug or
the fix is not yet fully understood, the solution is not well-tested, or for
vendor coordination. The timeframe for disclosure is from immediate to 90 days.
For a vulnerability with a straightforward mitigation, we expect report date to
disclosure date to be on the order of 7 days.
