---
title: Converter (experimental)
---

It is also possible to convert existing regular expressions to `magic-regexp` syntax.

```ts
import { convert } from 'magic-regexp/converter'

convert(/a|b|c/)
// createRegExp(exactly('a').or('b').or('c'))

convert(/(foo)bar\d+/)
// createRegExp(exactly('foo').grouped(), 'bar', oneOrMore(digit))
```

### Options

- `argsOnly` (boolean)
  _Default: `false`_
  Only show arguments without `createRegExp`

```ts
convert(/\w+@\w\.com/, { argsOnly: true })
// oneOrMore(wordChar), '@', wordChar, '.com'
```
