---
title: Transform
---

The best way to use `magic-regexp` is by making use of the included build-time transform.

```js
const beforeTransform = createRegExp(exactly('foo/test.js').after('bar/'))
// => gets _compiled_ to
const afterTransform = /(?<=bar\/)foo\/test\.js/
```

Of course, this only works with non-dynamic regexps. Within the `createRegExp` block you have to include all the helpers you are using from `magic-regexp` - and not rely on any external variables. This, for example, will not statically compile into a RegExp, although it will still continue to work with a minimal runtime:

```js
const someString = 'test'
const regExp = createRegExp(exactly(someString))
```
