---
title: Setup
description: Install magic-regexp from npm and (optionally) enable the build-time transform via a plugin.
---

First, install `magic-regexp`:

:pm-install{name="magic-regexp"}

---

Second, optionally, you can enable the included transform, [which enables zero-runtime usage](/guide/usage#build-time-transform).

::code-group

```js [nuxt.config.ts]
// Nuxt 3
import { defineNuxtConfig } from 'nuxt'

export default defineNuxtConfig({
  // This will also enable auto-imports of magic-regexp helpers
  modules: ['magic-regexp/nuxt'],
})
```

```js [vite.config.ts]
import { MagicRegExpTransformPlugin } from 'magic-regexp/transform'
import { defineConfig } from 'vite'

export default defineConfig({
  plugins: [MagicRegExpTransformPlugin.vite()],
})
```

```js [next.config.mjs]
// or, if using next.config.js
// const { MagicRegExpTransformPlugin } = require('magic-regexp/transform')
import { MagicRegExpTransformPlugin } from 'magic-regexp/transform'

export default {
  webpack(config) {
    config.plugins = config.plugins || []
    config.plugins.push(MagicRegExpTransformPlugin.webpack())
    return config
  },
}
```

```js [build.config.ts ]
import { MagicRegExpTransformPlugin } from 'magic-regexp/transform'
// unbuild
import { defineBuildConfig } from 'unbuild'

export default defineBuildConfig({
  hooks: {
    'rollup:options': (options, config) => {
      config.plugins.push(MagicRegExpTransformPlugin.rollup())
    },
  },
})
```

::
