# Prompt 即代码：设计和管理 AI 编程的最佳实践

> Prompt 即代码是一种基于多种输入模态的编程工具，它通过结合文本、图像、语音等多种输入方式来提供更丰富的上下文信息，帮助程序员更好地表达自己的意图，并生成相应的代码实现。Prompt 即代码将 prompt 作为代码的一部分，以及作为标准接口来定义生成的代码，同时提供注释和文档信息以支持可读性和可维护性。通过使用 prompt 即代码，程序员可以提高编码效率，同时生成更准确、更可靠的代码实现。
> 

在前两篇 AI 编程文章《**[渐近式 AI 编程模式：Unit Mesh 架构的设计思路与探索](https://www.phodal.com/blog/unit-mesh/)**》与《**[未来可期的 AI 编程：到底是程序员的终极解放还是失业的开始？](https://www.phodal.com/blog/thinking-in-ai-programming/)》**里，我们已经阐述了几年后、未来的  AI 编程带来的影响。

而在不考虑采用诸如 Unit Mesh 新架构的情况下，我们需要在现有的架构和工程体系中融入 AI 编程。因此在这篇文章里，我们将回到现在 —— 此时此该，我们应该如何与 AI 编程共处，让 AI 成为我们的 Copliot。

## 引子 1：一年的 GitHub Copilot 感受：20% 的效率提升

相关的例子可以见： [https://www.clickprompt.org/zh-CN/github-copilot-samples/](https://www.clickprompt.org/zh-CN/github-copilot-samples/) 

自打 GitHub Copilot 正式发布以后，作为知名的开源挖坑作者，拿到了免费的版本，但是只能偷偷使用。**公司明令禁止**我们在公司项目使用，所以只能在业余项目、开源项目中用用。

从个人的使用体验来说，AI 大概提升了我 20% 的编码效率 —— 大抵是我写的代码都比较偏门。但是怎么说呢，**抄、fork、生成** 的代码质量都  TM 的不行（有可能我是 Clean Code 的忠粉），所以 ，我经常吐槽说，你在垃圾库里是训练不出好的模型的。

所以，简单来说，对于效率提升是大大的，如果是 CRUD 效率更高，但是质量不行。反正，以后重写速度比重构更快，代码质量不重要（手动狗头）。

除此，从个人的感受来说，编写 Copilot 所需要的 Prompt 是需要学习门槛的。

## 引子 2：AI 编程的门槛

回到真实世界，我们要用好 AI 编码，需要考虑这个问题？

### 问题 1：AI 编程能取代人类编程吗？

不论是 GPT-4 发布会的 Demo，还是令大家惊艳的 [Cursor.so](http://Cursor.so) 开发工具。就当前的 GPT 能力而言，谈编程消失还太早了。GPT 只是一个复读机，解决不了任何复杂的编程问题。复杂场景下，GPT 容易丢失部分条件，需要由人来作这好 Tasking 的过程。

在条件不充分的情况，你可以轻松让 AI 生成一个页面、一个函数，但是他无法达到你想要的结果。所以在，Unit Mesh 架构下，一部分程序员成为了 **AI 代码验证师 + AI 代码修复师**，它将持续非常很长一段时间。

### 问题 2：编程只是在编码？

当前的 AI 编程只是取代你的转译过程：需求细分、转换需求成代码等。你可以看看你的提交历史：一天提交了几行代码，又是哪个时间提交的。有可能你算下来了，白天都在开会，只有晚上写代码。我记得知乎有一个相关的问题，大部分人的回答都是平均**几十行、几百行**。当然按行数是不科学的，成长期的项目的行数是远大于维护期的。

所以，如果你的编码时间很长，而架构设计、需求讨论等的时间很短，可能得考虑一下职业生涯，强化你的设计、拆解能力。毕竟，一旦效率提高的，还是有些程序员会失业的。

### 问题 3：人人都会写好的 Prompt？

身处于各类可访问 ChatGPT 的微信群中，遇到很多问题的时候，我经常会抛出一句：”问 ChatGPT 啊“。很多人并不会真正意识到 ChatGPT 是一个工具，唯一的乐趣可能就是：”请帮我生成一个 KFC v50 的故事“。

这也是我们创建 ClickPrompt、ChatFlow、PromptPatterns 等项目的初衷，大部分人需要先意识到  AI 能做什么。然后，才是如何写好 Prompt，我们要摸摸我们的 Copilot 的脾气，然后再一起干活。诸如于：

- 函数名直接生成代码。
- 函数名 + 处理步骤生成代码。

每种模式的背后，都很有意思。

## Prompt 即代码：一个新的规范 ——  Prompt  编写规范

在进一步展开 Prompt 即代码之前，我们需要先了解一下如何写好 Prompt。如下是，我之前放在 ClickPrompt 上面的一部分 GitHub Copilot 示例。

![Untitled](https://s3-us-west-2.amazonaws.com/secure.notion-static.com/b4f06e73-3bb3-4335-ba1a-27f381b00a89/Untitled.png)

从我的理解来说，一个好的 Prompt 规范应该包括以下内容：

1. 功能定义：定义所需的功能，并为模型提供足够的上下文和信息。这可以帮助模型更好地理解其意图并生成相应的代码。示例 1：函数名、输入和输出，就能自动填充。
2. 任务拆分：将任务拆分为小的子任务，并确保每个子任务的要求和期望输出都非常清晰。示例 2：如上图的按步骤设计示例，每一步都需要想好要怎么做。
3. 确定输入与输出格式：Prompt 规范应该明确输入与输出格式和数据类型，以便模型可以正确地处理输入。示例 3：我们添加了 i18n 的 json 过来，让 Copilot 自动映射。
4. 测试和调试：在生成代码之后，应该进行测试和调试，以确保其正确性和可靠性。同时，应该为模型提供反馈，以帮助它改进其生成的代码。示例：让 Copilot 编写对应的单元测试，我们对测试用例进行检查。
5. 避免歧义：Prompt 规范应该避免使用歧义的语言和术语，并确保在多种上下文中生成的代码是一致的。只在出错时，我们才会发现这条原则是有用的。
6. 编码标准：定义编码标准，并确保生成的代码符合这些标准。这可以确保生成的代码易于阅读和维护，并符合团队的编码惯例。这个就需要我们团队去做了。

看上去有没有像极你平时写的伪代码，作为一个伪代码工程师的你，是不是发现生产力可能爆炸了。

## Prompt 即代码：不同形态下的 AI 编程

再重复一下定义：

> Prompt 即代码是一种基于多种输入模态的编程工具，它通过结合文本、图像、语音等多种输入方式来提供更丰富的上下文信息，帮助程序员更好地表达自己的意图，并生成相应的代码实现。Prompt 即代码将 prompt 作为代码的一部分，以及作为标准接口来定义生成的代码，同时提供注释和文档信息以支持可读性和可维护性。通过使用 prompt 即代码，程序员可以提高编码效率，同时生成更准确、更可靠的代码实现。
> 

当谈到 Prompt 即代码时，我们通常会将其定义为一种编程范式，它将自然语言或其他形式的输入作为代码生成的起点。Prompt 即代码则让程序员通过提供高度概括的自然语言描述或其他形式的输入来描述他们想要的功能，然后由 AI 系统自动生成代码。

所以，在这里我们分为两种方式：标准的 Prompt 即代码、多模态的 Prompt 即代码。

### 标准的 Prompt 即代码：文本形式

> 文本 Prompt 即代码是指使用自然语言或其他方式描述需求或问题，通过 AI 模型自动生成对应的代码。Prompt 作为代码的一部分或者核心，通过描述期望的输入和输出，以及需要执行的操作来生成代码。
> 

尽管现有的 AI 工具都是多模态的，然而自然语言是作为中间语言存在的。所以，我想将文本形式的 prompt 称为**标准的 Prompt 即代码**，它可以方便地融入现有的编程体系。

- Prompt 即注释。Prompt 作为注释与代码并存，在这种情况下，Prompt 与代码共存于同一个文件中。通常，Prompt 以注释的形式出现在代码中，以提供必要的上下文信息和生成代码的指令。这种方式适合于需要经常手动修改生成的代码的场景。
- Prompt 即接口。在这种情况下，Prompt 作为一个标准的接口，代码则是实现这个接口的生成代码。这种方式适用于对生成的代码进行自动化测试和部署的场景，因为接口定义的一致性可以更好地保证代码的正确性。
- Prompt 即代码。在这种情况下，版本管理工具中不再存储代码，而是存储 Prompt。生成的代码则可以根据 Prompt 来生成，Prompt 作为代码的一部分。这种方式适合于需要频繁更新代码和对代码进行版本控制的场景。

而，事实上，在我第一次将注释加入到 ClickPrompt 中的时候，我犹豫了很久。我们的过去的编程习惯，并不允许将思考过程作为注释到其中。

![Untitled](https://s3-us-west-2.amazonaws.com/secure.notion-static.com/58d22ada-e054-4895-878d-3ecb1a6b80be/Untitled.png)

既然，它已经作为代码的一部分加入进来 ，我们还需要进一步考虑的点是：**尽可能地去修改 prompt 重新生成代码，减少直接修改 prompt**。

### 多模态 Prompt 即代码

PS：**感谢 ChatGPT 帮我考虑了这一部分**。

> 多模态 Prompt 即代码是指在训练 AI 模型时，同时利用多种不同的输入模式（如文本、图像和语音）来提供更丰富的上下文，以帮助模型更好地理解程序员的意图并生成相应的代码。通过使用多模态 Prompt，AI 模型可以获得更多的信息，并在生成代码时更准确地反映程序员的意图。
> 

例如，一个基于多模态 Prompt 训练的 AI 模型，可以同时考虑程序员在文本上下文中输入的代码片段，代码所处的项目信息、数据结构信息，以及程序员所提供的图像信息，如示意图、流程图等，从而生成更准确、更完整的代码。

PS：不过，这种技术需要大量的数据和计算资源，同时需要对不同的输入模式进行处理和整合，因此在实际应用中还需要进一步研究和优化。

## Prompt 即代码：交互方式的变化

过去的几个月里，每天层出不穷的 AI 新工具，都在让我们感受人类的智商上限和 AI 的下限。与现在的编程方式相比，未来几个月势必会出现新的、或者已经出现新的交互方式。

诸如于：

- 交互式 Prompt：在编写代码的过程中，模型可以提示程序员输入，从而帮助模型更好地理解程序员的意图，并生成更准确的代码。例如，Unit Mesh 采用的架构模式，便是由人类和 AI 共同完成的，并由 Unit Server 自动化部署。
- 面向场景的 Prompt：通过提供与特定场景相关的信息和上下文，可以帮助模型更好地理解程序员的意图并生成相应的代码。例如，面向 Web 开发的 Prompt 可能包括与 HTML、CSS 和 JavaScript 相关的信息和上下文。
- 等等。

Prompt 即代码的交互方式将会越来越多样化和智能化，以更好地满足程序员在不同领域和场景下的需求。

## 小结

PS：最后，让 ChatGPT  3.5 总结一下本文的后半部分（毕竟 4K Unit）。

> 这篇文章介绍了 Prompt 即代码的写作方法，多模态输入的利用，以及 AI 模型生成代码的方式。好的 Prompt 规范包括功能定义、任务分解、输入输出格式、测试和调试、避免歧义、编码标准等要素。文本形式的 Prompt 可以使用自然语言或其他方式描述需求或问题，并通过 AI 模型自动生成对应的代码。最后，根据具体应用场景选择不同的 Prompt 与代码的结合方式。
> 

PS：这东西，写得不行不行的。
