# Fraunces Worklog: May 24th

_Flavia_
Today, I finished compiling the extended Character Set *see documentation/Fraunces GooglePlus CharSet*. I took out all the extra glyphs like IJ/ IJacute because it would make more sense to build up the language support later, with more research on what else might be missing from Google's list. And also addressed diacritics names/unicode values.

The latest *Fraunces_OpticalMax* source reflects that new CharSet and organization, and have most glyphs done with exception of what's marked in red and accenteded characters that need to be placed correctly.

In an effort to color code things and make searching for certain groups easier, all glyphs that are just components are marked with light purple (214, 222, 255). Alternates, orange (253, 196, 79); Glyphs that still need to be drawn, red (253, 93, 83); Ligatures, light green (217, 251, 147); Diacritics for typing, dark purple (194, 164, 213); Combining Diacritics, yellow (255, 250, 85), Diacritics altered to work together, light blue (126, 211, 253); Cap forms, pink (254, 160, 215), Accents that are on the list but haven't been used, dark blue (84, 161, 252) — we can change this later and even add more colors to cover parts of the process like, if it's 100% done or needs to be proofed, etc.

I then re-wrote the structure file for Glyph Builder *see documentation/scripts/GooglePlus_003_fz.glyphConstruction*: following the new accents names and logic for combining diacritics. Vietnamese comb accents like, circunflexacute should be one glyph in order to allow us to shape it in a better way. Cap forms are slighted compressed vertically to use less space. Bottom accents are the same across the board. Ohorn & Uhorn are a base glyph and not made of components anymore, as well as all ogonek comb glyphs. 

When expanding the new masters to this CharSet, new global guides (for vertical metrics) and anchors (for horizontal placement) will be needed — but the vertical metrics should be the same for all masters within one axis. Right now, all accents are vertically aligned within each other and placed vertically on the spot that works for lowercase. All cap forms should shift up together).

_Spencer_
I worked on creating diagrams to explain the next steps for planning the Fraunces design space. So far, we have drawn 3 masters for each style, and still need to extrapolate and cleanup a Bold OpMax master. However, because of much of the restructuring we've done for building the combining characters as well as other design decisions, we would need to circle back and resolve compatibility for all masters. Looking at where we want to go with this (adding Light weights), it seems like we are making more work for ourselves by trying to draw the complete character set for each master individually, instead of drawing all masters at once.

Based on feedback from Dave (OpMax regular could be even more thin, Light weight is worth exploring as well), and what Flavia and I discussed about introducing a Black weight, and the work needed to extrapolate/clean-up an OpMax Bold/black, I think it would be best to return to a core character set of A-Z, a-z, 0-9, and establish exactly which masters we need to define the full design space. From there, we can work in sections of the character set across all masters, so that compatibility, spacing, and construction of everything is being considered at once. This will help us eliminate the need to constantly circle back on the masters we have designed so far. 

Another option is to try implementing David Berlow's parametric axes approach. I believe that would be a much bigger learning curve for myself and Flavia, and if our goal is to deliver a working family by the end of the year, I think it would be wise to focus on defining and designing the extremes of the design space first. 