
<div align="right">
<br />

[![license](https://img.shields.io/github/license/dec0dOS/amazing-github-template.svg?style=flat-square)](LICENSE)

[![PRs welcome](https://img.shields.io/badge/PRs-welcome-ff69b4.svg?style=flat-square)](https://github.com/unaisdev/playlistnotify/pulls)
[![made with hearth by unaisdev](https://img.shields.io/badge/made%20with%20%E2%99%A5%20by-unaisdev-ff1414.svg?style=flat-square)](https://github.com/unaisdev)

</div>
<div>
    <h1 align="left">Playlist Tracker mobile app.</h1>
    <h3>Did you wanted to know the latest updates on your favourite Spotify playlist?</h3> 
    <br/>
</div>
<div align="center">
    <p>Only available for <strong>Beta testing</strong>. You wanna join? Send me your Google Play and Spotify account e-mail to <a href="mailto:unaicanales@gmail.com">unaisdev@gmail.com</a></p>
     <a href="#"><img src="https://upload.wikimedia.org/wikipedia/commons/thumb/7/78/Google_Play_Store_badge_EN.svg/2560px-Google_Play_Store_badge_EN.svg.png" style="width: 140px; opacity: 0.2" alt="google-play-badge"></a>
    <a href="#"><img src="https://upload.wikimedia.org/wikipedia/commons/thumb/3/3c/Download_on_the_App_Store_Badge.svg/1200px-Download_on_the_App_Store_Badge.svg.png" style="width: 140px; opacity: 0.2" alt="app-store-badge-128x128"></a>
    <p>Play Store: released for internal testing</p>
    <p>App Store: not released yet</p>
</div>

Some screenshots:

<div align="center">
    <img src="https://i.ibb.co/RPNXT1T/Simulator-Screenshot-i-Phone-SE-3rd-generation-2023-09-14-at-17-43-16.png" alt="Simulator-Screenshot-i-Phone-SE-3rd-generation-2023-09-14-at-17-43-16" border="0" style="width: 30%;"/>
    <img src="https://i.ibb.co/FqMn8nr/Simulator-Screenshot-i-Phone-SE-3rd-generation-2023-09-13-at-19-54-35.png" alt="Simulator-Screenshot-i-Phone-SE-3rd-generation-2023-09-13-at-19-54-35" border="0" style="width: 30%;" />
        <img src="https://i.ibb.co/zFH9g31/Simulator-Screenshot-i-Phone-SE-3rd-generation-2023-09-13-at-19-56-04.png" alt="Simulator-Screenshot-i-Phone-SE-3rd-generation-2023-09-13-at-19-56-04" border="0" style="width: 30%;"/>
</div>

<br />
<br />

<div align="center">
        <img src="https://i.ibb.co/GVd4npc/Simulator-Screenshot-i-Phone-SE-3rd-generation-2023-09-13-at-20-01-45.png" alt="Simulator-Screenshot-i-Phone-SE-3rd-generation-2023-09-13-at-20-01-45" border="0" style="width: 30%;"/>
    <img src="https://i.ibb.co/Scwtv5B/Simulator-Screenshot-i-Phone-SE-3rd-generation-2023-09-13-at-19-54-51.png" alt="Simulator-Screenshot-i-Phone-SE-3rd-generation-2023-09-13-at-19-54-51" border="0"  style="width: 30%;" />
    <img src="https://i.ibb.co/Fz4MyQB/Simulator-Screenshot-i-Phone-SE-3rd-generation-2023-09-13-at-20-04-13.png" alt="Simulator-Screenshot-i-Phone-SE-3rd-generation-2023-09-13-at-20-04-13" border="0" style="width: 30%;"/>
</div>

<br />


## Table of Contents

- [Introduction](#introduction)
- [Features](#features)
- [Stack](#stack)
- [Feedback](#feedback)
- [Build Process](#build-process)

<br />

## Introduction

In today's digital age, music has become an integral part of our lives, and music streaming platforms like Spotify give us instant access to a wide range of songs and playlists. However, keeping up with updates to our favorite playlists can be a challenge. It is in this context that we present our exciting app project developed in React Native: an innovative solution for tracking updates on Spotify playlists.

Our app aims to simplify the experience of tracking updates to personal playlists and those that have been added to the "Like" list in your Spotify account. With direct integration of the Spotify API, our app offers an intuitive and easy-to-use interface that allows users to stay informed about songs that are added or removed from their favorite playlists.

<br />

## Features

* **Spotify connection:**<br/>
   Our application securely connects to your Spotify account, allowing you to access your personal playlists and those you have marked as favorites.

* **Update Tracking:**<br/> Ever wondered which new songs have been added to your playlists or which ones have been removed? Our application will notify you every time an update is made to a playlist you are following.

* **Playlist Browsing:**<br/> Browse your personal playlists and those you've marked as favorites conveniently, directly from the app.

* **Playlist Detail View:**<br/> Get a detailed view of the songs that make up a particular playlist. Easily identify recent additions and deletions.

* **Custom Notifications:**<br/> Don't want to miss any updates on a specific playlist? Our application allows you to activate custom notifications for selected playlists, making sure you are always aware of changes.

* **Intuitive Interface:**<br/> Designed with the user experience in mind, our interface is easy to navigate and provides a smooth and enjoyable user experience.


<br />

## Stack

* <a href="https://github.com/TanStack/query">@tanstack/react-query</a>
* <a href="https://github.com/react-navigation/react-navigation">@react-navigation</a>
* <a href="https://github.com/FormidableLabs/react-native-app-auth">react-native-app-auth</a>
* <a href="https://github.com/i18next/react-i18next">react-i18next</a>
* <a href="https://github.com/emeraldsanto/react-native-encrypted-storage">react-native-encrypted-storage</a>
* <a href="https://github.com/react-native-async-storage/async-storage">react-native-async-storage</a>
<br/>

* <a href="https://github.com/software-mansion/react-native-gesture-handler">react-native-gesture-handler</a>
* <a href="https://github.com/software-mansion/react-native-reanimated">react-native-reanimated</a>
* <a href="https://github.com/gorhom/react-native-bottom-sheet">@gorhom/react-native-bottom-sheet</a>
* <a href="https://github.com/gusgard/react-native-swiper-flatlist">react-native-swiper-flatlist</a>
* <a href="https://github.com/oblador/react-native-vector-icons">react-native-vector-icons</a>

<br/>

## Feedback

Feel free to send us feedback on [Twitter](https://twitter.com/unaisdev) or [file an issue](https://github.com/unaisdev/playlistnotify/issues/new). Feature requests are always welcome. If you wish to contribute, please take a quick look at the [guidelines](./CONTRIBUTING.md)!

If there's anything you'd like to chat about, please feel free to join our [Gitter chat](https://matrix.to/#/#playlist-tracker-contributors:gitter.im)!

<br />

## Build Process

- Follow the [React Native Guide](https://facebook.github.io/react-native/docs/getting-started.html) for getting started building a project with native code. **A Mac is required if you wish to develop for iOS.**
- Clone or download the repo
- `npm install` to install dependencies
- `cd ios / pod install` to install POD dependencies (iOS building only)
- `npm start` to start the Metro bundler and run the app (`npm start -- --clear-cache` will boot the application with no cache data.
- `npm android (npx react-native run-android)` to start the packager and run the app in the the Android device/emulator
- `npm ios (npx react-native run-ios)` to start the packager and run the app in the the Android device/emulator

Please take a look at the [contributing guidelines](./CONTRIBUTING.md) for a detailed process on how to build your application as well as troubleshooting information.

<br />
<br />
<div align="center">
    <h2 align="center" style="font-size: 34px">POWERED BY</h2>
    <br />
    <a href="https://developer.spotify.com"><img src="https://developer.spotify.com/images/spotify-for-developers-logo.svg#s4d-logo" style="width: 380px" /></a><br/>
    <a href="https://www.fl0.com"><img src="https://images.crunchbase.com/image/upload/c_lpad,h_256,w_256,f_auto,q_auto:eco,dpr_1/rucikbnjqz2ktuchdhih" style="width: 100px" /></a>
</div>
<hr />
<br />




