topic "Ultimate++ vs Qt";
[l288;i704;a17;O9;~~~.992; $$1,0#10431211400427159095818037425705:param]
[a83;*R6 $$2,5#31310162474203024125188417583966:caption]
[b83;* $$3,5#07864147445237544204411237157677:title]
[b167;a42;C $$4,6#40027414424643823182269349404212:item]
[b42;a42;pht300; $$5,5#45413000475342174754091244180557:text]
[l288;a17; $$6,6#27521748481378242620020725143825:desc]
[l321;t246;C@5;1 $$7,7#20902679421464641399138805415013:code]
[b2503; $$8,0#65142375456100023862071332075487:separator]
[*@(0.0.255) $$9,0#83433469410354161042741608181528:base]
[t4167;C+117 $$10,0#37138531426314131251341829483380:class]
[l288;a17;*1 $$11,11#70004532496200323422659154056402:requirement]
[i416;b42;a42;O9;~~~.416; $$12,12#10566046415157235020018451313112:tparam]
[b167;C $$13,13#92430459443460461911108080531343:item1]
[a42;C $$14,14#77422149456609303542238260500223:item2]
[*@2$(0.128.128) $$15,15#34511555403152284025741354420178:NewsDate]
[l321;*C$7 $$16,16#03451589433145915344929335295360:result]
[l321;b83;a83;*C$7 $$17,17#07531550463529505371228428965313:result`-line]
[l160;t4167;*C+117 $$18,5#88603949442205825958800053222425:package`-title]
[ $$0,0#00000000000000000000000000000000:Default]
[{_}%EN-US 
[s2; U`+`+ vs Qt [5 (R)]&]
[s5; To compare U`+`+ with Qt (R), we decided to reimplement Qt demonstration 
example `"AddressBook`". On the left side is U`+`+ code, on the 
right side original Qt example.f&]
[s0;/2 &]
[s0; [/0 Qt and the Qt logo are trademarks of Trolltech in Norway, 
the United States and other countries.]&]
[s0;2 &]
[s0;= [2 
@@image:1778&1704
(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)
]&]
[s0;=2 &]
[ {{5000:5000^@7 [s0; [*2 Ultimate`+`+ version]]
:: [s0; [*2 Qt version]]
::@2 [s0; [*C2 AddressBook.cpp]&]
[s0;C0 &]
[s0; [C0 #include <TCtrlLib/TCtrlLib.h>]&]
[s0;C0 &]
[s0; [C0 #define LAYOUTFILE <AddressBook/AddressBook.lay>]&]
[s0; [C0 #include <CtrlCore/lay.h>]&]
[s0;C0 &]
[s0; [C0 class AddressBook : public WithAddressBookLayout<TopWindow> 
`{]&]
[s0; [C0 -|WithModifyLayout<StaticRect> modify;]&]
[s0; [C0 -|WithSearchLayout<StaticRect> search;]&]
[s0; [C0 -|FileSel fs;]&]
[s0; [C0 -|String  filename;]&]
[s0; [C0 -|]&]
[s0; [C0 -|void SetupSearch();]&]
[s0; [C0 -|void Add();]&]
[s0; [C0 -|void Change();]&]
[s0; [C0 -|void Search();]&]
[s0; [C0 -|void Open();]&]
[s0; [C0 -|void Save();]&]
[s0; [C0 -|void SaveAs();]&]
[s0; [C0 -|void Print();]&]
[s0; [C0 -|void Quit();]&]
[s0; [C0 -|void FileMenu(Bar`& bar);]&]
[s0; [C0 -|void MainMenu(Bar`& bar);]&]
[s0;C0 &]
[s0; [C0 -|typedef AddressBook CLASSNAME;]&]
[s0;C0 &]
[s0; [C0 public:]&]
[s0; [C0 -|void Serialize(Stream`& s);]&]
[s0;C0 &]
[s0; [C0 -|AddressBook();]&]
[s0; [C0 `};]&]
[s0;C0 &]
[s0; [C0 AddressBook`::AddressBook()]&]
[s0; [C0 `{]&]
[s0; [C0 -|CtrlLayout(`*this, `"Address book`");]&]
[s0; [C0 -|CtrlLayout(modify);]&]
[s0; [C0 -|CtrlLayout(search);]&]
[s0; [C0 -|tab.Add(modify, `"Modify`");]&]
[s0; [C0 -|tab.Add(search, `"Search`");]&]
[s0; [C0 -|ActiveFocus(search.name);]&]
[s0; [C0 -|search.oname `= true;]&]
[s0; [C0 -|search.oname <<`= search.osurname <<`= search.oaddress]&]
[s0; [C0 -|             <<`= search.oemail <<`= THISBACK(SetupSearch);]&]
[s0; [C0 -|array.AddColumn(`"Name`");]&]
[s0; [C0 -|array.AddColumn(`"Surname`");]&]
[s0; [C0 -|array.AddColumn(`"Address`");]&]
[s0; [C0 -|array.AddColumn(`"Email`");]&]
[s0; [C0 -|modify.add <<`= THISBACK(Add);]&]
[s0; [C0 -|modify.change <<`= THISBACK(Change);]&]
[s0; [C0 -|search.search <<`= THISBACK(Search);]&]
[s0; [C0 -|SetupSearch();]&]
[s0; [C0 -|fs.AllFilesType();]&]
[s0; [C0 -|menu.Set(THISBACK(MainMenu));]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void AddressBook`::FileMenu(Bar`& bar)]&]
[s0; [C0 `{]&]
[s0; [C0 -|bar.Add(`"Open..`", CtrlImg`::open(), THISBACK(Open));]&]
[s0; [C0 -|bar.Add(`"Save`", CtrlImg`::save(), THISBACK(Save));]&]
[s0; [C0 -|bar.Add(`"Save as..`", CtrlImg`::save`_as(), THISBACK(SaveAs));]&]
[s0; [C0 -|bar.Separator();]&]
[s0; [C0 -|bar.Add(`"Print`", CtrlImg`::print(), THISBACK(Print));]&]
[s0; [C0 -|bar.Separator();]&]
[s0; [C0 -|bar.Add(`"Quit`", THISBACK(Quit));]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void AddressBook`::MainMenu(Bar`& bar)]&]
[s0; [C0 `{]&]
[s0; [C0 -|bar.Add(`"File`", THISBACK(FileMenu));]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void AddressBook`::SetupSearch()]&]
[s0; [C0 `{]&]
[s0; [C0 -|search.name.Enable(search.oname);]&]
[s0; [C0 -|search.surname.Enable(search.osurname);]&]
[s0; [C0 -|search.address.Enable(search.oaddress);]&]
[s0; [C0 -|search.email.Enable(search.oemail);]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void AddressBook`::Add()]&]
[s0; [C0 `{]&]
[s0; [C0 -|array.Add(`~modify.name, `~modify.surname, `~modify.address, 
`~modify.email);]&]
[s0; [C0 -|array.GoEnd();]&]
[s0; [C0 -|modify.name <<`= modify.surname <<`= modify.address <<`= 
modify.email <<`= Null;]&]
[s0; [C0 -|ActiveFocus(modify.name);]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void AddressBook`::Change()]&]
[s0; [C0 `{]&]
[s0; [C0 -|if(array.IsCursor()) `{]&]
[s0; [C0 -|-|array.Set(0, `~modify.name);]&]
[s0; [C0 -|-|array.Set(1, `~modify.surname);]&]
[s0; [C0 -|-|array.Set(2, `~modify.address);]&]
[s0; [C0 -|-|array.Set(3, `~modify.email);]&]
[s0; [C0 -|`}]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 bool Contains(const String`& text, const String`& substr)]&]
[s0; [C0 `{]&]
[s0; [C0 -|for(const char `*s `= text; s <`= text.End() `- substr.GetLength(); 
s`+`+)]&]
[s0; [C0 -|-|if(strncmp(s, substr, substr.GetLength()) `=`= 0)]&]
[s0; [C0 -|-|-|return true;]&]
[s0; [C0 -|return false;]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void AddressBook`::Search()]&]
[s0; [C0 `{]&]
[s0; [C0 -|if(!array.GetCount()) return;]&]
[s0; [C0 -|bool sc `= true;]&]
[s0; [C0 -|array.ClearSelection();]&]
[s0; [C0 -|for(int i `= 0; i < array.GetCount(); i`+`+) `{]&]
[s0; [C0 -|-|if((!search.oname `|`| Contains(array.Get(i, 0), `~search.name)) 
`&`&]&]
[s0; [C0 -|-|   (!search.osurname `|`| Contains(array.Get(i, 1), `~search.surname)) 
`&`&]&]
[s0; [C0 -|-|   (!search.oaddress `|`| Contains(array.Get(i, 2), `~search.address)) 
`&`&]&]
[s0; [C0 -|-|   (!search.oemail `|`| Contains(array.Get(i, 3), `~search.email))) 
`{]&]
[s0; [C0 -|-|-|array.Select(i);]&]
[s0; [C0 -|-|-|if(sc) `{]&]
[s0; [C0 -|-|-|-|array.SetCursor(i);]&]
[s0; [C0 -|-|-|-|array.CenterCursor();]&]
[s0; [C0 -|-|-|-|sc `= false;]&]
[s0; [C0 -|-|-|`};]&]
[s0; [C0 -|-|`}]&]
[s0; [C0 -|`}]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void AddressBook`::Open()]&]
[s0; [C0 `{]&]
[s0; [C0 -|if(!fs.ExecuteOpen()) return;]&]
[s0; [C0 -|filename `= fs;]&]
[s0; [C0 -|FileIn in(filename);]&]
[s0; [C0 -|if(!in) `{]&]
[s0; [C0 -|-|Exclamation(`"Unable to open `" `+ filename);]&]
[s0; [C0 -|-|return;]&]
[s0; [C0 -|`}]&]
[s0; [C0 -|array.Clear();]&]
[s0; [C0 -|while(!in.IsEof()) `{]&]
[s0; [C0 -|-|Vector<Value> q;]&]
[s0; [C0 -|-|for(int i `= 0; i < 4; i`+`+)]&]
[s0; [C0 -|-|-|q.Add(in.GetLine());]&]
[s0; [C0 -|-|array.Add(q);]&]
[s0; [C0 -|`}]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void AddressBook`::Save()]&]
[s0; [C0 `{]&]
[s0; [C0 -|if(IsEmpty(filename)) `{]&]
[s0; [C0 -|-|SaveAs();]&]
[s0; [C0 -|-|return;]&]
[s0; [C0 -|`}]&]
[s0; [C0 -|FileOut out(filename);]&]
[s0; [C0 -|if(!out) `{]&]
[s0; [C0 -|-|Exclamation(`"Unable to open `" `+ filename);]&]
[s0; [C0 -|-|return;]&]
[s0; [C0 -|`}]&]
[s0; [C0 -|for(int i `= 0; i < array.GetCount(); i`+`+) `{]&]
[s0; [C0 -|-|for(int q `= 0; q < 4; i`+`+)]&]
[s0; [C0 -|-|-|out.PutLine(String(array.Get(i, q)));]&]
[s0; [C0 -|`}]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void AddressBook`::SaveAs()]&]
[s0; [C0 `{]&]
[s0; [C0 -|if(!fs.ExecuteSaveAs()) return;]&]
[s0; [C0 -|filename `= fs;]&]
[s0; [C0 -|Save();]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void AddressBook`::Print()]&]
[s0; [C0 `{]&]
[s0; [C0 -|String qtf;]&]
[s0; [C0 -|qtf `= `"`+`+Name`|`|Surname`|`|Address`|`|Email`";]&]
[s0; [C0 -|for(int i `= 0; i < array.GetCount(); i`+`+) `{]&]
[s0; [C0 -|-|qtf << `"`-`-`";]&]
[s0; [C0 -|-|for(int q `= 0; q < 4; q`+`+) `{]&]
[s0; [C0 -|-|-|if(q) qtf << `"`|`|`";]&]
[s0; [C0 -|-|-|qtf << DeQtf((String)array.Get(i, q));]&]
[s0; [C0 -|-|`}]&]
[s0; [C0 -|`}]&]
[s0; [C0 -|qtf << `"`+`+`";]&]
[s0; [C0 -|Report report;]&]
[s0; [C0 -|report << qtf;]&]
[s0; [C0 -|report.Perform();]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void AddressBook`::Quit()]&]
[s0; [C0 `{]&]
[s0; [C0 -|Break();]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void AddressBook`::Serialize(Stream`& s)]&]
[s0; [C0 `{]&]
[s0; [C0 -|int version `= 0;]&]
[s0; [C0 -|s / version;]&]
[s0; [C0 -|s % search.oname % search.osurname % search.oaddress % search.oemail;]&]
[s0; [C0 -|s % fs;]&]
[s0; [C0 -|SetupSearch();]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 GUI`_APP`_MAIN]&]
[s0; [C0 `{]&]
[s0; [C0 -|AddressBook ab;]&]
[s0; [C0 -|LoadFromFile(ab);]&]
[s0; [C0 -|ab.Run();]&]
[s0; [C0 -|StoreToFile(ab);]&]
[s0; [C0 `}]&]
[s0;C0 ]
:: [s0; [*C2 mainwindow.h]&]
[s0;C0 &]
[s0; [C0 #ifndef AB`_MAINWINDOW`_H]&]
[s0; [C0 #define AB`_MAINWINDOW`_H]&]
[s0;C0 &]
[s0; [C0 #include <qmainwindow.h>]&]
[s0; [C0 #include <qstring.h>]&]
[s0;C0 &]
[s0; [C0 class QToolBar;]&]
[s0; [C0 class QPopupMenu;]&]
[s0; [C0 class ABCentralWidget;]&]
[s0;C0 &]
[s0; [C0 class ABMainWindow: public QMainWindow]&]
[s0; [C0 `{]&]
[s0; [C0     Q`_OBJECT]&]
[s0;C0 &]
[s0; [C0 public:]&]
[s0; [C0     ABMainWindow();]&]
[s0; [C0     `~ABMainWindow();]&]
[s0;C0 &]
[s0; [C0 protected slots:]&]
[s0; [C0     void fileNew();]&]
[s0; [C0     void fileOpen();]&]
[s0; [C0     void fileSave();]&]
[s0; [C0     void fileSaveAs();]&]
[s0; [C0     void filePrint();]&]
[s0; [C0     void closeWindow();]&]
[s0;C0 &]
[s0; [C0 protected:]&]
[s0; [C0     void setupMenuBar();]&]
[s0; [C0     void setupFileTools();]&]
[s0; [C0     void setupStatusBar();]&]
[s0; [C0     void setupCentralWidget();]&]
[s0;C0 &]
[s0; [C0     QToolBar `*fileTools;]&]
[s0; [C0     QString filename;]&]
[s0; [C0     ABCentralWidget `*view;]&]
[s0;C0 &]
[s0; [C0 `};]&]
[s0;C0 &]
[s0;C0 &]
[s0; [C0 #endif]&]
[s0;C0 &]
[s0; [*C2 mainwindow.cpp]&]
[s0;C0 &]
[s0; [C0 #include `"mainwindow.h`"]&]
[s0; [C0 #include `"centralwidget.h`"]&]
[s0;C0 &]
[s0; [C0 #include <qtoolbar.h>]&]
[s0; [C0 #include <qtoolbutton.h>]&]
[s0; [C0 #include <qpopupmenu.h>]&]
[s0; [C0 #include <qmenubar.h>]&]
[s0; [C0 #include <qstatusbar.h>]&]
[s0; [C0 #include <qapplication.h>]&]
[s0; [C0 #include <qfiledialog.h>]&]
[s0;C0 &]
[s0; [C0 ABMainWindow`::ABMainWindow()]&]
[s0; [C0     : QMainWindow( 0, `"example addressbook application`" ),]&]
[s0; [C0       filename( QString`::null )]&]
[s0; [C0 `{]&]
[s0; [C0     setupMenuBar();]&]
[s0; [C0     setupFileTools();]&]
[s0; [C0     setupStatusBar();]&]
[s0; [C0     setupCentralWidget();]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0;C0 &]
[s0; [C0 ABMainWindow`::`~ABMainWindow()]&]
[s0; [C0 `{]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void ABMainWindow`::setupMenuBar()]&]
[s0; [C0 `{]&]
[s0; [C0     QPopupMenu `*file `= new QPopupMenu( this );]&]
[s0; [C0     menuBar()`->insertItem( `"`&File`", file );]&]
[s0;C0 &]
[s0; [C0     file`->insertItem( `"New`", this, SLOT( fileNew() ), CTRL 
`+ Key`_N );]&]
[s0; [C0     file`->insertItem( QPixmap( `"fileopen.xpm`" ), `"Open`", 
this, SLOT( fileOpen() ), CTRL `+ Key`_O );]&]
[s0; [C0     file`->insertSeparator();]&]
[s0; [C0     file`->insertItem( QPixmap( `"filesave.xpm`" ), `"Save`", 
this, SLOT( fileSave() ), CTRL `+ Key`_S );]&]
[s0; [C0     file`->insertItem( `"Save As...`", this, SLOT( fileSaveAs() 
) );]&]
[s0; [C0     file`->insertSeparator();]&]
[s0; [C0     file`->insertItem( QPixmap( `"fileprint.xpm`" ), `"Print...`", 
this, SLOT( filePrint() ), CTRL `+ Key`_P );]&]
[s0; [C0     file`->insertSeparator();]&]
[s0; [C0     file`->insertItem( `"Close`", this, SLOT( closeWindow() 
), CTRL `+ Key`_W );]&]
[s0; [C0     file`->insertItem( `"Quit`", qApp, SLOT( quit() ), CTRL 
`+ Key`_Q );]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void ABMainWindow`::setupFileTools()]&]
[s0; [C0 `{]&]
[s0; [C0     //fileTools `= new QToolBar( this, `"file operations`" 
);]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void ABMainWindow`::setupStatusBar()]&]
[s0; [C0 `{]&]
[s0; [C0     //statusBar()`->message( `"Ready`", 2000 );]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void ABMainWindow`::setupCentralWidget()]&]
[s0; [C0 `{]&]
[s0; [C0     view `= new ABCentralWidget( this );]&]
[s0; [C0     setCentralWidget( view );]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void ABMainWindow`::closeWindow()]&]
[s0; [C0 `{]&]
[s0; [C0     close();]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void ABMainWindow`::fileNew()]&]
[s0; [C0 `{]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void ABMainWindow`::fileOpen()]&]
[s0; [C0 `{]&]
[s0; [C0     QString fn `= QFileDialog`::getOpenFileName( QString`::null, 
QString`::null, this );]&]
[s0; [C0     if ( !fn.isEmpty() ) `{]&]
[s0; [C0         filename `= fn;]&]
[s0; [C0         view`->load( filename );]&]
[s0; [C0     `}]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void ABMainWindow`::fileSave()]&]
[s0; [C0 `{]&]
[s0; [C0     if ( filename.isEmpty() ) `{]&]
[s0; [C0         fileSaveAs();]&]
[s0; [C0         return;]&]
[s0; [C0     `}]&]
[s0;C0 &]
[s0; [C0     view`->save( filename );]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void ABMainWindow`::fileSaveAs()]&]
[s0; [C0 `{]&]
[s0; [C0     QString fn `= QFileDialog`::getSaveFileName( QString`::null, 
QString`::null, this );]&]
[s0; [C0     if ( !fn.isEmpty() ) `{]&]
[s0; [C0         filename `= fn;]&]
[s0; [C0         fileSave();]&]
[s0; [C0     `}]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void ABMainWindow`::filePrint()]&]
[s0; [C0 `{]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [*C2 centralwidget.h]&]
[s0;C0 &]
[s0; [C0 #ifndef AB`_CENTRALWIDGET`_H]&]
[s0; [C0 #define AB`_CENTRALWIDGET`_H]&]
[s0;C0 &]
[s0; [C0 #include <qwidget.h>]&]
[s0; [C0 #include <qstring.h>]&]
[s0;C0 &]
[s0; [C0 class QTabWidget;]&]
[s0; [C0 class QListView;]&]
[s0; [C0 class QGridLayout;]&]
[s0; [C0 class QLineEdit;]&]
[s0; [C0 class QPushButton;]&]
[s0; [C0 class QListViewItem;]&]
[s0; [C0 class QCheckBox;]&]
[s0;C0 &]
[s0; [C0 class ABCentralWidget : public QWidget]&]
[s0; [C0 `{]&]
[s0; [C0     Q`_OBJECT]&]
[s0;C0 &]
[s0; [C0 public:]&]
[s0; [C0     ABCentralWidget( QWidget `*parent, const char `*name `= 
0 );]&]
[s0;C0 &]
[s0; [C0     void save( const QString `&filename );]&]
[s0; [C0     void load( const QString `&filename );]&]
[s0;C0 &]
[s0; [C0 protected slots:]&]
[s0; [C0     void addEntry();]&]
[s0; [C0     void changeEntry();]&]
[s0; [C0     void itemSelected( QListViewItem`* );]&]
[s0; [C0     void selectionChanged();]&]
[s0; [C0     void toggleFirstName();]&]
[s0; [C0     void toggleLastName();]&]
[s0; [C0     void toggleAddress();]&]
[s0; [C0     void toggleEMail();]&]
[s0; [C0     void findEntries();]&]
[s0;C0 &]
[s0; [C0 protected:]&]
[s0; [C0     void setupTabWidget();]&]
[s0; [C0     void setupListView();]&]
[s0;C0 &]
[s0; [C0     QGridLayout `*mainGrid;]&]
[s0; [C0     QTabWidget `*tabWidget;]&]
[s0; [C0     QListView `*listView;]&]
[s0; [C0     QPushButton `*add, `*change, `*find;]&]
[s0; [C0     QLineEdit `*iFirstName, `*iLastName, `*iAddress, `*iEMail,]&]
[s0; [C0         `*sFirstName, `*sLastName, `*sAddress, `*sEMail;]&]
[s0; [C0     QCheckBox `*cFirstName, `*cLastName, `*cAddress, `*cEMail;]&]
[s0;C0 &]
[s0; [C0 `};]&]
[s0;C0 &]
[s0; [C0 #endif]&]
[s0;C0 &]
[s0; [*C2 centralwidget.cpp]&]
[s0;C0 &]
[s0; [C0 #include `"centralwidget.h`"]&]
[s0;C0 &]
[s0; [C0 #include <qtabwidget.h>]&]
[s0; [C0 #include <qlistview.h>]&]
[s0; [C0 #include <qlayout.h>]&]
[s0; [C0 #include <qwidget.h>]&]
[s0; [C0 #include <qlabel.h>]&]
[s0; [C0 #include <qpushbutton.h>]&]
[s0; [C0 #include <qlineedit.h>]&]
[s0; [C0 #include <qlabel.h>]&]
[s0; [C0 #include <qcheckbox.h>]&]
[s0; [C0 #include <qfile.h>]&]
[s0; [C0 #include <qtextstream.h>]&]
[s0;C0 &]
[s0; [C0 ABCentralWidget`::ABCentralWidget( QWidget `*parent, const 
char `*name )]&]
[s0; [C0     : QWidget( parent, name )]&]
[s0; [C0 `{]&]
[s0; [C0     mainGrid `= new QGridLayout( this, 2, 1, 5, 5 );]&]
[s0;C0 &]
[s0; [C0     setupTabWidget();]&]
[s0; [C0     setupListView();]&]
[s0;C0 &]
[s0; [C0     mainGrid`->setRowStretch( 0, 0 );]&]
[s0; [C0     mainGrid`->setRowStretch( 1, 1 );]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void ABCentralWidget`::setupListView()]&]
[s0; [C0 `{]&]
[s0; [C0     listView `= new QListView( this );]&]
[s0; [C0     listView`->addColumn( `"First Name`" );]&]
[s0; [C0     listView`->addColumn( `"Last Name`" );]&]
[s0; [C0     listView`->addColumn( `"Address`" );]&]
[s0; [C0     listView`->addColumn( `"E`-Mail`" );]&]
[s0;C0 &]
[s0; [C0     listView`->setSelectionMode( QListView`::Single );]&]
[s0;C0 &]
[s0; [C0     connect( listView, SIGNAL( clicked( QListViewItem`* ) 
), this, SLOT( itemSelected( QListViewItem`* ) ) );]&]
[s0;C0 &]
[s0; [C0     mainGrid`->addWidget( listView, 1, 0 );]&]
[s0; [C0     listView`->setAllColumnsShowFocus( TRUE );]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void ABCentralWidget`::save( const QString `&filename )]&]
[s0; [C0 `{]&]
[s0; [C0     if ( !listView`->firstChild() )]&]
[s0; [C0         return;]&]
[s0;C0 &]
[s0; [C0     QFile f( filename );]&]
[s0; [C0     if ( !f.open( IO`_WriteOnly ) )]&]
[s0; [C0         return;]&]
[s0;C0 &]
[s0; [C0     QTextStream t( `&f );]&]
[s0;C0 &]
[s0; [C0     QListViewItemIterator it( listView );]&]
[s0;C0 &]
[s0; [C0     for ( ; it.current(); `+`+it )]&]
[s0; [C0         for ( unsigned int i `= 0; i < 4; i`+`+ )]&]
[s0; [C0             t << it.current()`->text( i ) << `"n`";]&]
[s0;C0 &]
[s0; [C0     f.close();]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void ABCentralWidget`::load( const QString `&filename )]&]
[s0; [C0 `{]&]
[s0; [C0     listView`->clear();]&]
[s0;C0 &]
[s0; [C0     QFile f( filename );]&]
[s0; [C0     if ( !f.open( IO`_ReadOnly ) )]&]
[s0; [C0         return;]&]
[s0;C0 &]
[s0; [C0     QTextStream t( `&f );]&]
[s0;C0 &]
[s0; [C0     while ( !t.atEnd() ) `{]&]
[s0; [C0         QListViewItem `*item `= new QListViewItem( listView 
);]&]
[s0; [C0         for ( unsigned int i `= 0; i < 4; i`+`+ )]&]
[s0; [C0             item`->setText( i, t.readLine() );]&]
[s0; [C0     `}]&]
[s0;C0 &]
[s0; [C0     f.close();]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void ABCentralWidget`::addEntry()]&]
[s0; [C0 `{]&]
[s0; [C0     if ( !iFirstName`->text().isEmpty() `|`| !iLastName`->text().isEmpty() 
`|`|]&]
[s0; [C0          !iAddress`->text().isEmpty() `|`| !iEMail`->text().isEmpty() 
) `{]&]
[s0; [C0         QListViewItem `*item `= new QListViewItem( listView 
);]&]
[s0; [C0         item`->setText( 0, iFirstName`->text() );]&]
[s0; [C0         item`->setText( 1, iLastName`->text() );]&]
[s0; [C0         item`->setText( 2, iAddress`->text() );]&]
[s0; [C0         item`->setText( 3, iEMail`->text() );]&]
[s0; [C0     `}]&]
[s0;C0 &]
[s0; [C0     iFirstName`->setText( `"`" );]&]
[s0; [C0     iLastName`->setText( `"`" );]&]
[s0; [C0     iAddress`->setText( `"`" );]&]
[s0; [C0     iEMail`->setText( `"`" );]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void ABCentralWidget`::changeEntry()]&]
[s0; [C0 `{]&]
[s0; [C0     QListViewItem `*item `= listView`->currentItem();]&]
[s0;C0 &]
[s0; [C0     if ( item `&`&]&]
[s0; [C0          ( !iFirstName`->text().isEmpty() `|`| !iLastName`->text().isEmpty() 
`|`|]&]
[s0; [C0            !iAddress`->text().isEmpty() `|`| !iEMail`->text().isEmpty() 
) ) `{]&]
[s0; [C0         item`->setText( 0, iFirstName`->text() );]&]
[s0; [C0         item`->setText( 1, iLastName`->text() );]&]
[s0; [C0         item`->setText( 2, iAddress`->text() );]&]
[s0; [C0         item`->setText( 3, iEMail`->text() );]&]
[s0; [C0     `}]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void ABCentralWidget`::selectionChanged()]&]
[s0; [C0 `{]&]
[s0; [C0     iFirstName`->setText( `"`" );]&]
[s0; [C0     iLastName`->setText( `"`" );]&]
[s0; [C0     iAddress`->setText( `"`" );]&]
[s0; [C0     iEMail`->setText( `"`" );]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void ABCentralWidget`::itemSelected( QListViewItem `*item )]&]
[s0; [C0 `{]&]
[s0; [C0     if ( !item )]&]
[s0; [C0         return;]&]
[s0; [C0     item`->setSelected( TRUE );]&]
[s0; [C0     item`->repaint();]&]
[s0;C0 &]
[s0; [C0     iFirstName`->setText( item`->text( 0 ) );]&]
[s0; [C0     iLastName`->setText( item`->text( 1 ) );]&]
[s0; [C0     iAddress`->setText( item`->text( 2 ) );]&]
[s0; [C0     iEMail`->setText( item`->text( 3 ) );]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void ABCentralWidget`::toggleFirstName()]&]
[s0; [C0 `{]&]
[s0; [C0     sFirstName`->setText( `"`" );]&]
[s0;C0 &]
[s0; [C0     if ( cFirstName`->isChecked() ) `{]&]
[s0; [C0         sFirstName`->setEnabled( TRUE );]&]
[s0; [C0         sFirstName`->setFocus();]&]
[s0; [C0     `}]&]
[s0; [C0     else]&]
[s0; [C0         sFirstName`->setEnabled( FALSE );]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void ABCentralWidget`::toggleLastName()]&]
[s0; [C0 `{]&]
[s0; [C0     sLastName`->setText( `"`" );]&]
[s0;C0 &]
[s0; [C0     if ( cLastName`->isChecked() ) `{]&]
[s0; [C0         sLastName`->setEnabled( TRUE );]&]
[s0; [C0         sLastName`->setFocus();]&]
[s0; [C0     `}]&]
[s0; [C0     else]&]
[s0; [C0         sLastName`->setEnabled( FALSE );]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void ABCentralWidget`::toggleAddress()]&]
[s0; [C0 `{]&]
[s0; [C0     sAddress`->setText( `"`" );]&]
[s0;C0 &]
[s0; [C0     if ( cAddress`->isChecked() ) `{]&]
[s0; [C0         sAddress`->setEnabled( TRUE );]&]
[s0; [C0         sAddress`->setFocus();]&]
[s0; [C0     `}]&]
[s0; [C0     else]&]
[s0; [C0         sAddress`->setEnabled( FALSE );]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void ABCentralWidget`::toggleEMail()]&]
[s0; [C0 `{]&]
[s0; [C0     sEMail`->setText( `"`" );]&]
[s0;C0 &]
[s0; [C0     if ( cEMail`->isChecked() ) `{]&]
[s0; [C0         sEMail`->setEnabled( TRUE );]&]
[s0; [C0         sEMail`->setFocus();]&]
[s0; [C0     `}]&]
[s0; [C0     else]&]
[s0; [C0         sEMail`->setEnabled( FALSE );]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [C0 void ABCentralWidget`::findEntries()]&]
[s0; [C0 `{]&]
[s0; [C0     if ( !cFirstName`->isChecked() `&`&]&]
[s0; [C0          !cLastName`->isChecked() `&`&]&]
[s0; [C0          !cAddress`->isChecked() `&`&]&]
[s0; [C0          !cEMail`->isChecked() ) `{]&]
[s0; [C0         listView`->clearSelection();]&]
[s0; [C0         return;]&]
[s0; [C0     `}]&]
[s0;C0 &]
[s0; [C0     QListViewItemIterator it( listView );]&]
[s0;C0 &]
[s0; [C0     for ( ; it.current(); `+`+it ) `{]&]
[s0; [C0         bool select `= TRUE;]&]
[s0;C0 &]
[s0; [C0         if ( cFirstName`->isChecked() ) `{]&]
[s0; [C0             if ( select `&`& it.current()`->text( 0 ).contains( 
sFirstName`->text() ) )]&]
[s0; [C0                 select `= TRUE;]&]
[s0; [C0             else]&]
[s0; [C0                 select `= FALSE;]&]
[s0; [C0         `}]&]
[s0; [C0         if ( cLastName`->isChecked() ) `{]&]
[s0; [C0             if ( select `&`& it.current()`->text( 1 ).contains( 
sLastName`->text() ) )]&]
[s0; [C0                 select `= TRUE;]&]
[s0; [C0             else]&]
[s0; [C0                 select `= FALSE;]&]
[s0; [C0         `}]&]
[s0; [C0         if ( cAddress`->isChecked() ) `{]&]
[s0; [C0             if ( select `&`& it.current()`->text( 2 ).contains( 
sAddress`->text() ) )]&]
[s0; [C0                 select `= TRUE;]&]
[s0; [C0             else]&]
[s0; [C0                 select `= FALSE;]&]
[s0; [C0         `}]&]
[s0; [C0         if ( cEMail`->isChecked() ) `{]&]
[s0; [C0             if ( select `&`& it.current()`->text( 3 ).contains( 
sEMail`->text() ) )]&]
[s0; [C0                 select `= TRUE;]&]
[s0; [C0             else]&]
[s0; [C0                 select `= FALSE;]&]
[s0; [C0         `}]&]
[s0;C0 &]
[s0; [C0         if ( select )]&]
[s0; [C0             it.current()`->setSelected( TRUE );]&]
[s0; [C0         else]&]
[s0; [C0             it.current()`->setSelected( FALSE );]&]
[s0; [C0         it.current()`->repaint();]&]
[s0; [C0     `}]&]
[s0; [C0 `}]&]
[s0;C0 &]
[s0; [*C2 main.cpp]&]
[s0;C0 &]
[s0; [C0 #include <qapplication.h>]&]
[s0;C0 &]
[s0; [C0 #include `"mainwindow.h`"]&]
[s0;C0 &]
[s0; [C0 int main( int argc, char `*`* argv )]&]
[s0; [C0 `{]&]
[s0; [C0     QApplication a( argc, argv );]&]
[s0;C0 &]
[s0; [C0     ABMainWindow `*mw `= new ABMainWindow();]&]
[s0; [C0     mw`->setCaption( `"Qt Example `- Addressbook`" );]&]
[s0; [C0     a.setMainWidget( mw );]&]
[s0; [C0     mw`->show();]&]
[s0;C0 &]
[s0; [C0     a.connect( `&a, SIGNAL( lastWindowClosed() ), `&a, SLOT( 
quit() ) );]&]
[s0; [C0     int result `= a.exec();]&]
[s0; [C0     delete mw;]&]
[s0; [C0     return result;]&]
[s0; [C0 `}]&]
[s0;=2 ]}}&]
[s0;=2 &]
[ {{5000:5000@(255.255.200)-1 [s0; [/2 To make this comparison more fair, we have omitted following 
parts that are designed by layout designer in Ultimate`+`+ and 
could be designed by Qt designer]]
::@2 [s0;%- ]
::^@7 [s0; [*2 Ultimate`+`+ version]]
:: [s0; [*2 Qt version]]
::@2 [s0; [*C2 AddressBook.lay]&]
[s0; [/C2 (designed using layout designer)]&]
[s0;/C2 &]
[s0; [C0 #ifdef LAYOUTFILE]&]
[s0;C0 &]
[s0; [C0 LAYOUT(AddressBookLayout, 496, 456)]&]
[s0; [C0 -|ITEM(MenuBar, menu, LeftPosZ(0, 200).TopPosZ(0, 20))]&]
[s0; [C0 -|ITEM(TabCtrl, tab, LeftPosZ(8, 480).TopPosZ(32, 84))]&]
[s0; [C0 -|ITEM(ArrayCtrl, array, LeftPosZ(8, 480).TopPosZ(124, 324))]&]
[s0; [C0 END`_LAYOUT]&]
[s0;C0 &]
[s0; [C0 LAYOUT(ModifyLayout, 480, 52)]&]
[s0; [C0 -|ITEM(Label, dv`_`_`_0, SetLabel(`"`&Name`").LeftPosZ(8, 48).TopPosZ(8, 
15))]&]
[s0; [C0 -|ITEM(EditField, name, LeftPosZ(8, 96).TopPosZ(28, 19))]&]
[s0; [C0 -|ITEM(Label, dv`_`_`_2, SetLabel(`"`&Surname`").LeftPosZ(108, 
48).TopPosZ(8, 15))]&]
[s0; [C0 -|ITEM(EditField, surname, LeftPosZ(108, 96).TopPosZ(28, 19))]&]
[s0; [C0 -|ITEM(Label, dv`_`_`_4, SetLabel(`"`&Address`").LeftPosZ(208, 
48).TopPosZ(8, 15))]&]
[s0; [C0 -|ITEM(EditField, address, LeftPosZ(208, 96).TopPosZ(28, 19))]&]
[s0; [C0 -|ITEM(Label, dv`_`_`_6, SetLabel(`"`&Email`").LeftPosZ(308, 
48).TopPosZ(8, 15))]&]
[s0; [C0 -|ITEM(EditField, email, LeftPosZ(308, 96).TopPosZ(28, 19))]&]
[s0; [C0 -|ITEM(Button, add, SetLabel(`"Ad`&d`").LeftPosZ(416, 56).TopPosZ(4, 
20))]&]
[s0; [C0 -|ITEM(Button, change, SetLabel(`"`&Change`").LeftPosZ(416, 
56).TopPosZ(28, 20))]&]
[s0; [C0 END`_LAYOUT]&]
[s0;C0 &]
[s0; [C0 LAYOUT(SearchLayout, 480, 56)]&]
[s0; [C0 -|ITEM(Option, oname, SetLabel(`"`&Name`").LeftPosZ(8, 56).TopPosZ(8, 
18))]&]
[s0; [C0 -|ITEM(EditField, name, LeftPosZ(8, 96).TopPosZ(28, 19))]&]
[s0; [C0 -|ITEM(Option, osurname, SetLabel(`"`&Surname`").LeftPosZ(108, 
64).TopPosZ(8, 18))]&]
[s0; [C0 -|ITEM(EditField, surname, LeftPosZ(108, 96).TopPosZ(28, 19))]&]
[s0; [C0 -|ITEM(Option, oaddress, SetLabel(`"`&Address`").LeftPosZ(208, 
64).TopPosZ(8, 18))]&]
[s0; [C0 -|ITEM(EditField, address, LeftPosZ(208, 96).TopPosZ(28, 19))]&]
[s0; [C0 -|ITEM(Option, oemail, SetLabel(`"`&Email`").LeftPosZ(308, 
52).TopPosZ(8, 18))]&]
[s0; [C0 -|ITEM(EditField, email, LeftPosZ(308, 96).TopPosZ(28, 19))]&]
[s0; [C0 -|ITEM(Button, search, SetLabel(`"`&Search`").LeftPosZ(416, 
56).TopPosZ(28, 20))]&]
[s0; [C0 END`_LAYOUT]&]
[s0;C0 &]
[s0; [C0 #endif]]
:: [s0; [C0 void ABCentralWidget`::setupTabWidget()]&]
[s0; [C0 `{]&]
[s0; [C0     tabWidget `= new QTabWidget( this );]&]
[s0;C0 &]
[s0; [C0     QWidget `*input `= new QWidget( tabWidget );]&]
[s0; [C0     QGridLayout `*grid1 `= new QGridLayout( input, 2, 5, 5, 
5 );]&]
[s0;C0 &]
[s0; [C0     QLabel `*liFirstName `= new QLabel( `"First `&Name`", 
input );]&]
[s0; [C0     liFirstName`->resize( liFirstName`->sizeHint() );]&]
[s0; [C0     grid1`->addWidget( liFirstName, 0, 0 );]&]
[s0;C0 &]
[s0; [C0     QLabel `*liLastName `= new QLabel( `"`&Last Name`", input 
);]&]
[s0; [C0     liLastName`->resize( liLastName`->sizeHint() );]&]
[s0; [C0     grid1`->addWidget( liLastName, 0, 1 );]&]
[s0;C0 &]
[s0; [C0     QLabel `*liAddress `= new QLabel( `"Add`&ress`", input 
);]&]
[s0; [C0     liAddress`->resize( liAddress`->sizeHint() );]&]
[s0; [C0     grid1`->addWidget( liAddress, 0, 2 );]&]
[s0;C0 &]
[s0; [C0     QLabel `*liEMail `= new QLabel( `"`&E`-Mail`", input );]&]
[s0; [C0     liEMail`->resize( liEMail`->sizeHint() );]&]
[s0; [C0     grid1`->addWidget( liEMail, 0, 3 );]&]
[s0;C0 &]
[s0; [C0     add `= new QPushButton( `"A`&dd`", input );]&]
[s0; [C0     add`->resize( add`->sizeHint() );]&]
[s0; [C0     grid1`->addWidget( add, 0, 4 );]&]
[s0; [C0     connect( add, SIGNAL( clicked() ), this, SLOT( addEntry() 
) );]&]
[s0;C0 &]
[s0; [C0     iFirstName `= new QLineEdit( input );]&]
[s0; [C0     iFirstName`->resize( iFirstName`->sizeHint() );]&]
[s0; [C0     grid1`->addWidget( iFirstName, 1, 0 );]&]
[s0; [C0     liFirstName`->setBuddy( iFirstName );]&]
[s0;C0 &]
[s0; [C0     iLastName `= new QLineEdit( input );]&]
[s0; [C0     iLastName`->resize( iLastName`->sizeHint() );]&]
[s0; [C0     grid1`->addWidget( iLastName, 1, 1 );]&]
[s0; [C0     liLastName`->setBuddy( iLastName );]&]
[s0;C0 &]
[s0; [C0     iAddress `= new QLineEdit( input );]&]
[s0; [C0     iAddress`->resize( iAddress`->sizeHint() );]&]
[s0; [C0     grid1`->addWidget( iAddress, 1, 2 );]&]
[s0; [C0     liAddress`->setBuddy( iAddress );]&]
[s0;C0 &]
[s0; [C0     iEMail `= new QLineEdit( input );]&]
[s0; [C0     iEMail`->resize( iEMail`->sizeHint() );]&]
[s0; [C0     grid1`->addWidget( iEMail, 1, 3 );]&]
[s0; [C0     liEMail`->setBuddy( iEMail );]&]
[s0;C0 &]
[s0; [C0     change `= new QPushButton( `"`&Change`", input );]&]
[s0; [C0     change`->resize( change`->sizeHint() );]&]
[s0; [C0     grid1`->addWidget( change, 1, 4 );]&]
[s0; [C0     connect( change, SIGNAL( clicked() ), this, SLOT( changeEntry() 
) );]&]
[s0;C0 &]
[s0; [C0     tabWidget`->addTab( input, `"`&Add/Change Entry`" );]&]
[s0;C0 &]
[s0; [C0     // `-`-`-`-`-`-`-`-`-`-`-`-`-`-`-`-`-`-`-`-`-`-`-`-`-`-`-`-`-`-`-`-`-`-`-`-
`-`-]&]
[s0;C0 &]
[s0; [C0     QWidget `*search `= new QWidget( this );]&]
[s0; [C0     QGridLayout `*grid2 `= new QGridLayout( search, 2, 5, 
5, 5 );]&]
[s0;C0 &]
[s0; [C0     cFirstName `= new QCheckBox( `"First `&Name`", search 
);]&]
[s0; [C0     cFirstName`->resize( cFirstName`->sizeHint() );]&]
[s0; [C0     grid2`->addWidget( cFirstName, 0, 0 );]&]
[s0; [C0     connect( cFirstName, SIGNAL( clicked() ), this, SLOT( 
toggleFirstName() ) );]&]
[s0;C0 &]
[s0; [C0     cLastName `= new QCheckBox( `"`&Last Name`", search );]&]
[s0; [C0     cLastName`->resize( cLastName`->sizeHint() );]&]
[s0; [C0     grid2`->addWidget( cLastName, 0, 1 );]&]
[s0; [C0     connect( cLastName, SIGNAL( clicked() ), this, SLOT( toggleLastName() 
) );]&]
[s0;C0 &]
[s0; [C0     cAddress `= new QCheckBox( `"Add`&ress`", search );]&]
[s0; [C0     cAddress`->resize( cAddress`->sizeHint() );]&]
[s0; [C0     grid2`->addWidget( cAddress, 0, 2 );]&]
[s0; [C0     connect( cAddress, SIGNAL( clicked() ), this, SLOT( toggleAddress() 
) );]&]
[s0;C0 &]
[s0; [C0     cEMail `= new QCheckBox( `"`&E`-Mail`", search );]&]
[s0; [C0     cEMail`->resize( cEMail`->sizeHint() );]&]
[s0; [C0     grid2`->addWidget( cEMail, 0, 3 );]&]
[s0; [C0     connect( cEMail, SIGNAL( clicked() ), this, SLOT( toggleEMail() 
) );]&]
[s0;C0 &]
[s0; [C0     sFirstName `= new QLineEdit( search );]&]
[s0; [C0     sFirstName`->resize( sFirstName`->sizeHint() );]&]
[s0; [C0     grid2`->addWidget( sFirstName, 1, 0 );]&]
[s0;C0 &]
[s0; [C0     sLastName `= new QLineEdit( search );]&]
[s0; [C0     sLastName`->resize( sLastName`->sizeHint() );]&]
[s0; [C0     grid2`->addWidget( sLastName, 1, 1 );]&]
[s0;C0 &]
[s0; [C0     sAddress `= new QLineEdit( search );]&]
[s0; [C0     sAddress`->resize( sAddress`->sizeHint() );]&]
[s0; [C0     grid2`->addWidget( sAddress, 1, 2 );]&]
[s0;C0 &]
[s0; [C0     sEMail `= new QLineEdit( search );]&]
[s0; [C0     sEMail`->resize( sEMail`->sizeHint() );]&]
[s0; [C0     grid2`->addWidget( sEMail, 1, 3 );]&]
[s0;C0 &]
[s0; [C0     find `= new QPushButton( `"F`&ind`", search );]&]
[s0; [C0     find`->resize( find`->sizeHint() );]&]
[s0; [C0     grid2`->addWidget( find, 1, 4 );]&]
[s0; [C0     connect( find, SIGNAL( clicked() ), this, SLOT( findEntries() 
) );]&]
[s0;C0 &]
[s0; [C0     cFirstName`->setChecked( TRUE );]&]
[s0; [C0     sFirstName`->setEnabled( TRUE );]&]
[s0; [C0     sLastName`->setEnabled( FALSE );]&]
[s0; [C0     sAddress`->setEnabled( FALSE );]&]
[s0; [C0     sEMail`->setEnabled( FALSE );]&]
[s0;C0 &]
[s0; [C0     tabWidget`->addTab( search, `"`&Search`" );]&]
[s0;C0 &]
[s0; [C0     mainGrid`->addWidget( tabWidget, 0, 0 );]&]
[s0; [C0 `}]&]
[s0;C0 ]}}&]
[s0;=2 &]
[s0; ]]