topic "Hydrocheck for Windows";
[ $$0,0#00000000000000000000000000000000:Default]
[{_}%EN-US 
[s0; [*6 Hydrocheck]&]
[s0; Copyright ©2005`-2011 Ing. Tomáš Rylek, [^http`:`/`/www`.hv`.cz`/^ Hydrosoft 
Veleslavín, spol. s r.o.]&]
[s0; &]
[s0; This is a specialized software for analyzing river flow. A built 
in editor is used to define cross sections and other river parameters, 
which can be afterwards subjected to a multitude of hydraulic 
computations and for generation of various readouts. [/ The software 
is under development, especially the hydraulic calculator is 
not yet complete, further development is scheduled for the year 
2006.]&]
[s0; &]
[ {{2986:7014 [s0; Database technology:]
:: [s0; Currently none (Hydrocheck is a standalone application managing 
all its data in a transparent XML file). Current data migration 
features include import and export using plain text files, DBF 
and RTF files. ]
:: [s0; Source files:]
:: [s0; cca 100 files in 2 special package plus 32 uppsrc packages]
:: [s0; Number of lines:]
:: [s0; cca 80000 (not including the uppsrc packages)]
::^ [s0; Application style:]
::= [s0; mainly combined graphical and alphanumerical editaton]
::^ [s0; Distinctive features:]
::= [s0; Vector graphics (cross section and chart display, print output 
generation), heavy numerical computations, customizability based 
on the built`-in expression evaluator. Additional support for 
GIS data for map`-style display.]}}&]
[s0; &]
[s0; &]
[s0; The project design starts with import of geodetical measurements 
of the river cross sections. Using the editor, you can equip 
the individual cross sections with a multitude of descriptive 
attributes like riverbed roughness and selection of an appropriate 
numerical approximation model.&]
[s0; &]
[s0; 
@@image:3006&2262
(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)
&]
[s0; &]
[s0; &]
[s0; After composing the whole river section you can use built`-in 
calculation to calculate steady flow parameters. ([/ As of November 
2005, the flow calculator is not yet finished. It is scheduled 
for further development in the year 2006.)]&]
[s0; &]
[s0; 
@@image:3006&2262
(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)
&]
[s0; &]
[s0; &]
[s0; You can use the collected data to generate printer`-ready reports 
and drawings.&]
[s0; &]
[s0; 
@@image:3006&2262
(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)
&]
[s0; ]]