topic "Clock";
[ $$0,0#00000000000000000000000000000000:Default]
[b83;*4 $$1,0#07864147445237544204411237157677:title]
[b42;a42;2 $$2,2#45413000475342174754091244180557:text]
[{_}%EN-US 
[s1; Description&]
[s2; The example shows U`+`+ implementation of analog/digital clock.&]
[s1; Result&]
[s0;= 
@@rawimage:2520&2448
(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)
&]
[s0; ]]