topic "Introduction";
[ $$0,0#00000000000000000000000000000000:Default]
[b83;*4 $$1,0#07864147445237544204411237157677:title]
[b42;a42;ph2 $$2,2#45413000475342174754091244180557:text]
[{_}%EN-US 
[s1; Description&]
[s2; Example of usage [^http`:`/`/box2d`.org`/^ Box2D] a 2D physics 
engine with U`+`+.&]
[s1; Result&]
[s0;0 &]
[s0;= 
@@rawimage:2642&2224
(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)
&]
[s0;0 ]]