topic "AddressBookWeb";
[ $$0,0#00000000000000000000000000000000:Default]
[b83;*4 $$1,0#07864147445237544204411237157677:title]
[b42;a42;ph2 $$2,2#45413000475342174754091244180557:text]
[{_}%EN-US 
[s1; Description&]
[s2; This example shows usage of SKYLARK technology to develop web 
application. More information about SKYLARK is available in U`+`+ 
official [^http`:`/`/www`.ultimatepp`.org`/www`$uppweb`$documentation`$en`-us`.html^ d
ocumentation]. If you would like to start playing with it, we 
recommended to begin with the [^http`:`/`/www`.ultimatepp`.org`/srcdoc`$Skylark`$Tutorial`$en`-us`.html^ t
utorial]. The application uses SQLite as a database engine. So, 
you don`'t need to install any SQL server to launch this example.&]
[s2; The application by default runs on following address: 127.0.0.1:8008 
(localhost port 8008). If you want to see this page, just type 
above address in your browser.&]
[s1; Result (Web pages)&]
[s0;0 &]
[s0;= [0 
@@rawimage:2199&727
(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)
]&]
[s0;= [1 Adress book list]&]
[s0;0 ]]