#include "SDL2GUI.h"

namespace Upp {

Tuple<int, int> SDL_key_map[] = {
#if 0
	{ K_BACK, SDLK_BACKSPACE },
	{ K_BACKSPACE, SDLK_BACKSPACE },

	//handled extra in fbKEYtoK
	{ K_TAB, SDLK_TAB },
 
	{ K_SPACE, SDLK_SPACE },

	{ K_RETURN, SDLK_RETURN },
	{ K_ENTER, K_RETURN },
#endif 

	{ K_SHIFT_KEY, SDLK_LSHIFT },
	{ K_CTRL_KEY, SDLK_LCTRL },
	{ K_ALT_KEY, SDLK_LALT },
	{ K_CAPSLOCK, SDLK_CAPSLOCK },
	{ K_ESCAPE, SDLK_ESCAPE },
	{ K_PAGEUP, SDLK_PAGEUP },
	{ K_PAGEDOWN, SDLK_PAGEDOWN },
	{ K_END, SDLK_END },
	{ K_HOME, SDLK_HOME },
	{ K_LEFT, SDLK_LEFT },
	{ K_UP, SDLK_UP },
	{ K_RIGHT, SDLK_RIGHT },
	{ K_DOWN, SDLK_DOWN },
	{ K_INSERT, SDLK_INSERT },
	{ K_DELETE, SDLK_DELETE },

	{ K_NUMPAD0, SDLK_KP_0 },
	{ K_NUMPAD1, SDLK_KP_1 },
	{ K_NUMPAD2, SDLK_KP_2 },
	{ K_NUMPAD3, SDLK_KP_3 },
	{ K_NUMPAD4, SDLK_KP_4 },
	{ K_NUMPAD5, SDLK_KP_5 },
	{ K_NUMPAD6, SDLK_KP_6 },
	{ K_NUMPAD7, SDLK_KP_7 },
	{ K_NUMPAD8, SDLK_KP_8 },
	{ K_NUMPAD9, SDLK_KP_9 },
	{ K_MULTIPLY, SDLK_KP_MULTIPLY },
	{ K_ADD, SDLK_KP_PLUS },
	{ K_SEPARATOR, SDLK_KP_PERIOD },
	{ K_SUBTRACT, SDLK_KP_MINUS },
	{ K_DECIMAL, SDLK_KP_PERIOD },
	{ K_DIVIDE, SDLK_KP_DIVIDE },
	{ K_SCROLL, SDLK_SCROLLLOCK },

	{ K_F1, SDLK_F1 },
	{ K_F2, SDLK_F2 },
	{ K_F3, SDLK_F3 },
	{ K_F4, SDLK_F4 },
	{ K_F5, SDLK_F5 },
	{ K_F6, SDLK_F6 },
	{ K_F7, SDLK_F7 },
	{ K_F8, SDLK_F8 },
	{ K_F9, SDLK_F9 },
	{ K_F10, SDLK_F10 },
	{ K_F11, SDLK_F11 },
	{ K_F12, SDLK_F12 },

	{ K_A, SDLK_a },
	{ K_B, SDLK_b },
	{ K_C, SDLK_c },
	{ K_D, SDLK_d },
	{ K_E, SDLK_e },
	{ K_F, SDLK_f },
	{ K_G, SDLK_g },
	{ K_H, SDLK_h },
	{ K_I, SDLK_i },
	{ K_J, SDLK_j },
	{ K_K, SDLK_k },
	{ K_L, SDLK_l },
	{ K_M, SDLK_m },
	{ K_N, SDLK_n },
	{ K_O, SDLK_o },
	{ K_P, SDLK_p },
	{ K_Q, SDLK_q },
	{ K_R, SDLK_r },
	{ K_S, SDLK_s },
	{ K_T, SDLK_t },
	{ K_U, SDLK_u },
	{ K_V, SDLK_v },
	{ K_W, SDLK_w },
	{ K_X, SDLK_x },
	{ K_Y, SDLK_y },
	{ K_Z, SDLK_z },
	{ K_0, SDLK_0 },
	{ K_1, SDLK_1 },
	{ K_2, SDLK_2 },
	{ K_3, SDLK_3 },
	{ K_4, SDLK_4 },
	{ K_5, SDLK_5 },
	{ K_6, SDLK_6 },
	{ K_7, SDLK_7 },
	{ K_8, SDLK_8 },
	{ K_9, SDLK_9 },

	{ K_CTRL_LBRACKET, K_CTRL|219 },
	{ K_CTRL_RBRACKET, K_CTRL|221 },
	{ K_CTRL_MINUS, K_CTRL|0xbd },
	{ K_CTRL_GRAVE, K_CTRL|0xc0 },
	{ K_CTRL_SLASH, K_CTRL|0xbf },
	{ K_CTRL_BACKSLASH, K_CTRL|0xdc },
	{ K_CTRL_COMMA, K_CTRL|0xbc },
	{ K_CTRL_PERIOD, K_CTRL|0xbe },
	{ K_CTRL_SEMICOLON, K_CTRL|0xbe },
	{ K_CTRL_EQUAL, K_CTRL|0xbb },
	{ K_CTRL_APOSTROPHE, K_CTRL|0xde },

	{ K_BREAK, SDLK_PAUSE }, // Is it really?

	{ K_PLUS, SDLK_PLUS },
	{ K_MINUS, SDLK_MINUS },
	{ K_COMMA, SDLK_COMMA },
	{ K_PERIOD, SDLK_PERIOD },
	{ K_SEMICOLON, SDLK_SEMICOLON },

	{ K_SLASH, SDLK_SLASH },
	{ K_GRAVE, SDLK_CARET },
	{ K_LBRACKET, SDLK_LEFTBRACKET },
	{ K_BACKSLASH, SDLK_BACKSLASH },
	{ K_RBRACKET, SDLK_RIGHTBRACKET },
	{ K_QUOTEDBL, SDLK_QUOTEDBL },
	
	{ 0, 0 },
};

}