topic "This is test:";
[a83;*R6 $$1,3#31310162474203024125188417583966:caption]
[H4;b83;*4 $$2,3#07864147445237544204411237157677:title]
[b42;a42;ph2 $$3,3#45413000475342174754091244180557:text]
[l321;C@5;1 $$4,4#20902679421464641399138805415013:code]
[ $$0,0#00000000000000000000000000000000:Default]
[{_}%EN-US 
[s1; Resolving memory leaks in U`+`+ applications&]
[s2; Table of contents&]
[s0; &]
[s0; [^topic`:`/`/Core`/srcdoc`/Leaks`_en`-us`#1^ 1. Introduction]&]
[s0; [^topic`:`/`/Core`/srcdoc`/Leaks`_en`-us`#2^ 2. Debugging leaks]&]
[s0; [^topic`:`/`/Core`/srcdoc`/Leaks`_en`-us`#3^ 3. False positives]&]
[s0; &]
[s2;:1: 1. Introduction&]
[s3; Before 2008.1 release, the memory leaks debugging facilities 
have changed. Here we try to explain why logic has changed and 
what problem is it supposed to solve:&]
[s3; Previous method involved watching for particular ADDRESS to 
be allocated (so that you could determine the source of leak). 
Anyway, that has a problem than often the same memory block is 
going to be allocated more than one time `- obviously, in that 
case the watch would only catch the first allocation, which would 
not be the cause of the problem. That is why logic was improved 
by introducing `"memory allocation serial number`".&]
[s3; The memory leaks mechanisms only applies to U`+`+ Core based 
application. When you develop non U`+`+ applications in TheIDE, 
the detection mechanism will not be present.&]
[s2;:2: 2. Debugging leaks&]
[s3;~~~2752; In `"memory allocation serial number`" each memory allocation 
has associated serial number (incremental). When U`+`+ detects 
a leak, it dumps all leak blocks (note that sometimes you can 
resolve the problem just by examining its content) to standard 
.log file. You can see it in TheIDE by pressing[*  Alt`+L] or by 
selecting [* `"View log file`"] option from `"Debug`" menu:&]
[s0; &]
[s0;= 
@@rawimage:2230&1400
(iVBORw0KGgoAAAANSUhEUgAAAf4AAAFACAIAAADSzYl3AAAACXBIWXMAAA7EAAAOxAGVKw4bAAAgAElEQVR4Xuydd1wT5xvAn7tcJiRAGDIDMqKICM6quFtrLQ6kbq17tlZb/bVVq9RRrdqWDrVaZ61dbgVXq23dUosCIqgMGTIFwsoiyd39/rgQwhEQcKG+308++Vyed9xdcnnuued93+fBiouLAYFAIBAvEwRbgHgR6RB/lC1qMdwMDmOLEAjEEwZnCxAIBALxooNUPwKBQLx0INWPQCAQLx1I9SMQCMRLB1L9CAQC8dLRWNW/YNHHqWnpABA+ZkJcwk128WMlLuFm+JgJzLZpv0+fZ7jr+mj4VzD/3p4E13uN62Hnwpa2PFrgD/cMsXipIBAWJne+/+Him4m3OBxj0ewZU0eOGP7tV+tr12o+FvuvXaUG035v37nL5/O9W3uZlzaMaUd8Ps/Xx3vmtCkB/m3Zleqnqafc7CMkCC6Hw2nl5Bg2NDRs2BB2JTOaekgNs6/j4FdsnfU0BQDZmsrDBWk/ZN8y0BS73rPj6+82X4n5d98ve3AMY5fVTwPfUjN+o2uxN7bt3J2VfZ/P57X28vzk4w+dWzmxKwFAszpvKu9/uLhn91dGvzXCJJk6651xo0e+/toAs1oIxMOxoPoBYM7M6eaX12OnGf3/tv9g3969mvq/Ynak0Wj2Hzr6v8XLju7/lc/nsSs9Jh7lCCmavhEX//Enn7b28gzqEMiu9MRYk3Zt+/0kAU4ESxyW+3XrJXWdGP8HSdPsetXQ9Rc9drRVVX/9c97Bwf7af7Hdu3VlFzeLpv5G5eUVS5av+OTj//Xv21utVt+IT3B0sGdXqqapnSMQz5DGOnzqPjYWl5QsXrZi0NAR4WMmHDoaZV7UDO7n5M5f9NGgoSMmz5iTfT/HJGf2+8XX352/eHnN+i8Hhob9fe68WbtGIRQKR4YPVyqVBYUFABA+ZkJKatrsee8PfHN4SYmipETx6eq1w94a+2bYyHVffq1Sq5lWplO2eKZFxSXLV342eNhbg4eP3LJtxyMeIY5hXTp19JR53M/JBYABbww1uSySbt8ZMmI0s133V6jve2sSWsoQU1YwKeHPDmKHwY5eANCKL/oxaODdfpOu9xo31b2dqWaA2P5897fu9pt0oNOb3iIbRpjRf0qA2KgQO9k43eozkdn2FIoPdHrzbr9Jf3cPH97K+3qvcYy8kfz19zn/tm3ChoYeO36SkVA0vWXbjrDR418fMuLtabMSbibWlUD1t1S3qBm/kaK0VK/Xd+/WFcMwKyur3iE9ORwOWLok6nbewI94/sKliVNnDho6Yv6ij5hf/LFQ96jMeXL7RTyPWLb6G8Mnn672byM/fuRAXl7euwv+5yWTde4UzK7UOGiajli1Jjgo8Kt1a8rKKz6JWMmq8OEH8++mpI4bPfLV/n1ZRQ+FpmmFovT3A4ecWzm5uboywjXrv4pY+pGXpwzH8Xff/5/c12f/r3v0Ov3aDV9+EfndimWLzXuweKZLlq/wb9vmyIFfgaYrK5WOjg7NPkIAMBgMcQk3HxQVNek7fOj31iRKdNrLpfl9pG7HH2Ts7PBafEVR+ws/ewklRzoPSVWXXVLkAcCwVq1H3jhZbtAt9un8Q+CAQdeOUvU/B/wQ+Oq/ZQUT4v9w4Al2dRjILn4Yx46ffHv8mE4dg7du31VcUuJgb3/9Rtw/5y/u3blNJBKmpKW7OjvXlZia1y1qxlUk83D38W699NOV786e6efrY5LXvSSa1PnvBw9/F7nB2srq+207l6/8bNe275vk0aqPukfFupye0H4RzyOWrf6t23cODA1jXhZHzLLv59y5mzJ7xlQuQXjKZH169Tx38RK7Uv2Y93/7bsr9nNx7GZkzp07hcrmODvZv1e/6bypbt+8cNDR85rvzi4pLvvlyPUEYb3Wj3grz8W7N4XDy8guSkm/PmTlNwOeLxdazZ0w7d+GiRqMx9WDxTLOys1PT0t+dPUPA5wsEAkdHB1P9psJ8Fa8OHrZ8xWfvzZ3tYqa8Hspj/94Kq9RSnsBHZNNB7PB5WqyeolJVZaeKMkMdvZgKe3JuF+k0Oor88t4Nf2upl1BSq70Z3iKbdtbS9emxOorM06q2Z99i12iQ1LT04uLikB7drUSivr1Djp/8AwBaOTmpVOq//jlnMJD+beQ2NpK6ElMPDRQ1Hg6Hs+nrL9r4+X3w4ZIZc9+LufYf1HNJsFs2yIjhQ6R2djweb+a0yfcyMnNz89g16sf8vzMwNOxeRiYjb8xRPcp+ES8Ylq3+h/rii4uLaZoeNtL4CE/TdJ9ePWtXaQhW/3EJN8Via5FIyHx0cnI0FT0i9Z2Im6txpsqDoiKx2FogEDAfnVs5kSRZXlEpFBoPxuKZlpQozFs9CiZff2Zm1rIVq9VqzYjhtUZ6aarecdcSheLxfm/uAutCndqZb4VjWHzv8YwQx+DUgyxmu1inZTbUpKHSoGvFF95TlzMSBhyMVmQrvrBMX6UmDczHvCpVTaVGEHX8ZFl5+bC3xgJAlU5nI5FMmjhO5uH+/Xdf/fLbgT0//zZ40MBpkyfWlZju7g0UNQkrK6u5s6bPmDb55Kk/Pvl09ZfrPqMpqu4lUbsRG9aPKLWzYzasRCIrkaikROHh7mZeoQFYl/TUWe8wGxYvVFM1hkfZL+IFozl/BgCwt5cSBHHq2MHm/Z1YSO3sKiuVVVU6Zgy2rKyWNmHAnsyTKbNrtVrDKND8gkIcxx3spaYKFs/0XkZmZaVSq9Waa/9HOUIcw7xbe4X06H71339HDB9CEISBJJmiB0VFtevW0JjvrfG4CqxCpC7zk84/0Kn1FOl/fm/d2T5OfONtxorDFRO8wioNAOhpiosZHx9dBVbMRpFOa8PlCXBCSxkAQMrlM/LGoNFozv59bst3Xzs6GB+n5rz3/r/XYnu80tVTJlv68aKysvKln676dd+BSRPG1ZWY+qlb1OzfiEsQw4eGXrx8NeHmrf59e9W9JKDOBdDAj1hUXMJslFdUKFUqB4ea663ZWLxQWTyJ/SKeUyw7fB6Kp0zm5+uz8fsf1GoNADwoKioqan7wZw8Pdy9P2a49P+kNBkVp6aEjx9g1ACQS8e27dwHAYDAako8FT5lHu7ZttmzfqdVqKyuVW7fvemPgq+Z/Hotn6t3ay8tTtnXH7qoqnd5gYEbMHvEIs7KzL16+0s6/LQDIPNzP/n2OoqjikpJ9B4+wq1bTmO+tMYgJ3gB7j1+D37hSmv9HUVaqqixJqVgpf8WawwUAV4GVC9+o0Ke5B7Tii3g453/enW4rFZmaCgBIV5cPb+XNwbBWfNEsWXumZrqqLE1Vvsi7IxfHHXnCaR4B1Xt7OGf/Pufr691G7ieV2jGvwYMGRh0/kZefn5Z+jyRJkUgotbNVqzV1JaZOLBY19TfKzcu/czelqkoHAHdTUlNS0wID2lm8JKBO5w38iIePRhWXlJAk+cP2XXJfH9MQ1KNQ31GZ8yT2i3hOaabqB4DPV31aXlHx1ri33xga/tHSiAdNiftv7q88eOQYjmGrIj5Jun13yIhRCxZ9PHb0W+wGABPHjbl46erA0LB/zl9klz0aa1ZGlJWVhY0aP2n6bCcnx/ffMz5Bm7B4pus+W5GTkzts5JjQsFEnTv0BzT1C5qt47c3hiz5e1q9P77fHjwWA999750Zc/ODhb320NMKiw4qhMd9bw3zi2y2t3+S4XuM+9On0c+6d6TfPMoO20xLOSLmC/3qNvdN30k9Br7sIrADAQFNf3Lt+sNObiX0mtBfbz078mxnjXXb3ai+pa3Lft/cGvW7y6dMAMxP/6ihxutVn4qHOoedLmjCf5Njxk28Oet1cMnjQ6zHXYrOzc1auWffGsLfCx0zkcDgTx42uqKhkSUxNLBY19TcqKy9f/9U3w0aOeWNo+OdfRL4zewYzcGrxkmB13sCPOPDV/u//b/GbYSNz8/JXRnzS7GcRFhaPypwntF/E8wiGUrXUR/iYCRFLFwcHPb1Z9k+OZx6v/3UH2Uc+nV/718ITzMsWr/9ZXVfPar+Ilknzrf4XGIqmS0oUFZVKW1vj1HVEMwixc3XiizAAJ57wHc8Ol0rRfBIjNNQ7I/aJ8qz2i2iB1Dsi9DKzYvXamGuxr7/a38tTxi5DNJputq2+adfHlstXGnRnS+5/de8GuwYCgXhGIIfPS8Ezd/g0wMvm8EEgWgLI4YNAIBAvHUj1IxAIxEsHcvggEAjESwca5n0poCgqr6CgVFFK0zRF008z9jIC8UKCYRiO4xiGSaV2Lq1a4fhz5kFBVv9LQW5+vlajlXm4AwCO40zkYQQC0WxIkqQoCgCyc3IFfIGbaxMCL7YEnrM7FaJ5KBSlMg93LpfL5XKR3kcgHh0Oh8P8oTzc3BSlCnZxi4fYtGkTW4Z44ejbHyXwQyCeIM+dIsWQ2/dl4J/zF/zbyLlcLrsAgUA8Gjqd/k5KSv++fdgFLRuipMQYxxXxAkPTNIrVhUA8CTAMo2n6uVOkyNf/soBUPwLxJHhO/1ktcXLnpk2b5s2bZ/qoI8nNBXeiSrNLDFVmtR6OA8EfKvV4t5U/ryUNbLLO7umArH4E4gmB4xhN01djrrELnilCodBT5mFnZ8uSl5aWZWXf12g0LVH1s9hceHt38T2Mi2O8prmqS4D8sTgdAD5wNeYPeWlBqh+BeEIwDp8hoYPZBU+A4ydO9ejejS2tA0VR5eUVqWnpfr4+5tq/tLSMEdrYSJ4Dh0+04j7GxaE66WtTwIBDRCvus8UvJUj1IxBPghb4z8Jx3M7O1tfX+/79HHN5VvZ95maAPxcr0IoNVUBjQENzXkxzxMtBWFhYYmIiW4pAvEDQjcZGIlGp1eZtNRqNRCJmSh/i8Lmee2X64WGmjzvDozq79TQrfzjXb8bqSZ3pI5fD69yhi1l546iegUoWKajSCppkpwtn4NhJOE72gDfhJlxaWqpRKWlSTwMAxhFZi6XSRuWqpuufFNsCrYAnRHh4eExMDEEQfD6/TZs2S5cu7dmzaZfHI3Ljxg2hUOjv7898PHq05camRiCeAoxeYlSQRcveJKxX9RuVvhSgP4AQAAA0MP3cMFA09gbAKH2cwEU2IgzHAICmaK1KGxN3pck3gGo9SynKkyYskvAEnDpnZTAY5hzec7qwmNPKHhqhfDUaTUlRoUjAE1uLuFweTdN6va5Kq8q6V2IlsXVwcGQ3AACA3Nzc4uJikiTZBWY4ODi4u7tb/N5fPCIiIubMmaPT6Xbu3Dlu3Li7d+8KBAJ2pSfG5s2bhwwZYlL9CASikVhWT9dzr0w/Nwz6A3Sv1vsAIAToDtAfpp8bdj33inn9uly/GUtiBpGNSCgWMnofADAcE4qFIhsRiRmu34yt3aIhTI8wFElJeAK9TldVjUqlqqysLCkpIQji8/7DBtFiQ0ExTTExyuj6bPOCvLzykgcSsbXYxo7HxzBMjWFagVAksZVKpVKySn0/K5PdBgAAiouLQ0JCBjSIQqHIyclh4nu8JPB4vEmTJqlUqqysLABwc3O7dcuYnz02NlYulzPbgYGBp0+fHjBggEwm69evX2ws+xooLCycMWNG27ZtfX19FyxYUFlZycgDAwOjo6N79Ojh5eU1fPjw9PR0AFi4cGF0dPS8efNkMhlj7wcGBl6+fLnhfuoeAEVRK1asCAgI8PT0DAkJuXr1KlMZgXjuwDCskV4HC6rfqPf9AIQAJQAxACfMioUAfg/R/oze5wl4JqUPAKpSlaZSQ+pJDMd4Al7TtD9FAUUBSQJFcXCcw+EQBIFXYzpbGxubzcMmhuK2ZH6RsUkd/UtRVO79bCGfsLbi03q1prKEpvQcQohhtFat1KqVXC5PYmNn0KkrKipYbQGAJEmCIJgNvV7P3H40Gg1z+8nPzweA7t27FxcXv1Tav7KyctOmTT4+Pq1bt2aX1eabb77Zu3dvRkZG//79P/zwQ1bptGnTHBwc4uLiYmNjS0pKFi5caCrasmVLVFTU3bt327VrN23aNIqiIiMjAwMDN23alJ2dHRZWK9VXA/3UPYALFy5ERUVdvnw5PT1906ZNbdq0qekIgWhhmIzaxsBubNbcguqffngYBAHYA5SAe7bngWHn2JNr7AGCwHwMgIWe1AmsBBwuezZ9e79AjMRIPcnhcgRWAvMxgIdA0zUvMLqrmHcOh8NofwDg8XgCgWDbyGlkaQVQlKm+Ofl5udYigchaTBn0PKGIpijSgOt1GoMeU+o0pdrK4vIiwEBiY6soKWK1ZUHTNFYduBXDMCacEwDgOB4YGMhof3abF45Vq1bJZDIfH5/4+Pjo6Ggej8euUZupU6e6ublxOJyRI0empqaaF2VmZsbGxkZERAiFQltb2+XLl0dHR6tUKqZ02rRpjo6OfD5/6dKlycnJGRkZ5m3Nabifugfg7u5eWVl55MgRg8HQsWPHRg72IBDPNWzVfz33CkiN9r57tufXg/Z09+rLqgMAIASQgkXD//rNWJzAze19EzZiWz8vOaP9MRzDCbyxhn+N3qcBQK1W7z9wwGT7czgcHo+Xm5u7fceOBw8eMA3MbxUmKsrLOUDigBdl3ddVkTqtBuNwSZLWVYFBT+tJg5AvJGlKp9VyuTyDTmve1hyCIDAMS05OFolESUlJBEHY2tpyudycnByCIJKTkx0dHfv06fPoAbGvXMl3cNhqel25ks+uYYmSkpLjx/8yvZ7oEvOIiIjs7Oy1a9fm5uba29uziwFYjz6urq7MBo/H0+v15kW5ubm2trYikYj56OHhYTAYFApjTERHR+Poi1gsFovFhYWFzMe6NNxP3QPw9fU9ceLE9evXu3TpsmbNGtZRIRAtE4tGfeNhD/NOPzwM+gNoaut9GuCkWSUaINRo+Me/x9ZuelInshEBgKrUaGeZw2j/1MwUmkMLrATq8lpzj+qFogEAaBooAICioqKdO3aMGzuWsbWZKmVlZb/+8svoUaMAACgAijY+rJjd3SoqymzEYk25km9lValQOMrcCC4PAGig9VVaIcGr0lXxcS5FGriEgG7QXYNhWJcuXbRarUAgqKqqAgCCILp06VJcXOzg4FBUVGRnZ8du0wgcHLZGRQ3v2dPlypX8YcOOAQDzEQAYieljfZSUlFy9Gt+jRzCjiJmPbh6WR60fF1OmTNmxY8fu3btnzJgBAARBmBRoXl6eec0GRr+dnJxKS0uVSqW1tTUAZGdnczgcZ2djGHTGmQYACoWioqKCkVt0azbcj8UDkMvlmzZtKikpmTRp0saNG80dRAhEi8Jc4/cd+KZZiZFzf5o76NmYmlv4G4AQIAEOjDlnsvfvr6Tvr6h5GVWqafi3DiaTv3e3vuYvRmgjtm0v76BVaS0+GVimtsPnhx9+SEpK2v3jjwNff/3af/8dP3Fi9pw5P/744+3bt3/ft69ufRMYRXK5PL6VUKfVWNvbElxeRXlZQX5ORVkpweVXaAylKqpMTVIUhQFG0w2pfgbmxmP+zufzAeChfo8GGDbsmEnLFxfPMSn6nj1doqKGM/eDBjDX+wBgb28/ZMirtas8fgiCWLFixbp16xjj2tfX9/DhwyRJFhQUbNmyhV27Hvz8/Dp37rxy5Uq1Wl1WVrZq1arRo0eboo3u2LGjoKDAYDCsXr06MDCQGVSQSqVxcXEAYG6qN9xPXbKyspKSkgwGg7W1taOjo1KppChqzJgxp06dMm2w2yAQLYC6Wr6upD4sqf6Wh2loglHls2fPDggImDplyo4dOxYtWrR27drIyMhZs2YxwloN2M9ENIZhAisriaM9l8+naVqtUnr6tFWplAC0Vk+Jrax0FMX4KJo6SMuofmYQ+BHTodRn3deVWMSi4+VJ88YbbwQEBKxZswYA1q1bd/HiRR8fn7Fjx86ZM4ddtX727NlTXFwcEBDQq1cvNze3devWmYpGjhw5YsQIX1/fjIyMXbt2Mfb+ggULTp48KZPJoqKianppsJ+6lJaWzpo1y9vbOzAwkCCIBQsWUBSVnp6uUChMG+w2CETLwFzXN17vQ12HDwCABiAIRu3rZ3L4eHyK1RrpZdSpxkxSG5qiGYv+4rXz5nLG8C+vLEvNTBFYCWjGjdMYGA1O09X7NuIpkzk7O3t5ednZ2pYUFzODrkwDlr3PQGNEWamCy+MRBMHjC2igBUJRRkqyUCSiadpGwFFq1DY8jkAoqqrSYnhD6ruuq4GRmAafWaVNxaL2b7yv/+lo/8OHD5t/PHbM+ETStWvXc+fOmeQjRoxgNsyX2vr5+dX11zs5Oe3evZslZOjQoUPdaZchISHmM0RN/dfXj8UDCA4OZqaEmmPqtu4MVASiRXHuzxP9Xg9tkt6Hulb/zvAoSAAQQo4s64M/JsdkngcAwADeNHuFAgBAAuwMr2VqMXA5PK1KCwBWdlbmL6aU0fs0h8ZwTKvScjmNc4xQdM3LjIuXLgFAfHz8nTt3MMws7Uw99d1lnjyRtVpTpSgtKyzIU6uUEhubVi6uEhvbKo1GgGMOAsLGSggYpqyssJE+xD8eGxvL5XLNVUNsbCyfz4+Nja17Y2gGdX07zP2AJWTRo0fw1avxbOnzT50HOAQCYaSpeh/qWv2d3XqCAkADYA85kPXBH5O/HrSHVQcAQAOgAItrejt36BITd8Vk+Jtj0vscLoemaMpAdevYuDW9JqufBgBwc3MrKCz8KjJy//79+/btKy4unr9gQdSxYwWFhd9v2TL/vfeArm5SBzs7qZ2dFAAqKysf5GULhSKNSkVRJNA0YJhQZE2ShrJSBYVxnJ3r9a4YDAYACA4OZjbMJXq9nqbppjqLTBQXP8Q98lCfz9Ox9xEIxDPhEW0gU3O26geAneFRxiVd9pADWaOi+tX2sgCUAKRaNvkZGMOfJ+CxpvbfSk1khKSe1Gl1jTX5AYwrs2gaaAoA+Hz+rcREAFi0cCFN054y2Z9//AEAjBAAgKaAohoO5yAWi4s4XJVSKbKyqtJoeAIB0KBUVpSWlljbOHjJPNkNmkKtR5DHx0NvDAxPYVz3KYOCsiEQjxe2wwcAOrv13NkvClKNtj90r/bwMGgAUmFnv4bC+HTu0IVDEzqtztybb2VnJRQLGXtfp9VxaKIJYXyYAV6arnvLY5ZTmUMxNU2t6sfBybmstMSg12M4rqysKCzMq1Sp3T39POrX+ziOmyx9i2AYxqwxNhgMj+7xRyAQiCeBBasfqrW/MXxbUE34NkiARoZv69yhy/WbsepyNU7gAiuBefg2ykA1NXybSeHTGKbSVYm4PLwei56iaaWuijYzui3XAwAAiURSKZEWFOQBxuELRA7O7jY27KQ2LBwdHS9dutQYfw6HwzGtQkIgEIgWhWXVDwCd3XrGv1f8KEGbGeXO3ABMQi6H11j/vjnVehyXWPtsWs4avGWDY7iNuGF734Sbuwe4e7Cl9ePm5ubm5lbn2YMNVs+dCYFAIFoC9ap+BuYGwJY2hSZZ9/VSrWo59jYce5vaZfXwMO38KCDNjkAgngkPtTtNWHROkCRpjIHGLml5OBB8wJqbpQvDHQk+u0cEAoF40SmvqBAJawVdEAqFFRXGAObPgeofJpXhIiFYCr3yEHAcFwneED9kNiQCgUA8L9CNgCTJ0rKyzMxsmayWN9tT5pGRmVVaVkaS5EMcPi2Bd1q1pYGOVtxvapZdR4L/hthlPN8YtwuBQCCeEMdPPKVAT9dvNGrBpkgo9PPzsbOtNW/Fzs7Wz9cnO/t+uiYDe/TAwoiWT1zCzY5BHdhSBALxOHge/19N96IgEAgE4jmHuBpzjS1DvHAIhE8vVToC8RLyXChSkUgk83C3s7MFAGJI6GB2OeKF4+zf/7BFAH/H3s/TS4qUNE0DUBRNUSRF0hRN0RRNkhQzWkRRUqGhvZtoQJcmrH5AIF42+vfrwxY9dWjT0td6JoAqFKXJt+/4+fpkZmUTAGAeXxfRojh//vynn37Klj4mUpUSsdiqVSMy0V65fXfA41iegUAgnhym9Ub1LTxycLD3929zLz1Damf7HMzwQTwh1HparVCypZZQ6y0bEQjEMyQw0G7rVmVICMql3ATspdJbt5Ld3FzqVf0JCTvs7f+gqBIAwHH7kpJBQUEz2JUQzzM0Sa+Z4MuWWmLGuiy2CAAAwsPDY2JimMRkALBs2bJZs2bVrvJ4uHHjhlAo9Pf3ZxcgXhQSEoivvhJeu0ao1ZiTEzV9unbuXO2NG4RQSPv7k+zajSA8XBITwyUIo9WybJl61iztzJnikye5prCKd+6UikRPxKypz+VSH/XZ6U8Oy6q/vLzM0XHf+PGmEJXFv/66T6EYIZU+qVjw8xZ+zCWIrzesYRcgnhhM8mGdgaQBaIomKaCApiiapCjSQJMGmqQpHUm3dhaTVL3/vYiIiCalYGwemzdvHjJkCFL9LypXrnDHjhW//77m669VNjbU3bsEEx5382bhkCG65ql+AIiIUM2ZozWXPHiA7dqlHDRIZy58qTDdY2pN7kxI2JGVNS4z89WKihHW1obbt4GigCTh1i2wtjaoVCMzM1/NyhqXkLDDvNXqdV++8/6HRWh9wHMHTQMAhmM4BjiO4RzgYBiB4wSHILg4wcd5PELEJQCAMjT2v3f69Gl/f38mmW1aWpq3t3dSUhIAFBQUTJgwwcvLKzAwcMcO4/WTn58/depUb29vHx+fFStWAICbm9utW7eY0tjYWLlcDgALFy6Mjo6eN2+eTCY7evRofb0hnl+WLLGaMkW7cKHG3p4iCAgIMAQFGRYutIqO5s2bZyWTSY8e5QFAYKDdzZvEoEE2Hh7SwkL2xPTQUJvbtx8SJr2oCG/VykJkm5cHk+qvZfU7OOyfMMHoOMvKgthY0OsBAFJSoGtX8PQEAAqg4Jdf9gMg589zD2PL4wA0hgEGHBooDCiK5tCAY5xVUa+pqipWhZ0DEFJkY/8tb7zxxp9//vnhhx9u27Zt3rx5ixYtCggIAIDJkyd37NgxJSUlMzNzyJAhcrm8T7Rzh1gAACAASURBVJ8+EydO7NSpU1JSEk3TZWVl7L6qiYyMTEhImDdvninHr8XeajdCPDcUFuJJSZytW9lr9SMjVQkJxLx52hEjaormzbPesqWyTRuyebkwysuxsWPFGg3m4kJNm6adNavWM8FLRY3q/++/9b6++uRkaNsWACA/H4RCuHkTAEAqhfx8cHcHmobbt0Ek0l++/FlIyDJT27pUVFbuO3j09p27fAG/Y1DgiKGhXC4XABKTks/+cz4nN5+D4/5t5WPeGiES1QowRNP01p0/Jt5KHvrmoMGvv3bi9JkrMdeUKqXUzq5PSM/+fXuZV0Y8CsZEOhgGNG26AWAY0CRNYVBl0Lk7+L+/75WfpsdR9Tt8Vq1atXbtWmb72LFjHTt2/Oyzz/r16zd27FiBQPDOO+8AQFpaWnx8/OHDh3k8nlwuDw0NjY6OdnZ2TkxMjI6OFgqFACASicy7bQCLvSHV//xSXIwBgKtro8yLWbM0AQG1rsboaN6771oDgFaLDRxog+PQrZvh4MEKAFi1ymrtWuN1deJERWCg4cyZcrGYFgrpa9e4U6aInZyosLAn4vx5mr773AWLDA8esKUAAIBLJB4/bGZLAcBc9Xt6nmnXDlQqSEgADgdyc+Gtt2rqHToEIhHo9aBSga0tODicA6hX9dM0vXXH7sys+64uziRJnrtwGQNsVPhwAMjLL7yfk+fq4lxUVPzf9Tg+nz9+dPVuMAwAjp/6M/FWcsegwDcGvpp0+86J038KBAKZu3t+YeGDoiKznSAeFZNCN16mNP3R7/1o2qCjDDqDwdXO19/5lUqtauhmbzv6G/OG5tT19YtEohkzZixduvT3339nes7Pz6coyuSppygqNDS0sLDQzs6uAY1vMeQs1NNb7SqI5wl7exoACgpwG5t6LQwTrVuzr4qhQ3VDhyoAIDTU5ssvleYDA3V9/aYbTM+e+nHjtH/9xXtCqv+pkffREsep0wg7KZO8thYYTqmUeR8udv1iHbvIXPVrtQI3N5VaDUolYBg4OUFqKvj4AACkp0OrVsDjAXNrcXAAna6h1aFZ93Mys+77+ngvfG8uTdOfrf/qcsw1RvUP6Nv71X69CYIoKytfuuKz9HsZplYcDh5/89bpM3+5ubhMnjAWwzCttgoAfFp7zZ4+GQCqqp7vH6mlYWDceRiGAdA0jWGYgdINDJhM0hRJkRTQeeX3A91DlDrNdc1kZVWyNV/C7sISRUVFX3/99YwZM5YvX96rVy+BQNCqVSsej5eens48+THcvn27rKxMrVaba3+CIPTMUQHk5eWZ5OY2lMXeEM8vzs6Ujw95+DB/yZKanE4MT9R01usxsbhp83BaGjkf/E/SZ2BVXpE2pxAAgKIBZ8w4AADAAMMw676DsqfOku3eZtYOoG4MH4EA7OyAwwEuF8rL4dYtuHULKipAoYCcHOBygct9eBKUgoJCAEhLv/fO+x+++8FH+QWFOp2OiRN9OebfNRsi5/9vydIVn0FtbY4B9vPv+2maHv1WGI/HA4B2/m3cXFySbt9ZvurzC5euCAQo8v7jhCYpAOAAYAAYhmEAWoOOpKmsktSMkpT0ouQyTUmWIj3Yo3cbly6Dtvux29fD/PnzR48evW7dOrlcHhERAQByubx9+/bLli1TKpUAkJubm5eX5+/vL5fLV69erdVqdTpdeno6APj6+h4+fJgkyYKCgi1btpj6lEqlcXFxAKDX6y32ZqqJeB6JiFBv3izYtk2gUGAAUFyM5+XhACCV0nFxBIBx0PERKSzEz5zhqdUYRcHFi9z9+/nh4ewBhmbT97XBYyZOiYtPMBfm5WETJvBdXUVubqJly3gAIJeLjh0jOnUSuriIBg8WpKUZNXB98oYxFJXQwCErVZRKYyitAAzIShWpVFMaLaXRkko1qVRTVTrc3sLMzJodMAqdpoGiQCgEDw+wsQE+HyorobQUxGLg84EZWiHJh2h/Zk6r1M62Xds2phdgkHYvY/+how+Kil1dnNvK2apEpVYbDCQAnD77FyMRCgQfL5o/asRwwODg0ejfDx6p1QDxaJg8KhgADoBjmNagNZCGVhKZs8TTxcabyxE6it1u3L/8b9rNXaONPwqLVatWyarZtm3brl277t+//8knnwBAZGRkVFTU2bNnAWDv3r0KhSIoKKh169bjx49nlPXPP/987969tm3b+vn5/fLLLwCwbt26ixcv+vj4jB071tyPtGDBgpMnT8pksqioqPp6Qzy/hIbqfvyxMjqa17mznUwmHTjQ5sYNAgAWLNCcPMmVyaRRUQ83+06cKG94GihNw6ZNgg4d7Hx9pStXir7/Xtmli2n++qPy9x/HP/1kcevWXubCMWMETk50Wpo6JUU9d67x9rVxI3H6tDYjQx0QQE2cyDf5Nb/7jjh1SnPvnoqRkyQTe98Cpv6NGawwoPR66aDejiNe54hFtEHvED7IIXwQRuDAwQHDMEvTNGocPjiuw3GgadDrgSRBrwcMA4oCgwH41V+7TmcUAjTke3FxbgUAYmvrd2ZNY5KBaTQaoVAYn5AIAN27dXl73Oj8gsLV6740b8XhcD75aOHeX/fdvpNyOeZaSPduZeXlQoGgf99eXToHL16+KvFWMowxb4F4JFyE2rlfX6JIkiIpkiQpilI7VP149UsdpdMadD4O7bp7v/5f1qULd68Nd/mujVN7dnuAw4cPs0UA06ZNYzbs7e3v3LnDbDs5OW3fvr2mEgAAeHp67tu3z1zStWtX87Aipik9ISEhsbGxJrnF3hDPNa+9pn/tNbZtHxKij42tmfqVmFhqVsj+yOLw4QqWxNmZOnaMLXxcGAyGdv5tzSV37+IJCfjp0xrGo2llZVTZM2canJxoAPj0U72rK/fePdzXlwKAmTP1jDwiQufmZmWSN0A5pbchDTRpwMUirosjcDgOwweSKjXHSggAuiotdStN4O+jwiz0U6P6Cws7/PvvdT8/kEhArYaqKqNpT1FGj5tOB7a2oFJBejqUl7MX1/ywcw+zqtPaymrenBk+rb3SMzKXr/rc0dG+vLzC3l46b/YMRwcHALgel1BUVJxfUMg33VIAAIDgcBwd7CeMHbVmQ+Sho9Ht2spvJd0+eDSaGSumadrRwcJjC6LZzB5RV5vXRB98fZsHhguT8pJ/m3S6tbRRi34RiJeWEaMnDHnzjVnTp5gWtxcUYHZ2tJVV7XoAjH4HALGYFovpggLM17cheQMU6/WeOh2l15Eabdr+wz4jR+AEwRGLaYqO+Wqj9cnz1phQG5dcKrHwMFTj8AkOXnf9+qLDh93i4wHDQCIB5hRIEnQ6EInA2hoyM+Hff1tlZb3XrdsGU0OGvPyC7Ps52fdzcnLzAGDOzKk9Xumq1+vvZWTRNN0hoB0A+LeV9+nVE8ew4hLFyPBhnYICWZ0AQCsnx8EDX9VqtT//fsC5VStHB/u8/IIShaJd2zZvj0c2/9NDrYd/Us5tH3Uc6X0E4qH8smfHjfj4n375zSRxdKTLyjCVyqwSAADk5RkHrxUKrKICc3Exavz8fMvyBigzGDBNJWiVuF5lnVeoLisjSYokKa1a7XDrriPOtxJwxEKumrag+jGaps0fscvLy5KSDtraHgsOVsrlQJKQkwMYBnl5kJ4uLC8fEhAw2t7eoaYDxJPkcUXuPPv3P89dFiEE4nkhLuFm547By1Z8JvNwf2f2rLfeEkyfrh8yhOzWTdinD7l6tY7Dgexs3NeXkstFzs70vn1aR0f6/ff5cXH4pUsaDIP65A2za9iwUQND9QY94Jhg4jgQWeE4rtdqCB4fDAYsYgORmY0TxGm6/M2D+02t/jl3wc/Xmz2ObGNj27PnDIlk499/v3r4MJaba5znc/16Hxubb/v0eQfpfQQCgWDxZthIDocz+e3xFAVpaTgzVWn/fm16Ou7tLZLJRD/9ZHQEjRljCA0VeHiI7t3D9u6tMun3+uQNUG7QQUUZVJYbFKVFJaVaXdWNrzfFLVxcqVKWV2krwIABhgEoDexBFKgvfJu7u5e7+7Lk5DdOnvwVQC+RjOvbtye7EgKBQCAAAODsySjTdmKicYGClxd95Ag7VkRQEHXjhoYlbEDeACQGeEU5RlHaAmXSx8tFXYJlFxPscG7ip2tVFN0jt8g4RcfSXcSy6mdo164LAMrQgUAgEI+N+mbG1ydvAKGtnSqvlABcV6zzMlgRF24LcBHOgVfulxoABBwBbQAgsAImDmptCADo168fW4xoGZw/f54tQiAQCAAAePeX334MHzpGYuscSJIEEDgQeBWBAYHTRkOfxk9nqOcfiK7dDqBhqx+BQCAQj5GUFHawCob65A9lyuHoyFEjXLOAAhpwwCjAORRGAwDgGOSV0/NPWND70IDqz8zMTEtLy8/PBwAXFxdfX18vLy92JQQCgUDUwXzNbWN4lEifCw80J8yBZdWv1Wr/+++/UaNGmSQHDhxwcnJqIM4iAoFAIJ4Xaqn+zMzM9PR0JiKKjY3N7du327RpQ9P07du3+Xz+oUOHAMDV1dXHx4f1BFB48+Y/y5dnX75M6fWOAQFd587t8Pbb5hUQCAQC0XKopfpjY2NHjhzJbGdlZcXGxjIRdFNSUrp27erp6ckUHTx40Fz1F8TH7+7dW6dU2vn48CWSvGvXitC4MQKBeIl5FAfO06FmSdf169c5HE5ycjJFURRF5efnC4XCmzdv3rx5UyQS5efnkyRpMBgSExM5HI75AuA/PvhAp1T2WLRoflra7Bs35qend5s3DwCUBQUHRo9eZ2Ozzsbm0Lhx6urkvasJ4sTcuXG7dn3h5HRy3jwAUBUWHhg1ap1EEunmdmr+fIOmaZNbEQgEAtEkaqz+rKysgIAAlUqVkJDA4XByc3PfMkvTdejQIZFIpNfrVSqVra1teno6MyVUU1KSdeECVyjst2IFU9PG9HAwZkzWhQtSX1+Mw7n1+++l9+5Nv3oVw3EAuPXbbze2b3cKDHTp2BFo+rdhw3KvXXNq357U669t3Ihh2Bvffst0gnhy/B17P08vKVLSNA1AUTRFkRRJUzRFUzRJUjRNkyRJUVKhob2baEAXD3Z7BALxfPL555/XqH4cx93c3NRqtVKpxDDMyckpNTXVx8cHANLT05nUSA8ePAAABwcHTnVS5NKMDJqibLy8eNbWpq4AIC82NuvCBQd//7kJCRiOb+/WLffatexLlzz79AEAbXn5sJ07O06bBgC5167lXrvm2afPlPPnaYra0qHDjR07kOp/CqQqJWKxVSspW16XK7fvDkBr+xCI+rGqG6KzpTIkdPCQ0MHsGT4CgYDL5VZWVnK53PLy8lu3bgGAXq9XKBRarZZJiWc+b4mmKADAq+8EJkru3gUAWa9eOJcLAJ59+uTfuPEgMZFR/RwuN3jKFKZmUXIyAGRduLDSzDumLCiwdnY2fUQ8CdR6Wq1QsqWWUOubNlOtPgIDA7du3RoSEsIuQCCeczBsJVvUsqlR/YxCp2maoiihUOjh4aFWqymKKi4u1mg0YrGYIAgMw0iSZKLnM60k7u4AUJaZSVZVcczi75NMRrXak1s5PJ5pg/H8ABjr2MhkDtWJtuF5GCR5AaBJes2ERgVknrEuiy0CAIDw8PCYmBgmQLmXl9fIkSPnzp2LUuYiWgLh4ZKYGC5BGFXQsmXqWbO0M2eKT57kmizVO3dKRaLHY9Y8d9Sofp1Oh+M4TdN6vZ4kSb1ej2EYRVEGg8GUU0Wn0zHCqipjTkuxq6tju3ZFyclXv/661+LFAEBTVFV5eavAQADIvnSJ0usxHM+6cAEAHNrWymLD4NiuHQBYOTmNP34cJwgA0JaVCWxt2fUQjxuapgBAZyBpAJqiSQoooCmKJimKNNCkgSZpSkfSrZ3FJGUh3jdDRETEnDlztFptXFxcRETEhQsX9u3bZ/IH1oXJ2oZAPAUiIlRz5tSKnvbgAbZrl3LQoIaSDDYPmv6ULWrZ1Kh+R0fHf//918/PTyKRqNXqqqoqxrSnKIqxwXU6na2trUqlYlz/poavrV//+/Dhfy1ZkrBnj8jRsfjOnR4LF/ZavNizT5+sCxc2t2uHE0TxnTvu3bvLevc2tTLh9sorHiEh9y9f/tbbW+rrW5mXZ9e69YRTp9j1EI8dmgYADMcwmqZxjMZojMJwHMMwHMPIJR/1mTV3V0lRyb4f/zRUdWe3rY1AIOjRo8fvv//evXv348ePDx8+vKCgYNGiRZcvXxaLxQsWLJgxYwZTMzExceHChfn5+cHBwV999RUzmOTm5vbHH3+0b98eAGJjY8ePH5+SkgIAWVlZCxYsiI+Pd3d3X7RoUURERGJiotluEYimUVSEt2plIVvho3P8xHOmsmpMsL59+7q5uf3333/x8fEYhkkkEuZBniRJnU4nEomsra0zMzOZiUBDhgwxNZQPGTIuKsq9R4+KnJyCGzfErq7OwcEAMPbo0aBJk9TFxRX377cdMWL0oUOmJizGRUUFT51q0GhyrlyhKUo+dCi7BuIJwNjyOACGYRiOcXAMwwHD4X/v9+RyOHyey7bv5+zYNu327X8AcGaFR8PY29v36tWLCTk3efJkDw+PlJSUQ4cObdiw4cKFC0ydo0ePRkVFpaSkdOjQYfr06abU8BaZOnVqQEBASkrKvn37Nm7cyC5GIJpIeTk2dqzY01Pavbvttm0CdvHLRI3Vz+Fw5HK5h4dHcnLymTNnvL295XK5SCRSq9UYhuXl5eXn57dr1y4oKMi69mQeAPALDfULDWUJBXZ2YXv2sIQAsLxOBFGhVDp81y6WEPGkoSkaAADDgKZxABrDgIPRNG3Qp2z9foPU7i8cBz6PCg4u3vHzx5+XdYmI+JLdRR2cnZ3z8vLS0tLi4+MPHz7M4/HkcnloaGh0dHSfPn0AYNq0aY6OjgCwePHiLVu2ZGRkMIZ/XdLT05OSko4fP87j8dzc3ObOnbtq1Sp2JQSiflatslq71hh75sSJisBAw5kz5WIxLRTS165xp0wROzlRYWGPx/kzJHQwW9SyYc/wEQqFnTt39vb2jo+PP3LkSOfOncvLy3NycpycnMLCwpg/LeLFgKr24BsH1Wn63dmvfBH5t5f3nJQ7Gzw9MYWCVKvpCxeqlCqsMXofAO7fv+/s7Jyfn09RlH/1uD1FUaHVloGDgzHLm0gkkkgkhYWFLNVveg4oLCy0tbU1hY1ydXWtqYRANIK6vn5XV+PV1bOnftw47V9/8R6X6o/RXmWLWjZs1c9gZ2fXv39/X1/fuLg4kiR79+7dunVrdiXEc46B8eFgGAZA0zSGYR2Cxsyb6+HubnB3x/LzKZoGmYxTUkIJeexMQxbJzc29ePHili1bmFUg6enpdWf7FBYWMhsqlaqiooIZNCIIwuRQYkJIAYCjo2N5eblWqxUIBACgUCgYOQLxWNDrMbH4sU3v6S7wYotaNg1Nt/Dw8Bg2bNiIESOQ3n8hoUkKADgAGOPuB3jn3UUGgw2G8QoLSZ0OpFK8pISiKNBTwvDwhq6BioqKs2fPjho1qlevXoMHD5bL5e3bt1+2bJlSqQSA3Nxck0Lfvn17QUGBTqdbt25dQEAAc2n5+voePnyYJMmCgoItW7YwNX19feVy+fr163U6XVFR0bZt26r3hkA0h8JC/MwZnlqNURRcvMjdv58fHm6cqfgS0pDqR7zYmFwrGAAOgGMYB8OCgt7WanVKJUgkUFJCFRRgFRU9fEI+OXAgrXZrI6tWrfLw8AgICPj8888nT578008/Me6jvXv3KhSKoKCg1q1bjx8/nlH9BEEsWbJk+PDhcrk8MTFx586dzFzPdevWXbx40cfHZ+zYsXPmzGF6xjBs9+7d169fl8vlQ4cO7d+/v9luEYgmQ9OwaZOgQwc7X1/pypWi779XdunCHnd8ecCamlIA8TRZuXLlp58+hvnCZ//+p2NQB5bwhyO37ldyKJKkSIokSYqiDDodTdO3zq59tUeigSQqK3Q3kr1wqojg2p+Ovsxq/pQ5ffr0559/jjJWIlogcQk3XxtgYdFSMzh7lj9woDQmpviVV2rm1KWlZ+/Yfejf/xIVijIbG7GPt8eEsaGvDehh1q7JWPb1A8rS9RIwe0R7tojh/ePLls2/desPklSfOnLWtKDv6XPx4kW5XO7k5FRUVLRx48beltaFIBAvEt9+a9Wtm95c7/997t+FH22wthaNHDHQw92lRFF+4VKsQlFu1qg5WFb9KEvXywxFUZ999h0AbN++ZfLkQb//fo4ZBGbXe/LExMTMmzevtLRULBa//vrrH3/8MbsGAvECkZZGnDzJ//nnMpOksLD4o6VfyTxc9uxca2crYYSzphuzqjwKtVR/s7N0WcQ9MvLn8PB+jajJYsCePV8NGtQRhW97RphiLcycOXfmzLnw7EIqffjhhx9++CFbikC0PEaMXvDmG71DenT8/IsdSUmpfAF/9FuDPpg/iSktfFAS+e2ei5evq9Vaua/ne+9M6N2rc+0OAAA2bhQ5O5MjR9YkLPntwCm1Wrvq03kmvc/ibkrGNxv3Xr+RbDAY2rf3e++dCV071zzNN3BUtVR/87J0PXb+njyZLbLErOhoZ2vrVWj0D4FAtAD+vXbzaNRfY0YNnjVtZPb9fDs7G0ZeXl45YfLHBMH58IOpNjbiE6cuzJ2/auvGT3uFdDJvXlmJ7d4t+vhjpfmM6Jh/E1xdnII7WB5ISEnNGj/5Y7mfZ8Qnc3g83vGT56fNWr7lu+XmPdd3VDWq35Slq23btgBgytIFAFKpND8/393dnXkCYLJ0MalanhVqvX5/cnLc7NnsAgQCgXgWXIu9dfTAd96t3VnyH/ceK3xQcvLoFg8PZwDo37dbWnr2d5t/Zqn+XbtEej3MmqU2FxY+ULT2cjOXmPPd5r1CIX/39jUCPg8AXn+t58QpH69Zv+1U1FZTnfqOqkb1Ny9LFwC4R0Z+O3jwsr//zq2s7Ozi8sOQIXJ7e1NDABCsWRMzfXqwszMAxOTkDPn11+KPPgKAe6WlM6KiYvPzZRLJsj59/vfnnzkLFzIdMp4i98jI70NDV54/f7ekxNfObuuQId3djSdwIDm5k7Nza1vbc5mZQ377jRFq9PqlvXuvRs8BCATiqSP386yrYQHgytW4NnIvRu8DAIZhnTq223/wdFWVjs83xrGnKNi0STR+vMbRsXZUqwaH2a7+e3PQaz0Zvc8w8LWe67/ceT+nwMPduLv6jqpG9TcvSxdD5NWr56ZMseHzPzpzZtSBA3GzZ+P1H66JUQcO9JbJTk2c+EClCvv9d3YxAAB8funS0bFjXcXipX/99c6JEzeqzfydN27M6twZAPp5eSmXLAGAWw8e9N+zZ1JQkHlzBAKBeDo4OtixRQAAoCgtz8170C54GEuuVKpNqv/ECUFaGnHwYM0AL4ODg11e3gOWkEGn02s0Wjup0YHDYC+1AYDS0gqT6q/vqNgzfJqapYvhna5dW1lZAcBnAwbYrl+fplCwDP+6pJSUJBQWXpg6lc/heEgkH3TvvvjsWXYlgLldunhIJAAwITBw47VrjDBVoUh88OCtdu1M1bQGw/hDh758/XU/aSPyDSIQCMTTwsZGbGMj/mjRNJZcIqmJg/ntt6J+/XRBQez4uB2D2v782/F7GTl1LXcej2tlJWTN8iwuKQMAOzvLY8Lm1KzmrZuly8bGhs/nV1ZWMrPr+Hw+Y+ybZ+liYPQ+AEj4fAmfn6+sN+0fVd0wX6mUCgRW1SMa7hLLx2qS8zgcHWkMN7YrLm5s+/ZCoua+9dGZM+2dnCYjkx+BQLQwevXsmJNbKPfz6tYl0PzF5Ro1WFIS8ddf/AULVLXbAQCMDB/E4eArPtusrbIQZq5Xz04XL13XamvCUZw5e8XD3dlk8jdAjfZsXpYuhtzKSmajRKMp12pdxWLzUi6O66tjBtyvqGA2WllZlWq1GoOB0eAlmpr5TObUdRyRNL0nPv7YuHEmyam0tOMpKXHVAQAQCASi5TB10ohTf16eNG3J2xOGujg7lpVV3LyVaiOxfneOUYl9+62Vlxc5bJiFIIlyP8+F8yd/8fXuYeHvDh86wNXFsbxCmXz7XvjwV7u/EjT/3YljJ/5vysxPJo4bwufzj588l5B499uvlrB7sUSN6m92li4A2HTt2kBvbycrq8Vnz3Z0dvat7XVpY2//W2JiJxeXQqXy66vG0KZtHBz8HRxWnDu3un//Uq32u3//NW/SAKdSU+1Foq7VIXwfqFQzo6IOjB5t8+wWnSIQCER92NiIf9/7xaYtv37/w77i4lIbG+u28tZTJoUxpQoF/vPPwtWrK+tLXTp18gg/X8+ffon6+bfjKpVGIrFqI28tldoCQGsvt19/2hD57Z6Va7aQBrKdv88Pm1eE9OjI7sISNaq/b9++6enp//33n729fZs2bSQSSWVlpcFgYPKw29ra8ni8zMxMtVodHBxsCsXOMCEw8NWffsqtrOzi4rJ/1CiWob7xzTfnHj9ut369j53dxyEh806eBAAM4ODo0bOiox2++MLV2vrtoKAtjYvKuzMublrHmnPbdv16vlI5cO9e5uOUoKBNb75pKkUgEIinwJH937JFZtjZSpYvmbN8iQXPhFRKqdUFbGlteoV0Ys0ENeHj7bH522VsaTUNHBU7fJtGo0lOTr59+zaTpYskyZycnIazdLlHRv7y1lt9qxd8NY+ou3eX//NPAnLa1OaJhm9DIBCPhccYvu2pwX7GYLJ0hYaGVlVVHTlyJDc3l5nnQxBEWFhYSEhI3eyMYGnOT2P4OyMjX6mkAQqUyg2XLw9AWQEQCATiqcCe3MnwdLJ0XcrOnnL0qEKrlfB4oXL5yme6PBiBQCBeHiyrfgYPDw8PDw+2tA7MEtxmENG3b0TfvmwpAvG8ERYWtnr16sDAQHZBg1y+fHnOnDmJiYnsgmoCAwO3bt0aEhLCLnj5CAy027pVGRLCnvbeEvCMawAAIABJREFUcojRZrJFLZuGVD8C0TDh4eExMTEEQfD5/DZt2ixdurRnz57sSk3hxo0bQqGQNYmgZaJUKgcMGLBt27bg4OCjR4+yi18Izpw5s379+lOnTtXNsfwoJCQQX30lvHaNUKsxJydq+nTt3LnaGzcIoZD29zeu3WkS4eGSmBguQRjdzsuWqWfN0gJAZiZn0iRxp06Gb74xrjTKzOQsWGAVF0fY29OLF6vHjHlsCRq7Cx4pccrTh+3rRyCaRERERHZ2dlJSUmho6Lhx47RaC3OTG8/mzZvv3LnDlrZINmzY0KtXr+DgYHbBY8UUQPuZMHDgQHt7+127drELHoErV7hDh0qCgw2XL5ffu6fYs0fZs6cBADZvFt6503xLNCJClZ2tYF6M3j9zhjd0qEQqrRUSZ8YM6+BgQ2pq6bZtlUuXWqWm1gpI81LxLC8sxAsDj8ebNGmSSqXKysoCADc3NyYECADExsbK5XJmOzAw8PTp0wMGDJDJZP369YuNjTX1AAALFy6Mjo6eN2+eTCZj7OjCwsIZM2a0bdvW19d3wYIFldUrB03k5+dPnTrV29vbx8dnxYoV0OCub968OWjQIA8Pj/z8/BUrVgQEBHh6eoaEhFy9ehXq35d5w8LCQkao1Wr37t07ffp0U53Lly8zGw2cIACkp6cPHz7cy8urd+/eaWk16Y4LCgomTJjg5eUVGBi4Y8cOkzwxMbFHjx5eXl5hYWHp6emMsL5zzMrKCgsL8/Ly6tWr15EjR0wOqPrkFnfKOt8pU6bs3LmTKXosLFliNWWKduFCjb09RRAQEGAICjIsXGgVHc2bN89KJpMePcoDgMBAu5s3iUGDbDw8pIWFbDUVGmpz+/ZDtHZpKbZvXwVzX2G4d4+TnEx89JGGz6e7djUMHar75ZeXdzEQ+ztFIJpBZWXlpk2bfHx8Hjod4Jtvvtm7d29GRkb//v1ZaVgiIyMDAwM3bdqUnZ0dFhYGANOmTXNwcIiLi4uNjS0pKVlYZ1Rp4sSJDg4OSUlJiYmJs2bNYpWymDdvXmRkZEZGxp07d6Kioi5fvpyenr5p06Y2bdpAg/syNXRycmIk169f5/P5AQEBpjomGjhBmqanT58eEBCQkpKyf//+n3/+2VQ0efJkDw+PlJSUQ4cObdiw4cKFC4z86NGjUVFRKSkpHTp0mD59OlW9Kt4iU6dOZTrft2/fxo0bHyqvb6fm59unT5+srCzmjv7oFBbiSUmccePYbpbISFVgoGHTJlV2tiIszBixYN4868hIZUaGwsmpobOuj9Gjq9q1q+U+Sk3luLuTVlZGv5C/vwFZ/c+MPQOgII4tRDxHrFq1SiaT+fj4xMfHR0dH83g18WMtMnXqVDc3Nw6HM3LkyNTUVHaxGZmZmbGxsREREUKh0NbWdvny5dHR0SpVTZyTlJSUxMTElStXCoVCkUjkWr3Auz5mzZoVEBBAEISHh0dlZeWRI0cMBkPHjh2lUmnD+zI1NIXPTU1NNdnaLBo4wfT09OTk5KVLl/J4PBcXl5kzZzLytLS0+Pj45cuX83g8uVweGhoaHR3NFE2bNs3R0ZHH4y1evDgpKSkjI6Omu9qkp6cnJSV98sknPB7Pzc1t7ty5Dcsb2Kn5+VpZWTG3B6boESkuxgDA1bVRqnzWLE1AAEkQYArmEh3Nk8mkMpn0v/+IgQNtZDLpyJHGGF+rVlkxRTKZNDHRsuNIowGxuGYaulhMKxTPWAE+Q2qd+YEDB7CHceDAAfMmj8jkv8G5UauOES0Uxte/du3a3Nxce0vhWlmGqklB83g8JgdcfeTm5tra2prSQXt4eBgMBoXZku/CwkI7O7sG8kWzdm16IvH19T1x4sT169e7dOmyZs0avV7f8L7qPspUVFTY2NQKlmuigRNkDti0MsbNzZiCIz8/n6Iof39/mUwmk8kOHDhQUR3qysHBgdkQiUQSicTkcTJhOsfCwkLzUzAdRn3yBnbKOl+JRGIqekTs7WkAKCholMJt3Zp9hxg6VMd487t2NZw5U56drTh40Hhg5r7+wMAaJ485UimtVNaEGqisxESi5ixIejGo9RuMHj361i2g6Xpft27B6NGjzZuwuHcGzjzrXKppp+HiGtCx3cKIJ8iUKVN0Ot3u3buZjwRBmLQek+rZRMPjlphZtD4nJ6fS0lJldRTY7OxsDofjbJax2cHBoaysTK2uldWogV2bI5fLN23adP78+StXrmzcuPGh+2JhbW1dnzZs4ASdnJzKyspMI+HFxcXMBpMMIz09PTs7Ozs7Oycn54cffmCKTLpepVJVVFQwsbMsnqOjo2N5ebmpc9N9qz55AztlUVFRIa4dkLHZODtTPj7k4cMWPOx14jQ+fnx8yJwcXKUy7unOHUIub86EohcD9mUaEAArMQCw/G7Jt2nk3lnY1QtivgH/cACASHe4fQg2+8M6CezpDyXVz4uR7pB/A3Z0h7VWoMyHSHfIPFfTCUPKcdjWBdbbQqQbxHxjFK4RQEG8cTsnBjY4AADcjYIvnUFdDABQchfW20JhArh3B4MWtnaEi2vRDeApQRDEihUr1q1bx2gWX1/fw4cPkyRZUFCwZcsWdu36kUqlcXFxAKDX6/38/Dp37rxy5Uq1Wl1WVrZq1arRo0ebzzL09/eXy+WrV6/WarU6nY4ZBW3MrrOyspKSkgwGg7W1taOjo1KpfOi+WPj6+jbDB+Lj4yOXy9etW6fT6YqKirZv387I5XJ5+/btly1bxtx7cnNzTQp9+/btBQUFOp1u3bp1AQEBjD1u8Rx9fX3lcvn69euZzrdt29awvIGdmqNSqXJycvz8/NgFzSUiQr15s2DbNoFCgQFAcTGel4cDgFRKx8URANDgo+Aj4eZGdetm+PJLYVUVdv06cewYb+RI9qjDywNb9QPAp3RD73W5dxZ+7AtxOyF0M4w/Ae7V01uvRsKUc/C/B+D0f/buPKyJc3sc+AkJYV8MqyIBBKMYAiLYiqIFFVERRS4iaiuI1NrK1X5prWKFKrYFbQv+rrihUiz21kJRCi5c16q1UtlExIXFKMoShLDIEiAkvz8GQhhCFNSK5nweHp7Jed+ZSVjOvHlnMocDyYtA3P3uLTUAPONgYwNo9jOo0jUHzzj4ohZ8U+Dsengq4w+yy5j5MGY+nPwExJ2QGgBTN4ORHajqgus2WJ0HSlQ4OAkPAP+Q2bNns9nsb775BgCioqKuXLliaWnp5+e3eiD3ZVq3bt2pU6eYTGZaWhoAHD58uKamhs1mOzs7m5iYREVFkfofOXLk/v37Y8eOHT169M8//wzPt+u6urpVq1aNGjWKw+HQaLR169bBc+xL2sSJE1taWgoLC8kNcikpKcXHx+fk5LBYLC8vrzVr1kiaEhMT+Xy+nZ2dhYXF0qVLiSxMo9FCQ0MXLFjAYrEKCgoOHTpEvKWQ+RopFMqPP/5IbNzT09O1u0xpf3HoZ6ckly9fNjEx6TvlNWgeHu0JCU/T0+kODsOYTIabm05uLg0A1q1rPXVKmclkpKXJeE9AcvJkw+A+AfD//l9TXh7N0nLYypVaW7c2OzjInhpSBL1u30ahUMRi2EqBr/r/TqH0umNP6Rn4eQ647YBJnwJF6mx59Ehw2w6cZQAAbY2wXRfW3AU9FkSPBNetYN91URxEjwTvI2Du0rMiSbQJLEoG08nwjSqszATj8QAAjzPhv/PgixoAgI5m2GcPwyygswP8zwP0ftv45Db84gmGNuD3e6/4mwJv3zZkbd68uaWlJTo6mtwwNGRkZERGRl66dOk54/3x9fV1dXWVnBxGMuXl35w5veeY+kZ40VG/5SxYnQ9P7sBuNvwZ1TX3QtDovqW/ijaoaENTZdfDYZbdPbpd3QGRmhCpCcc/AAD4+z+wlwPbdSFSE5oqe94uSEhHlDXgnWAoPQOTP5fK+2IoOQ3/nQe/B4JrBPj+1tMfoZdiw4YN165dk3Mbhn/elStXeDyeWCyurq7etWvX1KlT5cef6cKFC/X19UFBQeQG9OaTkfplzvJLvvdlaAPzD0LgFRB1wIGJcKH73tFPy7sWWmtB0ABa/V96N+ULCG2C0CZYmAjc83AxDDwPwBe1ENoEat3XjCgpg6h7ErDxUfeaAM08uPItvBMMZz4DYSsAQGUOxFpD7kFw3ghBmcBZBkr9ztkiNEhaWlrXrl0b6H17XqnMzMxZs2aZmZm5urqyWKwNGzbIjz/T9OnTz5w5I+ecB3pzkS+ALSyUMdKXfJczt6luANPCYMoGeJzZFbkeC6PcQMMQzm0EY3tgWPXq3x9BPdA1QdccxCLI3g+Cuq643hgo+AWGT4AmHlyL6en/eyDYfQBu38Gv3nDmc5i7G1R04P0M0DXv6YOQIli/fj3pQ2Ty40iR9Rr1JyUl2dgAhdLvl40NJCUlSa9CQqWD2bSuZc4y+GkG7GAAvxQWJZFn4fvD8gSz92CXFUSbgqAeRnt0xefuAu4F2D4M/usBkz7tCmbtgfqHMP1rAADP/XD7Nyg+BQwrzPsIISRPr1H/okWLBld0Rabh9rDmDjkY8pgcofQ+JFDp8K//9ooQRjrB6u6LOwHAxg8AYOInMPGTroi6AXxO/rwLQgghGcgTPi+R/IOIWATNPBDwQd2A3IQQQuiVeoWpX77f/KDkNHCWgcE4chNCCKFX6lWl/r4TOySL5J0yQAgh9ArJuLgTIYTQ2w1TP0IIKRxM/QghpHAw9SOEkMJ5ValfZvmtB39A9EhyECGE0D+sV+p/iVW6sPwWQggNWb1Sv6+vLzyrTNfQr9JFwFpdCCHUnz4TPmz2FgoFAGR/779MV98qXUT5rdoiOOwKUdqwlwO193r6P62AX+ZDlDZEj4TrsT1xCazV9fbhcDhXr14lR98Kkpf2Fr/G147DGXb1Kt5GtIeD07Rvd/wgHTmedmLc+InFJaXSQZn6pH6ALWKxnO999VelCwBADMm+YGQL65/A+xmQe6in5Vdv0DWD9TWw/Cz8sQW453uaCFira+jz9vYeMWIEUdd72rRp//nPf+RXWn+NcnNz79zpc0spNIRt2KBhbz+su+x8L7m5tDt3pCpDyeLtrT1ihB6TySC+4uJUAeDDD7VMTLoiTCajpeX5bio5VHV2doo6B1OtDGSnfpnj/e7vJKVn4Ig7jJkP3kfAyI7cWlsE1QUw/WugqoCWCbz77+74PajMhhmRQKWDvjVYL4TbKb1WBABDGxg+AShUGDkJNAyh/gG5g7TZMVB1A36eCzQ1mPxZT5yuBVM2wKJkyDsEx97viaOXJTw8vKysrKioaPv27enp6UuWLOmU+7cop2r5K7V79+67d++So2ioam2lHD+uoq0tvnBBxjB/9261u3effSeC8PDmsjI+8bVqlQAAqqsp8fFNkqC6uuzh7CDU18PBg7B2Lfj6wpo1kJ5O7tDQAHv3QmAgLF4Ma9fC4cNQXd3Tev06fPYZLF4M//43XL7cE391ZPwf9h3pyxn1y6nSBQBPK0GNAXStrofapl0LjeUgFsEPxl3FuQp+hrYGrNX1BlNVVXVycjp69Gh+fv6JEycAoKqqatmyZebm5hwO5+DBg5KeBQUFTk5O5ubmXl5eRCF1ADAxMbl16xaxnJ2dzWKxiOWHDx96eXmZm5s7OzsfP368b12UvnvJyMiwtrYmqsOXlJSMGjWqsLAwJCQkPT09ODiYyWSmpqbKXBEAOBzOzZs33d3dTU1NeTweh8PJyMiYPn06k8l0cXHJzs4mup05c2bGjBmjRo2ysbHZt29f11Ppzd3dXVJ1HQBmzpwpqYeOnsexY/QJE4QBAYLDh1VJTSEhGunp9OBgDSaTkZpKl8Q9PHSe+VbgyRMlI6M+qeRlGD4cPvwQdu2C5GTYswfmz4fN3UWrACAzE1gs+OQT+PFHSEqCXbsgIABOnOhq/fprePddiI6GpCSIjYX33oOXUZUVgv/v8/CIb86ev+jpvdhu4mQPL5+TpzMkrbJSf5+RvpxRP/RfpQsANI1BUNdVPAsAWp50LWgNByodNtR1Fefa1ALeP2Otrjeenp6es7MzUffV39/f1NS0qKgoJSVlx44dl7tHMqmpqWlpaUVFRba2titXrhTJfD/fbcWKFWw2u6io6Ndff921axe5WdZeZs+ePWfOnPXr13d2dgYHB3/22WdsNjs6OprD4cTGxpaVlXl5eclckdhgcHBwdHQ0l8s1NDQEgJ07dyYmJnK5XFdXV0m1E1NT05iYmOLi4oSEhC1btlRVVXU/nR4BAQFEmXgAKCkpuX37to+PT+8uSJ7Dh1WXLxf4+LT9+adyVVWvNBUd3czhCGNjm8vK+F5e7dJNz9TQQPHz0zIzY0yapEtMAb0s77wDixbBoUNw4gQQl8JERYFAAADQ0gILF0J1NVhZwf79cPIkfP89uLjA4sUAAH/8AWFhoKQEYWFw6hRERACVChER8FJOGF28dDl27/6gFct/2P6tGZO5PjTs7+tZRFOf1F9Y2Hek3/O9/zJdRJWu4HtgOasnqMcCfWu4+BV0tkMzD/7u/ufVtwaj8ZDxf13z742PoLH37d6ka3Vl7SHX6hJ3wtMKGbW65uwCfWs48zkAdNXq8k0BpnNPN/SqGRsb19bWlpSU3LhxIywsjE6ns1gsDw+P9O43wIGBgQYGBnQ6fePGjYWFhVwut/cGepSWlhYWFn755Zd0Ot3ExKRvZfD+9vL1118XFBT4+fmpqqp+8kl3PQcp/a0IAKtWrWKz2TQajUKhAMCKFStMTEyoVKqPj09xcTHRx9ra2tbWlkqlOjo66uvrl5WVSbYssXDhwsePH+fn5wNAUlLS7NmzGQwGuRPqx61btMpKJXf3di0t8bx57UeOqJB7SElPpxMT91lZNDc3HSaT4eOjTTRFRGhIpvULCmgAcPZsQ1ZWfWkpPzq6+fvv1aXfNLygS5cgKQkCA8HDA+LjgUKBzk4oKQEA+P13qKoCNTX44w9YtQrmzoXPPoOLF0FDAwBg/34AgPffh4gImDMHwsJgwQIAgJ9+6tn4oNXW8nd+v32Bp8fM6S6xO783GTFi34F4oqnXfFlSUpKvjY10pK/nr9IFABQlWJQMJz6C7/RB2xRmfAsn13Q1+aVCxqcQwwSxCHTNYd5+0Jb6tBfLE26nwC4rUNaEd9f2qtV14mPYPgyGWcKUDXAqGKC7VtfiYwAAnvthjw2M9oDRcyUbQ/+cR48eGRsbV1ZWikQia2trIigSiTw8un6F+vr6xIK6urq2tjaPx7O0tCQiBMn7AB6Pp6urq66uTjwcMYJc3Lm/vairqwcFBW3atOno0aNEBifpb0UAsLCw6OkntVM6nS45gx0XF5eYmFheXi4UCltbW2W+cVFVVV28eHFiYqKtrW1KSsr27dvJPVD/EhJUamuVrK0ZACAQAIMhDglp7e8kkadnu6cnHwA8PHS+/77J2rrnVFN4ePPq1YKergAjRnT9siZP7liyRHD+PH2g7xv609wMJ09CTg5UV0NrKygpQWdn16j/5k0AAEdHMDHpvQ4AANy4AQCQkwNeXl0RYu6zqEjSZfD09BgW5mbEspKS0hSnd0//7yzx8FVV6ZLctFl/LARc6omPWdC1oGkMPkd74iRYq+tNVF5efuXKlb179xoZGdHp9NLS0r4VvXm8rl9Pc3NzY2OjkZERANBoNElirajoupbLwMCgoaFBIBCoqqoCADF9L62/vTx58iQmJiYoKCgsLMzZ2ZlYXfoY0N+KffU9KX358uXIyMjk5GR7e3sqlTpmzBhSB4mAgIC5c+d6e3u3t7e7urqSm1E/mpspx46pnD7dMHx4V5qePVvnwgX6zJk9OVrWAX3AOjooWlovJ90BgJUVyJr5AwBoawOArjF+X+3tAACFheQpldbueXI5KBTo7D3y6BQKQeqvXVdHV7pVV1fnaVNTe3s7nU4n/2UjNAiNjY3nzp1btGiRs7PznDlzWCyWjY3N5s2bm5qaAKC8vFyS0A8cOFBVVdXe3h4VFcVms4lRtpWV1bFjxzo7O6uqqvbu3Uv0tLKyYrFY27dvb29vf/LkSd/TpP3tZe3atb6+vlFRUSwWKzw8nOjMYDDy8vIAoKOjo78Vn0dDQ4OGhgaTyRSJRPHx8fX19eQe3UaPHm1tbf3VV18tXryYSn3G6UckceyYio2N0M5OaGgoIr6WLBEkJPSa82EwxHl5NAAY0LXEPJ7S2bP0lhaKSARXrignJal4e7eROw1WVRVMnAj/+x/cvw8VFb0OTkwmAMCtWyAU9gQlzM0BAFavhosXe33t2UPqKIOmpuaTJ91nUAEAoIrHAwAtra5LaxobG6Vb6+rqtbS06HQ6yJjrR2ggIiIiTE1N2Wx2ZGSkv7//Tz/9RIw4EhMT+Xy+nZ2dhYXF0qVLidxKo9FCQ0MXLFjAYrEKCgoOHTpEDKujoqKuXLliaWnp5+e3evVqYssUCuXHH3/MyclhsVienp4yB8599xIfH//o0aMvv/wSAKKjo9PS0s6dOwcA69atO3XqFJPJTEtLk7kiacv9cXd3nzx5sqOjo62tbUNDg5ubG7mHlBUrVuTl5S1dupTcgPqXkKCyZEmvjOzn13b+PL2ioidZrVvXeuqUMpPJSEvrOSScPNkgPdvTl1gMsbGqtrbDrKwYW7eq79nT5OgoKxkP1rx5MGsWjBwJsbEgPXvi6QlUKjx+DMHBQLx3ffwY9uyBa9cAABYtAgA4fx6GDQMXF5g0CbS14eTJrncD8rGtra/9nVVb2/WGuLOzM+PMOSMjQyPDrrK3T2pq7nMfdLWKRH9lXh9nPZZ4SHlZMzzoVdi6detXL+M6r3MXLtrb2ZKjb5SMjIzIyEji8qE3RXx8/LFjx4irXdFbLC//ptsMVwAwNob6ehAIwMQEysshKwscHQEAvv4awsK6OtPpXWn9l1/Azw+EQvDwgDNnupo6OroOG6dPw+zZXav05++s7JUfrRkx3NjXx1tNVfVkxv9u5BdsCdvk+6+FABD8f59nZefq6up8tHKFrq5OyvHfL1668mPcnnffmQg46kdD2ZUrV3g8nlgsrq6u3rVr19SpU8k9hrDHjx/v2LFD5iVG6O3z+edgagq1tWBsDFFR8MEHvVo3b4Zjx8DFBbS1gUIBMzNYtqzrqECjwYkT8N13wOEAhQLa2jB+PHz5JTg49NqCTO9OdNz7nxh9fb09+w58F/Of9vaO7d9EEHmfYM40XfvJ6kMJP336+cYHD8u+i9xG5H14dbV5EXpxmZmZwcHBdXV1Wlpas2bN2rBhA7nHUDV9+vSysrKgoKC5c/FSM4Xw3Xfw3Xe9IpGRvR4uXAgLe3JyL8rK8Pnn8Pnn5PjzmOo8earzZHK0m6CtzWOOu8ccd3IDpn40lK1fv17yQao3y4ULF8ghhP5xcubzccIHIYQUDqZ+hBBSOL1S/0us0lV+Haq77seFEELonxYb831ayq/kaLdec/2+vr4JCQnmxGcMZHnw4IGvr6+c+aP7Z6H0DLh9B399D9beYPiMu0IMCSUZUJkD767tucMoQgi93cgTPubm5n+4uACAzO9yjgrSVbpOfAR3UuD3AIjUhMJfAfqpyRU9Eu6mwl4OfKsBibOg7j78thiitGGnGRR23ygoeiTcSYHd1hClDYddoVbWfS2wnhdCCA0IOfUDgMsff8j53lffKl3z9oOxPSxIgNAmYC8G6L8mV2YM+F+Ez3nQ0QxxDmC/EjbUg8sWOLEKoPutxbVoCPgDPq8GQw4kL5Jx436s54UQQgMiI/XLHO9LvpPIr9JFkFOTy2EVqOsDXROsZoMhByxnAUUJxvmAoAGau0vYTPwENIyApgrTv4bqAuCXdG+3G9bzQgihAZFxXX/fkb6cUT9RpStzJ+xmw/gAmBAE6l035e0hqclFEItgbPdHGzSHdy0oKYOGYc8yAHR235hJw6hrQUUbVLShqRLupsLlCACAsQthYSL8/R/IPQCNj0AkhI4WGW8L+tbzylgHS0/2rueVAdd3Q0sNuEYA27enP0IIvX1edNQP/VTpkr5xncyaXASKjP2TPS3vWmitBUEDaI3Ael4IIfRCyKn3wYMHfUf6ku8PHjyQ9CQhVelS04OKLAAAUceza3LJdz0WnlaASAjnNoKxPTCserViPS+EEBqoPlW6iLKS/XvOKl3OGyFtJeTsh3lxwFn6jJpc8nGWwU8z4Gk5DHeERUlSszQAgPW8EEJo4Ib6TZujR8K/fgaz98hxBYE3bUZo6MvLvzlzuox6EkMZecJnCBraxyY0ABwO5+rVq+ToCxAIBMuXL7ewsHjvvfe8vLwKCgrgFezlVZM84TfumUtwOMOuXn2hU2T9bcHLS5uoqC4QUJYv17KwYLz3Xq+ig2hwZFzhg9Bz8vb2zszMpNFoAGBubu7j4/Pxxx8/s+DtS3T06NHy8vK7d++2tbVpa2uTm1+S3NxcNTU1SRl3tGGDxpkz9JycOqU+Q8fcXJqamlh+tayLF5W//lq9uJiqpgZjxgh3724yNe1zWV631NSuEoNHj6qUlyvdvVvX1vZce/H21s7MVKbRukaOmze3rFol+PBDrVOnlCXlMu/erVNXV9ChZZ9f3RAT8hjMXchBNHSEh4eXlZUVFRVt3749PT19yZIlnZ3y/iH7Fjp/ESUlJRMnTlRRUXl1eR8Adu/efffuXXJUUbW2Uo4fV9HWFl+4IOMYv3u32t278gaUfL7S++9r/fvfrQ8f8rOy6lavFkjKr8tXUkKdOFGooiLW1hY/cy+E8PDmsjI+8bVqlQAAqqsp8fFNkqDC5n0Y+qkfvRFUVVWdnJyOHj2an59P1COsqqpatmyZubk5h8M5ePCgpGdBQYGTk5O5ubmXl1dpaSkRNDExuXWr625/2dnZLBaLWH748KGXl5e5ubmzs/Px48c5HA4RJ2zatCkhIeHw4cNMJvPMmTN9Z0v6ew79tWZkZFhbW/OKji82AAAgAElEQVT5fAAoKSkZNWpUYWFhSEhIenp6cHAwk8lMTU2VuSIAcDicmzdvuru7m5qa8ng8DoeTkZExffp0JpPp4uKSnZ1NdDtz5syMGTNGjRplY2Ozb9++rqfSm7u7+4EDByQPZ86c2bck/Wt07Bh9wgRhQIDg8GFVUlNIiEZ6Oj04WIPJZKSm0iVxDw+dO3e6RtrV1ZT2dsrMmR0UCmhri+fObad15/Dbt6kuLjpMJsPFRScrqytKTARt2qSRkKBy+LAqk8nw9dV+5l768+SJkpHRcx1p3nqY+tFLo6en5+zsTJTP9ff3NzU1LSoqSklJ2bFjx+XLl4k+qampaWlpRUVFtra2K1euFInk/R+uWLGCzWYXFRX9+uuvu3btIrV+++23y5YtCwwMLCsrmzVrFqkV+n8O/bXOnj17zpw569ev7+zsDA4O/uyzz9hsdnR0NIfDiY2NLSsr8/LykrkiscHg4ODo6Ggul2toaAgAO3fuTExM5HK5rq6ukoIzpqamMTExxcXFCQkJW7Zsqaqq6n46PQICAn7+ueuTLyUlJbdv3/bx8end5XU6fFh1+XKBj0/bn38qV1X1SiDR0c0cjjA2trmsjO/lJbusuJVVJ5stXL5c69Yt8rD9t99Ufv75KZfLd3Xt+OILDemmb79tXrasLTBQUFbGT0pqfOZe+tPQQPHz0zIzY0yapBsXRz50KRRM/ehlMjY2rq2tLSkpuXHjRlhYGJ1OZ7FYHh4e6enpRIfAwEADAwM6nb5x48bCwkIul9t7Az1KS0sLCwu//PJLOp1uYmLy8ccfk3vIJec5yGn9+uuvCwoK/Pz8VFVVZZbV7W9FAFi1ahWbzabRaBQKBQBWrFhhYmJCpVJ9fHyKi4uJPtbW1ra2tlQq1dHRUV9fv6ysTLJliYULFz5+/Dg/Px8AkpKSZs+ezWAwyJ1ek1u3aJWVSu7u7Vpa4nnz2o8cUSH3kJKeTmcyGUwmIyuL5uamw2QyfHy0aTRIS2u0sxN6e2vPmKFz7lzPrFFgoMDERESlgo9PW1HRM8bvEjL3QjRFRGgQTUwmgzhXfPZsQ1ZWfWkpPzq6+fvv1aXfNCga8oGX+KuVb4hfD4peo0ePHhkbG1dWVopEIsl5UZFI5OHR9YELff2uG32oq6tra2vzeDxLS0siQpC8D+DxeLq6uurq6sTDESNG9HR6DnKeg5xWdXX1oKCgTZs2HT16VOb/Qn8rAoCFhUVPP6knTKfTOzq6PlkeFxeXmJhYXl4uFApbW1tlvulRVVVdvHhxYmKira1tSkrK9u3byT1en4QEldpaJWtrBgAIBMBgiENCWvs7fePp2e7pyQcADw+d779vkpyV1dYWf/VVS2hoy3//q+rvr5WU9HTKlA4AGDGi66dBp4NQKOOHL1N/ewGA8PDm1asFPV2ldjF5cseSJYLz5+kDfd/w1iCnfpCb2S9duuTi4kKOIgQAAOXl5VeuXNm7d6+RkRGdTi8tLe17tQ+PxyMWmpubGxsbjYyMAIBGo0mSY0VF151XDQwMGhoaBAKBqqoqABBT8M9PznOQ0/rkyZOYmJigoKCwsDBnZ2di19LHgP5W7KvvCe3Lly9HRkYmJyfb29tTqdQxY8aQOkgEBATMnTvX29u7vb3d1XWoXDDe3Ew5dkzl9OkGyYnZ2bN1Llygz5zZkz1lHS5lo9MhIEBw+jT92jUakfr7/MD69fx7kaOjg6Kl1W+ue+s99w8bAAD+kHUHt5er/Pr16u4zfuhN0djYeO7cuUWLFjk7O8+ZM4fFYtnY2GzevLmpqQkAysvLJQn9wIEDVVVV7e3tUVFRbDabGClbWVkdO3ass7Ozqqpq7969RE8rKysWi7V9+/b29vYnT54M9FSnnOcgp3Xt2rW+vr5RUVEsFis8PJzozGAw8vLyAKCjo6O/FZ9HQ0ODhoYGk8kUiUTx8fH19fXkHt1Gjx5tbW391VdfLV68mCq5FPF1O3ZMxcZGaGcnNDQUEV9LlggSEnrN+TAY4rw8GgB0H8rJHjyg3rhBEwgoAJCfT8vPp77zjpDc6VmeuReZeDyls2fpLS0UkQiuXFFOSlLx9m4jd1IY/aR+CkXG13O4f/bs2e4zWoPz1/ffy0/9JRkZV775pv0p3lN/SIiIiDA1NWWz2ZGRkf7+/j/99BMxRk5MTOTz+XZ2dhYWFkuXLiXyI41GCw0NXbBgAYvFKigoOHToEDE0joqKunLliqWlpZ+f3+rVq4ktUyiUH3/8MScnh8VieXp6DmLwK/M5yGmNj49/9OjRl19+CQDR0dFpaWnnzp0DgHXr1p06dYrJZKalpclcUXqzcri7u0+ePNnR0dHW1rahocHNzY3cQ8qKFSvy8vKWLl1Kbnh9EhJUlizplSv9/NrOn6dXVPSkkXXrWk+dUmYyGWlpPYeEkycbJPMwNTWUTz/VGDt2mIUFY+1aza1bW6ZNG0j+BoDn2ItMYjHExqra2g6zsmJs3aq+Z0+To+OAjzpvDfKNHCgUckTa1q1bt2zZIrPD/XPn/tiyRVVHZ9rmzSOdnKJHjpwbG3sxLKzu/n3TKVPm7dt3PjS05PRp1WHD3L77ju3rCwBPKypOrF798I8/6Nrazhs3vhMcfOKjj3IPHqQqKyvRaPMPHWIvXlx04sQfW7bUlZQoa2hMXr9+0qefCurrr/3wQ8Evv9gHBr7773/Ttd7msop4IweJjIyMyMhI4vIhRRAfH3/s2DHiSlk0xL1FN3LoO+Tvf9R//9y5hPfeyzt0yGP37qUnT450ciLimTEx/hcvfs7jdTQ3xzk42K9cuaG+3mXLlhOrVhE3Z/jV21vXzGx9Tc3ys2f/2LKFe/78vP37je3tFyQkhDY1sRcvBgBdc3PPuLgvamt9U1LOrl//tKJCVVfXddu21Xl5SlTqwUmTrnz7Lb4DeFtduXKFx+OJxeLq6updu3ZNnTqV3OMt9fjx4x07dsi8xAihl6Kf1C8Wy/iSpfTMmSPu7mPmz/c+csTIrleZLodVq9T19emamlazZxtyOJazZlGUlMb5+AgaGpqrq2vv3avMzp4RGUml0/Wtra0XLryd0l27S4qhjc3wCRMoVOrISZM0DA3ru+8aTdfSmrJhw6Lk5LxDh469j1W13k6ZmZmzZs0yMzNzdXVlsVgbNmwg93gbTZ8+3cXFhTjTS25D6CWRcYUPQD9n0GVlf8tZs1bn52fu3LmbzR4fEDAhKEi9++o9zeFdJbiUlJU1DLtKcCkpKwNAZ0dHY3m5WCT6wbirdpdYJBq7sLt2l5S///Of3AMHGh89EgmFHS0tYuJiOLG4JCPj+u7dLTU1rhERxPQRevusX79e8mEoxXHhwgVyCKGXrZ/ULyvL98fQxmb+wYMtT55k79t3YOJEzrJl07/+GgAocq/V0ho+nEqnb6irIw4GEtIX0nHPn78YFvb+//5nMnEihUr9zsAAACpzclKWLTNks503bmQ6Y3UVhBAaMHnZeUDUDQymhYUF37tnKesj9X3pW1sbjR+f8X//R8zUNz561Pj4MQCo6elVZGUBgKijQ1BfT9fU1DU3F4tEWXv2COrqAEBFR+f9jAzflBTM+wghNDgyRv2XLl0a9PX7VDrdbNo0crQffqmpGZ9+GsNkikUiXXPzefv3a48c6bxxY9rKlTn798+Lixvn43M7JWWXlZWypua7a9eO9vAAAIaVFXlDCCH0WlEolKqqKuIjimKxWE9Pr66u7uzZszNnziQ6iMVic3Pz8vLyyspKAwMDyYoPHjwgPt0i7fjx48QNo8zNzR8/fnznzp3Ro0cTTQkJCStWrKirq9PVfaG6BTJS/0v5vG7I48eSZeeNGyXLNFXVr7pnkzSNjX2OHpU0EcxdXNZ239ARAP713/9KNSKE0FCkqal5/fp1T09PACguLn769KlW7+vO//7778ePH+vp6aWkpEg+vAIAI0eOvHnzZm1t7caNG7lc7s8//6yvry9J9ADQ2dkZGRkZHx8vibwU5Akf8XMgrYIQQgqOzWZfv36dWL5+/bqdnR3pHlBJSUkcDmfOnDnJycnScRqNxuFwXFxcjI2N1dTUZs6cOX78eA2NnhuXTpkyJTEx8eHDh1IrvQTk1I8QQmigbGxsJKn/77//njRpkkDQc+c4sVickpLi5uY2a9asS5cuVVdXS5qeyd3dffTo0VFRUeSGF4OpHyGEXtSECROysrKI5evXrzs5ObW399zV7u+//y4rK/P09JwzZw4ApMj6DFN/WltbQ0NDf/zxx/LycnLbC5Ax14+GjpdyFweS2NhYcgghNHDBwcGS5QkTJjQ1NRUXF5uZmd24cWPSpElSHSEpKWnYsGFTpkyhUqlTpkxJTk5+/voTHR0dS5cu3bp163fffbdz505y82Bh6lc40n+vCKGXQlVV1c7O7vr163V1dTo6OtJVKIjZntmzZxM3YZ0/f/4XX3zB4/GIy4GeSSwWU6nUjRs3rl27dtOmTeTmwcIJH4QQegmcnJyuX79OTPRLx4nZnl9++YVCoVAolM8//1wkEg1ozgcA/P399fX1f/jhh2cWinhOmPoRQuglmDRp0vXr14mJful4UlKSqqrqTz/9lNht7NixpOt8nklZWfmLL77Ys2dPS0sLuW1QcMIHIYReAicnp5UrV1ZVVQUGBkqCxGzPnDlzPvjgA0mQy+Vu2bKlqqrKuPsmZs8jKCjo22+/HWjNov7gqB8hhF4CCwsLHR2dR48eTZw4URIkZnt8e99i0sfHRzLnIxQKb926denSJR6P19raev78+fz8fJlDe1VV1c8++yw7O5vcMCiY+hFC6OWYNGmSjY2NpqamJJKcnKympjZv3jypXmBtbW1tbZ2UlAQAjx8/Jj7SlZmZWV1dTXyk68yZM9L9JVavXq3ffWvkFySvJhd6a7wFVboQGrLeoipdCCGE3l6Y+hFCSOFg6kcIIYWDqR8hhBQOpn6EEFI4mPrREMXhcK5evUqO9vGc3Z4fh8PJzMwkRwfIy8uroKCAHEVoyMDUjwZpypQpTCaTyWTq6+uPHDmSWObz+eR+Cik1NZXD4ZCjUnJzc+/cuUOOopfH21t7xAg9JpNBfMXFqQJAbi7NzU2HyWQ4Oemmp9PJ6ygSvJEDGiTJWNvExOTEiRPjx4/v3f7PUVJ680Ywu3fvnjdvnrW1NbkBvTzh4c2rV/fUS2ltpSxZorV5c+vSpYKsLJqvr7apaeP48UKpNRTIm/c/g4Y4Ho8XFBQ0duxYKyurdevWPX36lIg/fPjQy8vL3Nzc2dn5+PHjkkFxf3GJqqqqZcuWmZubczicgwcPkloBoKCgwMnJydzc3MvLq7S7sDOHw7l586a7u7upqSmPx5O5kTNnzsyYMWPUqFE2Njb79u3r2SIAAGRlZbHZ7Ly8PADgcDjp6enEXhYsWCDZS38vVjINxeFwMjIypk+fzmQyXVxciE/hh4SEpKenBwcHM5nM1NTUrv2hVywzk6alJf7gAwGVCpMmCZcsaTtyRIXcSWFg6kcvWWBgoL6+fl5eXnZ2dm1tbUhICBFfsWIFm80uKir69ddfd+3aJenfX1zC39/f1NS0qKgoJSVlx44dly9fJnVITU1NS0srKiqytbVduXKlSCQi4sHBwdHR0Vwu19DQUOZGTE1NY2JiiouLExISiNtpSbZ569atgICAuLg4e3t7IrJ37960tLR79+6NGzcuMDCQ2Et/L1bazp07ExMTuVyuq6vr+vXrASA6OprD4cTGxpaVlXl5eZFXQK9GZyfQpeZ4zMxEXC6157GCwdSPXqYHDx5kZ2eHh4erqanp6uqGhYWlp6c3NzeXlpYWFhZ++eWXdDrdxMREUqKov7hESUnJjRs3wsLC6HQ6i8Xy8PBIT08n9QkMDDQwMKDT6Rs3biwsLORyuUR81apVbDabRqOVlpbK3Ii1tbWtrS2VSnV0dNTX1y8rKyNWfPTokZ+fX0xMzJQpU0h7UVFR2bRp0+3bt7lcbn8vVrIKYcWKFSYmJlQq1cfHp7i4mNSKXp2ICA3JXH9BAc3evrOiQun33+ltbZRr15QPHFBVUVHc29jgXD96mcrLy3V1ddXV1YmHpqamQqGQz+fzeDzp+IgRI4iF/uISlZWVIpFIMicuEok8PDx6dwHJDa3U1dW1tbV5PB5RI8nCwoKI97eRuLi4xMTE8vJyoVDY2toqebsQERHR3NxMuk+WgYEBsaClpaWlpcXj8cRiscwXq6Gh0bOa1Iui0+kdHR3STeiVIs31A8ChQ08jIjRCQpQmT+6YN6+9tVW6UbFg6kcvk6GhYV1dXVNTE3HzwrKyMiqVamxsLBAIGhoaBAKBqqoqAEguBDIwMJAZlzAyMqLT6aWlpXKKE/F4PGKhubm5sbGxb907mRu5fPlyZGRkcnKyvb09lUodM2aMpGnbtm0NDQ1BQUEXLlzQ1dUlgpWVlcQCn89vbGw0Njbu7OyU+WIl2yHIPAtNoVDIIfTqzZjRMWNGPbHs5qazZo3i5n4Zf5QIDdro0aMdHBy2bt3a0tJSX18fERHh6+urrKxsZWXFYrG2b9/e3t7+5MkTSbmJ/uISLBbLxsZm8+bNTU1NAFBeXl5RUUHqc+DAgaqqqvb29qioKDabLRnsS8jcSENDg4aGBpPJFIlE8fHx9fVdGQEAjI2N/f39HRwcpOsYHzx4sKqqSigUbtu2jcPhWFhY9PdiJavIwWAwiBPI+D7gn9TeTgEAPl8pJERDLIZ589rJPRQGpn70kh0+fLimpobNZjs7O5uYmERFRQEAhUL58ccfc3JyWCyWp6enq2vXHW77i0tLTEzk8/l2dnYWFhZLly4lpX4ajRYaGrpgwQIWi1VQUHDo0CGZo+y+G3F3d588ebKjo6OtrW1DQ4Obmxtplejo6Lt37+7Zs4d46OPjs3DhQisrKy6XGx8fTwzbZb7Y57Fu3bpTp04xmcy0tDRyG3plPv1UY+RIxrRpOlQq/PZbI02BZz3wfv0KYajdrz8jIyMyMvLSpUvPGX/tOBzO/v37J0+eTG5ACO/Xj5AcV65cIU6NVldX79q1a+rUqfLjQw0OktDbBFM/+odkZmbOmjXLzMzM1dWVxWJt2LBBfhwh9OrghI9CGGoTPgi9TXDCByGE0BsAUz9CCCkcTP0IIaRwMPUjhJDCwdSPEEIKB1M/QggpHAX+IDNCCL0kDQ3kyBCHo36EEFI4mPoRQuhtdusWfPgh/O9/vYI44YMQQm+zAwcgORnu3wd3954gjvoRQuht5uQEamowa1avII76EULobebnB35+5CCO+tHQcvXqVQ6HQyx7eXkVFBT0bpcXHxwOh3P16lX5kRfE4XAyMzPJ0QF6ua/6TcThDLt69bmKoA0p/+//wdKlwOVCYiJ89BH8+99w4AC0tfXqk5MDX34JK1bAF1/AX38BALS1wbJl8MEHQFSMjo6GpUth/34AgKdPYelS+Ogj6Q3IFhkJS5d2fUVH92rCUT96Ifn5+T/88MP169dbWloMDQ1Xrlz58ccfkzsNVmpqKrGQm5urpqYmqasuiSuUZ75q0k/pTbdhg8aZM/ScnLq+Vddyc2lqamJr605ygxRvb+3MTGUarevOxJs3t6xaJcjNpW3YoHHvHtXERLRpU4un5z9RoDEnB06dAh4PcnJ6gkeOwPnzQJQJ++47+Oabnqa4ONiwAUJD4dYtePgQSkth9Gg4eBAqKuDxY/joIygogFOnYMqUnlX68/ff8Mcf5CChzw8Voef2119/eXp6jh8//urVq/fv3z98+PArqmO1e/fuu3fvkqOvkswqj0PcP/9TenVaWynHj6toa4svXJAxzN+9W+3u3WcPW8PDm8vK+MTXqlWC1lbKkiVay5e3cbn8mJimNWs0b9x49kZelpwc+Ne/4Jdf4NtvgUqF/Hw4cQIA4M8/4ZtvQEkJvvgCkpNh0yagUmH7dsjMBHt7AICCAigrg4oKUFGB27ehtRVu3gQAmDBBevOyHTsGJSUQFESOA6Z+9CJCQ0MDAgJCQkL09PRoNBqbzbazswMAHo8XFBQ0duxYKyurdevWPX36lOjP4XAyMjKmT5/OZDJdXFyys7OJeGlp6YIFC8zNzadOnVpSUiLZPjHxEhISkp6eHhwczGQyiZGvZEJmoDs6c+bMjBkzRo0aZWNjs2/fvu79yFBQUODk5GRubu7l5VVaWkoEORzOzZs33d3dTU1NeTxeVVXVsmXLzM3NORzOwYMHiT7yd5GVlcVms4mC7BwOJz09ndjLggULJHuR86KIVy3z1fX9Kb3Rjh2jT5ggDAgQHD6sSmoKCdFIT6cHB2swmYzUVLok7uGhc+cOVaojWWYmTUtL/MEHAioVJk0SLlnSduSICrnTK2NtDQcPwpw58MknQJSgJg7TP/4IAODrC5s2gZsbfPEFzJ0LAHD0aFdyv3ULrl0DAGCzQSiEvDzIzweArgODfEpKoK8PurrkOGDqR4PG4/EKCwuXLFlCbgAIDAzU19fPy8vLzs6ura0NCQmRNO3cuTMxMZHL5bq6uq5fvx4AxGLxypUr2Wx2UVFRUlLSkSNHejYEAADR0dEcDic2NrasrMzLy0u6aUA7AgBTU9OYmJji4uKEhIQtW7ZUVVVJ+pOkpqampaUVFRXZ2tquXLlSREy4AgQHB0dHR3O5XENDQ39/f1NT06KiopSUlB07dly+fBnk7uLWrVsBAQFxcXH23f+1e/fuTUtLu3fv3rhx4wIDA4m9yHlREn1fnZyf0pvo8GHV5csFPj5tf/6pXFXVK01FRzdzOMLY2OayMr6X1wBmbDo7gd5zpAAzMxGXK+9Q8XJNmgQUStcygwHQ/QFg4vRNfn7PpPytWwAAJSVdyf3WLSDOE9nZAQBkZQ1g1C8Hpn40SDU1NQAwYsQIUvzBgwfZ2dnh4eFqamq6urphYWHp6enNzc1E64oVK0xMTKhUqo+PT3FxMQCUlpbevn1706ZNdDp9+PDhH374Ya/N9W+gOwIAa2trW1tbKpXq6Oior69fVlbWs7neAgMDDQwM6HT6xo0bCwsLuVwuEV+1ahWbzabRaKWlpTdu3AgLC6PT6SwWy8PDIz09HfrfxaNHj/z8/GJiYqZIzdESe1FRUdm0adPt27e5XK78FyUh89W9NW7dolVWKrm7t2tpiefNa5c/Nk9PpzOZDCaTkZVFc3PTYTIZPj7aRFNEhAbRxGQyCgpo9vadFRVKv/9Ob2ujXLumfOCAqorKP1ejUEeHHCG0twMA3LkDp051fRF/awIBjB8PFAoUFUFODigpwb/+BQCQkwMlJTBsGJibS21l4P65qS70ltHT0wOAqqoqnd5/1OXl5bq6uurq6sRDU1NToVDI5/M1NDRA6lBBp9M7OjoAgMfjDRs2TFNTk4ibmJgQC8800B0BQFxcXGJiYnl5uVAobG1tlYzl+9LX1ycW1NXVtbW1eTyepaUlAFhYWBDxyspKkUgkOacqEok8PDyg/11EREQ0NzdLNkswMDAgFrS0tLS0tIjy9HJelITMV/fWSEhQqa1VsrZmAIBAAAyGOCSktb+TL56e7Z6efADw8ND5/vsm6XO/4eHNq1cLeroCHDr0NCJCIyREafLkjnnz2ltbpRtfDyYTHjyAwEDw9u4V19ICLS2wsoKHD4HHg3HjYNIkUFODP/+EtjZwdu7VeRAw9aNBMjY2trS0PHbsWGhoqHTc0NCwrq6uqamJyOZlZWVUKtXY2Jho7Xv61NDQsL6+XiAQqKqqQvebCRKK5K2ylIHu6PLly5GRkcnJyfb29lQqdcyYMaQO0ng8HrHQ3Nzc2NhoZGTUux2MjIzodHppaamycs95SDm72LZtW0NDQ1BQ0IULF3S7J18rKyuJBT6f39jYaGxs3NnZKedFSfR9ddDPT+mN09xMOXZM5fTphuHDu46as2frXLhAnzmzZ25n0C90xoyOGTPqiWU3N501a15/7vfygsuX4dIlCAwEGxsQCODePfjtN5g/HwBgwgQg3tS9+y7QaDBhAhBXHb/gbA/ghA96EeHh4bt3746Li+Pz+QBQU1NTUVExevRoBweHrVu3trS01NfXR0RE+Pr6SudHEktLSxaLFRUV1d7e/uTJkwMHDpB7ADAYDOLUqPQId6A7amho0NDQYDKZIpEoPj6+vr4rBch04MCBqqqq9vb2qKgoNpstGexLsFgsGxubzZs3NzU1AUB5eXlFRYWcXRgbG/v7+zs4OAQHB0uCBw8erKqqEgqF27Zt43A4FhYWA31R0qR/SiKRaPHixadPn5YskHsPVceOqdjYCO3shIaGIuJryRJBQkKvOR8GQ5yXRwOAgb7haW+nAACfrxQSoiEWw7x5AzhV8IosXw7Tp0NpKTg7g6EhDB8O770Hu3Z1nQmQnMt9992e7/B8qf/PP2H+fHBxgfh4AIBLl2DqVPDw6PpwAKZ+NHgeHh4JCQnp6ekODg5MJtPNzS03NxcADh8+XFNTw2aznZ2dTUxMoqKiyGtKUVJSio+Pz8nJYbFYXl5ea9asIfcAWLdu3alTp5hMZlpamnR8QDtyd3efPHmyo6Ojra1tQ0ODm5sbuUc3Go0WGhq6YMECFotVUFBw6NAhmaPsxMREPp9vZ2dnYWGxdOnSioqKZ+4iOjr67t27e/bsIR76+PgsXLjQysqKy+XGx8cTw/YBvShp0j8lkUhUWlrK5/MlC+TeQ1VCgsqSJb0+7+Tn13b+PL2ioudXsG5d66lTykwmIy2t55Bw8mSD/Cv9AeDTTzVGjmRMm6ZDpcJvvzUSl9W/XjQa/PorbNsG48YBhQJaWsDhwOefw/jxAH1S/zvvdD18nst7ysvh8mW4cQOIX35zMxQUwNWrXaeRKWLxP3eiA70u5y5ctLezJUfRa8XhcPbv3/+KPgmB/kl5+TcnOriSo0ObjLEMQuifgQMv9Lpg6kcIIYUzBOa6EFJICn4vNvR64agfIVmzwHQAABFZSURBVIQUDo76EULoRfX3Yd0hC0f9CCGkcDD1I4SQwsHUjxBCCgdTP0IIKRxM/QghpHAw9SOEkMLB1I8QQgoHUz9CCCkcTP0IIaRwMPUjhJDCwdSPXj4Oh3OVqCP3aki233dHfSMviMPhZGZmkqMD5OXlpVA3a+Nwhl29+lyVxST6W8XLS7uggAYAAgFl+XItCwvGe+91lbdELwJTP3oh+fn5y5cvHzt2LJPJdHR03Lt3L7kHAkhNTeVwOOSolNzc3Dt37pCjQ0N+Pm35cq2xY4cxmQxHR929e1UBIDeXducOldz1+Vy8qDxjhg6TyRgzhjF/vvajR/KyUGpqI4cjBICjR1XKy5Xu3q1LT294nr17e2uPGKHHZDKIr7i4rqft5qbDZDKcnHTT0+nkdRSJvB86QvL99ddfnp6e48ePv3r16v379w8fPjwUak7JLKY4xO3evfvu3bvk6BDw11/Knp7a48cLr15tuH+ff/hw0+TJQgDYvVvt7t3B3PyRz1d6/32tf/+79eFDflZW3erVAkn5dflKSqgTJwpVVMTa2uLn3Ht4eHNZGZ/4WrVK0NpKWbJEa/nyNi6XHxPTtGaN5o0bz97I2+rN+ydBQ0doaGhAQEBISIienh6NRmOz2XZ2dtIdqqqqli1bZm5uzuFwDh48SATPnDkzY8aMUaNG2djY7Nu3jwhyOJybN2+6u7ubmpryeDzJFmR2lq+goMDJycnc3NzLy6u0tJQIkrb//E9MIisri81mE3XPORxOeno6sZcFCxZI9sLj8YKCgsaOHWtlZbVu3bqnT58ScekZqoyMjOnTpzOZTBcXl+zsbAAICQlJT08PDg5mMpmpqakikWjLli1sNtvMzGzKlCnXrl3regavQ2ioRkCAICSkVU9PRKMBmy20sxOGhGikp9ODgzWYTEZqKh0AOJxhN2/S3N11TE0ZPB45q3h46EgG6dXVlPZ2ysyZHRQKaGuL585tlxTIvX2b6uKiw2QyXFx0srK6osRE0KZNGgkJKocPqzKZDF9fbdLeCdJ7kSkzk6alJf7gAwGVCpMmCZcsaTtypFe1d4VC/iUh9Jx4PF5hYeGSJUvIDVL8/f1NTU2LiopSUlJ27Nhx+fJlADA1NY2JiSkuLk5ISNiyZUtVVRXROTg4ODo6msvlGhoaSrbQX2c5UlNT09LSioqKbG1tV65cKRJ1DSqltz+gJwYAt27dCggIiIuLs++uh7137960tLR79+6NGzcuMDCQ2EtgYKC+vn5eXl52dnZtbW1ISIhkCxI7d+5MTEzkcrmurq7r168HgOjoaA6HExsbW1ZW5uXldfny5bS0tKtXr5aWlsbGxo4ZM4a8iX8Kj6dUWEglFUkHgOjoZg5HGBvbXFbG9/JqJ4LBwZrR0U1cLt/QUN4o3sqqk80WLl+udesWecT9228qP//8lMvlu7p2fPGFhnTTt982L1vWFhgoKCvjJyU19t378+jsBLrUHI+ZmYjLlXeoeLth6keDVFNTAwAjRowgN3QrKSm5ceNGWFgYnU5nsVgeHh7p6ekAYG1tbWtrS6VSHR0d9fX1y8rKiP6rVq1is9k0Go1CoUg20l9nOQIDAw0MDOh0+saNGwsLC7lcLhGXbL+0tHRAT+zRo0d+fn4xMTFTpkwh7UVFRWXTpk23b9/mcrkPHjzIzs4ODw9XU1PT1dUNCwtLT09vbm6WrEJYsWKFiYkJlUr18fEpLi4mtQLAyJEjnz59evz4caFQaG9vz2AwyD3+KTU1FAAYMUJeKpdYtaqVze6k0UDy20tPpxPz7FlZXTPsPj7aNBqkpTXa2Qm9vbVnzNA5d67n1G5goMDERESlgo9PW1HR8yZlmXshmiIiNCRz/QUFNHv7zooKpd9/p7e1Ua5dUz5wQFVFRXFrI2PqR4Okp6cHAHKG4ZWVlSKRyNramslkMpnM5OTkxsZGAIiLi5s6deqoUaOYTCaPx5OMyi0sLHqtDwD9d5ZDX1+fWFBXV9fW1pZMH0m2P9AnFhER0dzcLNkswcDAgFjQ0tLS0tLi8Xjl5eW6urrq6upE3NTUVCgU8vn8nnUAQOpgSafTOzo6ejcCAFhZWZ08eTInJ8fR0fGbb76R2eefoacnBoCqqufKEhYW5F+Np2c7Mc8+caLw7NmGsjL+b781AoC2tvirr1pu3eJ/8EGbv7+W5MIeyTGGTgehsOfwL19/e4Hec/0cjlBPT3To0NPoaPVx44bt2aM6b177cx7V3krk91wIPSdjY2NLS8tjx46FhoaS2wAAwMjIiE6nl5aWKiv3jOwuX74cGRmZnJxsb29PpVLlz2YMqLOEJNc3Nzc3NjYaGRn1bh/wE9u2bVtDQ0NQUNCFCxd0dbuuLKysrCQW+Hx+Y2OjsbFxZ2dnXV1dU1OTpqYmAJSVlVGpVGNjY8l2CDLPQku/0QEAFosVGxtbW1u7fPnyXbt2yZw4+gcYG4ssLTuPHVMJDW0hNfV+voNBp0NAgOD0afq1a7QpUzoAQNYPRrZB733GjI4ZM+qJZTc3nTVrWnu3K5Dn/mEj1Ed4ePju3bvj4uKIsW1NTU1FRYWklcVi2djYbN68uampCQDKy8srKioaGho0NDSYTKZIJIqPj6+v7/o/lGlAnSUOHDhQVVXV3t4eFRXFZrP7vpkY6BMzNjb29/d3cHAIDg6WBA8ePFhVVSUUCrdt28bhcCwsLEaPHu3g4LB169aWlpb6+vqIiAhfX1/po4scDAaDOIHc0dHx8OHDwsJCoVCoqalpYGBAPMnXJTy8Zfdu1bg4VT6fAgA1NUoVFUoAwGCI8/JoADDQ9yQPHlBv3KAJBBQAyM+n5edT33lHSO70LIPee3s7BQD4fKWQEA2xGObNG8CpgrcMpn40eB4eHgkJCenp6Q4ODkwm083NLTc3V7pDYmIin8+3s7OzsLBYunRpRUWFu7v75MmTHR0dbW1tGxoa3NzcpPuTDKgzgUajhYaGLliwgMViFRQUHDp0SOYoexBPLDo6+u7du3v27CEe+vj4LFy40MrKisvlxsfHE8P2w4cP19TUsNlsZ2dnExOTqKioXpvo37p1606dOsVkMtPS0urq6latWjVq1CgOh0Oj0datW0fu/Q/y8GhPSHiank53cBjGZDLc3HRyc2kAsG5d66lTykwmIy3t2RfJnDzZYG3dSSzX1FA+/VRj7NhhFhaMtWs1t25tmTZtgPm7n71L76U/n36qMXIkY9o0HSoVfvutUXJxkQKiiMWKe6JDcZy7cNHezpYcRYPF4XD2798/FD7EgIaCvPybM6e7kqNDm4wBEULomXDMhN5omPoRQkjhKPBcF0KDpVD3YkNvJRz1I4SQwsHUjxBCCgdTP0IIKRxM/QghpHAw9SOEkMLB1I8QQgoHUz9CCCkcvK5f4cTGxpJDCKGBk76d3xsHU7/CeaP/XhFCLwVO+CCEkMLB1I8QQgoHUz9CCCkcnOtXILY3UskhhNCLuTneixx6E+CoHyGEFA6mfoQQUjiY+hFCSOFg6kcIIYWDqR8hhBQOpn6EEFI4mPoRQkjhYOpHL1/yhLk2Wnrk6ADlOC9xGjacHB0IVSXaIduZd99bfu7dhZKn9OKbRUMK/kIHBz/ShQbp3LsLf3x8++fye5JIzLhpnWLx53euLMo9JdXxtVk03GqEqobdlZ/pStSnwnZyM3oDfTPGaaY+0+mvJJFYTGoar23QKhLea6ojxaX9aj/nXE3ZgUeF5AbFg6N+NEjJlSX/MraSPFRRos4xMP+tsliqy2tmqaGT01DdJurEvP92UKPSFhhZPhW2uzBMyG0AH5txxmoMI0dRPzD1o0E6XlXioGNoqqpJPHQ3MKsXtv1dXwVS78GNVNQT7NzuuSzPcV6yYuQ4APjFfvZqJodYZZ/N9BznJRQAAHDUMSqc9r4ShXjUi6GK+j6b6flTl95+7/0frKdq0ZSJuJmaVvKEufdcll+Y5L3AaFSO8xLptSJYkz4wGfu+ydhiF/+Z+qZ9pwX6Pjc0xC0wGpXX+OSn8rvvm4wlNW0fO2WugfnOcdOKXfznG42SxFMd5o3RxOOBDDjhgwapur31Cr9iobHVfx7cAIB/GVumVBaT3oQfsp15o/GJzeUj5mraxx3mFbfUX6otn8wYvq+sQFlJafKw4bUdAo6W/s2nNVMYw6/wK/q+iweAOJvpt5pqJ/2VRKdQd46btn2s8ye3LgLAfs6Mv+urlt34nz5dNd7WjbRWeFEmlUIRisVfFWWSmgh9n9uf/ApyJzSUvG8yNvZB/tW6ik2WE41U1HltLZKmDXev2mrr73tY8DvvvtQaqF846keDl1xZ/C9jSwBgKKu+pzcyubJEutVSXcdWSz+yJLtDJCpurj/95IGHgfklfvm7usY0itLUYSOKW+r/qH3sZsAEAOdhI/7gP5ZenWCmpj1Bx/DbkqzWTmGDsC2yNMvD0FyDqjxKXWecJmN7aXa7qLNC0Hyg7BZ5TblkPjdyJzSUsLX0hqtonK0peyrsOP3kwZIRY8g9pHgYmhe7+Be7+DvoGJ6aOL/Yxf8X+9nkTooNR/1o8DKePNw+1tlOW99e2zC/8cmD1kbpVmMVDSUK5cbUpcRDJQqcrn54p4nf0im01dZ3NzC7WPs4r+FJ2Oh3Yh/kO+gYri28JL06YYSqRoOwraVTSDx8LGiiUZSGKasYqajVd/TEK9qae9Z5DjKfW+8uaGj5wGSsnrJq/tRlAKCiRK3rEPznwQ2ZbxMB4GT1g5PVDwAg1WHehntX5Z/7VUyY+tHgtYk6T1RzPQ1HTdAxIA35AaC6vaVD1Gl9KVEoFknHr/DLJw8bPlOfuSj3VFnrUzM1LQ9D8wetjZWy0veT9lZdmoomVbmpswMATFW1OsXiqrYWVSpNR5muqkQTiIQAwFBWIa8pV3/PDQ1NGlTlBUaj5menV3X/kaRNnO/CGHmh9pGkTz9HASQbTvigF/JbZfFcQ3OOln5anznW4ub6wib+Vta7mlRlABihqjFcRQMALtWWextbNgrb77c0CMWiP2off2xme6m2nLQ6oaS5Pq/xyZdWE9WpNB2ayiYrx5SqEqFYVNpcX9Lc8Nkoe2UlJQO6WqApm7ymXP09NzQ0eRmPKnzKv/m0prq9lfhKqij6oPfJ3roOwXhtAwCgUeSlNWUlqgZVmfiS3/PtprivHL0Uf9dXUQAu1j5qlHUBZWD+WYayapaz3933lv9kN2u4qgYAXOGXszSGZTx5QPQ5W1M2TpNxiS879QNA0M1zenS1XOelFyd5VwiaN9+7BgBigA8LzttrG96a9n6Kg0d/Rw45ZD43NDS9bzI2qbJIOpJUWeyqP1L6gB378Ka7gVmxi7+nkYUk6JVzgjTb86XVxCKX5cTXGnNb6SaFQhHj2yQFcO7CRXs727e4StcsfeYXlg4z/z5ObkDoFbs53isv/+bM6a7khqENR/2K4u07xk8ZNsJQRZ0CYEhX+8TM9s86vDQTvQZv6H8WnuZVCBTKW/j27h1do53jpukqqzQJ28/VPvrhfi65B0Kvnlgspsj6KOIQh6lfIbyVqT+GmxfDzSNHEfpniURvZOrHCR9F8falfoSGgjf0PwtTv0J4K0f9CA0Fb+iED6Z+hfAm/mki9KZ4E/+/MPUjhJDCwdO8CoExjFH2uDx7nAeFAkpKSlQqldwDITQQnZ2dIpFILIZH5Y/1hr1594XGKWCF8OTJk8qqan4dXywWi0Qi/KUj9IIoFIqSkhKFQtEbNszY2MjAwIDcY2jD1I/QCzlx8rTTpHckD69lXgeAeR5zWlp67ib/Wqirq5NDCHXDuX6EEFI4mPoRQkjhYOpHCCGFg6kfIYQUDqZ+hBBSOJj6EUJI4WDqRwghhYOpHyGEFA6mfoQQUjiY+hH6/+3UgQAAAACAIH/rQS6IYEf9ADvqB9hRP8CO+gF21A+wE9g7RmBZZfQtAAAAAElFTkSuQmCC)
&]
[s0; &]
[s3;~~~2752; In the .log, serial number is printed for each leaked 
memory block. It is printed after `"`-`-memory`-breakpoint`_`_`":&]
[s0; &]
[s0;= 
@@rawimage:3768&922
(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)
&]
[s0; &]
[s3; Now the only thing you need to do is to add `"void [* MemoryBreakpoint](dword 
serial)`" call to your application source code. For the case 
above the serial parameter should 925. When Alloc for that serial 
happens again, `_`_BREAK`_`_ will segfault (`"`*(void `*)0 `= 
0`") the application and you will be able to catch the problem 
in the debugger. The code that will detect the leak could look 
like this:&]
[s0; &]
[s4; #include <Core/Core.h>&]
[s4; &]
[s4; using namespace Upp;&]
[s4; &]
[s4; CONSOLE`_APP`_MAIN&]
[s4; `{&]
[s4; -|MemoryBreakpoint(925); [@(28.127.0) // <`- The earlier you place 
this instruction the better]&]
[s4; -|&]
[s4; -|int`* a `= new int(5); [@(28.170.0)   ][@(28.127.0) // <`- Debugger 
should break in this line]&]
[s4; `}&]
[s3; &]
[s3; The alternative approach assumes that the `"`-`-memory`-breakpoint`_`_`" 
is passed as a program argument. In this case there is no need 
to modify source code. To do it open `"Run options`" dialog from 
`"Debug`" menu:&]
[s0; &]
[s0;= 
@@rawimage:2309&1620
(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)
&]
[s0; &]
[s3; Now the window where command line arguments for application 
can be specified should appears. In this case we need to add 
`"`-`-memory`-breakpoint`_`_ `$`{serial`_number`}`" as argument. 
In our example serial number is 925:&]
[s0; &]
[s0;= 
@@rawimage:3434&1555
(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)
&]
[s0; &]
[s3; Of course, the only problem with this is that the order of allocations 
must be exactly the same in the `"test run`". Which is often 
not, but usually it is possible to arrange it so after spending 
a couple of nights desperately looking for the source of leak 
in the code using other methods. So make sure that the serial 
number is still valid! In might be correct for several applications 
debug sessions, but in the end it will [* expire].&]
[s2;:3: 3. False positives&]
[s3; There is a very memory situation when memory leak can not be 
fixed by the programmer. For example the external library is 
used and there is not full control over it. Sometimes the operating 
system drivers leaks could be treated as leaks. To avoid such 
false positives U`+`+ library provides ignoring mechanisms.&]
[s3; The first one is the pair of function [* MemoryIgnoreLeaksBegin()] 
and [* MemoryIgnoreLeaksEnd()]. The below example show how to avoid 
leak detection:&]
[s0; &]
[s4; #include <Core/Core.h>&]
[s4; &]
[s4; using namespace Upp;&]
[s4; &]
[s4; CONSOLE`_APP`_MAIN&]
[s4; `{&]
[s4; -|MemoryIgnoreLeaksBegin();&]
[s4; -|int`* a `= new int(5);&]
[s4; -|MemoryIgnoreLeaksEnd();&]
[s4; `}&]
[s0; &]
[s3; The alternative simpler approach is to used [* MemoryIgnoreLeaksBlock] 
structure. On construction it starts ignoring and on destruction 
it cancels ignoring statement. This is the classical RAII pattern. 
Example below:&]
[s0; &]
[s0;l321; [C@5;1 #include <Core/Core.h>]&]
[s4; &]
[s4; using namespace Upp;&]
[s4; &]
[s4; CONSOLE`_APP`_MAIN&]
[s4; `{&]
[s4; -|`{&]
[s4; -|-|MemoryIgnoreLeaksBlock `_`_;&]
[s4; -|-|int`* a `= new int(5); [@(28.127.0) // <`- This leak will be 
ignored]&]
[s4; -|`}&]
[s4; -|int`* b `= new int(10); [@(28.127.0) // <`- This leak will be 
catched]&]
[s4; `}&]
[s0; &]
[s3; The memory leak detection mechanisms should be use with caution. 
In the vast majority of cases detections means that something 
is wrong in the application source code.&]
[s0; ]]