interface LogoProps extends React.HTMLAttributes<HTMLOrSVGElement> {
  variant?: "symbol" | "color";
}

const TailwindLogo: React.FC<LogoProps> = ({
  variant,
  className,
  ...props
}: LogoProps) => {
  const svgClass = className ? ` ${className}` : "";
  if (variant === "symbol") {
    return (
      <svg
        height="1rem"
        viewBox="0 0 56 56"
        className={`${svgClass}`}
        {...props}
      >
        <path
          d="M27.997 11.0027C20.5314 11.0027 15.8656 14.7833 13.9995 22.3447C16.7993 18.5633 20.0679 17.1455 23.8053 18.0912C25.9022 18.8412 27.7504 20.1696 29.1417 21.9267C30.6864 23.8661 32.6479 25.4226 34.8767 26.4776C37.1055 27.5327 39.5427 28.0584 42.0025 28.0147C49.4681 28.0147 54.1339 24.234 56 16.6727C53.2002 20.454 49.9336 21.8718 46.2001 20.9262C44.104 20.1758 42.2565 18.8474 40.8658 17.0906C39.3202 15.1502 37.3574 13.593 35.1272 12.5379C32.8969 11.4828 30.4582 10.9577 27.997 11.0027ZM13.9995 28.0167C6.5339 28.0167 1.86739 31.7973 0 39.3587C2.80109 35.5773 6.06771 34.1622 9.79985 35.1132C11.8966 35.8635 13.7448 37.1919 15.1362 38.9488C16.6809 40.8881 18.6424 42.4446 20.8712 43.4997C23.1 44.5547 25.5372 45.0804 27.997 45.0367C35.4626 45.0367 40.1291 41.256 41.9965 33.6947C39.1968 37.476 35.9301 38.8939 32.1967 37.9482C30.0994 37.197 28.2511 35.8671 26.8603 34.1086C25.3157 32.1691 23.3542 30.6125 21.1254 29.5575C18.8966 28.5024 16.4593 27.9768 13.9995 28.0207V28.0167Z"
          fill="url(#paint0_linear_46_724)"
        />
        <defs>
          <linearGradient
            id="paint0_linear_46_724"
            x1="28"
            y1="11"
            x2="28"
            y2="45.0392"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#B9E2FF" />
            <stop offset="1" stopColor="#A291FF" />
          </linearGradient>
        </defs>
      </svg>
    );
  } else if (variant === "color") {
    return (
      <svg
        height=".85em"
        viewBox="0 0 170.43 21.13"
        fill="currentColor"
        className={`${svgClass}`}
        {...props}
      >
        <g id="tailwindcss" transform="translate(-0.001)">
          <path
            fill="#38bdf8"
            d="M17.609,0q-7.043,0-8.8,7.044Q11.446,3.521,14.968,4.4a7.506,7.506,0,0,1,3.357,2.382c1.726,1.752,3.724,3.78,8.089,3.78q7.043,0,8.8-7.044-2.641,3.522-6.163,2.641A7.506,7.506,0,0,1,25.7,3.78C23.971,2.028,21.974,0,17.609,0Zm-8.8,10.565q-7.043,0-8.8,7.044,2.641-3.522,6.163-2.641A7.51,7.51,0,0,1,9.52,17.35c1.726,1.752,3.725,3.78,8.089,3.78q7.044,0,8.8-7.044-2.641,3.522-6.163,2.641a7.508,7.508,0,0,1-3.357-2.382c-1.726-1.753-3.724-3.781-8.089-3.781Z"
          />
          <path
            d="M142.594,10.158h-3.073v5.948c0,1.586,1.041,1.561,3.073,1.462v2.4c-4.114.5-5.749-.644-5.749-3.866V10.158h-2.28V7.581h2.28V4.252l2.676-.793V7.581h3.073Zm11.714-2.577h2.676V19.972h-2.676V18.188a5.093,5.093,0,0,1-4.337,2.106,6.333,6.333,0,0,1-6.17-6.518,6.317,6.317,0,0,1,6.171-6.518,5.136,5.136,0,0,1,4.337,2.081Zm-3.916,10.161a3.83,3.83,0,0,0,3.916-3.965,3.916,3.916,0,1,0-7.831,0A3.829,3.829,0,0,0,150.393,17.742Zm11.053-12.02a1.71,1.71,0,1,1,1.71-1.71A1.73,1.73,0,0,1,161.446,5.722Zm-1.338,14.25V7.581h2.676V19.972Zm5.774,0V1.881h2.677V19.972ZM185.931,7.58h2.825l-3.891,12.392h-2.627l-2.577-8.352-2.6,8.352h-2.627L170.541,7.581h2.825l2.4,8.55,2.6-8.55h2.552l2.577,8.55Zm6.146-1.858a1.71,1.71,0,1,1,1.71-1.71A1.73,1.73,0,0,1,192.077,5.722Zm-1.338,14.25V7.581h2.676V19.972ZM203.03,7.258c2.776,0,4.758,1.884,4.758,5.105v7.608h-2.676V12.636a2.583,2.583,0,0,0-2.776-2.875c-1.759,0-3.147,1.041-3.147,3.568v6.642h-2.676V7.581h2.676V9.167a4.267,4.267,0,0,1,3.841-1.908Zm17.447-4.634h2.676V19.972h-2.676V18.188a5.093,5.093,0,0,1-4.337,2.106,6.333,6.333,0,0,1-6.171-6.518,6.317,6.317,0,0,1,6.171-6.518,5.136,5.136,0,0,1,4.337,2.081Zm-3.916,15.118a3.83,3.83,0,0,0,3.916-3.965,3.916,3.916,0,1,0-7.831,0A3.829,3.829,0,0,0,216.562,17.742Zm15.563,2.552a6.408,6.408,0,0,1-6.542-6.518,6.393,6.393,0,0,1,6.542-6.518,6.122,6.122,0,0,1,5.527,3.2l-2.3,1.338A3.464,3.464,0,0,0,232.1,9.886a3.78,3.78,0,0,0-3.841,3.891,3.779,3.779,0,0,0,3.841,3.891,3.637,3.637,0,0,0,3.3-1.908l2.3,1.313a6.229,6.229,0,0,1-5.576,3.222ZM242.112,11c0,2.255,6.666.892,6.666,5.477,0,2.478-2.156,3.816-4.832,3.816a5.171,5.171,0,0,1-5.056-2.9l2.3-1.338a2.722,2.722,0,0,0,2.751,1.784c1.189,0,2.106-.4,2.106-1.388,0-2.206-6.666-.966-6.666-5.4,0-2.329,2.007-3.791,4.535-3.791a4.988,4.988,0,0,1,4.585,2.577L246.251,11.1a2.416,2.416,0,0,0-2.33-1.413c-.966,0-1.809.421-1.809,1.314Zm11.425,0c0,2.255,6.666.892,6.666,5.477,0,2.478-2.156,3.816-4.833,3.816a5.171,5.171,0,0,1-5.056-2.9l2.3-1.338a2.722,2.722,0,0,0,2.751,1.784c1.19,0,2.106-.4,2.106-1.388,0-2.206-6.666-.966-6.666-5.4,0-2.329,2.007-3.791,4.535-3.791a4.989,4.989,0,0,1,4.585,2.577L257.675,11.1a2.416,2.416,0,0,0-2.329-1.413c-.967,0-1.809.421-1.809,1.314Z"
            transform="translate(-89.771 -1.255)"
            fill="currentColor"
          />
        </g>
      </svg>
    );
  } else {
    return (
      <svg
        height=".85em"
        viewBox="0 0 170.43 21.13"
        fill="currentColor"
        className={`${svgClass}`}
        {...props}
      >
        <g id="tailwindcss" transform="translate(-0.001)">
          <path d="M17.609,0q-7.043,0-8.8,7.044Q11.446,3.521,14.968,4.4a7.506,7.506,0,0,1,3.357,2.382c1.726,1.752,3.724,3.78,8.089,3.78q7.043,0,8.8-7.044-2.641,3.522-6.163,2.641A7.506,7.506,0,0,1,25.7,3.78C23.971,2.028,21.974,0,17.609,0Zm-8.8,10.565q-7.043,0-8.8,7.044,2.641-3.522,6.163-2.641A7.51,7.51,0,0,1,9.52,17.35c1.726,1.752,3.725,3.78,8.089,3.78q7.044,0,8.8-7.044-2.641,3.522-6.163,2.641a7.508,7.508,0,0,1-3.357-2.382c-1.726-1.753-3.724-3.781-8.089-3.781Z" />
          <path
            d="M142.594,10.158h-3.073v5.948c0,1.586,1.041,1.561,3.073,1.462v2.4c-4.114.5-5.749-.644-5.749-3.866V10.158h-2.28V7.581h2.28V4.252l2.676-.793V7.581h3.073Zm11.714-2.577h2.676V19.972h-2.676V18.188a5.093,5.093,0,0,1-4.337,2.106,6.333,6.333,0,0,1-6.17-6.518,6.317,6.317,0,0,1,6.171-6.518,5.136,5.136,0,0,1,4.337,2.081Zm-3.916,10.161a3.83,3.83,0,0,0,3.916-3.965,3.916,3.916,0,1,0-7.831,0A3.829,3.829,0,0,0,150.393,17.742Zm11.053-12.02a1.71,1.71,0,1,1,1.71-1.71A1.73,1.73,0,0,1,161.446,5.722Zm-1.338,14.25V7.581h2.676V19.972Zm5.774,0V1.881h2.677V19.972ZM185.931,7.58h2.825l-3.891,12.392h-2.627l-2.577-8.352-2.6,8.352h-2.627L170.541,7.581h2.825l2.4,8.55,2.6-8.55h2.552l2.577,8.55Zm6.146-1.858a1.71,1.71,0,1,1,1.71-1.71A1.73,1.73,0,0,1,192.077,5.722Zm-1.338,14.25V7.581h2.676V19.972ZM203.03,7.258c2.776,0,4.758,1.884,4.758,5.105v7.608h-2.676V12.636a2.583,2.583,0,0,0-2.776-2.875c-1.759,0-3.147,1.041-3.147,3.568v6.642h-2.676V7.581h2.676V9.167a4.267,4.267,0,0,1,3.841-1.908Zm17.447-4.634h2.676V19.972h-2.676V18.188a5.093,5.093,0,0,1-4.337,2.106,6.333,6.333,0,0,1-6.171-6.518,6.317,6.317,0,0,1,6.171-6.518,5.136,5.136,0,0,1,4.337,2.081Zm-3.916,15.118a3.83,3.83,0,0,0,3.916-3.965,3.916,3.916,0,1,0-7.831,0A3.829,3.829,0,0,0,216.562,17.742Zm15.563,2.552a6.408,6.408,0,0,1-6.542-6.518,6.393,6.393,0,0,1,6.542-6.518,6.122,6.122,0,0,1,5.527,3.2l-2.3,1.338A3.464,3.464,0,0,0,232.1,9.886a3.78,3.78,0,0,0-3.841,3.891,3.779,3.779,0,0,0,3.841,3.891,3.637,3.637,0,0,0,3.3-1.908l2.3,1.313a6.229,6.229,0,0,1-5.576,3.222ZM242.112,11c0,2.255,6.666.892,6.666,5.477,0,2.478-2.156,3.816-4.832,3.816a5.171,5.171,0,0,1-5.056-2.9l2.3-1.338a2.722,2.722,0,0,0,2.751,1.784c1.189,0,2.106-.4,2.106-1.388,0-2.206-6.666-.966-6.666-5.4,0-2.329,2.007-3.791,4.535-3.791a4.988,4.988,0,0,1,4.585,2.577L246.251,11.1a2.416,2.416,0,0,0-2.33-1.413c-.966,0-1.809.421-1.809,1.314Zm11.425,0c0,2.255,6.666.892,6.666,5.477,0,2.478-2.156,3.816-4.833,3.816a5.171,5.171,0,0,1-5.056-2.9l2.3-1.338a2.722,2.722,0,0,0,2.751,1.784c1.19,0,2.106-.4,2.106-1.388,0-2.206-6.666-.966-6.666-5.4,0-2.329,2.007-3.791,4.535-3.791a4.989,4.989,0,0,1,4.585,2.577L257.675,11.1a2.416,2.416,0,0,0-2.329-1.413c-.967,0-1.809.421-1.809,1.314Z"
            transform="translate(-89.771 -1.255)"
            fill="currentColor"
          />
        </g>
      </svg>
    );
  }
};
export default TailwindLogo;
