interface LogoProps extends React.HTMLAttributes<HTMLOrSVGElement> {
  variant?: "symbol" | "color";
  fill?: string;
}

const SupabaseLogo: React.FC<LogoProps> = ({
  variant,
  fill,
  className,
  ...props
}: LogoProps) => {
  const svgClass = className ? ` ${className}` : "";

  if (variant === "symbol") {
    return (
      <svg
        height="1rem"
        viewBox="0 0 18 18"
        className={`${svgClass}`}
        fill={fill}
        {...props}
      >
        <path
          d="M10.5924 17.7169C10.4899 17.8378 10.3497 17.926 10.1912 17.9696C10.0327 18.0131 9.86369 18.0098 9.70729 17.9602C9.55089 17.9105 9.4148 17.8168 9.31772 17.6921C9.22063 17.5674 9.1673 17.4176 9.16505 17.2635L9 7.00001H16.3944C16.6962 6.99921 16.9922 7.07803 17.2481 7.2274C17.504 7.37677 17.7094 7.59059 17.8407 7.8442C17.9719 8.09781 18.0237 8.38088 17.99 8.66076C17.9563 8.94064 17.8385 9.20593 17.6502 9.42603L10.5924 17.7169Z"
          fill="url(#paint0_linear_72_775)"
        />
        <path
          d="M7.48464 0.308823C7.58831 0.176983 7.72996 0.0806966 7.89014 0.0331827C8.05032 -0.0143312 8.22117 -0.0107427 8.37924 0.0434557C8.53731 0.0976541 8.67485 0.199805 8.77298 0.335883C8.8711 0.471962 8.925 0.635296 8.92727 0.80346L9 12H1.61872C1.31437 12.0001 1.01616 11.9138 0.758327 11.7509C0.500496 11.588 0.2935 11.3552 0.16111 11.0792C0.0287197 10.8032 -0.0236977 10.4951 0.00987682 10.1905C0.0434513 9.8858 0.161657 9.59684 0.350919 9.35678L7.48464 0.308823Z"
          fill={fill}
        />

        <linearGradient
          id="paint0_linear_72_775"
          x1="13.5"
          y1="7"
          x2="13.5"
          y2="18"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor={fill} stopOpacity="0.2" />
          <stop offset="1" stopColor={fill} />
        </linearGradient>
      </svg>
    );
  } else if (variant === "color") {
    return (
      <svg
        height="1.2em"
        viewBox="0 0 143.785 27.728"
        className={`${svgClass}`}
        fill={fill}
        {...props}
      >
        <defs>
          <linearGradient
            id="linear-gradient"
            x1="0.5"
            x2="0.5"
            y2="1"
            gradientUnits="objectBoundingBox"
          >
            <stop offset="0" stopColor="#3ECF8E" stopOpacity="0.33" />
            <stop offset="1" stopColor="#3ECF8E" />
          </linearGradient>
        </defs>
        <g
          id="supabase-logo-wordmark--dark"
          transform="translate(-0.025 -0.211)"
        >
          <path
            d="M151.4,38.92c.148,1.388,1.411,3.766,5.073,3.766,3.192,0,4.727-2.032,4.727-4.014,0-1.784-1.213-3.246-3.613-3.742l-1.733-.372c-.668-.124-1.114-.5-1.114-1.09a1.4,1.4,0,0,1,1.559-1.214,1.856,1.856,0,0,1,2,1.635l2.747-.619c-.148-1.313-1.312-3.518-4.776-3.518-2.623,0-4.554,1.809-4.554,3.989,0,1.71,1.064,3.122,3.415,3.642l1.609.372c.94.2,1.312.644,1.312,1.189,0,.644-.52,1.214-1.609,1.214a2.026,2.026,0,0,1-2.227-1.858Z"
            transform="translate(-113.874 -22.223)"
            fill="currentColor"
          />
          <path
            d="M208.845,43.444h3.143a20.06,20.06,0,0,1-.124-2.205V31.253h-3.292v7.086a2.2,2.2,0,0,1-2.3,2.4,2.168,2.168,0,0,1-2.228-2.453V31.253h-3.292v7.706a4.489,4.489,0,0,0,4.628,4.807,3.846,3.846,0,0,0,3.366-1.635A8.352,8.352,0,0,0,208.845,43.444Z"
            transform="translate(-151.003 -23.352)"
            fill="currentColor"
          />
          <path
            d="M263.081,47.324v-5.9a4.276,4.276,0,0,0,3.514,1.487c3.44,0,5.741-2.726,5.741-6.418,0-3.618-2.054-6.343-5.618-6.343a4.256,4.256,0,0,0-3.737,1.759V30.425H259.79v16.9Zm6.014-10.8c0,2.18-1.336,3.444-3.019,3.444s-3.044-1.288-3.044-3.444,1.361-3.419,3.044-3.419S269.1,34.365,269.1,36.521Z"
            transform="translate(-195.416 -22.524)"
            fill="currentColor"
          />
          <path
            d="M317.964,38.995c0,1.908,1.584,3.667,4.183,3.667a4.067,4.067,0,0,0,3.588-1.809,8.256,8.256,0,0,0,.124,1.462h3.019a13.663,13.663,0,0,1-.148-1.933v-6c0-2.453-1.436-4.633-5.3-4.633-3.267,0-5.024,2.106-5.222,4.014l2.92.619a2.162,2.162,0,0,1,2.326-1.982c1.386,0,2.054.719,2.054,1.586,0,.421-.222.768-.916.867L321.6,35.3C319.573,35.6,317.964,36.814,317.964,38.995Zm4.875,1.214a1.43,1.43,0,0,1-1.584-1.412,1.538,1.538,0,0,1,1.51-1.536l2.747-.421v.545C325.512,39.54,324.225,40.209,322.839,40.209Z"
            transform="translate(-239.179 -22.223)"
            fill="currentColor"
          />
          <path
            d="M378.008,25.987V24.5a4.119,4.119,0,0,0,3.613,1.784c3.465,0,5.742-2.75,5.742-6.442,0-3.618-2.054-6.368-5.618-6.368a4.33,4.33,0,0,0-3.688,1.66V8.048h-3.242V25.987Zm6.063-6.12c0,2.23-1.336,3.469-3.019,3.469-1.658,0-3.044-1.264-3.044-3.469,0-2.23,1.386-3.444,3.044-3.444C382.734,16.423,384.071,17.637,384.071,19.867Z"
            transform="translate(-281.946 -5.895)"
            fill="currentColor"
          />
          <path
            d="M432.99,38.995c0,1.908,1.584,3.667,4.182,3.667a4.067,4.067,0,0,0,3.588-1.809,8.279,8.279,0,0,0,.124,1.462H443.9a13.741,13.741,0,0,1-.148-1.933v-6c0-2.453-1.436-4.633-5.3-4.633-3.267,0-5.024,2.106-5.222,4.014l2.92.619a2.163,2.163,0,0,1,2.326-1.982c1.386,0,2.054.719,2.054,1.586,0,.421-.223.768-.916.867l-2.994.446C434.6,35.6,432.99,36.814,432.99,38.995Zm4.875,1.214a1.43,1.43,0,0,1-1.584-1.412,1.538,1.538,0,0,1,1.51-1.536l2.747-.421v.545C440.538,39.54,439.251,40.209,437.865,40.209Z"
            transform="translate(-325.71 -22.223)"
            fill="currentColor"
          />
          <path
            d="M485.645,38.92c.148,1.388,1.411,3.766,5.073,3.766,3.193,0,4.727-2.032,4.727-4.014,0-1.784-1.212-3.246-3.613-3.742L490.1,34.56c-.668-.124-1.113-.5-1.113-1.09a1.4,1.4,0,0,1,1.559-1.214,1.856,1.856,0,0,1,2.005,1.635l2.747-.619c-.149-1.313-1.312-3.518-4.776-3.518-2.624,0-4.554,1.809-4.554,3.989,0,1.71,1.064,3.122,3.415,3.642l1.609.372c.941.2,1.312.644,1.312,1.189,0,.644-.52,1.214-1.609,1.214a2.026,2.026,0,0,1-2.227-1.858Z"
            transform="translate(-365.321 -22.223)"
            fill="currentColor"
          />
          <path
            d="M535.314,34.832a2.636,2.636,0,0,1,2.722-2.4,2.45,2.45,0,0,1,2.722,2.4ZM541.081,38a2.689,2.689,0,0,1-2.772,1.858,2.966,2.966,0,0,1-3.069-2.775h8.711c0-.05.049-.545.049-1.016,0-3.915-2.252-6.318-6.014-6.318A6.117,6.117,0,0,0,532,36.17a6.171,6.171,0,0,0,6.286,6.517,5.485,5.485,0,0,0,5.544-3.865Z"
            transform="translate(-400.191 -22.223)"
            fill="currentColor"
          />
          <path
            d="M56.385,57.458a1.212,1.212,0,0,1-2.162-.736l-.25-16.66h11.2A2.425,2.425,0,0,1,67.075,44Z"
            transform="translate(-40.585 -29.979)"
            fill="url(#linear-gradient)"
          />
          <path
            d="M11.245.672a1.212,1.212,0,0,1,2.162.736l.109,16.66H2.454a2.425,2.425,0,0,1-1.9-3.933Z"
            transform="translate(0 0)"
            fill="#3ECF8E"
          />
        </g>
      </svg>
    );
  } else {
    return (
      <svg
        height="1.2em"
        viewBox="0 0 143.785 27.728"
        className={`${svgClass}`}
        fill={fill}
        {...props}
      >
        <defs>
          <linearGradient
            id="linear-gradient"
            x1="0.5"
            x2="0.5"
            y2="1"
            gradientUnits="objectBoundingBox"
          >
            <stop offset="0" stopColor={fill} stopOpacity="0.33" />
            <stop offset="1" stopColor={fill} />
          </linearGradient>
        </defs>
        <g
          id="supabase-logo-wordmark--dark"
          transform="translate(-0.025 -0.211)"
          fill={fill}
        >
          <path
            d="M151.4,38.92c.148,1.388,1.411,3.766,5.073,3.766,3.192,0,4.727-2.032,4.727-4.014,0-1.784-1.213-3.246-3.613-3.742l-1.733-.372c-.668-.124-1.114-.5-1.114-1.09a1.4,1.4,0,0,1,1.559-1.214,1.856,1.856,0,0,1,2,1.635l2.747-.619c-.148-1.313-1.312-3.518-4.776-3.518-2.623,0-4.554,1.809-4.554,3.989,0,1.71,1.064,3.122,3.415,3.642l1.609.372c.94.2,1.312.644,1.312,1.189,0,.644-.52,1.214-1.609,1.214a2.026,2.026,0,0,1-2.227-1.858Z"
            transform="translate(-113.874 -22.223)"
          />
          <path
            d="M208.845,43.444h3.143a20.06,20.06,0,0,1-.124-2.205V31.253h-3.292v7.086a2.2,2.2,0,0,1-2.3,2.4,2.168,2.168,0,0,1-2.228-2.453V31.253h-3.292v7.706a4.489,4.489,0,0,0,4.628,4.807,3.846,3.846,0,0,0,3.366-1.635A8.352,8.352,0,0,0,208.845,43.444Z"
            transform="translate(-151.003 -23.352)"
          />
          <path
            d="M263.081,47.324v-5.9a4.276,4.276,0,0,0,3.514,1.487c3.44,0,5.741-2.726,5.741-6.418,0-3.618-2.054-6.343-5.618-6.343a4.256,4.256,0,0,0-3.737,1.759V30.425H259.79v16.9Zm6.014-10.8c0,2.18-1.336,3.444-3.019,3.444s-3.044-1.288-3.044-3.444,1.361-3.419,3.044-3.419S269.1,34.365,269.1,36.521Z"
            transform="translate(-195.416 -22.524)"
          />
          <path
            d="M317.964,38.995c0,1.908,1.584,3.667,4.183,3.667a4.067,4.067,0,0,0,3.588-1.809,8.256,8.256,0,0,0,.124,1.462h3.019a13.663,13.663,0,0,1-.148-1.933v-6c0-2.453-1.436-4.633-5.3-4.633-3.267,0-5.024,2.106-5.222,4.014l2.92.619a2.162,2.162,0,0,1,2.326-1.982c1.386,0,2.054.719,2.054,1.586,0,.421-.222.768-.916.867L321.6,35.3C319.573,35.6,317.964,36.814,317.964,38.995Zm4.875,1.214a1.43,1.43,0,0,1-1.584-1.412,1.538,1.538,0,0,1,1.51-1.536l2.747-.421v.545C325.512,39.54,324.225,40.209,322.839,40.209Z"
            transform="translate(-239.179 -22.223)"
          />
          <path
            d="M378.008,25.987V24.5a4.119,4.119,0,0,0,3.613,1.784c3.465,0,5.742-2.75,5.742-6.442,0-3.618-2.054-6.368-5.618-6.368a4.33,4.33,0,0,0-3.688,1.66V8.048h-3.242V25.987Zm6.063-6.12c0,2.23-1.336,3.469-3.019,3.469-1.658,0-3.044-1.264-3.044-3.469,0-2.23,1.386-3.444,3.044-3.444C382.734,16.423,384.071,17.637,384.071,19.867Z"
            transform="translate(-281.946 -5.895)"
          />
          <path
            d="M432.99,38.995c0,1.908,1.584,3.667,4.182,3.667a4.067,4.067,0,0,0,3.588-1.809,8.279,8.279,0,0,0,.124,1.462H443.9a13.741,13.741,0,0,1-.148-1.933v-6c0-2.453-1.436-4.633-5.3-4.633-3.267,0-5.024,2.106-5.222,4.014l2.92.619a2.163,2.163,0,0,1,2.326-1.982c1.386,0,2.054.719,2.054,1.586,0,.421-.223.768-.916.867l-2.994.446C434.6,35.6,432.99,36.814,432.99,38.995Zm4.875,1.214a1.43,1.43,0,0,1-1.584-1.412,1.538,1.538,0,0,1,1.51-1.536l2.747-.421v.545C440.538,39.54,439.251,40.209,437.865,40.209Z"
            transform="translate(-325.71 -22.223)"
          />
          <path
            d="M485.645,38.92c.148,1.388,1.411,3.766,5.073,3.766,3.193,0,4.727-2.032,4.727-4.014,0-1.784-1.212-3.246-3.613-3.742L490.1,34.56c-.668-.124-1.113-.5-1.113-1.09a1.4,1.4,0,0,1,1.559-1.214,1.856,1.856,0,0,1,2.005,1.635l2.747-.619c-.149-1.313-1.312-3.518-4.776-3.518-2.624,0-4.554,1.809-4.554,3.989,0,1.71,1.064,3.122,3.415,3.642l1.609.372c.941.2,1.312.644,1.312,1.189,0,.644-.52,1.214-1.609,1.214a2.026,2.026,0,0,1-2.227-1.858Z"
            transform="translate(-365.321 -22.223)"
          />
          <path
            d="M535.314,34.832a2.636,2.636,0,0,1,2.722-2.4,2.45,2.45,0,0,1,2.722,2.4ZM541.081,38a2.689,2.689,0,0,1-2.772,1.858,2.966,2.966,0,0,1-3.069-2.775h8.711c0-.05.049-.545.049-1.016,0-3.915-2.252-6.318-6.014-6.318A6.117,6.117,0,0,0,532,36.17a6.171,6.171,0,0,0,6.286,6.517,5.485,5.485,0,0,0,5.544-3.865Z"
            transform="translate(-400.191 -22.223)"
          />
          <path
            d="M56.385,57.458a1.212,1.212,0,0,1-2.162-.736l-.25-16.66h11.2A2.425,2.425,0,0,1,67.075,44Z"
            transform="translate(-40.585 -29.979)"
            fill="url(#linear-gradient)"
          />
          <path
            d="M11.245.672a1.212,1.212,0,0,1,2.162.736l.109,16.66H2.454a2.425,2.425,0,0,1-1.9-3.933Z"
            transform="translate(0 0)"
          />
        </g>
      </svg>
    );
  }
};
export default SupabaseLogo;
