interface LogoProps extends React.HTMLAttributes<HTMLOrSVGElement> {
  variant?: "symbol" | "color";
  fill?: string;
}

const ShadcnuiLogo: React.FC<LogoProps> = ({
  variant,
  fill,
  className,
  ...props
}: LogoProps) => {
  const svgClass = className ? ` ${className}` : "";

  if (variant === "symbol") {
    return (
      <svg
        height="1rem"
        viewBox="0 0 56 56"
        className={`${svgClass}`}
        fill={fill}
        {...props}
      >
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M55.2737 27.4906C55.5037 27.7169 55.6864 27.9868 55.8111 28.2844C55.9358 28.5821 56 28.9015 56 29.2242C56 29.5469 55.9358 29.8664 55.8111 30.164C55.6864 30.4617 55.5037 30.7315 55.2737 30.9579L30.9474 55.2819C30.7197 55.5096 30.4494 55.6902 30.1519 55.8134C29.8544 55.9366 29.5356 56 29.2136 56C28.8916 56 28.5727 55.9366 28.2752 55.8134C27.9778 55.6902 27.7075 55.5096 27.4798 55.2819C27.2521 55.0542 27.0715 54.784 26.9482 54.4865C26.825 54.189 26.7616 53.8702 26.7616 53.5483C26.7616 53.2263 26.825 52.9075 26.9482 52.61C27.0715 52.3125 27.2521 52.0423 27.4798 51.8146L51.8061 27.4906C52.0324 27.2606 52.3023 27.0779 52.6 26.9532C52.8977 26.8286 53.2172 26.7644 53.5399 26.7644C53.8626 26.7644 54.1821 26.8286 54.4798 26.9532C54.7775 27.0779 55.0473 27.2606 55.2737 27.4906ZM50.4084 0.731517C50.6385 0.957868 50.8211 1.22772 50.9458 1.52536C51.0705 1.823 51.1347 2.14248 51.1347 2.46517C51.1347 2.78787 51.0705 3.10734 50.9458 3.40497C50.8211 3.70261 50.6385 3.97247 50.4084 4.19882L4.18579 50.4092C3.72596 50.8689 3.10229 51.1273 2.45199 51.1273C1.80168 51.1273 1.178 50.8689 0.718166 50.4092C0.25833 49.9494 2.05563e-08 49.3258 0 48.6755C-2.05563e-08 48.0253 0.25833 47.4016 0.718166 46.9419L46.9408 0.726226C47.1672 0.49623 47.4371 0.313575 47.7347 0.188894C48.0324 0.0642141 48.3519 0 48.6746 0C48.9974 0 49.3169 0.0642141 49.6145 0.188894C49.9122 0.313575 50.1821 0.49623 50.4084 0.726226V0.731517Z"
        />
      </svg>
    );
  } else {
    return (
      <svg
        height="1em"
        viewBox="0 0 157.666 26.395"
        className={`${svgClass}`}
        fill={fill}
        {...props}
      >
        <g id="shadcnui" transform="translate(-31.939 -31.913)">
          <path
            d="M956.385,80.544V67.2h3.153V80.544Zm1.577-15.237a1.835,1.835,0,0,1-1.677-1.046,1.477,1.477,0,0,1-.143-.659,1.577,1.577,0,0,1,.545-1.2,1.784,1.784,0,0,1,1.29-.5,1.87,1.87,0,0,1,1.29.5,1.617,1.617,0,0,1-.014,2.408A1.821,1.821,0,0,1,957.962,65.307Zm-7.955,9.618V67.213h3.153v13.33h-3.053V78.179h-.143A4.014,4.014,0,0,1,948.473,80a4.2,4.2,0,0,1-2.523.717,4.042,4.042,0,0,1-3.87-2.293,5.881,5.881,0,0,1-.573-2.723V67.2h3.154v8.013a2.756,2.756,0,0,0,.688,2.007,2.347,2.347,0,0,0,1.82.76,2.853,2.853,0,0,0,1.347-.344,2.741,2.741,0,0,0,1.061-1,3.12,3.12,0,0,0,.43-1.691ZM939.5,61.91l-5.734,21.314H931l5.734-21.314h2.752Z"
            transform="translate(-770.192 -25.684)"
          />
          <path
            d="M57.992,44.869a1.147,1.147,0,0,1,0,1.634L46.525,57.97a1.155,1.155,0,1,1-1.634-1.634L56.358,44.869a1.147,1.147,0,0,1,1.634,0ZM55.7,32.255a1.147,1.147,0,0,1,0,1.634L33.911,55.677a1.155,1.155,0,0,1-1.634-1.634L54.065,32.255a1.147,1.147,0,0,1,1.634,0Z"
            transform="translate(0 0)"
            fillRule="evenodd"
          />
          <path
            d="M404.84,77.876v7.812H401.7V72.343h3.01v2.265h.143a3.965,3.965,0,0,1,1.476-1.777,4.6,4.6,0,0,1,2.508-.659,4.73,4.73,0,0,1,2.408.588,4.13,4.13,0,0,1,1.605,1.72,5.843,5.843,0,0,1,.559,2.723v8.486h-3.153V77.676a2.952,2.952,0,0,0-.688-2.093,2.437,2.437,0,0,0-1.906-.76,2.917,2.917,0,0,0-1.462.373,2.574,2.574,0,0,0-1,1.032A3.634,3.634,0,0,0,404.84,77.876ZM393.4,85.946a5.863,5.863,0,0,1-5.633-3.3,8,8,0,0,1-.76-3.583,7.883,7.883,0,0,1,.788-3.583A5.757,5.757,0,0,1,390,73.046a6.42,6.42,0,0,1,3.383-.874,6.594,6.594,0,0,1,2.867.6,4.916,4.916,0,0,1,2.867,4.2h-3.01a2.867,2.867,0,0,0-.86-1.62,2.546,2.546,0,0,0-1.82-.645,2.943,2.943,0,0,0-1.691.516,3.452,3.452,0,0,0-1.147,1.476,6.021,6.021,0,0,0-.4,2.322,6.316,6.316,0,0,0,.4,2.336,3.5,3.5,0,0,0,1.132,1.505,2.867,2.867,0,0,0,1.706.516,2.941,2.941,0,0,0,1.247-.258,2.278,2.278,0,0,0,.917-.774,2.884,2.884,0,0,0,.516-1.218h3.01a4.945,4.945,0,0,1-2.8,4.214,6.579,6.579,0,0,1-2.924.6Zm-16.283-.029a5.045,5.045,0,0,1-4.773-3.153,8.744,8.744,0,0,1-.717-3.727,8.863,8.863,0,0,1,.717-3.755,5.357,5.357,0,0,1,2.007-2.322,5.117,5.117,0,0,1,4.716-.387,3.623,3.623,0,0,1,1.19.946,4.979,4.979,0,0,1,.688,1.032h.143V67.9h3.153V85.688h-3.1V83.581h-.2a5.045,5.045,0,0,1-.7,1.032A3.87,3.87,0,0,1,377.118,85.918Zm.889-2.58a2.723,2.723,0,0,0,1.706-.53,3.5,3.5,0,0,0,1.061-1.519,6.45,6.45,0,0,0,.358-2.265,6.284,6.284,0,0,0-.358-2.25,3.211,3.211,0,0,0-1.061-1.491,2.738,2.738,0,0,0-1.72-.53,2.826,2.826,0,0,0-1.749.545,3.42,3.42,0,0,0-1.061,1.519,6.365,6.365,0,0,0-.358,2.207,6.625,6.625,0,0,0,.358,2.222,3.5,3.5,0,0,0,1.075,1.548A2.826,2.826,0,0,0,378.007,83.337Zm-16.039,2.623a5.419,5.419,0,0,1-2.293-.459,3.727,3.727,0,0,1-1.591-1.347,3.985,3.985,0,0,1-.573-2.207,3.775,3.775,0,0,1,.416-1.863,3.113,3.113,0,0,1,1.132-1.19,5.734,5.734,0,0,1,1.62-.674,13.733,13.733,0,0,1,1.892-.33l1.906-.215a3.124,3.124,0,0,0,1.061-.315.762.762,0,0,0,.33-.674v-.043a2.043,2.043,0,0,0-.573-1.534,2.443,2.443,0,0,0-1.691-.53,3.01,3.01,0,0,0-1.82.5,2.494,2.494,0,0,0-.9,1.19l-2.938-.416a4.687,4.687,0,0,1,3.1-3.268,8.342,8.342,0,0,1,4.472-.186,5.123,5.123,0,0,1,1.749.745,3.834,3.834,0,0,1,1.276,1.39,4.718,4.718,0,0,1,.473,2.222v8.93H366V83.854h-.115a3.841,3.841,0,0,1-2.093,1.82A5.391,5.391,0,0,1,361.967,85.961Zm.817-2.308a3.616,3.616,0,0,0,1.634-.373,2.9,2.9,0,0,0,1.075-1,2.63,2.63,0,0,0,.387-1.376V79.324a1.464,1.464,0,0,1-.516.229q-.812.189-1.634.33l-.745.1a5.118,5.118,0,0,0-1.247.315,2.091,2.091,0,0,0-.889.6,1.682,1.682,0,0,0,.315,2.293A2.739,2.739,0,0,0,362.784,83.653Zm-16.513-5.777v7.812h-3.153V67.9H346.2v6.708h.143a4.027,4.027,0,0,1,1.462-1.777,4.443,4.443,0,0,1,2.523-.659,4.921,4.921,0,0,1,2.422.573,3.942,3.942,0,0,1,1.591,1.72,5.8,5.8,0,0,1,.573,2.723v8.5h-3.139V77.676a2.935,2.935,0,0,0-.7-2.093,2.465,2.465,0,0,0-1.921-.76,2.987,2.987,0,0,0-1.491.373,2.646,2.646,0,0,0-1.032,1.032,3.457,3.457,0,0,0-.358,1.648Zm-6.02-2.007-2.867.315a2.293,2.293,0,0,0-1.233-1.433,2.881,2.881,0,0,0-1.233-.229,2.969,2.969,0,0,0-1.648.43,1.284,1.284,0,0,0-.659,1.089,1.147,1.147,0,0,0,.43.946,3.63,3.63,0,0,0,1.462.6l2.279.487a5.734,5.734,0,0,1,2.809,1.29,3.176,3.176,0,0,1,.946,2.322,3.67,3.67,0,0,1-.745,2.222,4.73,4.73,0,0,1-2.007,1.505,7.6,7.6,0,0,1-2.953.53,6.852,6.852,0,0,1-3.942-1.018,4.128,4.128,0,0,1-1.792-2.867l3.067-.315a2.2,2.2,0,0,0,.889,1.376,3.157,3.157,0,0,0,1.763.459,3.242,3.242,0,0,0,1.806-.459,1.359,1.359,0,0,0,.688-1.147,1.19,1.19,0,0,0-.444-.946,3.284,3.284,0,0,0-1.362-.573l-2.279-.473a5.48,5.48,0,0,1-2.838-1.347,3.3,3.3,0,0,1-.9-2.422,3.5,3.5,0,0,1,.659-2.136,4.4,4.4,0,0,1,1.906-1.4,7.382,7.382,0,0,1,2.824-.5,6.057,6.057,0,0,1,3.7,1A4.182,4.182,0,0,1,340.252,75.87Z"
            transform="translate(-254.567 -30.828)"
          />
        </g>
      </svg>
    );
  }
};
export default ShadcnuiLogo;
