interface LogoProps extends React.HTMLAttributes<HTMLOrSVGElement> {
  variant?: "symbol" | "color";
}

const ResendLogo: React.FC<LogoProps> = ({
  variant,
  className,
  ...props
}: LogoProps) => {
  const svgClass = className ? ` ${className}` : "";
  if (variant === "symbol") {
    return (
      <svg
        height="1rem"
        viewBox="0 0 56 56"
        className={`${svgClass}`}
        {...props}
      >
        <path
          d="M5 56V0H29.3557C32.8093 0 35.9277 0.773393 38.7113 2.31998C41.5465 3.86658 43.7629 5.99994 45.3608 8.72007C46.9588 11.3866 47.7577 14.4267 47.7577 17.8399C47.7577 21.36 46.9588 24.5333 45.3608 27.3599C43.7629 30.1333 41.5721 32.3201 38.7885 33.9199C36.0052 35.5199 32.8607 36.32 29.3557 36.32H17.5257V56H5ZM35.0001 56L21.2371 30.72L34.6908 28.7201L50 56H35.0001ZM17.5257 25.92H28.1958C29.5361 25.92 30.6959 25.6267 31.6752 25.0399C32.7062 24.3999 33.4793 23.52 33.9948 22.3999C34.5619 21.28 34.8453 20 34.8453 18.5601C34.8453 17.1199 34.536 15.8666 33.9175 14.8C33.2989 13.68 32.3969 12.8267 31.2114 12.2399C30.0774 11.6533 28.6855 11.3601 27.036 11.3601H17.5257V25.92Z"
          fill="url(#paint0_linear_46_725)"
        />
        <defs>
          <linearGradient
            id="paint0_linear_46_725"
            x1="27.5"
            y1="0"
            x2="27.5"
            y2="56"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#B8DEFF" />
            <stop offset="1" stopColor="#A497FF" />
          </linearGradient>
        </defs>
      </svg>
    );
  } else {
    // TODO: Add default
    return (
      <svg
        height="1rem"
        viewBox="0 0 69 15"
        className={`${svgClass}`}
        {...props}
      >
        <path
          d="M0.202759 14.5199V0.576904H5.9156C9.00254 0.576904 11.0672 2.38951 11.0672 5.21794C11.0672 7.01063 10.125 8.44476 8.66179 9.14191L11.428 14.5199H8.10051L5.73521 9.83906H3.20952V14.5199H0.202759ZM5.67505 3.06671H3.20952V7.34923H5.67505C7.09827 7.34923 8.0003 6.51267 8.0003 5.21794C8.0003 3.90332 7.09827 3.06671 5.67505 3.06671ZM17.4061 14.6394C13.9784 14.6394 11.9138 12.5878 11.9138 9.42078C11.9138 6.2338 14.0185 4.16225 17.2056 4.16225C20.2926 4.16225 22.3773 6.07445 22.4174 9.08213C22.4174 9.38094 22.3973 9.71955 22.3372 10.0383H14.8604V10.1777C14.9205 11.6317 15.8627 12.5081 17.2858 12.5081C18.4284 12.5081 19.2302 12.0102 19.4707 11.0541H22.257C21.9363 13.0459 20.1523 14.6394 17.4061 14.6394ZM14.9205 8.20573H19.571C19.3705 6.95084 18.5086 6.25369 17.2257 6.25369C16.0029 6.25369 15.0809 6.99068 14.9205 8.20573ZM23.4026 11.1138H26.0886C26.1888 12.0102 26.9706 12.6277 28.3537 12.6277C29.5364 12.6277 30.258 12.2492 30.258 11.5321C30.258 10.6956 29.5564 10.6358 27.8927 10.4167C25.4872 10.1378 23.623 9.60003 23.623 7.48864C23.623 5.45697 25.407 4.12241 28.053 4.14235C30.8192 4.14235 32.7235 5.35735 32.8638 7.4488H30.1577C30.0776 6.63214 29.2958 6.13418 28.1532 6.13418C27.0507 6.13418 26.3291 6.53256 26.3291 7.18988C26.3291 7.9667 27.2111 8.04638 28.6944 8.22563C31.0598 8.46466 33.0242 9.00245 33.0242 11.313C33.0242 13.3448 31.0999 14.6394 28.3336 14.6394C25.4672 14.6394 23.5228 13.3049 23.4026 11.1138ZM39.6044 14.6394C36.1767 14.6394 34.1121 12.5878 34.1121 9.42078C34.1121 6.2338 36.2168 4.16225 39.404 4.16225C42.4909 4.16225 44.5756 6.07445 44.6157 9.08213C44.6157 9.38094 44.5956 9.71955 44.5355 10.0383H37.0587V10.1777C37.1188 11.6317 38.0609 12.5081 39.4842 12.5081C40.6267 12.5081 41.4285 12.0102 41.6691 11.0541H44.4553C44.1346 13.0459 42.3506 14.6394 39.6044 14.6394ZM37.1188 8.20573H41.7693C41.5689 6.95084 40.7069 6.25369 39.424 6.25369C38.2013 6.25369 37.2792 6.99068 37.1188 8.20573ZM52.0735 4.16225C54.2986 4.16225 56.2029 5.33746 56.2029 8.84315V14.5199H53.3766V9.12197C53.3766 7.38907 52.7149 6.47283 51.2916 6.47283C49.8285 6.47283 48.9864 7.50858 48.9864 9.28132V14.5199H46.1602V4.28176H48.6258L48.8866 5.55655C49.5478 4.75982 50.4902 4.16225 52.0735 4.16225ZM65.4215 5.55655V0.576904H68.2478V14.5199H65.7822L65.5015 13.1057C64.8199 13.9821 63.8179 14.6394 62.3344 14.6394C59.5683 14.6394 57.5438 12.6277 57.5438 9.38094C57.5438 6.21386 59.5683 4.16225 62.3145 4.16225C63.7374 4.16225 64.7598 4.71998 65.4215 5.55655ZM62.9559 12.3488C64.4995 12.3488 65.4613 11.1537 65.4613 9.42078C65.4613 7.66794 64.4995 6.45289 62.9559 6.45289C61.4124 6.45289 60.4302 7.64799 60.4302 9.40084C60.4302 11.1537 61.4124 12.3488 62.9559 12.3488Z"
          fill="white"
        />
      </svg>
    );
  }
};
export default ResendLogo;
