interface LogoProps extends React.HTMLAttributes<HTMLOrSVGElement> {
  variant?: "symbol" | "color";
  fill?: string;
}

const PrismaLogo: React.FC<LogoProps> = ({
  className,
  fill,
  ...props
}: LogoProps) => (
  <svg
    height="1.8em"
    viewBox="0 0 150.575 59.187"
    className={className}
    fill={fill}
    {...props}
  >
    <g id="prisma" transform="translate(-0.284 0)">
      <path
        d="M199,62.06H203V47.42H199Zm-.17-18.425q0-1.951,2.174-1.951t2.174,1.951a1.9,1.9,0,0,1-.543,1.447,2.284,2.284,0,0,1-1.63.517Q198.835,45.6,198.835,43.635Z"
        transform="translate(-106.742 -22.409)"
      />
      <path
        d="M151.122,55.044a5.849,5.849,0,0,0,1.932-4.727,5.468,5.468,0,0,0-1.814-4.472,8.139,8.139,0,0,0-5.3-1.5h-6.115V63.491h4.059v-6.81h1.742A8.256,8.256,0,0,0,151.122,55.044Zm-5.9-1.689h-1.336V47.672h1.846a3.651,3.651,0,0,1,2.442.681,2.656,2.656,0,0,1,.779,2.109,2.589,2.589,0,0,1-.93,2.154A4.447,4.447,0,0,1,145.223,53.355Z"
        transform="translate(-75.019 -23.84)"
        fillRule="evenodd"
      />
      <path
        d="M183.551,53.611a6.437,6.437,0,0,0-1.349-.118,4.536,4.536,0,0,0-2.521.753,5.506,5.506,0,0,0-1.84,1.984h-.2l-.59-2.462h-3.025v14.64h3.994V60.957a3.552,3.552,0,0,1,1.067-2.75,4.238,4.238,0,0,1,2.98-.982,4.593,4.593,0,0,1,1.179.131ZM202.16,67.492a4.03,4.03,0,0,0,1.565-3.431,4.263,4.263,0,0,0-.38-1.873,3.837,3.837,0,0,0-1.179-1.388,11.6,11.6,0,0,0-2.515-1.3,15.5,15.5,0,0,1-2.494-1.166,1.124,1.124,0,0,1-.57-.93q0-.956,1.768-.956a6.473,6.473,0,0,1,1.951.3q.956.3,2.056.773l1.2-2.881a12.176,12.176,0,0,0-5.146-1.152,7.363,7.363,0,0,0-4.288,1.067,3.476,3.476,0,0,0-1.513,3.018,4.553,4.553,0,0,0,.361,1.918,3.671,3.671,0,0,0,1.153,1.382,11.805,11.805,0,0,0,2.481,1.31q1.178.5,1.886.871a4.2,4.2,0,0,1,1,.668,1.05,1.05,0,0,1,.288.766q0,1.257-2.174,1.257a10.165,10.165,0,0,1-2.455-.353,13.894,13.894,0,0,1-2.508-.878v3.3a10.3,10.3,0,0,0,2.109.635,14.683,14.683,0,0,0,2.724.216,7.728,7.728,0,0,0,4.681-1.179Zm17.388.916h-3.994V59.857a4.314,4.314,0,0,0-.53-2.377,1.867,1.867,0,0,0-1.67-.793,2.418,2.418,0,0,0-2.226,1.126,7.386,7.386,0,0,0-.694,3.706v6.888H206.44V53.768h3.051l.537,1.873h.223a4.057,4.057,0,0,1,1.7-1.578,5.53,5.53,0,0,1,2.554-.57q3.287,0,4.452,2.148h.353a3.957,3.957,0,0,1,1.735-1.585,5.785,5.785,0,0,1,2.586-.563A5.106,5.106,0,0,1,227.4,54.77a5.606,5.606,0,0,1,1.277,4.092v9.547h-4.007V59.857a4.315,4.315,0,0,0-.53-2.377,1.867,1.867,0,0,0-1.67-.793,2.493,2.493,0,0,0-2.194,1.048,5.948,5.948,0,0,0-.726,3.326Z"
        transform="translate(-93.407 -28.758)"
      />
      <path
        d="M147.3,37.66l.773,1.991h2.789V29.895a4.743,4.743,0,0,0-1.571-3.9,6.983,6.983,0,0,0-4.518-1.284,11.9,11.9,0,0,0-5.6,1.323l1.322,2.7a10.378,10.378,0,0,1,4.125-1.061,1.991,1.991,0,0,1,2.279,2.226v.642l-2.54.079a9.452,9.452,0,0,0-4.918,1.224,3.864,3.864,0,0,0-1.63,3.437,4.627,4.627,0,0,0,1.211,3.431,4.5,4.5,0,0,0,3.32,1.2,6.7,6.7,0,0,0,2.782-.491,5.9,5.9,0,0,0,2.076-1.761Zm-1.951-4.74,1.545-.052v1.2a2.8,2.8,0,0,1-.832,2.121,3.068,3.068,0,0,1-2.219.8q-1.938,0-1.938-1.689a1.973,1.973,0,0,1,.851-1.755A4.953,4.953,0,0,1,145.346,32.92ZM44.419,46.947,17.841,54.808a1.114,1.114,0,0,1-1.42-1.281L25.916,8.055a.918.918,0,0,1,1.724-.2l17.58,37.332a1.27,1.27,0,0,1-.8,1.758Zm4.558-1.854L28.621,1.867h0A3.265,3.265,0,0,0,25.838.006a3.231,3.231,0,0,0-2.975,1.542L.787,37.305A3.345,3.345,0,0,0,.826,40.9L11.617,57.612a3.482,3.482,0,0,0,3.9,1.433L46.841,49.78A3.433,3.433,0,0,0,49,47.917a3.359,3.359,0,0,0-.019-2.825Z"
        transform="translate(0 0)"
        fillRule="evenodd"
      />
    </g>
  </svg>
);
export default PrismaLogo;
