interface LogoProps extends React.HTMLAttributes<HTMLOrSVGElement> {
  fill?: string;
}

const PostgresLogo: React.FC<LogoProps> = ({
  fill,
  className,
  ...props
}: LogoProps) => {
  const svgClass = className ? ` ${className}` : "";
  return (
    <svg
      height="1rem"
      viewBox="0 0 18 18"
      className={`${svgClass}`}
      fill={fill}
      {...props}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M8.99458 10.647V17.847C6.75174 17.8456 4.59023 17.0069 2.9335 15.4951C1.27676 13.9833 0.244203 11.9074 0.0380999 9.67405C-0.168003 7.4407 0.467206 5.21088 1.81928 3.42141C3.17136 1.63194 5.14287 0.411795 7.34758 0L8.99458 1.647H13.4946C14.6865 1.647 15.8297 2.11987 16.6734 2.96184C17.517 3.8038 17.9922 4.94609 17.9946 6.138V14.256C17.9922 15.2092 17.6119 16.1226 16.937 16.7958C16.2621 17.469 15.3478 17.847 14.3946 17.847V16.047C14.872 16.047 15.3298 15.8574 15.6674 15.5198C16.0049 15.1822 16.1946 14.7244 16.1946 14.247C16.1946 13.7696 16.0049 13.3118 15.6674 12.9742C15.3298 12.6366 14.872 12.447 14.3946 12.447H10.7946L8.99458 10.647ZM13.9446 7.947C14.3026 7.947 14.646 7.80477 14.8992 7.55159C15.1523 7.29842 15.2946 6.95504 15.2946 6.597C15.2946 6.23896 15.1523 5.89558 14.8992 5.64241C14.646 5.38923 14.3026 5.247 13.9446 5.247C13.5865 5.247 13.2432 5.38923 12.99 5.64241C12.7368 5.89558 12.5946 6.23896 12.5946 6.597C12.5946 6.95504 12.7368 7.29842 12.99 7.55159C13.2432 7.80477 13.5865 7.947 13.9446 7.947Z"
      />
    </svg>
  );
};
export default PostgresLogo;
