interface LogoProps extends React.HTMLAttributes<HTMLOrSVGElement> {
  fill?: string;
}

const NextintlLogo: React.FC<LogoProps> = ({
  fill,
  className,
  ...props
}: LogoProps) => {
  const svgClass = className ? ` ${className}` : "";
  return (
    <svg
      height="1rem"
      viewBox="0 0 141 35"
      className={`${svgClass}`}
      fill={fill}
      {...props}
    >
      <path
        d="M52.1901 26.7111V15.2506C52.3584 15.1833 52.7245 15.1075 53.2882 15.0234C53.852 14.9392 54.5209 14.8972 55.2951 14.8972C56.0187 14.8972 56.6204 14.9855 57.1 15.1622C57.5796 15.3389 57.9667 15.6292 58.2612 16.0331C58.5557 16.437 58.7661 16.9587 58.8923 17.5982C59.0185 18.2377 59.0816 19.0203 59.0816 19.9458V26.7111H60.7224V19.4157C60.7224 18.5238 60.6383 17.7076 60.47 16.9671C60.3017 16.2267 60.0198 15.5914 59.6243 15.0612C59.2288 14.5311 58.6987 14.123 58.034 13.8369C57.3692 13.5508 56.5404 13.4078 55.5475 13.4078C54.3527 13.4078 53.3429 13.4919 52.5183 13.6602C51.6937 13.8285 51.0374 13.98 50.5493 14.1146V26.7111H52.1901ZM70.458 26.9888C71.3331 26.9888 72.0946 26.8962 72.7425 26.7111C73.3904 26.526 73.8322 26.3661 74.0678 26.2315L73.7648 24.8178C73.5292 24.9356 73.1506 25.0787 72.6289 25.247C72.1072 25.4153 71.4004 25.4994 70.5084 25.4994C68.8929 25.4994 67.7148 25.0703 66.9744 24.212C66.2339 23.3537 65.8384 22.1252 65.7879 20.5264H74.9513C74.9681 20.4086 74.9807 20.2824 74.9892 20.1478C74.9976 20.0132 75.0018 19.8785 75.0018 19.7439C75.0018 17.573 74.5264 15.9658 73.5755 14.9224C72.6247 13.879 71.3499 13.3573 69.7511 13.3573C69.0275 13.3573 68.3249 13.4962 67.6433 13.7738C66.9617 14.0515 66.3559 14.4764 65.8258 15.0486C65.2957 15.6208 64.8665 16.3318 64.5384 17.1817C64.2102 18.0316 64.0461 19.0287 64.0461 20.173C64.0461 21.1659 64.1639 22.0789 64.3995 22.912C64.6351 23.745 65.0138 24.4644 65.5355 25.0703C66.0572 25.6761 66.7219 26.1473 67.5297 26.4839C68.3375 26.8205 69.3136 26.9888 70.458 26.9888ZM73.3105 19.1381H65.8384C65.8721 18.5659 65.9857 18.0189 66.1792 17.4972C66.3727 16.9755 66.642 16.517 66.987 16.1215C67.332 15.726 67.7359 15.4104 68.1987 15.1748C68.6615 14.9392 69.1874 14.8214 69.7764 14.8214C70.8871 14.8214 71.7454 15.2001 72.3512 15.9574C72.9571 16.7147 73.2768 17.7749 73.3105 19.1381ZM78.8051 26.7111C79.0071 26.3408 79.2511 25.9159 79.5372 25.4363C79.8233 24.9567 80.1388 24.456 80.4838 23.9343C80.8288 23.4126 81.1864 22.8825 81.5567 22.344C81.9269 21.8054 82.2971 21.2922 82.6674 20.8041C83.0208 21.2922 83.3868 21.8054 83.7655 22.344C84.1441 22.8825 84.5059 23.4126 84.8509 23.9343C85.1959 24.456 85.5114 24.9567 85.7975 25.4363C86.0836 25.9159 86.3277 26.3408 86.5296 26.7111H88.2966C87.9769 26.0884 87.6277 25.4573 87.249 24.8178C86.8704 24.1783 86.4791 23.5599 86.0752 22.9624C85.6713 22.365 85.2674 21.7886 84.8635 21.2333C84.4596 20.6779 84.081 20.1646 83.7276 19.6934L87.8927 13.6602H86.1005L82.6674 18.6584L79.2847 13.6602H77.3662L81.6071 19.7944C80.8162 20.8714 80.042 21.9695 79.2847 23.0887C78.5274 24.2078 77.8038 25.4153 77.1138 26.7111H78.8051ZM95.2302 26.9888C95.9202 26.9888 96.5597 26.892 97.1487 26.6985C97.7377 26.5049 98.15 26.3324 98.3856 26.181L97.9817 24.8178C97.7461 24.9525 97.4179 25.0997 96.9972 25.2596C96.5765 25.4195 96.0211 25.4994 95.3311 25.4994C94.9272 25.4994 94.557 25.4573 94.2204 25.3732C93.8839 25.289 93.5978 25.1208 93.3622 24.8683C93.1265 24.6159 92.9456 24.2583 92.8194 23.7955C92.6932 23.3327 92.6301 22.731 92.6301 21.9906V15.0486H97.8302V13.6602H92.6301V9.52032L90.9893 9.82324V21.8391C90.9893 22.7142 91.0566 23.4715 91.1912 24.111C91.3259 24.7505 91.5573 25.2848 91.8854 25.714C92.2136 26.1431 92.6511 26.4629 93.1981 26.6732C93.745 26.8836 94.4224 26.9888 95.2302 26.9888ZM104.309 20.1983V18.6079H98.6044V20.1983H104.309ZM107.911 10.9844C108.247 10.9844 108.533 10.8708 108.769 10.6436C109.005 10.4165 109.122 10.1093 109.122 9.72227C109.122 9.3352 109.005 9.02807 108.769 8.80088C108.533 8.57369 108.247 8.46009 107.911 8.46009C107.574 8.46009 107.288 8.57369 107.053 8.80088C106.817 9.02807 106.699 9.3352 106.699 9.72227C106.699 10.1093 106.817 10.4165 107.053 10.6436C107.288 10.8708 107.574 10.9844 107.911 10.9844ZM108.744 26.7111V13.6602H107.103V26.7111H108.744ZM114.642 26.7111V15.2506C114.811 15.1833 115.177 15.1075 115.74 15.0234C116.304 14.9392 116.973 14.8972 117.747 14.8972C118.471 14.8972 119.073 14.9855 119.552 15.1622C120.032 15.3389 120.419 15.6292 120.713 16.0331C121.008 16.437 121.218 16.9587 121.344 17.5982C121.471 18.2377 121.534 19.0203 121.534 19.9458V26.7111H123.175V19.4157C123.175 18.5238 123.09 17.7076 122.922 16.9671C122.754 16.2267 122.472 15.5914 122.077 15.0612C121.681 14.5311 121.151 14.123 120.486 13.8369C119.821 13.5508 118.993 13.4078 118 13.4078C116.805 13.4078 115.795 13.4919 114.971 13.6602C114.146 13.8285 113.49 13.98 113.002 14.1146V26.7111H114.642ZM131.421 26.9888C132.111 26.9888 132.75 26.892 133.339 26.6985C133.928 26.5049 134.341 26.3324 134.576 26.181L134.172 24.8178C133.937 24.9525 133.609 25.0997 133.188 25.2596C132.767 25.4195 132.212 25.4994 131.522 25.4994C131.118 25.4994 130.748 25.4573 130.411 25.3732C130.075 25.289 129.788 25.1208 129.553 24.8683C129.317 24.6159 129.136 24.2583 129.01 23.7955C128.884 23.3327 128.821 22.731 128.821 21.9906V15.0486H134.021V13.6602H128.821V9.52032L127.18 9.82324V21.8391C127.18 22.7142 127.247 23.4715 127.382 24.111C127.517 24.7505 127.748 25.2848 128.076 25.714C128.404 26.1431 128.842 26.4629 129.389 26.6732C129.936 26.8836 130.613 26.9888 131.421 26.9888ZM140.273 26.9383L140.5 25.5751C140.163 25.5246 139.873 25.4657 139.629 25.3984C139.385 25.3311 139.187 25.2259 139.036 25.0829C138.884 24.9398 138.771 24.7463 138.695 24.5023C138.619 24.2583 138.582 23.9343 138.582 23.5304V7.12219L136.941 7.42511V23.5809C136.941 24.2036 137.012 24.7211 137.155 25.1334C137.298 25.5457 137.509 25.8823 137.786 26.1431C138.064 26.404 138.409 26.5975 138.821 26.7237C139.234 26.8499 139.717 26.9214 140.273 26.9383Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M6.52997 6.48774C9.29456 3.72315 13.1116 2.01461 17.3291 2.01461C21.5466 2.01461 25.3637 3.72315 28.1282 6.48774C30.8928 9.25232 32.6014 13.0693 32.6014 17.2869C32.6014 20.5456 31.5818 23.564 29.8438 26.043C29.6431 26.3291 29.433 26.6081 29.2137 26.8794H31.1071C33.0038 24.1601 34.116 20.8522 34.116 17.2869C34.116 12.6515 32.2363 8.45377 29.1992 5.41675C26.1622 2.37972 21.9645 0.5 17.3291 0.5C12.6938 0.5 8.49601 2.37972 5.45898 5.41675C2.42196 8.45377 0.542236 12.6515 0.542236 17.2869C0.542236 21.9222 2.42196 26.12 5.45898 29.157C8.49601 32.194 12.6938 34.0737 17.3291 34.0737C21.262 34.0737 24.881 32.7205 27.7424 30.4544C28.0967 30.1738 28.4393 29.8794 28.7693 29.572H27.721V28.4786C27.4255 28.7531 27.119 29.0161 26.8021 29.267L26.8021 29.267C24.1988 31.3287 20.9087 32.5591 17.3291 32.5591C13.1116 32.5591 9.29456 30.8506 6.52997 28.086C3.76538 25.3214 2.05684 21.5044 2.05684 17.2869C2.05684 13.0693 3.76538 9.25232 6.52997 6.48774Z"
        fill="#5FC3E7"
      />
      <path
        d="M28.2004 29.8244C28.6187 29.8244 28.9577 29.4854 28.9577 29.0671C28.9577 28.6489 28.6187 28.3098 28.2004 28.3098C27.7822 28.3098 27.4431 28.6489 27.4431 29.0671C27.4431 29.4854 27.7822 29.8244 28.2004 29.8244Z"
        fill="#5FC3E7"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M3.10959 8.57669L31.0036 8.62118L31.0012 10.1358L3.10718 10.0913L3.10959 8.57669Z"
        fill="#5FC3E7"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M12.6138 6.28593C11.2512 9.06215 10.3869 12.9506 10.3869 17.2869C10.3869 21.6232 11.2512 25.5116 12.6138 28.2878C14.0006 31.1134 15.7734 32.5591 17.4971 32.5591C19.2209 32.5591 20.9937 31.1134 22.3805 28.2878C23.7431 25.5116 24.6074 21.6232 24.6074 17.2869C24.6074 12.9506 23.7431 9.06215 22.3805 6.28593C20.9937 3.46031 19.2209 2.01461 17.4971 2.01461C15.7734 2.01461 14.0006 3.46031 12.6138 6.28593ZM11.2541 5.61858C12.7148 2.64263 14.8758 0.5 17.4971 0.5C20.1185 0.5 22.2795 2.64263 23.7402 5.61858C25.225 8.64393 26.122 12.7703 26.122 17.2869C26.122 21.8035 25.225 25.9298 23.7402 28.9552C22.2795 31.9311 20.1185 34.0737 17.4971 34.0737C14.8758 34.0737 12.7148 31.9311 11.2541 28.9552C9.76925 25.9298 8.87231 21.8035 8.87231 17.2869C8.87231 12.7703 9.76925 8.64393 11.2541 5.61858Z"
        fill="#5FC3E7"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M0.5 17.0765H33.9896V18.5911H0.5V17.0765ZM3.90786 25.3648H31.0025V26.8794H3.90786V25.3648Z"
        fill="#5FC3E7"
      />
    </svg>
  );
};
export default NextintlLogo;
