interface LogoProps extends React.HTMLAttributes<HTMLOrSVGElement> {
  variant?: "symbol" | "color";
}

const NextLogo: React.FC<LogoProps> = ({
  variant,
  className,
  ...props
}: LogoProps) => {
  const svgClass = className ? ` ${className}` : "";
  if (variant === "symbol") {
    return (
      <svg
        height="1rem"
        viewBox="0 0 56 56"
        className={`${svgClass}`}
        {...props}
      >
        <path
          d="M28 56C43.464 56 56 43.464 56 28C56 12.536 43.464 0 28 0C12.536 0 0 12.536 0 28C0 43.464 12.536 56 28 56Z"
          fill="transparent"
        />

        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M28 1.86667C13.567 1.86667 1.86667 13.567 1.86667 28C1.86667 42.433 13.567 54.1333 28 54.1333C42.433 54.1333 54.1333 42.433 54.1333 28C54.1333 13.567 42.433 1.86667 28 1.86667ZM0 28C0 12.536 12.536 0 28 0C43.464 0 56 12.536 56 28C56 43.464 43.464 56 28 56C12.536 56 0 43.464 0 28Z"
          fill="url(#paint0_linear_50_739)"
        />
        <path
          d="M46.5136 49.006L21.5109 16.7998H16.8V39.1905H20.5687V21.5858L43.5553 51.2849C44.5925 50.5908 45.5806 49.8289 46.5136 49.006Z"
          fill="url(#paint1_linear_50_739)"
        />
        <path
          d="M39.5111 16.7998H35.7778V39.1998H39.5111V16.7998Z"
          fill="url(#paint2_linear_50_739)"
        />

        <defs>
          <linearGradient
            id="paint0_linear_50_739"
            x1="28"
            y1="0"
            x2="28"
            y2="56"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#B8DDFF" />
            <stop offset="1" stopColor="#A598FF" />
          </linearGradient>
          <linearGradient
            id="paint1_linear_50_739"
            x1="33.9112"
            y1="36.2443"
            x2="44.9556"
            y2="49.9331"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#B8DDFF" />
            <stop offset="1" stopColor="#A59AFF" stopOpacity="0" />
          </linearGradient>
          <linearGradient
            id="paint2_linear_50_739"
            x1="37.6444"
            y1="16.7998"
            x2="37.5819"
            y2="33.2498"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#B8DDFF" />
            <stop offset="1" stopColor="#A598FF" stopOpacity="0" />
          </linearGradient>
        </defs>
      </svg>
    );
  } else {
    return (
      <svg
        height="1rem"
        viewBox="0 0 130.926 26.395"
        className={`${svgClass}`}
        {...props}
      >
        <path
          d="M109.84.011V4.22h-9.046V26.364H96.27V4.22H87.035V.011Zm1.017,23.843a1.158,1.158,0,0,1,.833.344,1.118,1.118,0,0,1,.362.824,1.143,1.143,0,0,1-.169.595,1.221,1.221,0,0,1-.438.426,1.131,1.131,0,0,1-.588.16,1.172,1.172,0,0,1-.849-.344,1.107,1.107,0,0,1-.35-.837,1.1,1.1,0,0,1,.35-.824A1.172,1.172,0,0,1,110.857,23.854ZM21.2,26.364,4.523,5.633v20.72H0V0H5.654L26.726,26.167V4.22l0-4.209h22.8V4.22H31.25v6.771h14.7V15.2H31.25v6.954H49.53v4.209Zm42.824-11.2,2.964,3.686L60.917,26.4H54.98ZM60.917.022l7.653,9.5L76.2.051,82.12.042,71.534,13.208l10.6,13.168H76.2L55,.022ZM118.577,15.1h2v7.722a3.568,3.568,0,0,1-.457,1.827,3.039,3.039,0,0,1-1.263,1.175,4.111,4.111,0,0,1-1.879.411,4.317,4.317,0,0,1-1.759-.347,2.831,2.831,0,0,1-1.238-1.027,2.954,2.954,0,0,1-.457-1.694h2.008a1.5,1.5,0,0,0,.2.767,1.281,1.281,0,0,0,.533.492,1.746,1.746,0,0,0,.791.172,1.559,1.559,0,0,0,.821-.2,1.284,1.284,0,0,0,.515-.6,2.46,2.46,0,0,0,.181-.975Zm10.252,3.02a1.456,1.456,0,0,0-.637-1.093,2.5,2.5,0,0,0-1.462-.393,2.836,2.836,0,0,0-1.082.187,1.626,1.626,0,0,0-.693.51,1.247,1.247,0,0,0-.245.734,1.075,1.075,0,0,0,.162.595,1.334,1.334,0,0,0,.438.426,2.926,2.926,0,0,0,.613.293q.34.118.68.2l1.045.257a7.224,7.224,0,0,1,1.217.393,4.308,4.308,0,0,1,1.051.622,2.786,2.786,0,0,1,.736.906A2.7,2.7,0,0,1,130.926,23a2.932,2.932,0,0,1-.5,1.7,3.293,3.293,0,0,1-1.447,1.142,5.732,5.732,0,0,1-2.283.411,5.817,5.817,0,0,1-2.253-.4,3.2,3.2,0,0,1-2.072-3.011h1.986a1.666,1.666,0,0,0,.359.954,1.931,1.931,0,0,0,.824.568,3.314,3.314,0,0,0,1.14.187,3.182,3.182,0,0,0,1.158-.2,1.811,1.811,0,0,0,.779-.547,1.279,1.279,0,0,0,.288-.821,1.057,1.057,0,0,0-.255-.713,1.953,1.953,0,0,0-.7-.471,7.179,7.179,0,0,0-1.048-.341l-1.269-.32a5.088,5.088,0,0,1-2.173-1.06,2.4,2.4,0,0,1-.8-1.891,2.787,2.787,0,0,1,.537-1.7,3.487,3.487,0,0,1,1.459-1.133,5.163,5.163,0,0,1,2.1-.4,4.98,4.98,0,0,1,2.081.4,3.391,3.391,0,0,1,1.407,1.12,2.835,2.835,0,0,1,.527,1.643Z"
          fill="currentColor"
        />
      </svg>
    );
  }
};
export default NextLogo;
