interface LogoProps extends React.HTMLAttributes<HTMLOrSVGElement> {
  fill?: string;
}

const MysqlLogo: React.FC<LogoProps> = ({
  fill,
  className,
  ...props
}: LogoProps) => {
  const svgClass = className ? ` ${className}` : "";
  return (
    <svg
      height="1rem"
      viewBox="0 0 18 18"
      className={`${svgClass}`}
      fill={fill}
      {...props}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M1.74141 2.1637C1.82204 2.491 2.09424 3.0117 2.75476 3.68977C2.90634 3.84538 2.99317 4.05274 2.99768 4.2699C3.01681 5.19181 3.48843 5.85007 4.85647 7.07804C5.09991 7.29655 5.19771 7.63453 5.10857 7.94923C5.09709 7.98977 5.08552 8.03056 5.07388 8.07157C4.82897 8.93495 4.55596 9.89741 4.47018 10.7396C4.42942 11.1399 4.43771 11.4596 4.48703 11.6969C4.4974 11.686 4.5079 11.6748 4.51851 11.6635C4.8024 11.3594 5.09166 10.9741 5.27333 10.6863C5.46119 10.3888 5.81191 10.2363 6.15774 10.3017C6.50357 10.3672 6.77424 10.6373 6.84029 10.9829C6.98329 11.7312 7.45801 12.6809 8.08875 13.5842C8.71683 14.4836 9.42183 15.2264 9.92773 15.59C10.3121 15.8663 10.3997 16.4018 10.1233 16.7861C9.84693 17.1704 9.31126 17.258 8.92685 16.9817C8.20944 16.466 7.37566 15.5573 6.68293 14.5653C6.32337 14.0504 5.98062 13.483 5.70529 12.9033C5.54243 13.0726 5.36408 13.2387 5.18185 13.3729C5.01487 13.4958 4.68622 13.7148 4.28375 13.7148C4.13001 13.7148 3.9791 13.6735 3.84682 13.5951C3.28023 13.2596 2.98126 12.7295 2.8424 12.1919C2.70773 11.6705 2.71007 11.1003 2.76449 10.566C2.85247 9.70218 3.09777 8.76452 3.31476 7.99112C2.23779 6.98382 1.44404 6.01466 1.30447 4.64964C0.656441 3.93543 0.239806 3.23593 0.0766362 2.57359C-0.111216 1.81106 0.0378164 1.04593 0.617677 0.528002C1.15944 0.0440994 1.90707 -0.0681577 2.60591 0.0353062C3.24056 0.129268 3.91351 0.407026 4.56393 0.859637H5.141C5.15783 0.859637 5.17465 0.860132 5.19145 0.861122C7.14104 0.976014 8.57749 1.50431 9.63937 2.35531C10.6969 3.20279 11.2994 4.30394 11.7019 5.40978C11.9958 6.21719 12.2015 7.08938 12.3886 7.88239C12.4509 8.14659 12.5112 8.402 12.5719 8.6433C12.7964 9.53501 13.0322 10.2632 13.3815 10.8234C15.0891 11.3202 16.2831 12.5132 17.1924 13.4217C17.3825 13.6116 17.5602 13.7892 17.7275 13.9453C17.9959 14.1957 18.075 14.5892 17.9242 14.9238C17.7734 15.2584 17.4262 15.4599 17.0608 15.4249C16.7704 15.3971 16.5181 15.3714 16.2958 15.3487C16.049 15.3235 15.8392 15.3021 15.6553 15.2858C15.7138 15.3318 15.7757 15.3773 15.8412 15.4225C16.0753 15.5845 16.3398 15.734 16.6387 15.8943C16.7113 15.9333 16.7872 15.9735 16.8653 16.0149C17.094 16.1361 17.3407 16.2668 17.5732 16.4018C17.9826 16.6396 18.1217 17.1641 17.8838 17.5734C17.646 17.9826 17.1213 18.1216 16.712 17.8839C16.5107 17.767 16.3079 17.6595 16.0885 17.5433C16.0044 17.4987 15.9179 17.4529 15.8282 17.4047C15.5178 17.2383 15.1828 17.0515 14.8656 16.832C14.2213 16.3863 13.5987 15.7703 13.3192 14.8116C13.2018 14.4091 13.393 13.9809 13.771 13.7993C14.118 13.6326 14.4539 13.562 14.8132 13.5428C14.1948 13.0217 13.5267 12.6036 12.6662 12.4079C12.4684 12.363 12.293 12.2494 12.1711 12.0873C11.5061 11.2031 11.1699 10.0967 10.9093 9.06165C10.8348 8.76597 10.7665 8.47637 10.6993 8.19203C10.5188 7.4272 10.3472 6.70042 10.0907 5.99587C9.74965 5.0588 9.29235 4.27399 8.56699 3.69267C7.84955 3.11771 6.78707 2.67588 5.11529 2.57366H4.28375C4.09435 2.57366 3.91028 2.51095 3.76029 2.39534C3.22288 1.98108 2.72774 1.78606 2.35473 1.73084C1.9664 1.67334 1.79752 1.77266 1.75999 1.80618C1.74504 1.81954 1.73227 1.83582 1.72321 1.87229C1.71279 1.91423 1.70263 2.00632 1.74141 2.1637ZM4.096 12.0372C4.09606 12.0369 4.09981 12.0348 4.10705 12.0317C4.09955 12.036 4.09594 12.0375 4.096 12.0372ZM5.141 4.28768C5.141 3.81437 5.52481 3.43067 5.99826 3.43067H6.00683C6.48028 3.43067 6.86409 3.81437 6.86409 4.28768C6.86409 4.761 6.48028 5.14469 6.00683 5.14469H5.99826C5.52481 5.14469 5.141 4.761 5.141 4.28768Z"
      />
    </svg>
  );
};
export default MysqlLogo;
