interface LogoProps extends React.HTMLAttributes<HTMLOrSVGElement> {
  variant?: "symbol" | "color";
}

const LemonSqueezyLogo: React.FC<LogoProps> = ({
  variant,
  className,
  ...props
}: LogoProps) => {
  const svgClass = className ? ` ${className}` : "";
  if (variant === "symbol") {
    return (
      <svg
        height="1rem"
        viewBox="0 0 56 56"
        className={`${svgClass}`}
        {...props}
      >
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M21.8575 34.3707L36.8799 41.316C38.7419 42.1772 40.056 43.6226 40.7658 45.2806C42.561 49.4791 40.1074 53.7731 36.2559 55.3175C32.4035 56.8611 28.298 55.8677 26.4312 51.5015L19.8934 36.1727C19.3868 34.9845 20.6595 33.8169 21.8575 34.3707Z"
          fill="url(#paint0_linear_46_723)"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M22.758 29.8746L38.2651 24.0127C43.4188 22.0645 49.0485 25.7507 48.9725 31.1066C48.9713 31.1766 48.9701 31.2464 48.9683 31.317C48.8569 36.5326 43.3838 40.0381 38.3433 38.1929L22.7726 32.494C21.5306 32.0396 21.5214 30.342 22.758 29.8746Z"
          fill="url(#paint1_linear_46_723)"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M21.8898 27.8446L37.1339 21.3672C42.1994 19.2146 43.485 12.7538 39.5177 9.02084C39.4657 8.97168 39.4137 8.9231 39.3611 8.87454C35.4713 5.26416 29.0414 6.53534 26.827 11.2907L19.9863 25.9828C19.4405 27.1544 20.6741 28.361 21.8898 27.8446Z"
          fill="url(#paint2_linear_46_723)"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M17.9669 25.2849L23.5091 10.0882C24.1963 8.20391 24.069 6.28233 23.3586 4.62435C21.5597 0.427556 16.6881 -0.927148 12.837 0.619475C8.98656 2.1667 6.81077 5.68052 8.68124 10.0449L15.2618 25.3571C15.7721 26.5437 17.5251 26.4969 17.9669 25.2849Z"
          fill="url(#paint3_linear_46_723)"
        />
        <defs>
          <linearGradient
            id="paint0_linear_46_723"
            x1="30.5721"
            y1="34.229"
            x2="30.5721"
            y2="55.9999"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#B9E2FF" />
            <stop offset="1" stopColor="#A293FF" />
          </linearGradient>
          <linearGradient
            id="paint1_linear_46_723"
            x1="35.4045"
            y1="23.4849"
            x2="35.4045"
            y2="38.6907"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#B9E2FF" />
            <stop offset="1" stopColor="#A293FF" />
          </linearGradient>
          <linearGradient
            id="paint2_linear_46_723"
            x1="30.8524"
            y1="6.79492"
            x2="30.8524"
            y2="27.9674"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#B9E2FF" />
            <stop offset="1" stopColor="#A293FF" />
          </linearGradient>
          <linearGradient
            id="paint3_linear_46_723"
            x1="15.9815"
            y1="0"
            x2="15.9815"
            y2="26.221"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#B9E2FF" />
            <stop offset="1" stopColor="#A293FF" />
          </linearGradient>
        </defs>
      </svg>
    );
  } else if (variant === "color") {
    return (
      <svg
        height="21"
        viewBox="0 0 159 21"
        className={`${svgClass}`}
        {...props}
      >
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M31.9381 10.3906H36.6657C36.3509 9.18957 35.4883 8.70259 34.4379 8.70259C33.2829 8.70259 32.3572 9.33214 31.9381 10.3906ZM39.4394 12.4446H31.7704C32.0852 13.9916 33.3873 14.5616 34.5217 14.5616C35.9505 14.5616 36.5613 13.7068 36.5613 13.7068H39.2083C38.4093 15.7409 36.498 16.8591 34.438 16.8591C31.601 16.8591 29.1218 14.7637 29.1218 11.5914C29.1218 8.43762 31.5804 6.48462 34.354 6.48462C37.0439 6.48462 39.7764 8.29497 39.4394 12.4446Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M65.4922 11.6725C65.4922 10.0856 64.5256 8.84502 62.929 8.84502C61.3312 8.84502 60.2599 10.0856 60.2599 11.6725C60.2599 13.2594 61.3312 14.5001 62.929 14.5001C64.5256 14.5001 65.4922 13.2594 65.4922 11.6725ZM57.5068 11.6923C57.5068 8.43762 60.1127 6.48462 62.929 6.48462C65.7659 6.48462 68.2451 8.45742 68.2451 11.651C68.2451 14.8861 65.6803 16.8589 62.8436 16.8589C59.986 16.8589 57.5068 14.8861 57.5068 11.6923Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M79.4932 11.2454V16.758H76.6972V11.8549C76.6972 11.5088 76.9507 8.94604 74.933 8.84524C73.9441 8.78389 72.1798 9.31212 72.1798 11.9775V16.758H69.4065V6.58569H71.9524L71.9608 7.99782C71.9608 7.99782 73.1087 6.48462 75.2497 6.48462C77.9602 6.48462 79.4932 8.43762 79.4932 11.2454Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M89.7128 8.64132C88.83 8.64132 88.452 9.06867 88.452 9.49609C88.452 10.1869 89.3978 10.3906 90.0278 10.5132C91.8998 10.899 93.7905 11.4491 93.7905 13.604C93.7905 15.6996 92.004 16.8591 89.8395 16.8591C87.4238 16.8591 85.5533 15.4362 85.4265 13.2795H88.0103C88.074 13.889 88.4948 14.6824 89.7765 14.6824C90.8475 14.6824 91.101 14.1342 91.101 13.7068C91.101 12.9531 90.3645 12.7294 89.6498 12.567C88.4108 12.3021 85.7415 11.8152 85.7415 9.49609C85.7415 7.50177 87.7178 6.48462 89.7555 6.48462C92.1083 6.48462 93.6638 7.86784 93.7905 9.57717H91.2045C91.1213 9.23104 90.786 8.64132 89.7128 8.64132Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M102.286 11.6725C102.286 9.98299 101.339 8.98737 99.9742 8.98737C98.6925 8.98737 97.4092 9.88189 97.4092 11.6725C97.4092 13.4616 98.6925 14.3577 99.9742 14.3577C101.339 14.3577 102.286 13.3605 102.286 11.6725ZM104.912 6.58569V20.8262H102.286V15.7607C101.614 16.4928 100.667 16.8589 99.5737 16.8589C96.9067 16.8589 94.6785 14.7438 94.6785 11.6725C94.6785 8.59977 96.9067 6.48462 99.5737 6.48462C101.671 6.48462 102.456 7.84699 102.456 7.84699L102.451 6.58569H104.912Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M119.928 10.3906H124.656C124.341 9.18957 123.479 8.70259 122.429 8.70259C121.274 8.70259 120.347 9.33214 119.928 10.3906ZM127.43 12.4446H119.759C120.076 13.9916 121.378 14.5616 122.512 14.5616C123.941 14.5616 124.552 13.7068 124.552 13.7068H127.199C126.4 15.7409 124.488 16.8591 122.429 16.8591C119.591 16.8591 117.112 14.7637 117.112 11.5914C117.112 8.43762 119.571 6.48462 122.345 6.48462C125.034 6.48462 127.767 8.29497 127.43 12.4446Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M131.092 10.3906H135.82C135.505 9.18957 134.643 8.70259 133.592 8.70259C132.437 8.70259 131.512 9.33214 131.092 10.3906ZM138.594 12.4446H130.925C131.239 13.9916 132.541 14.5616 133.676 14.5616C135.105 14.5616 135.715 13.7068 135.715 13.7068H138.363C137.563 15.7409 135.652 16.8591 133.592 16.8591C130.756 16.8591 128.276 14.7637 128.276 11.5914C128.276 8.43762 130.735 6.48462 133.508 6.48462C136.198 6.48462 138.931 8.29497 138.594 12.4446Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M147.95 14.4801V16.7576H139.02V15.4144L144.085 8.86473H139.231V6.58545H147.741V7.92865L142.676 14.4801H147.95Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M158.883 6.58545V15.537V15.7407C158.883 18.4872 157.432 20.9289 153.839 20.9289C150.477 20.9289 148.649 18.7919 148.649 17.1852H151.276C151.276 17.1852 151.675 18.5484 153.755 18.5484C155.521 18.5484 156.257 17.571 156.257 16.1481V15.7207C155.793 16.2294 154.912 16.8589 153.336 16.8589C150.583 16.8589 148.86 14.9274 148.86 12.0997L148.838 6.58545H151.57V11.4886C151.57 12.8716 152.075 14.5001 153.818 14.5001C154.722 14.5001 156.214 14.0727 156.214 11.366V6.58545H158.883Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M27.1219 13.7042C27.1219 14.3386 27.3718 14.6002 27.8355 14.6002C28.1622 14.6002 28.3745 14.5623 28.684 14.4694L28.857 16.5599C28.2785 16.7454 27.7192 16.858 27.0056 16.858C25.3682 16.858 24.3655 16.3363 24.3655 14.077V2.51733H27.1219V13.7042Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M56.3208 11.2454V16.758H53.5249V11.8549C53.5249 10.4519 53.6723 8.6813 51.7386 8.84525C51.2357 8.885 49.848 9.10842 49.848 11.9775V16.758H47.0744V11.8549C47.0744 10.4519 47.2215 8.6813 45.2881 8.84525C44.7833 8.885 43.3974 9.10842 43.3974 11.9775V16.758H40.6238V6.58568H43.17L43.1724 7.99782C43.1724 7.99782 44.1454 6.48461 45.9604 6.48461C48.1475 6.48461 49.0059 8.13192 49.0059 8.13192C49.0059 8.13192 49.9476 6.46484 52.3494 6.46484C55.0804 6.46484 56.3208 8.41782 56.3208 11.2454Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M106.091 12.0981V6.58545H108.887V11.4886C108.887 11.8347 108.634 14.3974 110.651 14.4983C111.64 14.5596 113.404 14.0313 113.404 11.366V6.58545H116.178V16.7578H113.636L113.623 15.3457C113.623 15.3457 112.475 16.8589 110.335 16.8589C107.624 16.8589 106.091 14.9059 106.091 12.0981Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M5.19661 12.8891L10.8301 15.4936C11.5283 15.8166 12.0211 16.3586 12.2873 16.9803C12.9605 18.5548 12.0404 20.1651 10.5961 20.7442C9.15142 21.3231 7.61182 20.9505 6.91176 19.3132L4.46008 13.5648C4.27009 13.1193 4.74735 12.6814 5.19661 12.8891Z"
          fill="#FFC233"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M5.53429 11.2033L11.3495 9.00507C13.2822 8.27449 15.3934 9.65682 15.3649 11.6653C15.3644 11.6916 15.364 11.7177 15.3633 11.7442C15.3215 13.7001 13.2691 15.0147 11.3788 14.3227L5.5398 12.1856C5.07402 12.0152 5.07058 11.3786 5.53429 11.2033Z"
          fill="#FFC233"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M5.20874 10.4418L10.9253 8.01278C12.8249 7.20552 13.307 4.78271 11.8193 3.38282C11.7997 3.36439 11.7803 3.34617 11.7605 3.32796C10.3019 1.97405 7.8906 2.45075 7.06019 4.23404L4.49492 9.74363C4.29025 10.183 4.75283 10.6355 5.20874 10.4418Z"
          fill="#FFC233"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M3.73762 9.48195L5.81599 3.78311C6.07367 3.0765 6.02594 2.3559 5.75954 1.73415C5.08496 0.160335 3.25807 -0.347684 1.8139 0.232306C0.369963 0.81252 -0.445965 2.13022 0.255467 3.7669L2.72321 9.50903C2.91458 9.954 3.57196 9.93645 3.73762 9.48195Z"
          fill="#FFC233"
        />
      </svg>
    );
  } else {
    return (
      <svg
        height="21"
        viewBox="0 0 159 21"
        className={`${svgClass}`}
        {...props}
      >
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M31.9381 10.3906H36.6657C36.3509 9.18957 35.4883 8.70259 34.4379 8.70259C33.2829 8.70259 32.3572 9.33214 31.9381 10.3906ZM39.4394 12.4446H31.7704C32.0852 13.9916 33.3873 14.5616 34.5217 14.5616C35.9505 14.5616 36.5613 13.7068 36.5613 13.7068H39.2083C38.4093 15.7409 36.498 16.8591 34.438 16.8591C31.601 16.8591 29.1218 14.7637 29.1218 11.5914C29.1218 8.43762 31.5804 6.48462 34.354 6.48462C37.0439 6.48462 39.7764 8.29497 39.4394 12.4446Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M65.4922 11.6725C65.4922 10.0856 64.5256 8.84502 62.929 8.84502C61.3312 8.84502 60.2599 10.0856 60.2599 11.6725C60.2599 13.2594 61.3312 14.5001 62.929 14.5001C64.5256 14.5001 65.4922 13.2594 65.4922 11.6725ZM57.5068 11.6923C57.5068 8.43762 60.1127 6.48462 62.929 6.48462C65.7659 6.48462 68.2451 8.45742 68.2451 11.651C68.2451 14.8861 65.6803 16.8589 62.8436 16.8589C59.986 16.8589 57.5068 14.8861 57.5068 11.6923Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M79.4932 11.2454V16.758H76.6972V11.8549C76.6972 11.5088 76.9507 8.94604 74.933 8.84524C73.9441 8.78389 72.1798 9.31212 72.1798 11.9775V16.758H69.4065V6.58569H71.9524L71.9608 7.99782C71.9608 7.99782 73.1087 6.48462 75.2497 6.48462C77.9602 6.48462 79.4932 8.43762 79.4932 11.2454Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M89.7128 8.64132C88.83 8.64132 88.452 9.06867 88.452 9.49609C88.452 10.1869 89.3978 10.3906 90.0278 10.5132C91.8998 10.899 93.7905 11.4491 93.7905 13.604C93.7905 15.6996 92.004 16.8591 89.8395 16.8591C87.4238 16.8591 85.5533 15.4362 85.4265 13.2795H88.0103C88.074 13.889 88.4948 14.6824 89.7765 14.6824C90.8475 14.6824 91.101 14.1342 91.101 13.7068C91.101 12.9531 90.3645 12.7294 89.6498 12.567C88.4108 12.3021 85.7415 11.8152 85.7415 9.49609C85.7415 7.50177 87.7178 6.48462 89.7555 6.48462C92.1083 6.48462 93.6638 7.86784 93.7905 9.57717H91.2045C91.1213 9.23104 90.786 8.64132 89.7128 8.64132Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M102.286 11.6725C102.286 9.98299 101.339 8.98737 99.9742 8.98737C98.6925 8.98737 97.4092 9.88189 97.4092 11.6725C97.4092 13.4616 98.6925 14.3577 99.9742 14.3577C101.339 14.3577 102.286 13.3605 102.286 11.6725ZM104.912 6.58569V20.8262H102.286V15.7607C101.614 16.4928 100.667 16.8589 99.5737 16.8589C96.9067 16.8589 94.6785 14.7438 94.6785 11.6725C94.6785 8.59977 96.9067 6.48462 99.5737 6.48462C101.671 6.48462 102.456 7.84699 102.456 7.84699L102.451 6.58569H104.912Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M119.928 10.3906H124.656C124.341 9.18957 123.479 8.70259 122.429 8.70259C121.274 8.70259 120.347 9.33214 119.928 10.3906ZM127.43 12.4446H119.759C120.076 13.9916 121.378 14.5616 122.512 14.5616C123.941 14.5616 124.552 13.7068 124.552 13.7068H127.199C126.4 15.7409 124.488 16.8591 122.429 16.8591C119.591 16.8591 117.112 14.7637 117.112 11.5914C117.112 8.43762 119.571 6.48462 122.345 6.48462C125.034 6.48462 127.767 8.29497 127.43 12.4446Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M131.092 10.3906H135.82C135.505 9.18957 134.643 8.70259 133.592 8.70259C132.437 8.70259 131.512 9.33214 131.092 10.3906ZM138.594 12.4446H130.925C131.239 13.9916 132.541 14.5616 133.676 14.5616C135.105 14.5616 135.715 13.7068 135.715 13.7068H138.363C137.563 15.7409 135.652 16.8591 133.592 16.8591C130.756 16.8591 128.276 14.7637 128.276 11.5914C128.276 8.43762 130.735 6.48462 133.508 6.48462C136.198 6.48462 138.931 8.29497 138.594 12.4446Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M147.95 14.4801V16.7576H139.02V15.4144L144.085 8.86473H139.231V6.58545H147.741V7.92865L142.676 14.4801H147.95Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M158.883 6.58545V15.537V15.7407C158.883 18.4872 157.432 20.9289 153.839 20.9289C150.477 20.9289 148.649 18.7919 148.649 17.1852H151.276C151.276 17.1852 151.675 18.5484 153.755 18.5484C155.521 18.5484 156.257 17.571 156.257 16.1481V15.7207C155.793 16.2294 154.912 16.8589 153.336 16.8589C150.583 16.8589 148.86 14.9274 148.86 12.0997L148.838 6.58545H151.57V11.4886C151.57 12.8716 152.075 14.5001 153.818 14.5001C154.722 14.5001 156.214 14.0727 156.214 11.366V6.58545H158.883Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M27.1219 13.7042C27.1219 14.3386 27.3718 14.6002 27.8355 14.6002C28.1622 14.6002 28.3745 14.5623 28.684 14.4694L28.857 16.5599C28.2785 16.7454 27.7192 16.858 27.0056 16.858C25.3682 16.858 24.3655 16.3363 24.3655 14.077V2.51733H27.1219V13.7042Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M56.3208 11.2454V16.758H53.5249V11.8549C53.5249 10.4519 53.6723 8.6813 51.7386 8.84525C51.2357 8.885 49.848 9.10842 49.848 11.9775V16.758H47.0744V11.8549C47.0744 10.4519 47.2215 8.6813 45.2881 8.84525C44.7833 8.885 43.3974 9.10842 43.3974 11.9775V16.758H40.6238V6.58568H43.17L43.1724 7.99782C43.1724 7.99782 44.1454 6.48461 45.9604 6.48461C48.1475 6.48461 49.0059 8.13192 49.0059 8.13192C49.0059 8.13192 49.9476 6.46484 52.3494 6.46484C55.0804 6.46484 56.3208 8.41782 56.3208 11.2454Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M106.091 12.0981V6.58545H108.887V11.4886C108.887 11.8347 108.634 14.3974 110.651 14.4983C111.64 14.5596 113.404 14.0313 113.404 11.366V6.58545H116.178V16.7578H113.636L113.623 15.3457C113.623 15.3457 112.475 16.8589 110.335 16.8589C107.624 16.8589 106.091 14.9059 106.091 12.0981Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M5.19661 12.8891L10.8301 15.4936C11.5283 15.8166 12.0211 16.3586 12.2873 16.9803C12.9605 18.5548 12.0404 20.1651 10.5961 20.7442C9.15142 21.3231 7.61182 20.9505 6.91176 19.3132L4.46008 13.5648C4.27009 13.1193 4.74735 12.6814 5.19661 12.8891Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M5.53429 11.2033L11.3495 9.00507C13.2822 8.27449 15.3934 9.65682 15.3649 11.6653C15.3644 11.6916 15.364 11.7177 15.3633 11.7442C15.3215 13.7001 13.2691 15.0147 11.3788 14.3227L5.5398 12.1856C5.07402 12.0152 5.07058 11.3786 5.53429 11.2033Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M5.20874 10.4418L10.9253 8.01278C12.8249 7.20552 13.307 4.78271 11.8193 3.38282C11.7997 3.36439 11.7803 3.34617 11.7605 3.32796C10.3019 1.97405 7.8906 2.45075 7.06019 4.23404L4.49492 9.74363C4.29025 10.183 4.75283 10.6355 5.20874 10.4418Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M3.73762 9.48195L5.81599 3.78311C6.07367 3.0765 6.02594 2.3559 5.75954 1.73415C5.08496 0.160335 3.25807 -0.347684 1.8139 0.232306C0.369963 0.81252 -0.445965 2.13022 0.255467 3.7669L2.72321 9.50903C2.91458 9.954 3.57196 9.93645 3.73762 9.48195Z"
          fill="currentColor"
        />
      </svg>
    );
  }
};
export default LemonSqueezyLogo;
