interface LogoProps extends React.HTMLAttributes<HTMLOrSVGElement> {
  variant?: "symbol" | "color";
}

const NextAuthLogo: React.FC<LogoProps> = ({
  variant,
  className,
  ...props
}: LogoProps) => {
  const svgClass = className ? ` ${className}` : "";
  if (variant === "symbol") {
    return (
      <svg
        height="1rem"
        viewBox="0 0 56 56"
        className={`${svgClass}`}
        {...props}
      >
        <path
          d="M3.02246 7.38889L28.3002 0L53.1892 7.38889C53.1892 42.8556 36.5965 54.5741 28.3002 56C7.14468 49.4667 2.63357 20.8704 3.02246 7.38889Z"
          fill="url(#paint0_linear_46_722)"
        />
        <path
          d="M28.3003 56C15.4669 51.7223 10.002 39.6667 10.002 39.6667L53.1892 7.38892C53.1892 42.8556 36.5966 54.5741 28.3003 56Z"
          fill="#9575F2"
          fillOpacity="0.62"
        />
        <defs>
          <linearGradient
            id="paint0_linear_46_722"
            x1="28.0946"
            y1="0"
            x2="28.0946"
            y2="42"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#B9E2FF" />
            <stop offset="1" stopColor="#A18FFF" />
          </linearGradient>
        </defs>
      </svg>
    );
  } else {
    // Color (Defult)
    return (
      <svg
        height="1em"
        viewBox="0 0 124 31"
        className={`${svgClass}`}
        {...props}
      >
        <path
          d="M0.0124344 4.09028L14.0055 0L27.7833 4.09028C27.7833 23.7236 18.5981 30.2106 14.0055 31C2.29438 27.3833 -0.202843 11.5532 0.0124344 4.09028Z"
          fill="url(#paint0_linear_25_431)"
        />
        <path
          d="M14.0055 31.0001C6.90134 28.632 3.8761 21.9584 3.8761 21.9584L27.7833 4.09033C27.7833 23.7237 18.5981 30.2107 14.0055 31.0001Z"
          fill="url(#paint1_linear_25_431)"
        />
        <path
          d="M116.129 18.0106L118.161 17.7008C118.248 18.0947 118.423 18.3949 118.687 18.6015C118.952 18.8032 119.321 18.9041 119.797 18.9041C120.321 18.9041 120.715 18.808 120.979 18.6159C121.156 18.4814 121.245 18.3012 121.245 18.0755C121.245 17.9217 121.197 17.7944 121.101 17.6936C121 17.5975 120.775 17.5086 120.424 17.427C118.791 17.0667 117.755 16.7376 117.318 16.4398C116.713 16.0267 116.41 15.4526 116.41 14.7177C116.41 14.0548 116.672 13.4975 117.196 13.046C117.719 12.5944 118.531 12.3687 119.631 12.3687C120.679 12.3687 121.457 12.5392 121.966 12.8802C122.475 13.2213 122.826 13.7257 123.018 14.3934L121.108 14.7465C121.027 14.4487 120.871 14.2205 120.64 14.062C120.414 13.9034 120.09 13.8242 119.667 13.8242C119.134 13.8242 118.752 13.8986 118.522 14.0475C118.368 14.1532 118.291 14.2901 118.291 14.4583C118.291 14.6024 118.358 14.7249 118.493 14.8257C118.675 14.9603 119.305 15.15 120.381 15.395C121.462 15.64 122.216 15.9402 122.643 16.2957C123.066 16.656 123.277 17.158 123.277 17.8016C123.277 18.503 122.984 19.1059 122.398 19.6102C121.812 20.1146 120.945 20.3668 119.797 20.3668C118.755 20.3668 117.928 20.1555 117.318 19.7327C116.713 19.31 116.317 18.736 116.129 18.0106Z"
          fill="white"
        />
        <path
          d="M112.692 11.5038V9.63037H114.717V11.5038H112.692ZM114.717 12.5414V19.9559C114.717 20.9311 114.652 21.618 114.523 22.0167C114.398 22.4202 114.153 22.7349 113.788 22.9607C113.427 23.1864 112.966 23.2993 112.404 23.2993C112.202 23.2993 111.984 23.2801 111.748 23.2417C111.518 23.2081 111.268 23.1552 110.999 23.0832L111.352 21.3538C111.448 21.373 111.539 21.3875 111.626 21.3971C111.708 21.4115 111.784 21.4187 111.856 21.4187C112.063 21.4187 112.231 21.373 112.361 21.2818C112.495 21.1953 112.584 21.0896 112.627 20.9647C112.671 20.8398 112.692 20.4651 112.692 19.8407V12.5414H114.717Z"
          fill="white"
        />
        <path
          d="M108.628 20.1937V18.1689H110.653V20.1937H108.628Z"
          fill="white"
        />
        <path
          d="M101.625 9.63037V13.5142C102.278 12.7504 103.059 12.3685 103.966 12.3685C104.432 12.3685 104.853 12.455 105.227 12.6279C105.602 12.8008 105.883 13.0218 106.07 13.2908C106.263 13.5598 106.392 13.8576 106.46 14.1843C106.532 14.5109 106.568 15.0177 106.568 15.7047V20.1937H104.543V16.1514C104.543 15.3492 104.504 14.84 104.428 14.6238C104.351 14.4077 104.214 14.2371 104.017 14.1122C103.825 13.9825 103.582 13.9177 103.289 13.9177C102.953 13.9177 102.653 13.9993 102.388 14.1627C102.124 14.326 101.93 14.5734 101.805 14.9048C101.685 15.2315 101.625 15.7167 101.625 16.3604V20.1937H99.5999V9.63037H101.625Z"
          fill="white"
        />
        <path
          d="M98.202 12.5414V14.1555H96.8185V17.2395C96.8185 17.864 96.8306 18.229 96.8546 18.3347C96.8834 18.4356 96.9434 18.5197 97.0347 18.5869C97.1308 18.6542 97.2461 18.6878 97.3806 18.6878C97.5679 18.6878 97.8393 18.6229 98.1948 18.4932L98.3677 20.0641C97.897 20.2658 97.3638 20.3667 96.7681 20.3667C96.403 20.3667 96.074 20.3066 95.7809 20.1865C95.4879 20.0616 95.2717 19.9031 95.1324 19.711C94.9979 19.514 94.9043 19.2498 94.8514 18.9184C94.8082 18.683 94.7866 18.2074 94.7866 17.4917V14.1555H93.8571V12.5414H94.7866V11.0211L96.8185 9.83936V12.5414H98.202Z"
          fill="white"
        />
        <path
          d="M90.7082 20.1938V19.0481C90.4296 19.4564 90.0621 19.7783 89.6058 20.0137C89.1542 20.2491 88.6762 20.3667 88.1719 20.3667C87.6579 20.3667 87.1967 20.2539 86.7884 20.0281C86.3801 19.8023 86.0846 19.4853 85.9021 19.077C85.7196 18.6686 85.6283 18.1042 85.6283 17.3836V12.5415H87.6531V16.0578C87.6531 17.1338 87.6891 17.7944 87.7611 18.0393C87.838 18.2795 87.9749 18.4717 88.1719 18.6158C88.3688 18.7551 88.6186 18.8248 88.9212 18.8248C89.2671 18.8248 89.5769 18.7311 89.8508 18.5437C90.1246 18.3516 90.3119 18.1162 90.4128 17.8376C90.5137 17.5542 90.5641 16.8648 90.5641 15.7696V12.5415H92.5889V20.1938H90.7082Z"
          fill="white"
        />
        <path
          d="M84.5474 20.1937H82.2272L81.3049 17.7943H77.0824L76.2105 20.1937H73.948L78.0624 9.63037H80.3177L84.5474 20.1937ZM80.6204 16.0145L79.1648 12.0947L77.7381 16.0145H80.6204Z"
          fill="white"
        />
        <path
          d="M73.6022 12.5414V14.1555H72.2187V17.2395C72.2187 17.864 72.2307 18.229 72.2547 18.3347C72.2835 18.4356 72.3436 18.5197 72.4349 18.5869C72.5309 18.6542 72.6462 18.6878 72.7807 18.6878C72.9681 18.6878 73.2395 18.6229 73.595 18.4932L73.7679 20.0641C73.2971 20.2658 72.7639 20.3667 72.1682 20.3667C71.8032 20.3667 71.4741 20.3066 71.1811 20.1865C70.8881 20.0616 70.6719 19.9031 70.5326 19.711C70.3981 19.514 70.3044 19.2498 70.2516 18.9184C70.2083 18.683 70.1867 18.2074 70.1867 17.4917V14.1555H69.2572V12.5414H70.1867V11.0211L72.2187 9.83936V12.5414H73.6022Z"
          fill="white"
        />
        <path
          d="M60.906 20.1938L63.6657 16.2524L61.0213 12.5415H63.4928L64.8474 14.6455L66.2742 12.5415H68.652L66.058 16.1659L68.8898 20.1938H66.4039L64.8474 17.8232L63.2766 20.1938H60.906Z"
          fill="white"
        />
        <path
          d="M58.0958 17.7584L60.1133 18.0971C59.8539 18.8368 59.4432 19.4013 58.8812 19.7904C58.3239 20.1747 57.625 20.3668 56.7844 20.3668C55.4537 20.3668 54.469 19.9321 53.8301 19.0626C53.3257 18.3661 53.0735 17.487 53.0735 16.4254C53.0735 15.1572 53.4049 14.1652 54.0679 13.4495C54.7308 12.7289 55.569 12.3687 56.5826 12.3687C57.7211 12.3687 58.6194 12.7457 59.2775 13.4999C59.9356 14.2493 60.2502 15.3998 60.2214 16.9514H55.1487C55.1631 17.5519 55.3264 18.0202 55.6387 18.3565C55.9509 18.6879 56.34 18.8537 56.806 18.8537C57.123 18.8537 57.3896 18.7672 57.6058 18.5943C57.822 18.4213 57.9853 18.1427 58.0958 17.7584ZM58.2111 15.712C58.1966 15.126 58.0453 14.6816 57.7571 14.379C57.4689 14.0716 57.1182 13.9178 56.7051 13.9178C56.2631 13.9178 55.8981 14.0788 55.6098 14.4006C55.3216 14.7225 55.1799 15.1596 55.1847 15.712H58.2111Z"
          fill="white"
        />
        <path
          d="M43.0361 20.1937V9.63037H45.1113L49.4347 16.6846V9.63037H51.4162V20.1937H49.2762L45.0177 13.3052V20.1937H43.0361Z"
          fill="white"
        />
        <defs>
          <linearGradient
            id="paint0_linear_25_431"
            x1="14.164"
            y1="4.03391"
            x2="0.272386"
            y2="4.03391"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#1FACF5" />
            <stop offset="1" stopColor="#32EAC3" />
          </linearGradient>
          <linearGradient
            id="paint1_linear_25_431"
            x1="27.7833"
            y1="18.4704"
            x2="3.81339"
            y2="18.4704"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#7411D6" />
            <stop offset="1" stopColor="#E05EEB" />
          </linearGradient>
        </defs>
      </svg>
    );
  }
};
export default NextAuthLogo;
