import React from 'react';
export const Travis = props => (
  <svg viewBox="0 0 20 20" width="16px" height="16px" {...props} className={`ffont ${props.className ? props.className : ''}`}><path d="M10.582 20.0450286C10.582 20.0450286 3.38463946 25.0514286 3.10315646 26.9586286L3.64322449 26.8489143C3.64322449 26.8489143 12.2621088 21.2034286 19.0942585 20.5149714L19.2489932 19.6580571 10.582 20.0450286zM21.8801769 19.3296L16.210966 23.3033143 16.5174286 23.5462857C16.7484898 23.3620571 26.5876735 20.3924571 26.5876735 20.3924571L28.6621361 19.1072C27.2702177 19.2784 21.8801769 19.3296 21.8801769 19.3296zM26.8069388 24.136C30.832585 24.136 36.8670068 20.2397714 36.8670068 20.2397714L34.9162857 19.8729143C34.8198367 19.9682286 31.7707075 19.7673143 31.7707075 19.7673143L30.3232789 19.3700571 26.8652245 23.264 26.5837415 23.9396571C26.832381 23.8397714 26.8069388 24.136 26.8069388 24.136zM39.7999213 36.9198623L38.5690464 37.249685 32.882116 37.1327003 29.3245511 34.5 25.0246155 35.5238884 20.0512125 35.1143331 17.2662351 38.0104124 12.040568 39.495922 9.4313971 38.726045C9.34830102 38.6578584 9.3 38.6184278 9.3 38.6184278L10.4711281 41.3474172C10.4711281 41.3474172 13.1237928 44.0539682 14.6055583 44.3722451 16.0870949 44.6905219 18.7637957 44.349371 20.7713785 44.0535326 22.7787324 43.757912 24.3799914 43.0756102 25.0250733 41.9615324 25.6701552 40.8468011 25.7658416 40.5285243 25.7658416 40.5285243 25.7658416 40.5285243 27.677967 43.0984843 29.3268403 43.3943227 30.9757136 43.6899432 35.8749481 42.0976878 35.8749481 42.0976878 35.8749481 42.0976878 38.8625152 41.3245431 39.3878747 40.3466208 39.913692 39.3686984 41.3 36.161967 41.3 36.161967L39.7999213 36.9198623zM9.97919021 39.1432251C9.95172044 39.1312434 9.92402175 39.1190439 9.89655197 39.1070622 9.7006009 38.9460721 9.54036054 38.8144915 9.43574648 38.728877L9.97919021 39.1432251z" fillRule="evenodd" />,
<path d="M45.3579326,16.2228394 C45.3454018,16.0678253 45.32823,15.9128111 45.3092017,15.758721 C45.2957427,15.6494487 45.2783389,15.535325 45.2593107,15.429749 C44.8432423,15.0811404 44.3703213,14.771112 43.87814,14.4892681 C43.3446536,14.1790087 42.7865697,13.9010921 42.2168832,13.6430432 C41.6511416,13.3773706 41.0700846,13.1368791 40.4855468,12.9021632 C40.193858,12.7843432 39.8996167,12.6699884 39.6042151,12.5609472 C39.3097417,12.4465925 39.0124837,12.3400924 38.7142975,12.2319752 C39.3401405,12.335241 39.959486,12.476625 40.5741905,12.6341804 C40.9740152,12.7372152 41.3717515,12.852494 41.7669353,12.9753964 C38.9563273,5.66246981 32.2365794,0.9 24.8998064,0.9 C17.5618733,0.9 10.8428215,5.66246981 8.03290966,12.9753964 C8.4280934,12.852494 8.8258297,12.7372152 9.22495832,12.6341804 C9.840591,12.476625 10.4601686,12.335241 11.0855474,12.2319752 C10.786433,12.3400924 10.4898712,12.4465925 10.1944696,12.5609472 C9.90046029,12.6699884 9.60598691,12.7843432 9.3131379,12.9021632 C8.72860012,13.1368791 8.14916747,13.3773706 7.58203356,13.6430432 C7.01350733,13.9010921 6.45495932,14.1790087 5.92147288,14.4892681 C5.42929161,14.770881 4.95683471,15.0811404 4.53914198,15.429749 C4.52173811,15.535325 4.5041022,15.6494487 4.49041116,15.758721 C4.47161498,15.9128111 4.45444317,16.0678253 4.44168034,16.2228394 C4.41429826,16.5344849 4.40315978,16.8472855 4.40060722,17.1610102 C4.39434183,17.7877665 4.43680726,18.4145227 4.51663298,19.0345794 C4.60249204,19.6564843 4.71712549,20.2742308 4.88675515,20.8714166 C4.9702937,21.170587 5.06497072,21.4655991 5.17449904,21.7511393 C5.22949525,21.8936785 5.28936454,22.0341384 5.3517864,22.170671 C5.3828813,22.2385908 5.41536851,22.3058175 5.44762368,22.370272 L5.48753654,22.4460464 C5.53371479,22.4693794 5.58221356,22.4931744 5.62839181,22.5153523 L5.90778184,22.6481886 C6.06348841,22.7186496 6.27906427,22.8205292 6.45727984,22.9 C6.46725806,22.8914523 6.47723627,22.8826735 6.48582218,22.8736638 L5.96718703,20.9069936 C6.07717945,20.876961 7.0620061,20.6239945 8.75923092,20.3024152 C8.62232052,20.276541 8.48401782,20.2467395 8.34803562,20.2143967 C7.96166984,20.1187546 7.58017715,20.0020897 7.21121523,19.853082 C7.02789453,19.7761525 6.84735844,19.6920613 6.67540827,19.5954951 C6.50322604,19.4970808 6.33382843,19.3857293 6.20271932,19.2378767 C8.06748534,19.8436102 11.9204688,19.5691589 15.3453172,19.2168539 C18.4777806,18.8955056 21.6174377,18.6871259 24.7735704,18.6808884 C27.9299352,18.6871259 31.0707525,18.8955056 34.2018237,19.2168539 C37.6282964,19.5691589 41.4812799,19.8436102 43.3458138,19.2378767 C43.2149368,19.3857293 43.0457712,19.4973118 42.873589,19.5954951 C42.7016388,19.6920613 42.5211027,19.7761525 42.3380141,19.853082 C41.968588,20.0020897 41.5875595,20.1187546 41.2011937,20.2143967 C41.1438769,20.2280269 41.0860961,20.2405019 41.0287794,20.252746 C42.8898326,20.5965032 43.9732811,20.8758059 44.0890748,20.9067626 L43.5929487,22.7803318 C43.6927308,22.735514 43.7934412,22.6923133 43.8922951,22.6477266 L44.1712211,22.5148903 C44.2176314,22.4924814 44.2647378,22.4689174 44.3120763,22.4455844 L44.3505969,22.3698099 C44.3844764,22.3053555 44.4169636,22.2381287 44.4478265,22.170209 C44.5104804,22.0336764 44.5703497,21.8932164 44.6251138,21.7506773 C44.7348742,21.465137 44.8297833,21.170125 44.9130898,20.8709545 C45.0827194,20.2737688 45.1973529,19.6560223 45.283212,19.0341174 C45.3632697,18.4138297 45.4052711,17.7870734 45.3994698,17.1605481 C45.3969172,16.8472855 45.3855467,16.5344849 45.3579326,16.2228394 Z" fillRule="evenodd" />,
<path d="M26.7,42.3889145 C26.5060871,42.4257894 26.3121742,42.4569025 26.1193548,42.4753399 C25.9950611,42.4829454 25.8634773,42.4988477 25.7441042,42.4988477 L25.7,42.5 C25.8498086,42.0766306 25.963532,41.7486748 26.0497357,41.5 C26.2252415,41.7489053 26.4484964,42.0570408 26.7,42.3889145 Z" fillRule="evenodd" />,
<path d="M27.3784544,42.8949739 C28.1893404,43.5054936 29.1941125,43.8551617 30.3,43.9172959 C28.4423741,44.490871 26.6917537,44.7121658 25.3431404,44.7812038 C23.9986992,44.849682 22.6356058,44.7291454 21.3,44.4507543 C21.411914,44.435454 21.4938862,44.4246319 21.5927927,44.415489 C21.7024979,44.4054132 24.0976057,44.1678852 25.1772327,42.9474054 L25.2785934,42.9490847 L25.543653,42.9474054 C25.7230591,42.9474054 25.8860217,42.9362101 26.0575741,42.9311722 C26.4649805,42.9043033 26.8633062,42.8600817 27.2547599,42.8 C27.295746,42.8319067 27.3364866,42.8630671 27.3784544,42.8949739 Z" fillRule="evenodd" />,
<path d="M29.2901195 20.5170727C28.8450209 21.0779907 28.2276853 21.7954334 27.4954485 22.4970399 26.6443959 22.470876 25.7698564 22.456417 24.8695274 22.456417 23.3820274 22.456417 21.9555472 22.4956629 20.6011393 22.5613022 22.5148564 21.7697285 25.0332566 20.9376721 27.5230921 20.4731475 28.2502632 20.3359016 28.7754814 20.2850399 29.5314353 20.2088432 29.4584419 20.3036301 29.3769288 20.4082858 29.2901195 20.5170727zM18.3768013 21.0426517C17.6938408 21.5209468 16.9065391 22.153226 16.1584141 22.8938489 14.2423944 23.0850293 12.5507517 23.3305446 11.1717056 23.5527085 13.2917385 22.5814298 15.7471961 21.6517665 18.3768013 21.0426517zM40.9723026 30.4935082L37.2392763 33.0995738 27.5030592 31.9963279 26.0374342 27.1856066C26.0026645 27.0685574 25.9036513 26.9824918 25.7823026 26.9627541 25.4214803 26.9046885 25.1023355 26.875082 24.8363816 26.875082 24.5692763 26.875082 24.2512829 26.9046885 23.8888487 26.9627541 23.7686513 26.9824918 23.6700987 27.0685574 23.6341776 27.1856066L22.2044737 31.8790492 12.5225987 34.0265574 8.68595395 31.3477377 7.93 25.2492459C8.09463816 25.1565246 8.26180921 25.0642623 8.43105263 24.9717705 8.66845395 24.9208197 8.93555921 24.8668852 9.23121711 24.8101967L9.94365132 30.5646557C9.95470395 30.654623 10.0044408 30.7347213 10.0785855 30.7865902L12.7178618 32.63C12.7722039 32.6667213 12.8366776 32.686459 12.9009211 32.686459 12.9164254 32.686459 15.5933114 32.0954754 20.9315789 30.9135082 20.9589803 30.9073115 20.9861513 30.8976721 21.0107895 30.8850492 21.0849342 30.8458033 21.1431908 30.7780984 21.1678289 30.6952459L22.6012171 25.9907869C22.9857566 25.8920984 23.9705921 25.6628197 24.8361513 25.6628197 25.6994079 25.6628197 26.6851645 25.8920984 27.0699342 25.9907869L28.5033224 30.6952459C28.5403947 30.8173443 28.6470066 30.9045574 28.7741118 30.9194754L36.7343092 31.8207541C36.8114474 31.8292459 36.8901974 31.8092787 36.9535197 31.7652131L39.5944079 29.9234098C39.6657895 29.872918 39.7141447 29.7935082 39.7263487 29.7062951L40.4314145 24.79C40.96125 24.8919016 41.4040461 24.9841639 41.7515132 25.0589836L40.9723026 30.4935082zM42.7555921 21.5817705L42.0703289 24.172918C40.6689474 23.864918 37.5903289 23.260623 33.4 22.8539344 34.7691447 22.2721311 36.1631579 21.5422951 37.4367434 20.63 39.9302632 20.9811475 41.7610855 21.3573115 42.7555921 21.5817705z" fillRule="evenodd" />,
<path d="M14.0393182,29.9195444 C14.575,29.6255444 15.1804545,29.6691598 16.1279545,29.6705444 C16.2295455,29.6730829 16.3343182,29.6716983 16.4438636,29.6693906 C16.5370455,29.6682368 16.6306818,29.6668521 16.7297727,29.6643137 C17.7061364,29.6546214 18.5181818,29.7487752 18.5038636,28.1917752 C18.4890909,26.635006 17.8079545,25.3768521 16.8325,25.3867752 C15.8559091,25.3953137 14.9111364,26.6707752 14.9695455,28.2266214 C14.9854545,28.6318521 15.0440909,28.9242368 15.1381818,29.1351598 C14.2870455,29.3516214 14.0525,29.8860829 14.0393182,29.9195444 Z M25.7795455,23.5159291 C25.4011364,23.8272368 25.0020455,24.1182368 24.5865909,24.3725444 L23.2009091,25.2217752 C22.3318182,25.3293137 21.5775,25.5476214 21.5347727,25.5603137 C21.5093182,25.5674675 21.485,25.5785444 21.4627273,25.5926214 C21.3954545,25.6320829 21.3443182,25.6976214 21.3197727,25.7758521 L19.9086364,30.4973906 L12.3665909,32.2004675 L9.99113636,30.511006 L9.3,24.8262368 C10.6490909,24.5746983 12.4531818,24.2834675 14.6204545,24.037006 C14.3881818,24.3196983 14.1627273,24.6157752 13.9488636,24.9266214 L12.6586364,26.8071598 L14.5372727,25.5353906 C14.5652273,25.5155444 15.7615909,24.7163906 17.7186364,23.7443906 C19.6690909,23.5957752 21.8215909,23.500006 24.125,23.500006 C24.6865909,23.4997752 25.2375,23.5062368 25.7795455,23.5159291 Z" fillRule="evenodd" />,
<path d="M33.9636364,28.9261538 C33.9540909,28.8892308 33.7488636,28.2631538 32.8404545,28.373 C32.9452273,28.1415385 32.9918182,27.8293077 32.9588636,27.4014615 C32.8388636,25.8481538 31.9490909,24.6137692 30.9736364,24.6481538 C29.9981818,24.6832308 29.3731818,25.9706923 29.4270455,27.5276923 C29.4806818,29.0833077 30.2997727,29.0724615 31.2752273,29.0376154 C32.5865909,29.0129231 33.3068182,28.6037692 33.9636364,28.9261538 Z M38.7772727,24.4526923 L38.0972727,29.2859231 L35.7020455,30.9887692 L28.17,30.1196923 L26.7647727,25.4205385 C26.7329545,25.3164615 26.6525,25.2361538 26.55,25.205 C26.5034091,25.1911538 25.5709091,24.9211538 24.5820455,24.8341538 L24.7627273,24.8219231 C24.9188636,24.8106154 27.5168182,24.4870769 30.6188636,23.4010769 C34.0540909,23.669 36.8593182,24.098 38.7772727,24.4526923 Z" fillRule="evenodd" />,
<path d="M15.0393182 29.7195444C15.575 29.4255444 16.1804545 29.4691598 17.1279545 29.4705444 17.2295455 29.4730829 17.3343182 29.4716983 17.4438636 29.4693906 17.5370455 29.4682368 17.6306818 29.4668521 17.7297727 29.4643137 18.7061364 29.4546214 19.5181818 29.5487752 19.5038636 27.9917752 19.4890909 26.435006 18.8079545 25.1768521 17.8325 25.1867752 16.8559091 25.1953137 15.9111364 26.4707752 15.9695455 28.0266214 15.9854545 28.4318521 16.0440909 28.7242368 16.1381818 28.9351598 15.2870455 29.1516214 15.0525 29.6860829 15.0393182 29.7195444zM26.7795455 23.3159291C26.4011364 23.6272368 26.0020455 23.9182368 25.5865909 24.1725444L24.2009091 25.0217752C23.3318182 25.1293137 22.5775 25.3476214 22.5347727 25.3603137 22.5093182 25.3674675 22.485 25.3785444 22.4627273 25.3926214 22.3954545 25.4320829 22.3443182 25.4976214 22.3197727 25.5758521L20.9086364 30.2973906 13.3665909 32.0004675 10.9911364 30.311006 10.3 24.6262368C11.6490909 24.3746983 13.4531818 24.0834675 15.6204545 23.837006 15.3881818 24.1196983 15.1627273 24.4157752 14.9488636 24.7266214L13.6586364 26.6071598 15.5372727 25.3353906C15.5652273 25.3155444 16.7615909 24.5163906 18.7186364 23.5443906 20.6690909 23.3957752 22.8215909 23.300006 25.125 23.300006 25.6865909 23.2997752 26.2375 23.3062368 26.7795455 23.3159291zM34.9636364 29.1250769C34.9540909 29.0881538 34.7488636 28.4620769 33.8404545 28.5719231 33.9452273 28.3404615 33.9918182 28.0282308 33.9588636 27.6003846 33.8388636 26.0470769 32.9490909 24.8126923 31.9736364 24.8470769 30.9981818 24.8821538 30.3731818 26.1696154 30.4270455 27.7266154 30.4806818 29.2822308 31.2997727 29.2713846 32.2752273 29.2365385 33.5865909 29.2118462 34.3068182 28.8026923 34.9636364 29.1250769zM39.7772727 24.6516154L39.0972727 29.4848462 36.7020455 31.1876923 29.17 30.3186154 27.7647727 25.6194615C27.7329545 25.5153846 27.6525 25.4350769 27.55 25.4039231 27.5034091 25.3900769 26.5709091 25.1200769 25.5820455 25.0330769L25.7627273 25.0208462C25.9188636 25.0095385 28.5168182 24.686 31.6188636 23.6 35.0540909 23.8679231 37.8593182 24.2969231 39.7772727 24.6516154z" fillRule="evenodd" />,
<path d="M43.0619815 26.5909091C43.1780062 26.6899455 43.2700494 26.9464 43.1661296 28.1409818 43.0384568 29.6036 42.4444012 32.1707455 42.0764568 32.5846182 41.6703704 32.6659273 40.819142 32.5694909 40.3 32.4439818 40.3897593 32.0754909 40.4153395 31.8989273 40.4877407 31.5221636L41.3956111 30.8648364C41.4680123 30.8128364 41.5157469 30.7310545 41.5280802 30.6424182L42.1625617 26.0413636C42.5476358 26.2569273 42.9439012 26.4902182 43.0619815 26.5909091zM9.37221808 32.5969091C9.4176687 32.7633091 9.46540327 32.9294727 9.5147366 33.0932727 9.02619956 33.2417091 8.03131067 33.384 7.5813724 33.3026909 7.20840327 32.9138727 6.51271191 30.238 6.3606008 28.8169818 6.23658228 27.6656545 6.3236008 27.4167636 6.43665635 27.3198545 6.56798351 27.2056909 7.05971808 26.9161455 7.48567487 26.6800182L8.06100203 31.5134182C8.071965 31.6063091 8.11969956 31.6885636 8.19484154 31.7419818L9.37221808 32.5969091zM27.8342901 32.6630909L27.7998025 32.9715455C27.7998025 32.9715455 26.7535247 33.9756182 25.0691111 34.2004 23.3846975 34.4249455 22.0609198 33.3537455 22.0609198 33.3537455 22.1161914 33.54 22.1947593 33.9604909 22.576179 34.3195273 22.1273827 34.2639818 21.6427284 34.2266364 21.134321 34.2266364 20.9506914 34.2266364 20.7652346 34.2320727 20.5859444 34.2410545 19.5492593 34.2970727 18.0909568 35.9192364 17.065463 37.5534545 16.5623086 37.7182 14.9895802 38.2348909 13.1690432 38.7912909 11.469784 36.3546182 10.6343148 33.865 10.5495802 33.6073636L10.5507222 33.6059455C10.516463 33.5069091 10.4819753 33.4076364 10.45 33.3062364L10.8869198 33.6224909 10.8869198 33.6236727 11.9663148 34.4058 12.327179 34.6660364C12.3810802 34.7055091 12.4448025 34.7258364 12.5085247 34.7258364 12.531821 34.7258364 12.5551173 34.7232364 12.5781852 34.7185091L22.4985247 32.4328727C22.6097531 32.4075818 22.6997407 32.3210727 22.7326296 32.2083273L24.1473086 27.3888727C24.391463 27.3546 24.6059259 27.3368727 24.7900123 27.3368727 24.9729568 27.3368727 25.1887901 27.3546 25.4329444 27.3888727L26.8887346 32.3518C26.9257346 32.4775455 27.0312531 32.5690182 27.1561852 32.5827273L27.8342901 32.6630909zM39.2862593 32.3983636L39.6064691 32.1657818C39.5534815 32.3957636 39.4959259 32.6243273 39.435858 32.8502909 38.990716 34.3270909 38.465179 35.6332364 37.8816296 36.7871636 37.7525864 36.7963818 37.616463 36.8015818 37.4705185 36.8015818 37.0201235 36.8015818 36.5601358 36.7621091 36.0510432 36.7138909 35.1676111 36.6299818 33.7654938 36.4638182 33.3226358 36.4106364 32.941216 36.0958 31.6359383 35.0224727 30.5499198 34.138 30.5072099 34.1023091 30.4704383 34.0692182 30.4345802 34.0387273 30.2434136 33.8713818 30.0259815 33.6811091 29.5856358 33.6811091 29.185716 33.6811091 28.6017099 33.8319091 27.19 34.2739091 27.9236049 33.7064 27.9284012 32.9739091 27.9284012 32.9739091L27.9628889 32.6654545 37.2695309 33.7595818C37.345358 33.7685636 37.4239259 33.7482364 37.4876481 33.7026182L38.4226975 33.0247273 39.2862593 32.3983636z" fillRule="evenodd" />,
<path d="M31.9906604 12.2C32.0211309 13.0504898 31.9987695 14.5916945 31.5839769 16.034829 31.5672673 16.0904335 31.5697246 16.147211 31.5839769 16.2 31.0561484 16.1469764 30.5280742 16.1016951 30 16.0613408 30.5927013 14.8755821 30.7219553 13.6128688 30.7499686 13.1680333 31.2050609 12.8590416 31.6581874 12.48858 31.9906604 12.2zM18.2507457 12.9686014C18.2782954 13.413698 18.4076808 14.6745701 19 15.8600857 18.4713895 15.9002289 17.943025 15.9469452 17.4156444 16 17.4299112 15.948119 17.4316331 15.8927167 17.4156444 15.8370796 17.0009225 14.3959153 16.9797683 12.8523974 17.0087939 12 17.3416045 12.2889841 17.7934693 12.6596631 18.2507457 12.9686014z" fillRule="evenodd" />,
<path d="M35,28.8902541 C34.2765666,28.5973322 33.4832931,28.9693598 32.0391798,28.9918115 C30.9647936,29.0234957 30.0626295,29.0333577 30.0035533,27.6188976 C29.9442268,26.2031784 30.632615,25.0325401 31.7070012,25.000646 C32.7813874,24.9691716 33.7614019,26.091759 33.8935724,27.5041209 C33.9298693,27.8931446 33.878553,28.1770438 33.7631542,28.3875028 C34.7634448,28.2874141 34.9894864,28.8564715 35,28.8902541 Z M31.6236436,26.817559 C31.9262841,26.8118936 32.1680961,26.602274 32.1628393,26.3485902 C32.1575826,26.0938573 31.9075099,25.8909523 31.6033675,25.8968275 C31.2997257,25.9010241 31.058915,26.1108535 31.0646724,26.3655864 C31.0699292,26.6190604 31.3200019,26.8221752 31.6236436,26.817559 Z" fillRule="evenodd" />,
<path d="M18.9997911,28.0942554 C19.0158258,29.81164 18.1066804,29.7077875 17.0130079,29.7184782 C16.9022917,29.7212782 16.7971749,29.7225509 16.6928217,29.7240781 C16.5701431,29.7268781 16.4525548,29.7281508 16.3390389,29.7253508 C15.2781995,29.7240781 14.5999037,29.67597 14,30 C14.0147622,29.9630916 14.2774268,29.3735759 15.2306043,29.1345624 C15.125233,28.9019124 15.0593123,28.5794096 15.0417504,28.1324365 C14.9763388,26.4165791 16.0343784,25.0094793 17.1280509,25.0000613 C18.2204508,24.9893706 18.9832473,26.3773799 18.9997911,28.0942554 Z M17.3113053,27.1959821 C17.61902,27.1880913 17.8623412,26.9304963 17.8541965,26.6230114 C17.8457974,26.3139993 17.5892412,26.0706586 17.2815265,26.0790584 C16.9722847,26.0869492 16.728709,26.3440351 16.7371082,26.6517745 C16.7452528,26.9610412 17.002318,27.2043819 17.3113053,27.1959821 Z" fillRule="evenodd" />,
<path d="M11.6331765 17.3185C11.6331765 17.3185 11.7901176 15.1455 12.1108235 14.31275 12.276 13.8835 13.2863529 13.61025 14.0581176 13.415 14.8294118 13.22 16.06 12.8295 16.2990588 13.981 16.5378824 15.1325 16.9232941 15.97175 17.1804706 16.3425L16.8501176 11.6 11.5414118 12.966 11.1922353 17.1625 11.3576471 17.49425 11.6331765 17.3185M37.5477647 17.2185C37.5477647 17.2185 37.3910588 15.0455 37.0703529 14.21275 36.9049412 13.7835 35.8945882 13.51025 35.1232941 13.315 34.3515294 13.12 33.1209412 12.7295 32.8818824 13.881 32.6435294 15.0325 32.2574118 15.87175 32 16.2425L32.3310588 11.5 37.6397647 12.866 37.9887059 17.0625 37.8232941 17.39425 37.5477647 17.2185" fillRule="evenodd" />,
<path d="M30.2896403 3.09C30.2896403 3.09 30.1519712 13.9209524 27.7056978 13.9209524L21.3455252 13.9209524C18.8992518 13.9209524 18.7017266 3.0947619 18.7017266 3.0947619L17.5 6.77047619 17.5195683 11.8140476 18.3729784 12.5157143 18.7608921 14.6814286 19.3035108 15.945 29.7741871 15.965 30.2587914 15.062381 30.6660432 13.5385714 30.724518 12.5759524 31.8808921 9.16142857 30.2896403 3.09zM38.0296978 13.4C38.0296978 13.4 38.5331799 17.1361905 39.8654388 17.81 41.1979281 18.4835714 39.8654388 17.81 39.8654388 17.81L38 17.2280952 38.0296978 13.4zM11.0281886 13.4C11.0281886 13.4 10.5247066 17.1361905 9.19221743 17.81 7.85972822 18.4835714 9.19221743 17.81 9.19221743 17.81L11.0578865 17.2280952 11.0281886 13.4z" fillRule="evenodd" />,
<path d="M38.1777911,17.2419522 C38.8025031,17.447594 39.4308432,17.665547 40,18 C39.6954671,17.8787123 39.3811837,17.7918503 39.0644059,17.7134237 C38.7489887,17.6324893 38.4310772,17.564094 38.1118052,17.5027662 C37.4723541,17.3817065 36.8306354,17.2788856 36.1848352,17.200231 C35.5406222,17.1158768 34.8952754,17.0447457 34.2469809,16.9895735 C33.598913,16.9346293 32.9524325,16.8794571 32.3030041,16.8413837 C29.7075583,16.6808828 27.1048562,16.6407575 24.5003401,16.6380217 C21.8965043,16.6393896 19.2935755,16.6884062 16.6979029,16.8425236 C16.048928,16.880369 15.401994,16.9357692 14.7541529,16.9909414 C14.1063119,17.0458856 13.4593778,17.1158768 12.8162986,17.2013709 C12.1707251,17.2800255 11.5287797,17.3828465 10.8893286,17.5039061 C10.5702833,17.564094 10.252145,17.6338572 9.93559406,17.7134237 C9.62017687,17.7918503 9.30453292,17.8787123 9,18 C9.56893008,17.665775 10.1972702,17.4466821 10.8233427,17.2405842 C10.87595,17.2234854 10.9292376,17.2088944 10.9827519,17.1917956 C10.9793506,17.1783445 10.9754958,17.1660334 10.9730014,17.1514424 C10.9621172,17.0791714 10.7305996,15.3597137 11.1337712,12.9006748 C11.1532722,12.7830349 11.2371718,12.6875095 11.3519102,12.6555917 L12.0133566,12.4661367 C12.1571198,7.30799161 14.2700295,4.88201052 14.3360154,4.80723166 C12.4480473,7.86153753 12.4652808,11.4839803 12.4979336,12.3275223 L16.6085611,11.1529471 C16.6121892,11.1518072 16.6144568,11.1518072 16.6180849,11.1506672 C16.6353183,11.1470195 16.652325,11.1445117 16.6693317,11.1433717 C16.6740935,11.1433717 16.6804427,11.1420038 16.6863383,11.1420038 C16.7071999,11.1408639 16.7305557,11.1433717 16.7536848,11.1481594 C16.7570861,11.1481594 16.7607142,11.1506672 16.7657028,11.1518072 C16.7827095,11.1554549 16.7985824,11.1613825 16.8164961,11.168906 C16.8239791,11.1725537 16.8287409,11.1764295 16.8359971,11.1800772 C16.8491489,11.1876007 16.862981,11.1960361 16.8761329,11.2056115 C16.879761,11.2081193 16.8838426,11.2092592 16.8872439,11.2131349 C16.8897382,11.2156428 16.8920058,11.2181506 16.8945001,11.2204304 C16.8981282,11.2240782 16.90289,11.226586 16.9067449,11.2304617 C16.909466,11.2341095 17.0187622,11.342858 17.1929106,11.5060948 C17.1516411,10.1443445 17.2160397,6.23783324 19.0663663,3 C19.0273643,3.11353619 17.5593478,7.42927927 18.0652398,12.2664225 C18.2294109,12.3986534 18.4021988,12.5283764 18.5706783,12.6423686 C18.6520836,12.6986807 18.7021966,12.7916983 18.7033304,12.8908715 C18.7046909,12.9068304 18.7398381,14.4486883 19.4171574,15.7602821 C19.4266811,15.7798887 19.4339373,15.8006353 19.4402864,15.8213819 C21.1248546,15.7062498 22.8139579,15.659741 24.4996599,15.6586011 C26.1858153,15.659741 27.8737848,15.7087576 29.5578995,15.8252576 C29.5640219,15.8031431 29.5715049,15.7812566 29.5826159,15.7602821 C30.2597084,14.4486883 30.2950823,12.9068304 30.2950823,12.8908715 C30.2973499,12.7914703 30.3474629,12.6986807 30.429095,12.6423686 C30.5971209,12.5283764 30.7676412,12.3986534 30.9333997,12.2664225 C31.4399719,7.42927927 29.9719554,3.11353619 29.9331802,3 C31.7819195,6.23760525 31.8479054,10.1441165 31.8066359,11.5060948 C31.9794237,11.343086 32.0891735,11.2343375 32.0925748,11.2304617 C32.0962029,11.226814 32.1014183,11.2243062 32.1045929,11.2204304 C32.107314,11.2181506 32.1086745,11.2156428 32.1120758,11.2131349 C32.1157039,11.2094872 32.1195588,11.2081193 32.1231869,11.2056115 C32.1367922,11.1960361 32.1501708,11.1876007 32.1633226,11.1787093 C32.1696718,11.1764295 32.1755674,11.1725537 32.1816898,11.168906 C32.2000571,11.1613825 32.216837,11.1554549 32.2352042,11.1506672 C32.2388323,11.1506672 32.2426871,11.1481594 32.2463152,11.1481594 C32.2680838,11.1433717 32.2916664,11.1408639 32.3134349,11.1420038 C32.3195573,11.1420038 32.3245459,11.1433717 32.3293078,11.1433717 C32.3463145,11.1445117 32.3646817,11.1470195 32.3816884,11.1506672 C32.3844094,11.1520351 32.3880375,11.1520351 32.3912121,11.1529471 L36.5020664,12.3275223 C36.5351727,11.4839803 36.5521794,7.86130954 34.6644381,4.80723166 C34.7299705,4.88201052 36.8433337,7.30799161 36.9857363,12.4661367 L37.6483165,12.6555917 C37.7614676,12.6875095 37.8467278,12.7830349 37.8664555,12.9006748 C38.2694004,15.3597137 38.0369758,17.0791714 38.0269986,17.1514424 C38.024731,17.1662614 38.0211029,17.1797124 38.0174748,17.1929355 C38.0716694,17.2088944 38.12405,17.2246253 38.1777911,17.2419522 Z M37.4301775,17.0212633 C37.4619233,16.7460863 37.6090878,15.2409338 37.2961649,13.1908989 L32.6431377,11.8610664 C32.6848608,12.6533119 32.703228,14.3716296 32.2560657,16.0101529 C32.2501701,16.0297596 32.2429139,16.0493662 32.2331634,16.0689729 C32.2791948,16.0737605 32.3256797,16.0774083 32.3705773,16.0835639 C33.678731,16.2342615 34.9807623,16.444691 36.2682813,16.7287595 C36.656487,16.8194972 37.0451463,16.9163906 37.4301775,17.0212633 Z M31.6685417,15.8469161 C32.0513053,14.4448126 32.0719401,12.9469556 32.0438224,12.1205125 C31.7370219,12.4009332 31.3188844,12.7609204 30.8989328,13.0609478 C30.8730826,13.4932061 30.7538091,14.7202176 30.2068744,15.8724504 C30.6941724,15.9118917 31.1814704,15.9558926 31.6685417,16.0071891 C31.6553898,15.9561206 31.6531223,15.9011764 31.6685417,15.8469161 Z M18.7933524,15.8692586 C18.2473246,14.7179378 18.1280511,13.4932061 18.1026545,13.0611758 C17.6813424,12.7611484 17.2645654,12.4011612 16.9577649,12.1207405 C16.930781,12.9485515 16.9505087,14.4475484 17.3328189,15.8471441 C17.347558,15.9011764 17.3459707,15.9549807 17.3328189,16.0053652 C17.8192099,15.9536128 18.3060544,15.9084719 18.7933524,15.8692586 Z M16.7677436,16.066237 C16.7589002,16.0491382 16.7518707,16.0295316 16.7455216,16.0099249 C16.297679,14.3714016 16.31718,12.6533119 16.3573158,11.8608384 L11.7056491,13.1906709 C11.3927263,15.238426 11.5387569,16.7433505 11.570276,17.0201234 C11.956441,16.9147947 12.3437397,16.8179013 12.7337595,16.7273916 C13.376612,16.5842174 14.0246798,16.4642977 14.6738814,16.3539532 C15.3244435,16.2449767 15.9770465,16.1617625 16.6298762,16.0821959 C16.6763611,16.0760404 16.7214855,16.0726206 16.7677436,16.066237 Z" fillRule="evenodd" />,
<path d="M29.8386364,4.21842857 L29.8386364,8.04036735 L27.0959091,8.04036735 L27.0959091,6.9237551 L26.4777273,6.9237551 L26.4777273,12.0827551 L27.4115909,12.0827551 L27.4115909,14.967449 L22.6140909,14.967449 L22.6140909,12.0827551 L23.5440909,12.0827551 L23.5440909,6.92397959 L22.9279545,6.92397959 L22.9279545,8.04059184 L20.1870455,8.04059184 L20.1870455,4.21842857 L29.8386364,4.21842857 Z M29.0145455,7.22838776 L29.0145455,5.03085714 L21.0090909,5.03085714 L21.0090909,7.22838776 L22.1036364,7.22838776 L22.1036364,6.11177551 L24.3681818,6.11177551 L24.3681818,12.8969796 L23.4363636,12.8969796 L23.4363636,14.1554694 L26.5875,14.1554694 L26.5875,12.8969796 L25.6556818,12.8969796 L25.6556818,6.11177551 L27.9202273,6.11177551 L27.9202273,7.22838776 L29.0145455,7.22838776 Z" fillRule="evenodd" />,
<path d="M7.04721915,21.5899015 C7.29668731,21.5031057 8.24070289,21.3284479 8.67246976,21.2470697 C8.36129104,21.4810656 7.77099003,21.9389724 7.24776013,22.3245371 L7.04721915,21.5899015 Z" fillRule="evenodd" />,
<path d="M22.5194188 32.0967164C22.5194188 32.0967164 22.6331938 32.8525373 21.6087563 33.1758806 20.5847813 33.4994627 14.0972938 35.4961194 13.3572938 35.3879403 12.617525 35.2802388 10.739775 33.985194 10.739775 33.985194L10.2844438 32.312597 13.0631438 34.1017313 22.5194188 32.0967164zM28.3305 31.9510448C28.3305 31.9510448 28.2486375 32.7109254 29.2857938 32.9886567 30.3227188 33.2659104 36.8881375 34.9695522 37.6223562 34.8284179 38.3568062 34.6872836 40.1783625 33.3093731 40.1783625 33.3093731L40.5629312 31.6176716 38.008775 33.1909254 28.3305 31.9510448z" fillRule="evenodd" />,
<path d="M7.095275 30.7068657C7.095275 30.7068657 7.99414375 32.5635821 9.4461625 31.9207164L10.4833187 32.3135522 10.3797187 33.0992239 8.201575 33.384597 7.61396875 33.0278209 7.095275 30.7068657zM43.8959375 30.1958209C43.8959375 30.1958209 42.4268063 32.1337313 40.9747875 31.4911045L40.5078938 31.8020299 40.6114938 32.5874627 42.7896375 32.8730746 43.3770125 32.5160597 43.8959375 30.1958209zM21.1707688 44.7820896C21.1707688 44.7820896 26.4964563 47.5548657 32.5265313 43.7819701L30.5900438 43.6456119C30.5900438 43.6456119 26.3646438 45.3726567 23.0193813 44.4181493L21.1707688 44.7820896z" fillRule="evenodd" />,
<path d="M25.9040369,39.7708019 L26.2706577,40.2111538 C26.2789377,40.2218206 27.0933695,41.198989 28.0890417,42.1942446 C28.7512131,42.8558159 29.5511549,43.1906596 30.4679369,43.1906596 C30.7809676,43.1906596 31.1098683,43.1500795 31.441989,43.0693831 C31.7501897,42.9937882 32.0850704,42.9133237 32.4280012,42.8305403 C33.6663239,42.5321028 35.068867,42.1930851 35.7487485,42.0010834 C35.8832988,41.9625902 36.0334891,41.9280392 36.1914995,41.8916331 C37.0965514,41.6808485 38.3371742,41.3900632 38.9945156,40.0622829 C39.4887867,39.0658679 40.1553282,37.7726385 40.6498293,36.8249196 C40.2213383,37.0241099 39.7721473,37.2399959 39.4531366,37.4092729 C38.9613955,37.6696811 38.3173941,37.7958271 37.4847923,37.7958271 C36.9898312,37.7958271 36.5036101,37.7538557 35.965639,37.7056234 C34.8903866,37.6059124 33.0708526,37.3900263 33.0522226,37.3874756 L32.9128423,37.3719392 L32.802902,37.2831268 C32.786572,37.2710687 31.1922085,35.9903612 29.9035157,34.9686706 C29.8513055,34.9255398 29.8036954,34.8856554 29.7606853,34.849713 C29.624985,34.7330742 29.624985,34.7330742 29.5440249,34.7330742 C29.130714,34.7330742 27.9294213,35.1087299 25.2977555,35.9312302 L25.1360652,35.9829408 L24.9775948,35.9226504 C24.9596548,35.9166214 23.233041,35.2710502 21.1639565,35.2710502 C20.9946761,35.2710502 20.8258557,35.2754561 20.6614054,35.2840358 C20.4541749,35.2947026 19.2910624,35.8516933 17.8036491,38.2243528 L17.7072789,38.3767021 L17.5368485,38.431891 C17.5122385,38.4404708 14.9521028,39.2736379 12.2371769,40.0562538 L12.0609965,40.106805 L11.8942461,40.0286594 C11.8765361,40.0214709 10.8141637,39.5245388 9.80331152,39.0561286 C10.3546227,39.8772377 11.0595743,40.901479 11.6798856,41.7047328 C12.763418,43.1115864 14.129161,44.4117723 16.7477168,44.4117723 C17.0761575,44.4117723 17.4250683,44.3913663 17.783409,44.3503224 C20.4470449,44.0467834 21.1329064,43.9243475 21.5020572,43.8594194 C21.6269475,43.8380858 21.7258477,43.8197668 21.852118,43.8042304 C21.872358,43.8016797 24.0534528,43.5173872 24.6654842,42.1332585 C25.2966055,40.7108685 25.4240258,40.3720828 25.4288558,40.3590972 L25.6514963,39.7601351 C25.6514963,39.7601351 25.6790964,39.6050033 25.7244065,39.5567709 C25.7244065,39.5579304 25.7244065,39.5579304 25.7255565,39.5579304 L25.7299265,39.5616405 C25.8000766,39.6124236 25.9040369,39.7708019 25.9040369,39.7708019 Z M9.31479045,12.9183801 C8.73610918,13.1535127 8.16110792,13.3960657 7.59898668,13.6625029 C7.03571545,13.9219836 6.48210423,14.2004789 5.95333307,14.5112064 C5.465502,14.7945713 4.99722097,15.1055307 4.58391006,15.4563746 C4.56620003,15.5618828 4.54963999,15.6771302 4.53537996,15.7863486 C4.51743992,15.9410167 4.49949988,16.0961486 4.48753985,16.252208 C4.46016979,16.5643268 4.44935977,16.8789964 4.44613976,17.1934341 C4.44015975,17.8225413 4.48293984,18.4516486 4.56160002,19.0744949 C4.6471602,19.6987326 4.76032045,20.3194919 4.92822082,20.918454 C5.011711,21.2187466 5.10463121,21.5150972 5.21411145,21.8005491 C5.26770157,21.9450142 5.3272717,22.0853053 5.38937183,22.2221182 C5.4201919,22.2902927 5.45239197,22.3577716 5.48436204,22.4224678 L5.52392213,22.4980627 C5.57015223,22.5221789 5.61799233,22.5460632 5.66307243,22.5676286 L5.94045304,22.7007313 C6.09524338,22.7728479 6.30845385,22.8748778 6.48463424,22.9541829 C6.49521426,22.9456031 6.50487428,22.9360958 6.5131543,22.9277479 L6.00002317,20.9541644 C6.10835341,20.9242511 7.08493556,20.6696401 8.76738925,20.3468545 C8.63168895,20.3215789 8.49345865,20.2916656 8.35913835,20.2589696 C7.97687751,20.1632006 7.59806668,20.0454024 7.23259588,19.8965315 C7.05158548,19.8186177 6.87172509,19.734443 6.70152471,19.6370508 C6.53109434,19.5384992 6.36319397,19.4271938 6.23347369,19.2783229 C8.08152774,19.8867923 11.8999961,19.6106158 15.2950336,19.2579169 C18.4002704,18.9348994 21.5114872,18.7262018 24.6394941,18.7187815 C27.767501,18.72597 30.8812478,18.9346675 33.9844146,19.2579169 C37.3815221,19.6108477 41.2004505,19.8870242 43.0478145,19.2783229 C42.9180942,19.4271938 42.7504239,19.5384992 42.5799935,19.6370508 C42.4100231,19.734443 42.2299327,19.8183858 42.0489223,19.8965315 C41.6820715,20.0454024 41.3046407,20.1629687 40.9212298,20.2589696 C40.8651097,20.2719552 40.8080696,20.2854046 40.7507995,20.2974627 C42.5954035,20.6420456 43.6692759,20.9228598 43.7835861,20.9541644 L43.2918451,22.8340658 C43.3907453,22.7895437 43.4905655,22.7466448 43.5880857,22.7009632 L43.8656963,22.5678605 C43.9107764,22.5460632 43.9586165,22.5224108 44.0050766,22.4982946 L44.0432567,22.4226997 C44.0763768,22.3580035 44.1085768,22.2905246 44.1396269,22.2223501 C44.2017271,22.0853053 44.2610672,21.9450142 44.3160373,21.8007809 C44.4243675,21.515329 44.5182077,21.2187466 44.6003179,20.9186859 C44.7684483,20.3197238 44.8827585,19.6989644 44.9671687,19.0747268 C45.0467489,18.4518805 45.088609,17.8225413 45.082629,17.193666 C45.080329,16.8792283 45.068369,16.5645587 45.0421489,16.2524399 C45.0290389,16.0963805 45.0122488,15.9414805 44.9931588,15.7865805 C44.9800488,15.6773621 44.9621087,15.5621147 44.9441687,15.4566064 C44.5308578,15.1057626 44.0630367,14.7950351 43.5747457,14.5114383 C43.0459745,14.2007108 42.4928233,13.9222155 41.9281721,13.6627348 C41.3674308,13.3962976 40.7912796,13.1537446 40.2123683,12.918612 C39.9227977,12.8008138 39.630927,12.6855664 39.3381364,12.576348 C39.0467257,12.4624919 38.7511751,12.3546648 38.4560844,12.2463739 C39.0761658,12.3495633 39.6909571,12.4921733 40.2990785,12.649624 C40.6955994,12.7530453 41.0912002,12.8694521 41.4815111,12.9930475 C38.696205,5.6519942 32.0353903,0.871892106 24.7639244,0.871892106 C17.4908484,0.871892106 10.8314138,5.6519942 8.04656767,12.9930475 C8.43802853,12.8694521 8.83224939,12.7530453 9.22762026,12.649624 C9.8373516,12.4924052 10.4516829,12.3495633 11.0722243,12.2463739 C10.7755237,12.3544329 10.481583,12.46226 10.1885624,12.576348 C9.89692173,12.6853345 9.60551109,12.8005819 9.31479045,12.9183801 Z M45.983771,17.1656077 C46.017351,17.8413241 45.999411,18.5181999 45.9244308,19.1906699 C45.8542807,19.8617486 45.7280104,20.5267982 45.55206,21.1860506 C45.4600598,21.5139377 45.3542596,21.8378827 45.2291393,22.1595089 C45.1658892,22.320206 45.098269,22.4802075 45.0244389,22.6397452 C44.9874088,22.7188184 44.9483087,22.7969641 44.9041486,22.8774286 L44.8388284,22.9961543 C44.8149084,23.0392851 44.7958184,23.0717492 44.7587883,23.129257 L44.6911681,23.235229 L44.5851379,23.290186 C44.4719776,23.3490851 44.3792874,23.3933754 44.2764772,23.4416077 L43.9779366,23.5772611 C43.7776061,23.6635228 43.5765857,23.7451467 43.3753352,23.8242199 C43.2348049,23.8796407 43.1108347,23.9301919 42.9930744,23.9805112 L42.6609537,25.2528708 C42.6526736,25.2507838 42.5526234,25.2250444 42.365863,25.1798266 L42.347923,25.3129293 C42.7145438,25.5060905 43.4349054,25.8977463 43.6803159,26.102038 C44.174357,26.513636 44.2090871,27.1657 44.0996068,28.3840301 C44.0434867,29.0094272 43.8376363,30.2265979 43.5519756,31.3445212 C43.0588545,33.2687129 42.796884,33.4948019 42.4587832,33.5819911 C42.2872028,33.6265133 42.0231623,33.6708036 41.7669417,33.6708036 C41.2457606,33.6708036 40.535749,33.6854124 40.058268,33.5690055 C39.9356777,34.0068067 39.5856169,35.1486143 38.8926254,36.5747144 C38.9273555,36.5577867 38.9616255,36.5434098 38.9926756,36.526714 C39.8475875,36.0740721 41.4907111,35.3524423 41.5599412,35.3211376 L42.8578341,34.7525527 L42.1931326,36.0128542 C42.1777226,36.0402167 40.7524095,38.7428504 39.8795576,40.5075044 C39.0126857,42.2554625 37.3875021,42.6359878 36.4146,42.8613812 C36.2680896,42.896396 36.1291693,42.92886 36.0160091,42.9599328 C35.3179575,43.1579636 33.9046044,43.4976769 32.6582317,43.8000565 C32.6435117,43.8037667 32.6283316,43.8077087 32.6129216,43.8097957 C31.8458699,44.2877132 31.0088981,44.71392 30.0932661,45.0645319 C26.7426187,46.34408 23.210961,46.2721952 20.0091239,45.0858655 C19.4890928,45.1533443 18.8053013,45.2358958 17.8947293,45.3402446 C17.4991284,45.3847668 17.1145676,45.4077235 16.7481768,45.4077235 C13.6974501,45.4077235 12.0805465,43.8457381 10.9004139,42.3164486 C9.63702116,40.6788683 8.09164777,38.2477733 8.02609762,38.1459753 L7.13001565,36.7368029 L8.64456898,37.4234179 C9.36953057,37.7524644 11.5250953,38.7583868 12.1417267,39.0466213 C12.1916368,39.0324762 12.2406269,39.0178674 12.289387,39.0034905 C11.2642747,37.5293899 10.4236229,35.8486787 9.82953158,33.9868645 C9.32468047,34.1403731 8.54704877,34.2593307 7.94214744,34.2593307 C7.72111695,34.2593307 7.52308652,34.2426349 7.37082618,34.2064607 C7.03249544,34.1285469 6.64678459,33.7997323 6.12169344,31.9351354 C5.81694277,30.8526906 5.58947227,29.6709985 5.52300213,29.062761 C5.39190184,27.8752718 5.41582189,27.239208 5.90526297,26.8283056 C6.20035361,26.5799555 7.1957958,26.0528782 7.40187625,25.9450511 L7.35771615,25.5786709 C4.19520921,27.4523114 2.29977505,29.1079788 2.26159497,29.1418342 L0,31.1427802 L1.61115354,28.5811334 C2.88627634,26.5509697 4.35919957,24.9099111 5.71436255,23.6456675 C5.65824242,23.6229427 5.60603231,23.6002178 5.55106219,23.577493 L5.25229153,23.4418396 C5.14994131,23.3936072 5.0570211,23.349317 4.94409086,23.2904179 L4.83806062,23.2354609 L4.77021047,23.1294889 C4.73203039,23.0717492 4.71547035,23.039517 4.6904003,22.9963862 L4.62370015,22.8776605 C4.58207006,22.7971959 4.54135997,22.7190503 4.50455989,22.6399771 C4.42934973,22.4802075 4.36172958,22.3204379 4.29985944,22.1597408 C4.17473917,21.8381146 4.06870893,21.5141696 3.97693873,21.1862825 C3.79960834,20.5270301 3.67448807,19.8622123 3.60433791,19.1909018 C3.53050775,18.5184318 3.51141771,17.841556 3.54476778,17.1658396 C3.56270782,16.8284452 3.59490789,16.4912827 3.64113799,16.1562071 C3.66505805,15.9880896 3.6901281,15.8199721 3.72347818,15.6530141 C3.75797825,15.4828096 3.79155832,15.3241994 3.84261844,15.1379948 L3.87826852,15.007211 L3.97118872,14.9337031 C4.49880988,14.5158441 5.06783113,14.200247 5.6465124,13.9205923 C6.12284344,13.694967 6.60860451,13.4955449 7.09804558,13.313978 C8.46493859,9.4894789 10.8153137,6.09814325 13.9039905,3.73452723 C17.0975475,1.29160613 20.8527658,0 24.7643844,0 C28.676003,0 32.4312212,1.29160613 35.6245482,3.73475911 C38.713455,6.09837513 41.0638302,9.48994267 42.4298032,13.3132823 C42.9203942,13.4957768 43.4050053,13.6938076 43.8824863,13.9208242 C44.4609376,14.2004789 45.0301889,14.516076 45.55758,14.933935 L45.6505002,15.0074429 L45.6863803,15.1382267 C45.7385904,15.3244313 45.7719405,15.4830415 45.8052906,15.6532459 C45.8388706,15.820204 45.8650907,15.9883215 45.8874008,16.156439 C45.9340909,16.4910508 45.9674409,16.8282133 45.983771,17.1656077 Z M43.2249149,28.3033337 C43.3297951,27.1318447 43.2382549,26.8797844 43.1202647,26.7835516 C43.0022744,26.6838405 42.6034535,26.4561283 42.2152127,26.2434886 L41.5760413,30.7569216 C41.5640813,30.8445746 41.5150912,30.9241115 41.442641,30.9753584 L40.527929,31.6202339 C40.4554788,31.9896286 40.4292588,32.164007 40.3400186,32.5252857 C40.8628097,32.6477217 41.7197916,32.742795 42.1282725,32.663258 C42.4990333,32.257921 43.0974946,29.7391731 43.2249149,28.3033337 Z M42.0378823,24.2110061 L42.7225938,21.5930109 C41.7294516,21.3662262 39.9004876,20.9866285 37.4095821,20.631147 C36.1376793,21.5531265 34.7457163,22.2902927 33.3776733,22.8783561 C37.5634525,23.2890266 40.6387892,23.9000467 42.0378823,24.2110061 Z M40.9614799,30.5268905 L41.7400316,25.0367528 C41.3936509,24.9611579 40.9508999,24.8677078 40.4218988,24.7656779 L39.7183272,29.733144 C39.7052172,29.820797 39.6573771,29.9012615 39.5860769,29.9518127 L36.9475111,31.8122357 C36.885411,31.8567578 36.8058308,31.8771638 36.7297006,31.868584 L28.7781232,30.9575032 C28.6507029,30.9428943 28.5446727,30.8540819 28.5076426,30.7318779 L27.0754294,25.9782108 C26.6917886,25.8782679 25.7071564,25.6466136 24.8453446,25.6466136 C23.9796227,25.6466136 22.9959105,25.8782679 22.6124996,25.9782108 L21.1800565,30.7318779 C21.1549864,30.8144294 21.0977163,30.8832996 21.0231962,30.9224883 C20.9992761,30.9357059 20.971906,30.9452132 20.944306,30.9514741 L12.9927285,32.7351428 C12.9676585,32.7402442 12.9462684,32.742795 12.9223484,32.742795 C12.8581782,32.742795 12.7937781,32.7235484 12.740188,32.6848234 L10.1027722,30.8230092 C10.028942,30.7712985 9.97995191,30.6896746 9.96822189,30.5985433 L9.25729033,24.7846926 C8.96196968,24.8424322 8.69539909,24.8976211 8.45711857,24.9477085 C8.2882982,25.0416225 8.12131783,25.1353045 7.95709747,25.2289865 L8.71172913,31.389739 L12.5449175,34.0970104 L22.2157488,31.9279469 L23.6433619,27.186106 C23.679242,27.0669165 23.7779122,26.9792635 23.8982025,26.960017 C24.2602233,26.9013498 24.576704,26.8714365 24.8448845,26.8714365 C25.1100751,26.8714365 25.4281658,26.9013498 25.7890366,26.960017 C25.9104769,26.9792635 26.0091471,27.0669165 26.0438772,27.186106 L27.5080604,32.0455132 L37.2329417,33.160422 L40.9614799,30.5268905 Z M39.1053759,29.5040405 L39.7935374,24.6464884 C37.8525631,24.2903112 35.0141269,23.8594666 31.5372092,23.5904786 C28.3983924,24.681967 25.7694866,25.0068395 25.6110162,25.0177382 L25.4277058,25.0309557 C26.428898,25.1176811 27.3721301,25.388988 27.4195102,25.403133 C27.5234704,25.4344377 27.6044306,25.5146703 27.6366307,25.6194829 L29.0594138,30.3420772 L36.6811705,31.2148968 L39.1053759,29.5040405 Z M39.635067,32.2507325 L39.3121463,32.4786766 L38.4429744,33.0934069 L37.5011223,33.7584565 C37.4369522,33.8029787 37.358292,33.8233847 37.2817019,33.8148049 L27.9101013,32.7404761 L27.2279198,32.6623305 C27.1016495,32.6477217 26.9956193,32.5589092 26.9585892,32.4357777 L25.491876,27.5666313 C25.2466954,27.5330078 25.028655,27.5158482 24.8455746,27.5158482 C24.6595041,27.5158482 24.4428437,27.5327759 24.1976631,27.5666313 L22.7735,32.2952546 C22.7401499,32.4056325 22.6497597,32.4898072 22.5377495,32.514619 L12.5476775,34.7574223 C12.5239875,34.76206 12.5002974,34.7643789 12.4775274,34.7643789 C12.4133573,34.7643789 12.3489571,34.7451323 12.293987,34.7057117 L11.9310462,34.4511006 L10.8440638,33.684253 L10.8440638,33.6817022 L10.4047628,33.3721341 C10.4358129,33.4718452 10.471233,33.5692374 10.5061931,33.6661658 L10.5048131,33.6675572 C10.5894533,33.9207769 11.4312551,36.3625386 13.1422289,38.7525896 C14.9746429,38.207657 16.5595764,37.7009857 17.0653475,37.5388972 C18.0975897,35.9349404 19.567063,34.3442011 20.6114953,34.2892441 C20.7911256,34.2806643 20.9783461,34.275099 21.1639565,34.275099 C21.6747876,34.275099 22.1630787,34.3122008 22.6152597,34.3662303 C22.2309288,34.0144589 22.1522686,33.6014696 22.0963785,33.4189752 C22.0963785,33.4189752 23.4287714,34.4694196 25.1254852,34.2500553 C26.8224289,34.0290677 27.8760612,33.0433195 27.8760612,33.0433195 C27.8760612,33.0433195 27.8712312,33.7626305 27.1317796,34.3193893 C28.5536427,33.885994 29.141754,33.737123 29.5442549,33.737123 C29.9883858,33.737123 30.2073463,33.9244871 30.3991667,34.0893582 C30.4361968,34.1192715 30.4732269,34.1515037 30.515777,34.1865185 C31.6089694,35.0542366 32.9234223,36.1072318 33.3082131,36.4158724 C33.7534941,36.4685105 35.1654672,36.630599 36.0551092,36.7133824 C36.5680103,36.7599915 37.0314613,36.799644 37.4850223,36.799644 C37.6315326,36.799644 37.7686129,36.793615 37.8983332,36.7850352 C38.4866745,35.6534306 39.0154457,34.370868 39.4641766,32.9234343 C39.5242068,32.7008236 39.5828569,32.4763578 39.635067,32.2507325 Z M36.1772394,20.2870278 C36.1749394,20.2856365 36.1726394,20.2842452 36.1701094,20.2842452 C35.4175478,20.2278969 34.6652161,20.1761862 33.9101245,20.1332873 C32.8624722,20.0729969 31.8143599,20.0226776 30.7667076,19.9783873 C30.7057574,20.0697505 30.5822471,20.2496942 30.4046868,20.4943341 C29.8345155,21.2723123 28.703143,22.6995719 27.2527598,23.9097859 C29.3057443,23.538768 32.8668422,22.6204987 35.9474689,20.4535221 C36.0247491,20.3983332 36.1011093,20.3408254 36.1772394,20.2870278 Z M29.3057443,20.5017545 C29.3924545,20.3925361 29.4734147,20.2870278 29.5458649,20.191027 C28.7912332,20.2677813 28.0481016,20.378391 27.32176,20.5175227 C24.8345345,20.9868604 22.5375195,21.7671575 20.6264453,22.5667011 C21.9804583,22.5006135 23.4043914,22.4611928 24.8906547,22.4611928 C25.7894966,22.4611928 26.6634985,22.4767292 27.5135804,22.5020048 C28.244752,21.7933606 28.8616134,21.0684843 29.3057443,20.5017545 Z M30.1307562,44.1726976 C29.0950639,44.0957114 28.1532118,43.6613885 27.3930601,42.9026569 C27.3537301,42.8620768 27.31578,42.8231199 27.2775999,42.7839312 C26.9100591,42.8583666 26.5372283,42.9135555 26.1549674,42.947179 C25.9944271,42.9532081 25.8419367,42.9673531 25.6740364,42.9673531 L25.4249458,42.9699039 L25.3299556,42.9673531 C24.3188734,44.483657 22.0733785,44.77908 21.9707982,44.7922975 C21.878108,44.8029643 21.8019779,44.8161818 21.6968676,44.8354284 C22.9485304,45.1811707 24.2259532,45.3312011 25.485896,45.2458669 C26.7490587,45.1607647 28.3901123,44.8845882 30.1307562,44.1726976 Z M26.1287474,42.4425947 C26.3716279,42.4233481 26.6156584,42.3920435 26.861069,42.3549417 C26.5429783,42.0214893 26.2621477,41.7114575 26.0404272,41.4605566 C25.9320969,41.7114575 25.7883466,42.0414316 25.5988262,42.4667132 L25.6547163,42.4667108 C25.8060567,42.4669427 25.971657,42.4502469 26.1287474,42.4425947 Z M25.3573257,24.2089191 C25.7775366,23.9531486 26.1811875,23.6602764 26.5645983,23.3481576 C26.0155871,23.3386502 25.4585259,23.3314617 24.8906547,23.3314617 C22.5591395,23.3314617 20.3812647,23.4276945 18.4071704,23.577493 C16.4268661,24.553502 15.2159134,25.3565239 15.1876233,25.3769299 L13.2859792,26.6555504 L14.592152,24.7659098 C14.8076625,24.4521677 15.036283,24.1546577 15.2720335,23.8715247 C13.0787487,24.1187154 11.2523147,24.4115877 9.88772171,24.6650393 L10.5864632,30.3768601 L12.9906585,32.074499 L20.6229953,30.3636426 L22.0517584,25.6183234 C22.0756785,25.5401778 22.1278886,25.4743221 22.1959687,25.4344377 C22.2185088,25.4198288 22.2424288,25.4091621 22.2684189,25.4019736 C22.312579,25.3899155 23.0757207,25.1703193 23.9557026,25.0622603 L25.3573257,24.2089191 Z M26.2350076,19.8522412 C25.7037064,19.8438933 25.1717153,19.8390237 24.6404141,19.8378643 L24.6392641,19.8378643 C23.8595624,19.8390237 23.0782507,19.8473716 22.295789,19.8631399 L20.8539158,20.5520738 C20.8527658,20.5532332 20.8444858,20.5569434 20.8336757,20.5632043 C20.6170153,20.669872 18.7236511,21.6328953 16.9422972,23.3507083 C18.5391907,22.5043237 20.8858859,21.3986903 23.6475019,20.541407 C24.4748137,20.2858684 25.3416856,20.050272 26.2350076,19.8522412 Z M16.1577655,22.9001534 C16.9054971,22.1523204 17.6769188,21.5352713 18.3581803,21.0527161 C15.7327245,21.6674464 13.3158792,22.5699475 11.1987246,23.5519855 C12.5761976,23.3275197 14.2443913,23.0935465 16.1577655,22.9001534 Z M16.6543366,20.5931176 C17.5340885,20.3445356 18.4416705,20.1272583 19.3713325,19.9447638 C18.0377896,19.9939237 16.7033267,20.0563011 15.3709337,20.1321279 C14.596752,20.1752587 13.8264804,20.2281288 13.0559787,20.286796 C12.6700378,20.3167093 12.286627,20.347782 11.9043661,20.3899853 C11.7948859,20.4006521 11.6877057,20.4127102 11.5782254,20.4270871 C10.5733532,21.0332376 6.71900475,23.4726804 4.07307894,26.6622751 C6.64425459,24.8607512 11.1235144,22.1537117 16.6543366,20.5931176 Z M9.55882099,33.1606539 C9.50868088,32.9999568 9.46130077,32.836477 9.41599067,32.6732291 L8.22872807,31.8356562 C8.1535179,31.7827861 8.1059078,31.7023216 8.09394777,31.6109585 L7.5152665,26.8691176 C7.08654556,27.1007719 6.59135447,27.3850644 6.45910418,27.4968335 C6.34479393,27.591675 6.25785374,27.8353874 6.38182401,28.9651369 C6.53546435,30.358773 7.23558589,32.9844204 7.61186671,33.3661051 C8.06450771,33.4465696 9.06707991,33.3062785 9.55882099,33.1606539 Z M8.68136906,21.2509788 C8.01091759,21.3817626 7.46420639,21.4993289 7.0596355,21.5918515 L7.25030592,22.3169596 C7.78229709,21.8893615 8.26943816,21.5341118 8.68136906,21.2509788 Z" fillRule="evenodd" /></svg>
);
