import React from 'react';
export const Postcss = props => (
  <svg viewBox="0 0 20 20" width="16px" height="16px" {...props} className={`ffont ${props.className ? props.className : ''}`}><path d="M7.36472628,18.0005245 C7.42599567,18.0424818 7.53235009,18.069754 7.42599567,18.1526197 C7.34969794,18.2491215 7.25837187,18.3319872 7.19768049,18.4426496 C7.13698911,18.5396759 7.09132607,18.5669481 7,18.498243 C7.12138276,18.3183511 7.24276551,18.1520952 7.36414827,18 L7.36472628,18.0005245 Z M37.9387306,32.4847118 C37.9387306,32.5256202 37.9537589,32.5528924 37.9537589,32.5948497 C37.9843936,32.5397808 37.9843936,32.5119841 38,32.4847118 L37.9387306,32.4847118 Z M37.9387306,32.6084859 L37.9387306,32.5948497 L37.9387306,32.6084859 Z M34.8359561,37.9984266 L32.188656,24.6759322 C32.143571,24.6628206 32.0828796,24.6355483 31.9759472,24.6077516 C32.0065819,24.6628206 32.0221882,24.7042534 32.0372166,24.7456863 C32.1123583,24.7320501 32.143571,24.7320501 32.1736277,24.718414 C32.1736277,24.7047779 32.1736277,24.6911418 32.189234,24.6764567 L34.8365342,38 L34.8359561,37.9984266 Z M32.097908,21.6770336 C32.0828796,21.717942 32.0828796,21.7598993 32.0828796,21.8013321 C32.0828796,21.7593748 32.0828796,21.7174175 32.099064,21.6765092 L32.097908,21.6770336 Z M32.1129363,21.9529029 C32.097908,21.9529029 32.097908,21.9529029 32.0828796,21.9382179 L32.0828796,21.951854 C32.099064,21.9654901 32.099064,21.9654901 32.1140923,21.951854 L32.1129363,21.9529029 Z M32.0828796,22.0630409 L32.0828796,21.9660146 C32.0383726,21.9796507 31.9927096,21.9796507 31.9314402,21.9938113 C32.0077379,22.0200346 32.0840357,22.0347197 32.0840357,22.0619919 L32.0828796,22.0630409 Z" fillRule="evenodd" />,
<path d="M43.9062467,19.1384337 C43.8768962,18.5579585 43.862221,17.9774834 43.8023911,17.3975728 C43.6985355,16.6087364 43.5946799,15.8052187 43.4163193,15.0316282 C43.2825487,14.3918633 43.0607267,13.7814609 42.8372114,13.1716231 C42.5549952,12.4573224 42.2727789,11.7283404 41.9160575,11.043967 C41.3369497,9.94287104 40.5794812,8.96035467 39.8812781,7.93379447 C39.4195723,7.27878355 38.8257892,6.74348153 38.3798875,6.07378934 C38.1275862,5.6869941 37.7561895,5.36005331 37.3847929,5.06303974 C36.7904454,4.58589817 36.1667474,4.15392977 35.5430495,3.73777197 C35.072346,3.40757702 34.5863985,3.09968374 34.0868135,2.81511005 C33.6860663,2.59093821 33.2554043,2.4125042 32.8394175,2.21882425 C32.3641653,1.99578174 31.9035883,1.72756606 31.3690707,1.62366778 C31.2347357,1.59543455 31.1162049,1.55026139 30.9824344,1.50508822 C30.6409527,1.38650866 30.3141462,1.25268315 29.9721001,1.14822021 C29.4528221,0.984467477 28.947655,0.791352191 28.4125729,0.656962021 C27.8944238,0.523136515 27.3593418,0.434484176 26.8242597,0.359383787 C26.2304767,0.271860777 25.6220184,0.240804225 25.0271064,0.182643773 C24.6473763,0.133561166 24.265922,0.0989034983 23.8835661,0.0787454905 C23.3191335,0.0488182677 22.7400257,0.0488182677 22.1755931,0.0341369886 C21.8933769,0.0188910449 21.5964853,-0.0110361778 21.3142691,0.00420976586 C20.883607,0.0188910449 20.452945,0.0634995468 20.0217185,0.122789328 C19.6062961,0.167962494 19.1903093,0.24136889 18.7895622,0.301788 C18.3001992,0.361077781 17.8102717,0.391005003 17.3197798,0.450859449 C16.8592029,0.510713894 16.3839506,0.599930898 15.9239381,0.674466623 C15.7602527,0.704393845 15.5965672,0.763683626 15.4328818,0.793046184 C15.0772893,0.867581909 14.7058926,0.897509132 14.3491713,1.01665336 C13.7113625,1.21089797 13.0718604,1.43450515 12.4481624,1.67166427 C11.8684902,1.90995272 11.3040576,2.16292246 10.7548647,2.46050069 C10.1904321,2.77219554 9.65535008,3.14374483 9.12083245,3.50174218 C8.60742845,3.845439 8.10663663,4.20762642 7.61944184,4.58759216 C7.14531848,4.96027079 6.69941676,5.37642858 6.26819029,5.79315104 C6.03112861,6.03031017 5.83752824,6.31377179 5.61457738,6.5814228 C5.24374519,7.0133912 4.87234856,7.429549 4.51562719,7.87619868 C4.21986452,8.2488773 3.95119462,8.63510788 3.66897834,9.02246778 C3.16494007,9.70571192 2.73427802,10.4352586 2.33353091,11.1648052 C2.16984546,11.4623834 2.0213997,11.7599617 1.87295394,12.0569752 C1.65000308,12.5030602 1.41237697,12.9350287 1.20466579,13.3963596 C1.05565559,13.7091838 0.937124752,14.0513705 0.847944407,14.3935573 C0.640797657,15.1231039 0.432522042,15.8673318 0.239486107,16.5957491 C0.0611254177,17.25076 0.0165352454,17.9351335 0.00242443137,18.6048257 C-0.0128152478,19.1999822 0.0464501711,19.7804574 0.10571559,20.3756138 C0.120955269,20.5246853 0.0323393571,20.7031193 0.209571181,20.8216988 C0.150305762,20.9854516 0.194895935,21.0757979 0.282947414,21.1040311 C0.180220688,21.2677839 0.328102019,21.3728115 0.269401032,21.5218829 C0.254161353,21.5512455 0.314555637,21.6105353 0.342777265,21.6551438 C0.342777265,21.7003169 0.328666451,21.7596067 0.342777265,21.8042152 C0.358581377,21.9380407 0.417846796,22.0718662 0.417846796,22.2209377 C0.417846796,22.324836 0.506462708,22.4439802 0.536377634,22.5484431 C0.55105288,22.592487 0.536377634,22.6670227 0.506462708,22.6969499 C0.417282363,22.8008482 0.43195761,22.8900652 0.565728127,22.9499196 C0.640797657,23.1430349 0.610882732,23.2322519 0.596207485,23.3225983 C0.625557978,23.4558591 0.580967806,23.5004676 0.596207485,23.5303948 C0.714738323,23.7686833 0.759892928,24.0363343 0.774003742,24.3039853 C0.774003742,24.3638398 0.803918667,24.4236942 0.833833593,24.4976653 C0.84850884,24.4976653 0.833833593,24.7799976 0.833833593,24.7799976 C0.907209826,24.7359537 0.96760411,24.7212724 1.04154478,24.6913452 C1.08669938,24.8844605 1.13072512,25.0640238 1.18999054,25.2277766 C1.26449564,25.3463561 1.26449564,25.4050812 1.23514514,25.4197625 C1.29441056,25.6874135 1.32376106,25.9403833 1.42705221,26.193353 C1.42705221,25.9110207 1.39883059,25.6286884 1.35367598,25.3604727 C1.56138716,25.4350085 1.73974785,25.5089795 1.85884312,25.5089795 C1.8740828,25.4638064 1.88875805,25.4050812 1.90399773,25.375154 C1.81481738,25.2865017 1.74031229,25.1526762 1.65113194,25.0634592 C1.68104687,25.1820387 1.65113194,25.2272119 1.65113194,25.2723851 C1.59186652,25.2418932 1.51736142,25.211966 1.44342076,25.1820387 C1.50268618,25.1086323 1.5619516,25.033532 1.65113194,24.9448796 C1.65113194,24.8104894 1.57775571,24.6907806 1.36891566,24.7060265 C1.458096,24.6766639 1.54727635,24.6326201 1.65113194,24.6021282 C1.81481738,24.5134759 1.63645669,24.3497231 1.63645669,24.1413619 C1.65113194,23.8889568 1.50268618,23.6359871 1.458096,23.3677714 C1.38359091,22.9516136 1.39883059,22.32653 1.35424041,21.9098075 C1.26506007,21.8352718 1.19055497,22.0283871 1.17587972,22.043633 C1.22103433,22.400501 1.26506007,22.757369 1.29441056,23.1148017 C1.20579465,22.8172235 1.1459648,22.489718 1.07202413,22.1322853 C1.05678445,22.2367483 1.04210921,22.2813568 1.04210921,22.3412112 C0.968732975,22.4146176 1.02743396,22.504964 1.07202413,22.6088622 C0.968168542,22.5636891 0.849073272,22.5794997 0.849073272,22.5794997 L0.849073272,22.9962221 C0.701191941,22.8471507 0.657166202,22.7285711 0.582096671,22.6235435 C0.552746178,22.504964 0.536942066,22.3863844 0.508720438,22.2678048 C0.536942066,22.1927044 0.508720438,22.1480959 0.508720438,22.1040521 C0.491283355,21.9850329 0.476228806,21.8656766 0.463565833,21.7460548 C0.47824108,21.7313735 0.448890587,21.5088956 0.448890587,21.5088956 C0.567421424,21.5230123 0.642490955,21.5371289 0.71643162,21.5371289 C0.567985857,21.3451429 0.671277016,21.225434 0.7316713,21.1062898 C0.761586225,21.0464353 0.865441816,21.0328834 0.895356742,20.9718996 C1.01388758,20.7488571 1.20748795,20.5709878 1.20748795,20.2875262 C1.20748795,20.1537006 1.25264255,20.0051939 1.26675337,19.8708037 C1.29666829,19.617834 1.32601879,19.3648642 1.3401296,19.1118945 C1.37060896,18.784389 1.3401296,18.4568836 1.41519913,18.1446241 C1.53485883,17.6251327 1.6833046,17.1039472 1.84642561,16.5827618 C1.96495644,16.2100832 2.09929139,15.8543445 2.24717272,15.4816659 C2.47012359,14.9011907 2.6783992,14.3207155 2.96061548,13.7707322 C3.3613626,12.9666499 3.82193957,12.1930594 4.26784129,11.4047876 C4.55005757,10.9135295 4.8469491,10.4521985 5.15964474,9.97618625 C5.45597183,9.51485529 5.75229893,9.03884305 6.09490949,8.60687465 C6.56522653,7.99756312 7.092534,7.43449246 7.66967633,6.92530353 C8.26402382,6.3900015 8.82845638,5.83945354 9.46682961,5.34819535 C10.2977071,4.70733572 11.1824633,4.13961205 12.1111962,3.65137829 C12.8692291,3.25046644 13.6560481,2.93651293 14.4434315,2.6389347 C14.9485986,2.44581941 15.4977915,2.35660241 16.0181983,2.19284968 C16.6119814,1.99916973 17.2063289,1.91051739 17.8300269,1.89527145 C18.230774,1.8800255 18.6174103,1.835417 19.0181574,1.7908085 C19.3748788,1.76257527 19.7310357,1.73208338 20.117672,1.68747488 C20.0725174,1.74676466 20.0578422,1.77669188 20.0431669,1.80605444 C19.8806103,2.04434289 19.7022497,2.28263135 19.5385642,2.52035514 C19.4047937,2.71403509 19.2563479,2.92239632 19.1225774,3.1155116 C18.8843869,3.42890045 18.6315211,3.74115996 18.4091347,4.06866541 C18.067653,4.5599236 17.7555218,5.06586306 17.3988004,5.55655658 C17.0432079,6.03256882 16.6565716,6.47921851 16.2851749,6.93998481 C15.7952475,7.58031444 15.3346705,8.23476069 14.844743,8.87452566 C14.3988413,9.4843634 13.924718,10.0659679 13.4934915,10.6758057 C13.1074196,11.210543 12.7653735,11.7769016 12.3939769,12.3263202 C11.844784,13.1450839 11.2950267,13.9480369 10.7458338,14.7668006 C10.3146864,15.3900213 9.87893256,16.01004 9.43860798,16.6268057 C9.40869305,16.6719788 9.36410288,16.6855308 9.32007714,16.715458 C9.2015463,16.9085733 9.2015463,17.0130363 9.1563917,17.1022533 C9.03786086,17.3252958 8.91933002,17.5483383 8.78499507,17.7572642 C8.71048998,17.8758437 8.60663438,17.979742 8.51745404,18.0988862 C8.50277879,17.9204522 8.75451571,17.8312352 8.63598488,17.6076281 C8.56260864,17.7273369 8.48753911,17.8312352 8.41359845,17.9503795 L8.23523776,18.3061181 C8.29450318,18.3512913 8.3989232,18.3812185 8.29450318,18.4698709 C8.24934857,18.5449713 8.20532283,18.6336236 8.16073266,18.708724 C8.22502501,18.67091 8.28076435,18.6201471 8.3244181,18.5596525 C8.3244181,18.7234053 8.23523776,18.8566661 8.16073266,18.9904916 C8.10146724,19.1090712 7.95302148,19.1994175 7.84916589,19.2880698 C7.86384113,19.3033158 7.96769673,19.3479243 7.9829364,19.3626056 C8.11670692,19.3174324 8.16129709,19.244026 8.17653677,19.2880698 C8.22169138,19.2287801 8.26571712,19.1841716 8.28039236,19.1395631 C8.33909335,18.9904916 8.42827369,18.8719121 8.57671946,18.8120576 C8.63654931,18.7821304 8.68057505,18.7375219 8.72516522,18.693478 C9.17106694,18.2315824 9.63164391,17.7854974 10.032391,17.2942392 C10.6566534,16.5347654 11.221086,15.7470583 11.8159979,14.9734678 C12.0677348,14.6459623 12.3651908,14.3184569 12.6321674,14.0056327 C12.6761931,14.3478194 12.6468427,14.6747602 12.6321674,14.9881491 C12.5870128,15.5381324 12.5576623,16.089245 12.5136366,16.6539096 C12.4983969,16.8769521 12.5136366,17.0999946 12.4983969,17.3236018 C12.4983969,17.3828916 12.4532423,17.4275001 12.4532423,17.4873545 C12.4532423,17.6358613 12.4983969,17.799614 12.4983969,17.9486855 C12.4532423,18.4992334 12.3934124,19.0345354 12.3488223,19.5850834 C12.3335826,19.703663 12.392848,19.8233719 12.4221985,19.9278348 C12.3488223,20.7307878 12.5125077,21.5794787 12.3781728,22.4276049 C12.4820283,22.2638522 12.5119433,22.1599539 12.5119433,22.0560556 C12.5260541,21.9668386 12.5119433,21.8776216 12.5119433,21.7737233 L12.5119433,21.6246519 C12.5260541,21.3564362 12.5853195,21.0741039 12.555969,20.8058882 C12.5260541,20.50831 12.5260541,20.2259777 12.5858839,19.9430808 C12.6157989,19.8245012 12.5712087,19.6754297 12.6457138,19.5263583 L12.6457138,19.7494008 C12.6310385,20.5963977 12.6609535,21.4450885 12.5424226,22.2932147 C12.5271829,22.3677505 12.5875772,22.5021406 12.4238918,22.4868947 C12.2895568,22.7545457 12.4532423,22.9482257 12.305361,23.0967324 C12.2748816,23.1266597 12.3335826,23.2604852 12.3488223,23.3497022 C12.2889924,23.5287008 12.2889924,23.5287008 12.3781728,23.5433821 C12.392848,23.8708876 12.4233274,24.1679011 12.4374382,24.4807253 C12.6744998,23.9160607 12.555969,23.3344562 12.6609535,22.753981 C12.6756287,22.9922695 12.6908684,23.2305579 12.6756287,23.4823983 C12.6756287,23.8703229 12.6609535,24.2418722 12.6462782,24.6286674 C12.6462782,24.7032032 12.6310385,24.7777389 12.6163633,24.8522746 C12.5712087,25.0612005 12.5570979,25.2689971 12.4825928,25.4621124 C12.4233274,25.6111838 12.4532423,25.834791 12.4532423,26.0126603 L12.4532423,26.5790189 C12.5125077,26.8319886 12.4380026,26.9658141 12.4825928,27.1143209 C12.4374382,27.263957 12.4233274,27.3085655 12.4374382,27.353174 L12.4825928,27.5762166 C12.7800487,27.5462893 12.6462782,27.7698965 12.7648091,27.8884761 C12.6756287,28.008185 12.7055436,28.0522288 12.7055436,28.1126479 C12.7055436,28.2464734 12.6914328,28.3656176 12.6761931,28.4994431 C12.6761931,28.8416299 12.6615179,29.1838166 12.6615179,29.5113221 C12.6615179,29.5564952 12.6761931,29.5999744 12.6761931,29.6445829 C12.6761931,29.6750748 12.6615179,30.0624347 12.6615179,30.0624347 C12.6914328,30.1064785 12.6615179,30.151087 12.6163633,30.1956955 C12.6022525,30.1956955 12.5576623,28.3057632 12.5576623,28.3057632 L12.3347114,28.3057632 C12.305361,29.1979332 12.3798661,30.0014509 12.2161806,30.8354605 C12.0378199,30.8495771 11.9791189,30.8795043 11.7849541,30.8795043 C11.3243772,30.8795043 10.8638002,30.8795043 10.4032232,30.8941856 C9.85346591,30.8941856 9.31951271,30.9088669 8.76919096,30.9088669 C8.50277879,30.9088669 8.22056251,30.9393588 7.95302148,30.9393588 C7.5963001,30.9393588 7.22490348,30.8941856 6.86931096,30.8941856 C6.31898922,30.8941856 5.78447158,30.9393588 5.23471427,30.9540401 C4.83396715,30.9687214 4.43322003,30.9687214 4.03247291,30.9839673 C3.76436745,30.9980839 3.49626198,31.0122005 3.22984981,31.0426924 C3.11131897,31.0573737 3.00689895,31.1019822 2.85845319,31.1465907 C2.81329858,31.1465907 2.71000742,31.1319094 2.62139151,31.1465907 C2.47181688,31.1765179 2.33917523,31.2651703 2.1896006,31.2956621 C1.96664974,31.3408353 1.90738432,31.3995604 1.93673482,31.6231676 L1.93673482,31.7716744 C1.92205957,31.8010369 2.2641057,31.7265012 2.2641057,31.7265012 C2.23362634,31.7265012 2.2189511,31.8157182 2.17379649,31.8902539 C2.29345619,31.8450808 2.36739686,31.8157182 2.44190196,31.7863557 C2.66485282,31.8908186 2.85788876,31.8315288 3.03568501,31.876702 C3.61479282,32.0246441 4.20857587,32.0856279 4.80235893,32.1437883 C5.18899523,32.1737156 5.56039185,32.1889615 5.94646373,32.2030781 C6.49565661,32.2330053 7.04541392,32.2629326 7.5946068,32.2629326 C8.05518377,32.2629326 8.5010855,32.2177594 8.9605336,32.2177594 C9.59834239,32.2177594 10.2384089,32.247122 10.8767821,32.2629326 C11.0105527,32.2629326 11.1589984,32.247122 11.3074442,32.247122 L12.3911547,32.247122 C13.3574632,32.2177594 14.3226429,32.2019488 15.288387,32.1737156 C15.8387088,32.157905 16.4031413,32.1285424 16.9523342,32.1132965 L18.6456319,32.0681233 C19.2992448,32.053442 19.9528577,32.053442 20.5917954,32.0398901 C21.0817228,32.0398901 21.5569751,32.0229501 22.0480314,32.0088335 C22.5966598,31.9941522 23.1610924,31.9495437 23.7108497,31.9201812 C24.0083057,31.9049352 24.3057616,31.875008 24.6026531,31.8456454 C24.9593745,31.8162829 25.3307712,31.7722391 25.6863637,31.7569931 C26.2214457,31.7265012 26.771203,31.7118199 27.3062851,31.6818927 C27.9745733,31.6378489 28.6428614,31.5785591 29.3258248,31.5633132 C29.9500872,31.5339506 30.5884605,31.5486319 31.2127229,31.5339506 C31.7624802,31.5187047 32.3122375,31.4887774 32.8766701,31.4740962 L33.8136281,31.428923 C33.8136281,31.428923 34.4367617,31.4142417 34.7488929,31.3837498 C35.2834105,31.3543873 35.8179281,31.2950975 36.3530102,31.2804162 C36.6939275,31.2651703 37.0359736,31.2804162 37.3774553,31.2651703 C37.9266482,31.250489 38.4910807,31.2199971 39.040838,31.2199971 C39.2479848,31.2199971 39.4709357,31.250489 39.7384767,31.2651703 C39.6199459,31.3696332 39.5454408,31.428923 39.4562604,31.5034587 C39.5155258,31.51814 39.5747912,31.5486319 39.6346211,31.5779944 C39.5653546,31.6269397 39.4823532,31.6526412 39.3975594,31.6514008 C39.3670801,31.7265012 39.3371651,31.7564284 39.3072502,31.9054999 L39.5747912,31.9054999 C39.4709357,31.9054999 39.3817553,32.0393254 39.2778997,32.1285424 C39.1593689,32.0980505 39.0549489,32.1285424 38.9956834,32.2922951 C39.099539,32.3510202 39.0848638,32.3956287 39.0701885,32.4560479 C38.8918279,32.514773 38.7580573,32.5746274 38.8331269,32.7677427 C38.7727326,32.7971053 38.6987919,32.8270325 38.6242868,32.871641 C38.5509106,32.9902206 38.4165756,33.0201478 38.4459261,33.1839005 C38.505756,33.1980171 38.564457,33.2290737 38.6096116,33.2426256 C38.5351065,33.2725528 38.4611658,33.3171613 38.3866607,33.3465239 C38.1196841,33.5102766 38.2387794,33.5848124 38.2980448,33.6593481 C38.2528902,33.6892753 38.2088645,33.7186379 38.1642743,33.7338838 C38.1936248,33.8677093 38.2376505,33.8976365 38.2528902,33.8976365 C38.1769698,33.9550812 38.1026253,34.0145812 38.0299393,34.0760705 C37.9847847,34.209896 37.9255193,34.2691858 37.8662539,34.3584028 C37.8069885,34.4476198 37.7770735,34.5673287 37.7025684,34.6559811 C37.3910017,34.9987325 37.1680508,35.4013383 36.7673037,35.6684247 C36.6182935,35.7728876 36.4850874,35.9067131 36.3513169,36.0411033 C36.0837759,36.2935083 35.8461498,36.5764053 35.5639335,36.8146938 C35.190765,37.1238558 34.8043278,37.4166288 34.4057179,37.6921825 C33.9193198,38.0345777 33.4293657,38.371889 32.9359355,38.7040614 C32.6683944,38.8819308 32.3715029,39.0157563 32.0892866,39.179509 C31.8070704,39.3432617 31.5395293,39.4923332 31.257313,39.6555213 C31.0789523,39.7741008 30.9152669,39.9378535 30.722231,40.0281999 C30.2323035,40.2371258 29.7118967,40.4149951 29.207294,40.6086751 C28.7162377,40.817601 28.3606451,40.9954703 27.9892485,41.1292958 C27.6477668,41.2478754 27.2910454,41.3382217 26.9348885,41.4116281 C26.8163577,41.44212 26.6820227,41.4116281 26.5482522,41.426874 C26.2953864,41.4720472 26.043085,41.5319017 25.7902193,41.5612642 C25.1366064,41.6504812 24.4829934,41.7103357 23.829945,41.7995527 C23.4433087,41.8447258 23.071912,41.9181322 22.6858402,41.9633054 C22.4188636,41.9779867 22.1366473,41.9486241 21.8691063,41.9486241 C21.6760703,41.9486241 21.4683591,41.9937973 21.2747588,41.9638701 C20.963192,41.9186969 20.6510608,41.8452905 20.3389296,41.7854361 C20.2655534,41.7707548 20.1605689,41.7402629 20.1018679,41.7707548 C19.9833371,41.8306092 19.8783526,41.7413922 19.7592573,41.7707548 C19.6858811,41.7860007 19.611376,41.7255816 19.5368709,41.7255816 C19.4770411,41.711465 19.402536,41.7413922 19.3280309,41.7255816 C19.1643454,41.6815378 19.0164641,41.622248 18.8369745,41.6369293 C18.6603072,41.6516105 18.481382,41.5623935 18.289475,41.5183497 C18.0213695,41.4584953 17.770197,41.3997701 17.5015271,41.339351 C17.3976999,41.3069091 17.2981956,41.2619715 17.2052,41.2055255 C16.8185637,41.2055255 16.5656979,41.1908442 16.3280718,41.1010626 C16.1203606,41.0276562 15.9273247,40.9231932 15.7043738,40.9531205 C15.6456728,40.9678017 15.6010827,40.9384392 15.5406884,40.9384392 C15.4955338,40.8785847 15.4520725,40.7594405 15.4080467,40.7594405 C15.1111552,40.7746865 14.9327945,40.5222814 14.6799287,40.447181 C14.5467227,40.4020078 14.4428671,40.253501 14.3090965,40.2088925 C13.9817257,40.075067 13.7153135,39.7927347 13.3439169,39.7481262 C13.225386,39.7328803 13.1068552,39.6735905 12.9725202,39.6295467 C13.0176748,39.6882718 13.0458965,39.7328803 13.0910511,39.7774888 C12.660389,39.5685629 12.2596419,39.3314038 11.8583304,39.1077966 C11.7996294,39.0931153 11.7550392,39.0343902 11.710449,39.0038983 L11.3097019,38.7362473 C11.0867511,38.7814205 10.9975707,38.6910742 10.9371764,38.6617116 C10.5364293,38.3793793 10.0764168,38.2003806 9.68978047,37.8881211 C9.52609503,37.7537309 9.33418795,37.6645139 9.21565712,37.5007612 C9.00681707,37.2477915 8.75451571,37.0693575 8.47229943,36.9208507 C8.24991301,36.8022711 8.04220182,36.667881 7.83449064,36.5340555 C7.73007062,36.4595197 7.62565059,36.3703027 7.62565059,36.20655 C7.62565059,36.1020871 7.58162485,35.9976241 7.44785434,36.0574786 C7.38858892,35.9682615 7.3293235,35.8643633 7.2548184,35.834436 C7.07645771,35.7610296 6.95792687,35.6255101 6.82415636,35.5069306 C6.69038584,35.388351 6.58709468,35.2245983 6.42340924,35.1653085 C6.12595328,35.046729 5.94759259,34.7937592 5.76979633,34.585398 C5.35324511,34.0941398 4.98184848,33.5577085 4.59577661,33.038217 C4.56586168,32.9930439 4.50659626,32.9631167 4.46200609,32.9185081 C4.52127151,33.0822609 4.59577661,33.2160864 4.66971727,33.3645932 C4.52183594,33.3053034 4.41798035,33.2008404 4.32880001,33.0969422 C4.31356033,33.1121881 5.35324511,34.8231218 5.35324511,34.8231218 C5.44355431,34.9569473 5.51693055,35.0913375 5.60611089,35.225163 C5.42319913,35.2421825 5.24776802,35.1484326 5.16020917,34.9868745 C5.02700309,34.7497154 4.87799289,34.6006439 4.58110136,34.6311358 C4.54959224,34.5236688 4.52508207,34.4142708 4.50772513,34.3036304 C4.44733085,34.3036304 4.40330511,34.3036304 4.29888508,34.2883844 C4.50772513,34.6158899 4.68552139,34.8982222 4.87855732,35.2257276 C4.80348779,35.1805545 4.76002648,35.1511919 4.72898269,35.1365106 C4.99595929,35.4188429 5.18899523,35.7762756 5.53047693,35.9552743 C5.60498203,36.2968963 5.9910539,36.4606491 6.08023424,36.7881545 C6.00685801,36.7729086 5.94589929,36.7582273 5.8713942,36.7429814 C5.75286336,36.5944746 5.61909284,36.4459678 5.48588676,36.2822151 C5.51523725,36.3861133 5.55926299,36.4753303 5.61909284,36.5498661 C5.79745353,36.7729086 5.96113897,36.9959511 6.16885016,37.189631 C6.24335525,37.2652961 6.34721084,37.2952233 6.34721084,37.4290488 C6.46574168,37.4883386 6.51089629,37.5024552 6.55492203,37.5024552 C6.58540138,37.5928015 6.54081121,37.726627 6.71860747,37.6966998 C6.83713831,37.9197423 6.95566914,37.9197423 7.11935459,37.8457713 C7.31295496,38.0394512 7.41737498,38.0546972 7.55058106,37.9361176 C7.55058106,38.009524 7.56525631,38.0840597 7.56525631,38.1439142 C7.62452173,38.113987 7.61041091,38.0693785 7.61041091,37.9948427 C7.68378715,38.0541325 7.72894175,38.0840597 7.75829225,38.1134223 C7.90673801,38.3223482 8.04050853,38.5154635 8.24821971,38.6792162 C8.53043599,38.9175046 8.78330178,39.1704744 9.04971394,39.3935169 C9.57012076,39.8254853 10.1503574,40.182918 10.7289008,40.5098588 C11.4423436,40.9118999 12.1258714,41.3433037 12.853425,41.7295343 C13.7294243,42.1914299 14.6652535,42.5042541 15.6304332,42.7272966 C15.9871545,42.8018323 16.3286362,42.8758034 16.6859221,42.9644557 C16.99636,43.054802 17.3090556,43.1886275 17.6211868,43.2625986 C18.096439,43.3670615 18.5863665,43.4562785 19.0616187,43.5449309 C19.1649099,43.5601768 19.2704587,43.5754228 19.3889896,43.5901041 C19.5216312,43.6200313 19.6847522,43.5601768 19.7146672,43.60535 C19.7891723,43.7239296 19.8484377,43.6640751 19.937618,43.6493938 C20.0414736,43.6194666 20.1605689,43.6194666 20.2790997,43.6194666 C20.6950865,43.6341479 21.0958337,43.7233649 21.5118204,43.6940023 C21.6021297,43.6940023 21.7353357,43.6189019 21.8098408,43.7674087 C21.9430469,43.7081189 22.017552,43.7081189 22.0768174,43.6940023 C22.0926216,43.8272632 22.0768174,43.8272632 22.0485958,43.8419445 C22.0181165,43.8566257 21.9735263,43.8718717 21.9142609,43.9164802 C22.4487785,44.0203785 22.9539456,44.0350597 23.3987185,43.9164802 C24.1719911,43.97577 24.8402793,43.886553 25.4792169,43.6635104 C25.5384823,43.7380462 25.5830725,43.8419445 25.6722529,43.6934377 C25.7016033,43.6482645 25.7761084,43.6330186 25.8359383,43.6183373 C25.9691444,43.5884101 26.1328298,43.5291203 26.2513607,43.5731641 C26.3856956,43.6183373 26.4302858,43.4997577 26.5335769,43.4997577 C26.7125021,43.4997577 26.8756231,43.4845118 27.0393085,43.4545846 C27.1284889,43.4399033 27.2176692,43.3952948 27.3215248,43.3653675 C27.2197779,43.315054 27.1076481,43.2893309 26.9941539,43.2902672 C27.173079,43.2010502 27.3362,43.1265144 27.4998855,43.053108 C27.4699706,43.0971519 27.4400556,43.1564417 27.3813546,43.1564417 L27.5885014,43.1564417 C27.5433468,43.1564417 27.4840814,43.2902672 27.4101407,43.3794842 C27.9440939,43.2456587 28.4340214,43.1265144 28.909838,43.0068055 C28.7461526,42.6951107 29.0876343,42.7995736 29.2067295,42.620575 C29.0582838,42.6657481 28.909838,42.709792 28.7608278,42.7391545 C29.265995,42.4867495 29.7858374,42.263707 30.2904401,42.0406644 C30.2170638,42.1298814 30.1267546,42.1744899 29.994113,42.2495903 C30.0832933,42.263707 30.1425587,42.263707 30.1871489,42.2778236 C30.4242106,42.352924 30.3655096,42.1298814 30.4394503,41.9954913 C30.7216665,41.9954913 30.8401974,41.9514474 30.9739679,41.9062743 C31.1224137,41.8611011 31.2708594,41.8170573 31.4198696,41.7577675 C31.6569313,41.6538692 31.8798822,41.5206084 32.1175083,41.4020288 C32.1626629,41.3862182 32.2360391,41.4020288 32.2958689,41.4020288 C32.4595544,41.2970012 32.5182554,41.2077842 32.5628456,41.2224655 C32.7716856,41.2523927 32.9184381,41.1772923 32.9782679,40.9853063 C33.0821235,40.910206 33.1566286,40.8509162 33.2305693,40.805743 C33.5568113,40.627309 33.8683781,40.448875 34.1957489,40.270441 C34.3142798,40.270441 34.3741096,40.270441 34.4034601,40.255195 C34.5976249,40.1648487 34.7759856,40.0620798 34.9537819,39.9576168 C34.9027617,39.9363931 34.8531751,39.9118726 34.8053361,39.8842104 C34.9532174,39.8537185 34.9972432,39.8390372 35.0875524,39.80911 C35.4431449,39.3912582 35.9342012,39.1089259 36.3050334,38.7814205 C36.4687189,38.7667392 36.4687189,38.7221307 36.4687189,38.6927681 C36.5274199,38.6182324 36.5872497,38.5290154 36.6606259,38.469161 C36.9879968,38.1715827 37.3435893,37.918613 37.6410453,37.6063535 C38.0711543,37.177577 38.4824486,36.7303178 38.873766,36.2658398 C39.2293585,35.8491173 39.5872088,35.4329595 39.8841003,34.9716286 C40.3000871,34.3318636 40.656244,33.6768527 41.0276407,33.0065958 C41.2951817,32.5311482 41.5328078,32.055136 41.8009133,31.5791238 C41.8291349,31.5339506 41.8895292,31.4746608 41.9341194,31.4746608 C42.3348665,31.4294877 42.7367425,31.4012544 43.1228143,31.3560813 C43.2119947,31.3414 43.3158503,31.2826749 43.4050306,31.2375017 C43.359876,31.162966 43.3305255,31.073749 43.2864998,30.9992132 C43.2266699,30.9088669 43.1374896,30.8354605 43.0776597,30.7451142 C43.0189587,30.6717078 42.9743686,30.5813615 42.9297784,30.4927091 C42.8846238,30.4193027 42.840598,30.3594483 42.7960079,30.2837832 C42.7027159,30.119998 42.6179382,29.9515037 42.5420132,29.7789731 C42.527338,29.7337999 42.4968586,29.6603935 42.5126627,29.6152204 C42.7802038,29.0353098 42.8840594,28.4102261 43.1363607,27.829751 C43.3886621,27.2345945 43.4637316,26.5649023 43.5822624,25.9251373 C43.686118,25.3152996 43.7459479,24.7054618 43.8193241,24.0956241 C43.8644787,23.6642203 43.9237441,23.2474979 43.9378549,22.8160941 C44.0281642,22.1317207 43.9976848,21.491391 43.9830095,20.8510614 C43.9683343,20.2863968 43.9378549,19.7059216 43.9096333,19.1401277 L43.9062467,19.1384337 Z M6.63958691,37.4550234 C6.53573132,37.3364438 6.44655097,37.2020537 6.34269538,37.0834741 L6.38784999,37.0383009 C6.54984213,37.2172996 6.71352758,37.3957336 6.87664859,37.5894136 C6.78746824,37.5442404 6.68361265,37.5148778 6.63958691,37.4550234 Z M6.87664859,37.5894136 C6.92180319,37.5741676 6.9669578,37.5741676 7.01098354,37.5594863 C7.05613814,37.6340221 7.08548863,37.7232391 7.12951437,37.8124561 C6.92180319,37.7972101 6.8179476,37.7079931 6.87721302,37.5894136 L6.87664859,37.5894136 Z M22.3251678,43.7346582 L22.3251678,43.689485 C22.607384,43.6601225 22.8743606,43.6301952 23.1565769,43.6008327 L23.1565769,43.6443119 C22.8743606,43.689485 22.607384,43.7177182 22.3251678,43.7335289 L22.3251678,43.7346582 Z M26.0673556,43.3478629 C25.8602089,43.3930361 25.637258,43.4229633 25.4295469,43.4528906 C25.3550418,43.4675718 25.2658614,43.5421076 25.2365109,43.4077174 C25.206596,43.4229633 25.1766811,43.4229633 25.1473306,43.4382093 C25.2207068,43.6606871 25.3996319,43.4822531 25.5480777,43.5714701 C25.2207068,43.6166433 24.9102689,43.6460058 24.5975733,43.6900497 L24.5975733,43.6606871 C24.6878825,43.6460058 24.7911736,43.6307599 24.8797895,43.615514 L24.8797895,43.5714701 C24.7317631,43.5538934 24.5829346,43.5439046 24.4338878,43.5415429 C24.3904265,43.5415429 24.3305967,43.6013973 24.2860065,43.6160786 C24.2267411,43.6307599 24.1674756,43.6460058 24.0929705,43.6460058 C23.8406692,43.6606871 23.5883678,43.6606871 23.3501773,43.6753684 C23.3349376,43.6753684 23.3050227,43.6606871 23.2903474,43.6606871 L23.2903474,43.615514 C24.2854421,43.4822531 25.2658614,43.3484276 26.260956,43.2146021 C26.2761957,43.2439647 26.2761957,43.2738919 26.2908709,43.3032544 C26.2016906,43.3032544 26.1424252,43.334311 26.0679201,43.3484276 L26.0673556,43.3478629 Z M26.2908709,43.1999208 C26.6329171,43.1547477 26.9456127,43.1253851 27.2718547,43.0813413 C26.5888913,43.2744566 26.3659405,43.3038191 26.2914354,43.1999208 L26.2908709,43.1999208 Z M13.3535122,13.1569418 C13.8276356,12.5019309 14.3186919,11.84692 14.7939441,11.1777925 C14.9423899,10.9829832 15.0609207,10.774622 15.2093665,10.5815067 C15.2545211,10.5216522 15.3137865,10.4922897 15.3877272,10.4324352 L15.3730519,10.404202 C15.4323173,10.3291016 15.4915828,10.2686825 15.5214977,10.2099574 C15.5971316,10.0913778 15.6417218,9.95698766 15.7009872,9.82316215 C15.7156625,9.79492892 15.7602527,9.7650017 15.7602527,9.7650017 C15.9690927,9.86889998 15.9690927,9.64642214 16.0424689,9.57132175 C16.1762395,9.4222503 16.31001,9.25906224 16.4285408,9.10999079 C16.5177212,8.99141123 16.6069015,8.88694828 16.6814066,8.75312277 C16.6960818,8.70794961 16.6514917,8.63454321 16.636252,8.5741241 L16.5922263,8.5741241 C16.6373809,8.54476154 16.6814066,8.5007177 16.7259968,8.47022582 C16.740672,8.47022582 16.740672,8.47022582 16.7553473,8.45554454 C16.8445276,8.32115437 16.9337079,8.18732886 17.0228883,8.06818464 C17.2006846,7.83102551 17.3937205,7.59273706 17.6014317,7.38494049 C17.5720812,7.45834689 17.5421662,7.53344728 17.5122513,7.59273706 C17.527491,7.59273706 17.527491,7.607983 17.5421662,7.607983 C17.7205269,7.36969455 17.9135629,7.14665204 18.0919236,6.90779892 C18.0766839,6.89368231 18.0620086,6.87843637 18.046769,6.87843637 C17.9733927,6.95297209 17.9135629,7.02750782 17.8390578,7.10204354 C17.8243825,7.0867976 17.8097073,7.07211632 17.7939032,7.07211632 C17.9434778,6.87843637 18.0919236,6.68532108 18.2398049,6.46227857 C18.2697198,6.50745174 18.2996347,6.56617685 18.3583357,6.68532108 C18.41873,6.53681429 18.4779954,6.43291601 18.5220212,6.32845306 C18.4779954,6.37362623 18.41873,6.41767007 18.3741398,6.46284323 L18.3289852,6.41767007 L18.5965263,6.01675822 C18.8787426,5.61471704 19.1609588,5.19799458 19.4431751,4.79595339 C19.5475951,4.64744661 19.6802368,4.52830238 19.770546,4.37923093 C20.0527623,3.81456635 20.498664,3.36735201 20.8395813,2.84673126 C20.9140864,2.74283298 21.017942,2.65361598 21.1071223,2.56439897 C21.1804985,2.47405264 21.2408928,2.50454453 21.3001582,2.57908025 C21.7009054,3.08501972 22.1016525,3.60564046 22.5023996,4.11157992 C22.80042,4.48425855 23.0973115,4.83999723 23.3795278,5.22735713 C23.7210095,5.70393404 24.0478159,6.17994628 24.3898621,6.65595852 C24.7759339,7.20650649 25.1620058,7.75705445 25.5334024,8.32171903 C26.097835,9.15572862 26.6323526,9.98917354 27.1967852,10.8220538 C27.612772,11.4318915 28.0287588,12.0276127 28.4295059,12.6374504 L27.6709085,12.6374504 C26.9732699,12.6233338 26.2598271,12.564044 25.5621885,12.5934066 C24.6116841,12.6385797 23.6465044,12.742478 22.696,12.8170138 C21.4926297,12.9214767 20.2745843,12.9355933 19.0723429,12.9355933 C18.640552,12.9355933 18.20989,12.9960124 17.7797924,13.0259397 C17.2593855,13.0553022 16.7542184,13.0852294 16.234376,13.099346 C15.6247888,13.1298379 15.0321347,13.1445192 14.4225475,13.1597652 C14.0805014,13.1744464 13.7243444,13.1597652 13.3529478,13.1597652 L13.3535122,13.1569418 Z M30.3897802,20.0006765 L30.3897802,20.1350667 C30.3751049,20.1350667 30.3604297,20.1503127 30.3305148,20.1503127 C30.2712494,19.9413868 30.2119839,19.7177796 30.1374788,19.5094184 C29.9890331,19.07745 29.8253476,18.6454816 29.5578066,18.259251 C29.2597862,17.8430932 28.993374,17.4122541 28.6953536,16.9802857 C28.6219774,16.8758228 28.516993,16.7866058 28.4278126,16.6979534 C28.1156814,16.355202 27.8035502,15.9977693 27.4028031,15.7453643 C26.8123396,15.3748486 26.1910447,15.0559498 25.54582,14.7922105 C25.3666751,14.7152702 25.1931552,14.625833 25.026542,14.5245594 L25.3821345,14.5245594 L27.922081,14.4793863 C28.4718384,14.4652697 29.0069204,14.4652697 29.5561133,14.4353424 C29.6893194,14.4353424 29.7638245,14.4805156 29.8383296,14.5990952 C29.9715357,14.8221377 30.1053062,15.0451802 30.2537519,15.2687874 C30.2689916,15.2981499 30.2989065,15.3421938 30.2989065,15.3873669 C30.2989065,15.7148724 30.2989065,16.0570591 30.3135818,16.3845646 C30.3276926,16.7267513 30.3587364,17.0542568 30.3722828,17.3964435 C30.3722828,17.7386302 30.3423679,18.0954983 30.3576075,18.4523663 C30.3728472,18.9588704 30.3875225,19.4800558 30.3875225,19.9995472 L30.3897802,20.0006765 Z M14.4073078,15.0180763 C15.1055109,14.9881491 15.7732346,14.9435406 16.4573269,14.9136133 C16.9907156,14.8836861 17.5410374,14.8684402 18.0749906,14.8390776 C18.2979414,14.824961 18.5062171,14.8108444 18.7286035,14.8390776 C18.4915418,14.9587865 18.2533513,15.0779307 18.0456401,15.2264375 C17.7780991,15.4048715 17.5263621,15.6425953 17.2582567,15.8362753 C16.9901512,16.0293906 16.7525251,16.267679 16.5301387,16.5206487 C16.2479224,16.8622708 15.9357912,17.159849 15.6383352,17.4873545 C15.4294952,17.725643 15.1924335,17.9486855 15.0146372,18.2016552 C14.7623359,18.5291607 14.539385,18.8848993 14.3017589,19.257578 C14.376264,17.8436578 14.4654444,16.4455483 14.4056145,15.016947 L14.4073078,15.0180763 Z M24.1070814,29.3323234 C23.6312647,29.450903 23.1419017,29.5852931 22.6508454,29.6445829 C22.235423,29.7044374 21.8041965,29.6897561 21.3735345,29.6897561 C20.9863337,29.6897561 20.6149371,29.6750748 20.2288652,29.6445829 C19.7982032,29.6005391 19.3675412,29.5559306 18.9515544,29.3622506 C18.5942685,29.1984979 18.2234364,29.0499911 17.8678438,28.8709924 C17.5099936,28.6925584 17.1538366,28.4847619 16.8857312,28.1572564 C16.6938241,27.9184033 16.4257186,27.725288 16.1880925,27.5169268 C16.2332471,27.6953608 16.3365383,27.8444322 16.5002237,27.9483305 C16.4257186,28.0375475 16.3218631,27.9935037 16.1728529,27.7546506 C16.1288271,27.7845778 16.0842369,27.7998237 16.054322,27.814505 C16.0994766,27.7100421 16.1435024,27.6055791 16.1880925,27.5169268 C16.1288271,27.3983472 16.054322,27.263957 15.9950566,27.1442482 C15.8765258,26.9511329 15.7579949,26.7433363 15.6535749,26.5496563 C15.62366,26.5044832 15.62366,26.4604393 15.5943095,26.4158308 C15.5201731,26.3300441 15.4504688,26.240522 15.3854694,26.1476152 C15.2669386,25.9697458 15.163083,25.7766305 15.0146372,25.5976319 C15.0146372,25.642805 15.0298769,25.6868489 15.0298769,25.7467033 C15.0146372,25.7467033 14.999962,25.7613846 14.999962,25.7613846 L14.6872664,25.0024754 C14.6725911,25.0024754 14.6725911,25.0024754 14.6579159,25.0171567 L14.9248925,25.999673 C14.9102172,25.999673 14.895542,26.0137897 14.8797379,26.0137897 C14.8362766,25.9550645 14.7916864,25.8952101 14.761207,25.8218037 C14.7318565,25.7020948 14.6426762,25.7020948 14.5693,25.7467033 C14.5241453,25.7766305 14.4942304,25.8805288 14.5094701,25.9251373 C14.6138901,26.1781071 14.732421,26.4310768 14.8515162,26.6840465 C14.8808667,26.7732635 14.9107817,26.8477992 14.9553718,26.9370163 C14.9706115,26.9669435 15.0152017,26.996306 15.0152017,27.0409145 C15.0750315,27.1594941 15.1196217,27.2780737 15.1935624,27.3831013 C15.3273329,27.5615353 15.4757786,27.7399693 15.6095492,27.9184033 C15.7421908,28.0968373 15.8607217,28.2910819 15.9798169,28.4689513 C15.9944922,28.4988785 16.0390823,28.4988785 16.0531932,28.5141244 C16.1282627,28.7371669 16.380564,28.900355 16.5589247,28.811138 C16.6040793,29.1533247 16.9749115,29.272469 17.1233573,29.5999744 C16.977589,29.5404595 16.8339471,29.47586 16.6926952,29.4062945 C16.6774556,29.4209757 16.6774556,29.435657 16.6622159,29.4655842 C16.8405766,29.5548012 17.0189373,29.6440182 17.1814938,29.7479165 C17.3310685,29.8382629 17.4795142,29.9269152 17.6132848,30.0302488 C17.7916454,30.1940015 17.9999211,30.2843479 18.2510935,30.343073 C18.2375472,30.2978998 18.2228719,30.2826539 18.2228719,30.2826539 C18.6382943,30.4763338 19.0695208,30.6846951 19.3957628,30.8473185 C17.8509109,30.8778104 16.2022034,30.9077376 14.493666,30.9376648 C14.493666,30.6553325 14.4789907,30.3871168 14.4789907,30.1042199 C14.4789907,29.9856403 14.5083412,29.8811774 14.4931016,29.7620331 C14.447947,29.078789 14.447947,28.3932862 14.359331,27.723594 C14.2707151,27.009858 14.2707151,26.3102386 14.2859548,25.5948085 C14.3000656,25.2091426 14.2707151,24.8076661 14.2554754,24.4203062 C14.2554754,23.8996855 14.2554754,23.3926167 14.2712796,22.8731253 C14.2712796,22.7985895 14.3011945,22.7392998 14.3311094,22.6641994 L14.376264,22.6641994 C14.3903748,22.6946913 14.376264,22.7392998 14.4044856,22.7545457 C14.4496403,22.7997189 14.5241453,22.8731253 14.5540603,22.858444 C14.6426762,22.7985895 14.7764467,22.7398644 14.8063616,22.6495181 C14.8797379,22.4716487 14.9102172,22.2779688 14.9102172,22.0995348 C14.9102172,21.966274 14.9700471,21.8770569 15.0287481,21.7872753 C15.0592274,21.7421021 15.0739027,21.6980583 15.1038176,21.6387685 C15.0445522,21.5935953 14.9852868,21.5642328 14.9107817,21.504943 C14.9706115,21.3411903 14.9559363,21.1475103 15.1788871,21.058858 C15.2082376,21.043612 15.2082376,20.9685116 15.2240417,20.9244678 C15.2381525,20.8041942 15.2522634,20.6703687 15.2680675,20.5517892 C15.297418,20.5969623 15.3132221,20.611079 15.3414437,20.6404415 C15.3498345,20.6242621 15.3600618,20.6091043 15.3719231,20.5952683 C15.3719231,20.5365432 15.3572478,20.417399 15.3719231,20.417399 C15.5502837,20.3874718 15.4757786,20.1943565 15.564959,20.1051395 C15.5790698,20.0893289 15.5497193,20.0447204 15.5497193,20.0147932 C15.5497193,19.9854306 15.5497193,19.9413868 15.5643946,19.9413868 C15.7715413,19.8962136 15.7421908,19.6731711 15.8759613,19.5687081 C15.9211159,19.5387809 15.9352267,19.4953017 15.9944922,19.4202014 C16.113023,19.6279979 15.9053118,19.7324609 15.8906366,19.8809677 C16.1423735,19.7324609 16.2168786,19.3755929 16.0684328,19.2711299 C16.1276983,19.2259567 16.1869637,19.1672316 16.2321183,19.1073772 C16.3958037,18.9289432 16.5730355,18.7651904 16.7220457,18.5867564 C16.8264658,18.4534956 16.8857312,18.2897429 16.9895868,18.1559174 C17.0494166,18.0813816 17.1679475,18.0220919 17.2571278,17.9769187 C17.5246688,17.8289766 17.7764058,17.6652238 17.9400912,17.4122541 C17.9700061,17.3823269 18.0145963,17.3529643 18.058622,17.3230371 C18.1037766,17.2931099 18.192957,17.2931099 18.2076322,17.2485014 C18.2228719,17.2191388 18.1782817,17.1446031 18.1483668,17.0999946 C18.2070678,17.0700674 18.2668977,17.0107776 18.3854285,16.9509231 C18.3402739,17.0401402 18.3261631,17.0999946 18.2962482,17.159849 L18.3696244,17.2332554 C18.5039593,17.1293572 18.7116705,17.0107776 18.845441,16.9215606 C18.845441,16.907444 18.7709359,16.8481542 18.7709359,16.8481542 C18.68232,16.8933274 18.5485495,16.9667338 18.4153434,17.0265882 C18.443565,16.981415 18.443565,16.9520525 18.460498,16.9373712 C18.6676448,16.8035457 18.875356,16.6697202 19.0983068,16.5646926 C19.6175848,16.3275335 20.1379916,16.089245 20.657834,15.8662025 C20.7470143,15.8210293 20.866674,15.8515212 20.9699652,15.8515212 C21.0139909,15.8515212 21.0433414,15.8515212 21.088496,15.8368399 C21.3255577,15.7623042 21.5637482,15.6877685 21.8013744,15.627914 C21.9046655,15.5985515 22.0231963,15.5838702 22.1287452,15.5838702 C22.5729537,15.5979868 23.0188554,15.5979868 23.4641927,15.627914 C23.6572286,15.6425953 23.8355893,15.6872038 24.01395,15.7464936 C24.2426018,15.8259942 24.4658367,15.9203044 24.6822381,16.0288259 C24.9345395,16.1643454 25.1721656,16.3122875 25.4103561,16.4760402 C25.8410182,16.7583725 26.2417653,17.0711967 26.6724273,17.3241664 C27.0884141,17.5771362 27.4152206,17.9193229 27.6827616,18.3066828 C28.0101325,18.7674491 28.3809647,19.1841716 28.5294105,19.7494008 L28.7517969,20.7319172 C28.7969515,20.9103512 28.9008071,21.0887852 28.8562169,21.2965818 C28.7811474,21.6692604 28.721882,22.0560556 28.6626166,22.4281696 C28.6332661,22.5778057 28.6033511,22.7274418 28.6185908,22.8742546 C28.6468124,23.3372796 28.4690162,23.7381914 28.2912199,24.1549139 C28.2313901,24.2887394 28.1422097,24.4231295 28.0682691,24.5716363 C28.1046068,24.5973361 28.144551,24.6175067 28.1867999,24.6314908 L28.3205704,24.3638398 C28.3358101,24.3638398 28.3358101,24.3638398 28.3504854,24.3790857 C28.2759803,24.5868823 28.2167148,24.8104894 28.1416453,25.0188507 C27.9644135,25.4801816 27.7860528,25.9561939 27.5631019,26.4022789 C27.4445711,26.6552486 27.235731,26.8636099 27.0878497,27.102463 C26.9399684,27.3102595 26.8208731,27.533302 26.6724273,27.726982 C26.5386568,27.8907347 26.4054507,28.0544875 26.2265256,28.173067 C25.8257785,28.4706453 25.4097917,28.7682235 24.9791297,29.0065119 C24.7121531,29.1702647 24.4000219,29.2594817 24.1031303,29.3340174 L24.1070814,29.3323234 Z M16.1897858,28.541793 L16.1751106,28.5570389 C16.1440668,28.5423577 16.0994766,28.5276764 16.0701261,28.4977492 L15.7134048,27.9613178 C15.6840543,27.917274 15.6682501,27.8726655 15.6840543,27.8133757 C15.8477397,28.0663454 16.0114251,28.3046339 16.1892214,28.541793 L16.1897858,28.541793 Z M25.4295469,30.5802321 C26.0972706,30.2978998 26.6470279,29.896988 27.1510662,29.4350924 C27.2261357,29.3605566 27.3000764,29.2865856 27.3892567,29.2261665 C28.0135191,28.8399359 28.4729672,28.3040692 28.8895184,27.7089127 C29.3647707,27.0245393 29.6769019,26.2509488 30.0635382,25.5219668 C30.0897514,25.465646 30.119344,25.410962 30.1521541,25.3582141 C30.1222392,27.0544665 30.3158395,28.7207917 30.538226,30.4023628 C28.860168,30.4616526 27.1516306,30.5209423 25.4289824,30.5807968 L25.4295469,30.5802321 Z M40.4903009,30.1341471 C40.4756256,30.1640743 40.4451463,30.1940015 40.4310354,30.2244934 C40.4157958,30.1940015 40.4157958,30.149393 40.4011205,30.0889739 C40.3119402,30.3278271 40.1189042,30.2086828 39.9851337,30.2086828 C39.1836395,30.2239288 38.3663411,30.2239288 37.563718,30.2239288 C36.7915743,30.2239288 36.0047553,30.2239288 35.2326116,30.2374807 C34.9797458,30.2374807 34.7122047,30.2967705 34.459339,30.3120164 C33.8508807,30.341379 33.2418579,30.3571896 32.6328352,30.3713062 C32.5876806,30.3713062 32.5436548,30.2978998 32.4691497,30.2380454 C32.4429831,30.2849283 32.413164,30.3296753 32.3799694,30.3718709 C32.3641653,30.3425083 32.3348148,30.3131458 32.3048999,30.2685373 C32.2902246,30.3137104 32.2749849,30.3577543 32.2597453,30.3871168 L32.2168484,30.3871168 C32.1869335,30.1793203 32.127668,29.986205 32.127668,29.7772791 C32.127668,29.3311941 32.1728227,28.8851091 32.1869335,28.4378947 C32.2021731,28.2300981 32.1869335,28.0369829 32.1869335,27.8427382 C32.2467633,27.8879114 32.2913535,27.9178386 32.3506189,27.9613178 C32.3799694,27.9031573 32.4098843,27.8585488 32.4397993,27.814505 C32.4397993,27.814505 32.4098843,27.7986944 32.3799694,27.7693318 C32.408191,27.7540859 32.4386704,27.7241587 32.4386704,27.7094774 C32.4533456,27.6643042 32.483825,27.6202604 32.483825,27.5908978 C32.483825,27.4864349 32.4533456,27.3972179 32.4386704,27.3085655 C32.4533456,27.3085655 32.4680209,27.3085655 32.483825,27.2927549 L32.5724409,27.73884 L32.6175955,27.73884 C32.5577657,27.6355063 32.7508016,27.5457247 32.5876806,27.4271451 C32.5730053,27.4118992 32.6023558,27.3226822 32.6023558,27.2780737 C32.5572012,27.1894213 32.5289796,27.1002043 32.483825,26.9810601 C32.4985002,26.9663788 32.5430904,26.9511329 32.5876806,26.9358869 C32.5284152,26.9065244 32.483825,26.8771618 32.4392348,26.8624805 C32.5876806,26.7280904 32.5876806,26.6535546 32.4539101,26.5050478 C32.4843894,26.4909312 32.5137399,26.4909312 32.5137399,26.4768146 C32.5137399,26.3424244 32.5137399,26.2085989 32.4843894,26.0759028 C32.4544745,25.925702 32.529544,25.7483973 32.3060287,25.658051 C32.3197696,25.7003101 32.3397453,25.7402779 32.3652942,25.7766305 C32.3652942,25.7766305 32.3201395,25.7918765 32.2761138,25.8218037 C32.0830779,25.642805 32.2027376,25.4039519 32.157583,25.1368656 C32.2614386,25.1667928 32.3359437,25.19672 32.4098843,25.2272119 C32.3799694,25.1221843 32.3060287,25.0030401 32.2614386,24.8692146 L32.2010443,24.8692146 L32.2010443,23.8866982 C32.2010443,23.9019441 32.3048999,23.9019441 32.3647297,23.9171901 C32.3647297,23.9019441 32.3788405,23.8872629 32.3788405,23.8720169 C32.3336859,23.8127271 32.2744205,23.7534373 32.2151551,23.6789016 L32.24507,23.6489744 C32.1265392,23.5010323 32.1858046,23.2932357 32.1858046,23.2480625 L32.1858046,22.2062564 C32.3348148,22.3553278 32.1124284,22.5484431 32.3348148,22.6376601 L32.3348148,22.4891534 L32.3195751,22.4891534 C32.3048999,22.2661108 32.3048999,22.0430683 32.2902246,21.8194612 L32.2608741,21.8194612 C32.2456345,21.849953 32.2456345,21.8646343 32.2303948,21.8945615 L32.2010443,21.8945615 L32.2902246,18.338304 C32.4386704,18.5314193 32.6017914,18.7109826 32.705647,18.9029686 C33.0476931,19.528617 33.4930304,20.0644836 33.9090172,20.6297129 C34.2657386,21.1209711 34.5919806,21.6562731 34.9193515,22.1622126 C35.3200986,22.7720503 35.7061705,23.3818881 36.107482,23.9917258 C36.4059383,24.4538222 36.7126627,24.9105212 37.0275071,25.3616021 C37.3097234,25.7625139 37.6077438,26.1498738 37.9046353,26.5372337 C38.1563722,26.8794205 38.4239133,27.2216072 38.6762146,27.5637939 C38.9736706,27.9805164 39.2705621,28.3966742 39.5680181,28.7987154 C39.7158994,29.0065119 39.8795848,29.2148732 40.0421414,29.4232344 C40.1324506,29.541814 40.2656567,29.6321603 40.354837,29.7055667 C40.3407262,29.7055667 40.3254866,29.7055667 40.2961361,29.6908854 C40.3412907,29.7501752 40.3695123,29.7947837 40.3999917,29.8247109 C40.5636771,29.9139279 40.5783523,30.0031449 40.489172,30.1375351 L40.4903009,30.1341471 Z M41.2477694,26.4152662 L41.2477694,26.3108032 C41.2477694,26.3401658 41.2624446,26.3842096 41.2477694,26.4147015 L41.2477694,26.4152662 Z M41.7529365,19.8538638 C41.7376968,19.8538638 41.6490809,19.7635174 41.6344057,19.7488361 C41.619166,19.7940093 41.6344057,19.8380531 41.6044907,19.8979076 C41.5892511,19.8538638 41.4859599,19.868545 41.4859599,19.8245012 C41.4707202,20.0322978 41.5745758,20.240659 41.5593361,20.4490202 C41.6044907,20.419093 41.782287,20.4038471 41.8268772,20.3598032 C41.8421168,20.3744845 41.8720318,20.3891658 41.886707,20.3891658 C41.5892511,20.612773 41.6637562,20.8352508 41.7975267,21.0893499 C41.8268772,21.148075 41.9160575,21.2672192 41.8268772,21.3863634 C41.7975267,21.4162906 41.8421168,21.504943 41.8567921,21.5800434 L41.9002534,21.5800434 L41.9002534,21.6082766 L41.7664829,21.6534498 C41.7371324,21.6082766 41.5593361,21.5201889 41.5593361,21.4445239 L41.5593361,22.2045624 C41.7077819,22.2497356 41.7077819,22.4575321 41.7670473,22.5619951 C41.7931575,22.5258127 41.8135288,22.4858153 41.8274416,22.4434155 L41.8426813,22.4569675 C41.8274416,22.5461845 41.8127664,22.6354015 41.7828514,22.7251831 C41.7535009,22.858444 41.723586,22.9775882 41.7094752,23.1114137 C41.7094752,23.126095 41.7376968,23.1565869 41.7376968,23.1707035 C41.5751402,23.5433821 41.6643206,23.9589753 41.6050552,24.3452058 C41.5599006,24.6275381 41.6050552,24.9268103 41.5751402,25.2238239 C41.5446609,25.4767936 41.484831,25.7444447 41.42613,25.9974144 C41.4108904,26.0425876 41.3809754,26.0567042 41.3075992,26.0866314 C41.3369497,25.9081974 41.3222745,25.7890532 41.2923595,25.6253004 C41.2765554,25.6253004 41.0835195,25.5214021 41.0682798,25.5214021 C41.0682798,25.730328 41.1868106,26.0126603 41.2319652,26.2498195 C41.1868106,26.2351382 41.0090144,26.1312399 40.9949036,26.1312399 C40.9644242,26.3096739 40.9644242,26.5479624 40.949749,26.7410776 C40.9345093,26.8901491 40.8013032,27.0234099 40.7860635,27.1871627 C40.7860635,27.277509 40.8899191,27.3362341 40.8752439,27.4853056 L40.9937747,27.4853056 C40.9937747,27.188292 41.1281097,26.920641 41.1281097,26.6078168 L41.1721354,26.6078168 C41.1873751,26.637744 41.2319652,26.6676712 41.21729,26.6823525 C41.1873751,26.8461053 41.1269808,27.0245393 41.1427849,27.188292 C41.1427849,27.277509 41.2161611,27.366726 41.1879395,27.4706243 C41.1574601,27.5609706 41.1427849,27.649623 41.1275452,27.7834485 C41.1123055,27.7089127 41.0976303,27.6795502 41.0976303,27.6349417 C41.0829551,27.6349417 40.9491845,27.6196957 40.9339449,27.6196957 C40.9192696,27.7089127 41.0383649,27.7981297 41.0231252,27.8726655 C41.00845,27.8873467 40.9937747,27.8873467 40.9638598,27.9025927 L40.4739323,27.1877273 C40.0867316,26.6230627 39.7006597,26.0567042 39.3145878,25.4767936 C39.214471,25.3348345 39.1248637,25.185742 39.0464824,25.0307086 C38.586915,24.2389801 38.0759481,23.4782507 37.5168701,22.7534164 C37.0867725,22.2034331 36.7435975,21.6071473 36.3428504,21.0283661 C35.9725826,20.4778181 35.601186,19.9419514 35.2297894,19.3908388 C35.0960189,19.2129695 34.9328979,19.0492167 34.8138026,18.8555368 C34.4282952,18.245699 34.0856846,17.6206153 33.7007416,17.0107776 C33.3733707,16.5042735 33.0177782,16.0130153 32.6757321,15.5223218 C32.5572012,15.358569 32.4386704,15.1795704 32.3190107,15.0011364 C32.3004858,14.9700053 32.2903713,14.9345901 32.2896602,14.8983674 C32.2597453,14.5708619 32.2298303,14.2433565 32.2151551,13.931097 C32.2151551,13.6335187 32.24507,13.3359405 32.24507,13.0231163 L32.24507,12.7554653 C32.24507,12.6809296 32.2591808,12.6216398 32.2591808,12.5465394 C32.2732916,12.5324228 32.2885313,12.5024956 32.3032066,12.4878143 C31.8725445,12.4878143 31.4266428,12.4720037 30.9959808,12.4878143 C30.7137645,12.5019309 30.5653187,12.3827867 30.3722828,12.1744255 C29.8078502,11.5346605 29.3918634,10.8056785 28.901936,10.1213051 C28.4400157,9.47015232 27.9696152,8.82506214 27.4908546,8.18619953 C27.1042183,7.66557879 26.717582,7.15963933 26.3320745,6.63901858 C25.900848,6.04386212 25.4854257,5.44870565 25.039524,4.85354918 C24.5044419,4.13981315 23.9546846,3.42494779 23.4054917,2.71121176 C23.151497,2.38370631 22.8692808,2.07144679 22.5870645,1.72869539 C22.7806648,1.75918728 22.95959,1.78854984 23.1373862,1.80379578 L23.850829,1.84896895 C24.3853466,1.89244812 24.9198642,1.92237534 25.4538175,1.99578174 C25.8997192,2.05620085 26.3456209,2.14541785 26.8061979,2.21938891 C27.7871817,2.38314164 28.7523613,2.65135732 29.6881905,2.96361683 C30.2379478,3.14205084 30.771901,3.38033929 31.308112,3.6033818 C32.5103533,4.09463999 33.6544581,4.68979645 34.7833232,5.31431548 C35.1389158,5.50799543 35.3477558,5.82025494 35.614168,6.1031519 C36.0008043,6.50519308 36.3874406,6.90666959 36.7582728,7.32282739 C37.1883704,7.81408558 37.5891175,8.32002504 38.0056687,8.8259645 C38.3765009,9.27204952 38.7620084,9.71813454 39.1345339,10.1653489 C39.2530647,10.2991744 39.3433739,10.4629271 39.4461006,10.6114339 C39.6831623,10.9688666 39.9512678,11.311618 40.1589789,11.6978486 C40.3068603,11.9813102 40.3960406,12.3088156 40.4998962,12.6210751 C40.6477775,13.0824061 40.7967877,13.5284911 40.9457979,13.9898221 C41.0490891,14.3320088 41.137705,14.6900062 41.2122101,15.0457449 C41.27204,15.284598 41.2573647,15.537003 41.3307409,15.7741622 C41.4210502,16.0881157 41.3307409,16.4291731 41.4210502,16.7425619 C41.435161,16.7724891 41.4492718,16.8170976 41.4650759,16.8470249 C41.5243413,16.90575 41.5689315,16.9656044 41.4797511,17.0548214 C41.4656403,17.0695027 41.4656403,17.1282278 41.4797511,17.173401 C41.5102305,17.1440384 41.5249057,17.1141112 41.5548207,17.0695027 C41.5548207,17.0994299 41.5689315,17.1146759 41.5689315,17.1287925 C41.5689315,17.1875176 41.5536918,17.2473721 41.5689315,17.3066618 C41.5689315,17.3360244 41.598282,17.3800682 41.6129572,17.4105601 C41.6428722,17.3800682 41.6722226,17.365387 41.7314881,17.3202138 C41.8652586,17.8267179 41.8804983,18.3326574 41.8804983,18.8532781 C41.8804983,19.3445363 41.9691142,19.8357945 41.7619674,20.3118067 C41.8059932,20.148054 41.7021376,19.9984179 41.7467277,19.8499111 L41.7529365,19.8538638 Z" fillRule="evenodd" />,
<path d="M32.6120424,24.6593077 C32.6264035,24.6593077 32.6419134,24.6734862 32.6419134,24.6734862 L32.6264035,24.6577323 C32.6264035,24.6446041 32.6264035,24.6446041 32.611468,24.6577323 L32.6120424,24.6593077 Z M35,38.3315481 C34.8334117,38.4418251 34.6668233,38.5389738 34.4554285,38.580459 C34.4393441,38.5668056 34.4393441,38.5526272 34.4244086,38.5384487 C34.5909969,38.4418251 34.7719463,38.3452015 34.9385346,38.2480527 C34.9540446,38.2743092 34.9844901,38.3026661 34.9994256,38.3304979 L35,38.3315481 Z M6.6558567,19.5802668 C6.82244504,19.3875447 6.98903337,19.1937723 7.16940832,19 C7.18376939,19.0136533 7.30440232,19.0420103 7.31991227,19.0551385 C7.15332393,19.2494359 6.92641913,19.5120001 6.76040524,19.7194258 C6.72938535,19.691594 6.68400439,19.5949704 6.65413338,19.5807919 L6.6558567,19.5802668 Z M2.36189879,26.3622988 C2.24126586,26.1270413 2.12063293,25.8776054 2,25.642873 C2.04205893,25.618511 2.08770964,25.5997671 2.13556844,25.5872094 C2.30215677,25.8077633 2.3768343,26.0703274 2.49861612,26.3066352 C2.49861612,26.3066352 2.37798318,26.3617737 2.36247324,26.3617737 L2.36189879,26.3622988 Z M6.21755705,19.7194258 C6.12679513,19.8444063 6.03603321,19.9830402 5.94527129,20.1080207 C5.93033579,20.0933171 5.76374745,20.1626341 5.74881195,20.1489807 C5.83957387,20.0245253 6.06590422,19.802396 6.15666614,19.6784658 C6.17217609,19.6921191 6.1871116,19.7062976 6.21755705,19.720476 L6.21755705,19.7194258 Z M33.3829443,38.899737 C33.3973053,38.899737 33.3973053,38.8860836 33.4128153,38.8860836 C33.5185127,38.899737 33.6391456,38.9133903 33.760353,38.9133903 C33.5627448,39.0378457 33.4415374,39.0236672 33.381221,38.899737 L33.3829443,38.899737 Z M6.24627918,20.3007428 C6.26236357,20.2587325 6.29223458,20.2177725 6.32268004,20.1762874 C6.35255105,20.1762874 6.39735756,20.1621089 6.39735756,20.1621089 C6.45882292,20.0654853 6.45882292,19.9961684 6.51913938,19.9131981 C6.50420387,19.8995448 6.48869393,19.8995448 6.47318398,19.8853663 C6.3829965,19.9420802 6.29223458,20.0113971 6.20147266,20.0665356 C6.23191812,20.0938423 6.23191812,20.1085458 6.23191812,20.1358525 C6.11128518,20.1216741 6.06532978,20.1778628 6.00501332,20.3290997 C5.99007781,20.37111 5.9142514,20.3847633 5.83842498,20.4393767 C5.82348948,20.4677336 5.80855397,20.5370505 5.77810852,20.6058423 L5.79361847,20.6205459 C5.76317301,20.6483777 5.71779205,20.6625562 5.71779205,20.6625562 C5.62703013,20.7450013 5.52133271,20.8148434 5.43057079,20.8972886 C5.41563528,20.9392988 5.40069978,20.9802588 5.40069978,21.021744 C5.50697164,20.9251204 5.68792104,20.7450013 5.82406392,20.6341993 L5.83957387,20.6483777 C5.89989033,20.5654075 5.94527129,20.4824372 6.0061622,20.3994669 C6.02052326,20.4131203 6.02052326,20.4267736 6.03603321,20.4414772 C5.99007781,20.5517541 5.94527129,20.6756844 5.89989033,20.7864865 C5.86829599,20.8001398 5.82291503,20.8284967 5.82291503,20.8143183 C5.76259857,20.8563285 5.71721761,20.9109419 5.6563267,20.952427 L5.38461538,21.1183676 C5.233537,21.242823 5.08245861,21.3530999 4.91587028,21.4780805 C4.81017285,21.6303677 4.70447543,21.7684764 4.58269361,21.9485954 C4.7647919,21.9065851 4.81017285,21.9764272 4.79523735,22.1150611 C5.0066322,22.1423678 5.02214215,21.9906057 5.08245861,21.8798036 C5.09739412,21.8514467 5.11290407,21.7957831 5.14277508,21.7821297 C5.27891796,21.6718528 5.42999634,21.5752292 5.58107473,21.4644271 C5.61152018,21.4365953 5.61152018,21.3804066 5.61152018,21.3394466 C5.61152018,21.3257932 5.53511933,21.3257932 5.48973837,21.3116148 C5.62588125,21.1729809 5.82291503,20.9387737 5.95848347,20.7864865 C6.03430989,20.7444762 6.10956186,20.6888126 6.10956186,20.6473275 C6.09462635,20.4950403 6.20032378,20.4540803 6.32210559,20.3984167 C6.26121468,20.3564064 6.24570474,20.3159715 6.24570474,20.3023182 L6.24627918,20.3007428 Z" fillRule="evenodd" />,
<path d="M6.36348409,20.9552864 C6.30218648,21.0631104 6.24088888,21.1556984 6.17959127,21.2641084 L6.08735297,21.2172284 C6.02605537,21.5717584 5.81063808,21.8805803 5.59580457,21.9421103 C5.65710217,21.9731683 5.71839978,22.0042263 5.76510271,21.9889903 C5.81063808,21.9731683 5.84099498,21.8952303 5.87193568,21.8495223 L6.28642424,21.2471144 L6.42536548,21.0150584 L6.36406787,20.9535284 L6.36348409,20.9552864 Z M1.24834497,27.7341336 C1.32540481,27.7341336 1.40246466,27.7493696 1.49353538,27.7493696 C1.49353538,27.6878396 1.57117902,27.7024896 1.57117902,27.6415456 L1.61788195,27.6415456 C1.61788195,27.7188976 1.63306041,27.7804276 1.63306041,27.8583656 L1.31081015,27.8583656 C1.2950479,27.8425436 1.2337503,27.7493696 1.24892875,27.7341336 L1.24834497,27.7341336 Z M1.12574976,27.0239017 C1.07904682,26.9770217 1.00315455,26.9313137 1.00315455,26.8850197 C0.987392311,26.8240757 1.03351146,26.7473097 1.07904682,26.6699577 C1.11057131,26.7777817 1.12574976,26.8703697 1.15610667,26.9787797 C1.14034443,26.9934297 1.12516597,27.0092517 1.12516597,27.0244877 L1.12574976,27.0239017 Z M1.50988141,26.0353198 C1.57117902,26.1911958 1.63247662,26.3611358 1.69435801,26.5158398 C1.65069419,26.5301701 1.60938209,26.5509045 1.5717628,26.5773697 C1.5104652,26.4226658 1.43340535,26.2527258 1.37210775,26.0986078 C1.4136122,26.0688016 1.46066402,26.0476775 1.5104652,26.0364918 L1.50988141,26.0353198 Z M35.7081066,40.799002 C35.7839989,40.76853 35.8762372,40.752122 36,40.722822 C35.8610588,40.83006 35.753642,40.907412 35.6614037,41 C35.6456415,40.984764 35.630463,40.968942 35.6147008,40.968942 C35.6456415,40.907412 35.6765822,40.861118 35.7081066,40.799002 Z M16.8249419,8.16993998 C16.9165964,8.10782399 16.99424,8.06152999 17.0858945,8 L17.1162514,8.030472 C17.0228455,8.15353198 16.9469533,8.27659197 16.8389527,8.43188195 C16.8237743,8.32464396 16.8237743,8.26194197 16.808012,8.18576198 C16.7928336,8.18576198 16.808012,8.18576198 16.8237743,8.17052598 L16.8249419,8.16993998 Z M21.3259374,15.983077 C21.4642948,15.920961 21.6026523,15.860017 21.7713666,15.7820791 C21.7561882,15.874667 21.7561882,15.936783 21.7561882,15.998899 C21.7066246,15.9808723 21.6547029,15.9702117 21.6020685,15.967255 C21.5098302,15.983077 21.340532,16.106723 21.2634722,16.121959 C21.2488775,16.121959 21.3253536,15.998899 21.3253536,15.983077 L21.3259374,15.983077 Z M32.8498869,29.0778314 C32.8802438,29.2319494 33.1721372,29.3093014 32.8802438,29.4634194 C32.9269468,29.4956494 32.9718984,29.5102994 33.0180175,29.5419434 C33.0143563,29.5652434 33.0037762,29.5868923 32.9876606,29.6040594 C32.9567199,29.6187094 32.8954223,29.6497674 32.8650654,29.6333594 C32.8493031,29.6333594 32.8183625,29.5724154 32.8183625,29.5413574 C32.8183625,29.4024754 32.8341247,29.2635934 32.8493031,29.0784174 L32.8498869,29.0778314 Z" fillRule="evenodd" /></svg>
);
