import React from 'react';
export const Grunt = props => (
  <svg viewBox="0 0 20 20" width="16px" height="16px" {...props} className={`ffont ${props.className ? props.className : ''}`}><path d="M2.06790927,11.2520608 C2.06790927,11.2520608 2.81551091,14.0844652 2.92210637,15.0288134 C3.02896245,15.9729055 1,18.0710303 1,19.1200926 C1,20.169411 1.42651215,22.0577233 3.77630347,23.0020715 C6.1260948,23.9462916 6.4461418,26.3590711 6.4461418,27.8281424 C6.4461418,29.2968297 5.5919447,32.1291061 5.5919447,32.1291061 C5.5919447,32.1291061 5.05818553,39.158016 7.9414754,40.4168909 C10.8245046,41.6756377 10.18415,41.6756377 10.8245046,41.6756377 C11.464338,41.6756377 16.1633994,43.5651021 18.9403545,42.8303104 C21.7173095,42.0967988 22.4639989,41.2570369 22.4639989,41.2570369 C22.4639989,41.2570369 25.240954,41.4669774 26.0944995,39.0539419 C26.9493482,36.6421865 27.4823255,31.6061751 27.1617572,29.2981099 C26.841189,26.9900446 26.4137646,23.9484678 28.335871,22.8987654 C30.2579774,21.8503431 32.2869398,20.5907001 31.9663716,19.5422778 C31.6458033,18.4938555 29.9374091,17.0242721 29.9374091,17.0242721 C29.9374091,17.0242721 29.5099848,14.4025763 29.8292499,13.7727548 C30.1498182,13.1442135 32.0719245,11.5696598 31.0033637,10.4162673 C29.936106,9.26287471 28.0126965,9.26287471 28.0126965,9.26287471 L25.5576129,9.47153507 C25.5576129,9.47153507 21.3942653,5.79872866 15.9472113,6.00866914 C10.5040667,6.21860963 7.08597517,9.47012693 7.08597517,9.47012693 C7.08597517,9.47012693 5.27072489,8.8405615 3.66879583,9.47012693 C2.06595458,10.0999484 1.74668946,9.47012693 2.06725771,11.2533409 L2.06790927,11.2520608 Z" fillRule="evenodd" />,
<path d="M11.3989916,22.8210526 C11.3989916,22.8210526 9.21680672,26.0861842 7.61640336,28.4032895 C7.3687395,28.7617105 9.21694118,28.7865789 9.21694118,28.7865789 L11.3991261,22.8210526 L11.3989916,22.8210526 Z M12.437916,16.0517105 C12.437916,16.0517105 11.7801681,17.6575 11.4198319,18.5088158 C11.0285714,19.4343421 9.53747899,19.8947368 9.53747899,19.8947368 C9.53747899,19.8947368 10.3105882,19.1013158 10.3105882,17.0913158 C10.3105882,16.2492105 11.4229244,15.9136842 11.4229244,15.9136842 L12.4380504,16.0531579 L12.437916,16.0517105 Z" fillRule="evenodd" />,
<path d="M11.7727731,16.9592105 C11.7727731,16.9592105 10.4251429,18.5289474 7.92295798,17.65 C5.42023529,16.7710526 5.16369748,13.6307895 5.16369748,12.7515789 C5.16369748,11.8723684 9.91220168,13.6307895 10.5539496,14.0076316 C11.1956975,14.3844737 12.4143866,15.8914474 11.7727731,16.9592105 Z M2.32067227,0.184210526 C2.32067227,0.184210526 4.63058824,-0.255789474 6.17062185,0.9375 C7.71119328,2.13052632 8.15973109,3.07276316 8.15973109,3.07276316 L5.56410084,5.08631579 C5.56410084,5.08631579 4.30991597,4.51710526 3.92470588,2.88421053 C3.53989916,1.25157895 3.79657143,0.498157895 2.32067227,0.184210526 Z" fillRule="evenodd" />,
<path d="M11.0991597,12.425 C10.1044706,11.0434211 8.46547899,10.4407895 7.15697479,10.3407895 C4.92544538,10.1701316 3.86608403,10.9421053 3.86608403,10.9421053 C3.86608403,10.9421053 7.52053782,11.0934211 8.57384874,12.4473684 C10.5347227,14.9671053 13.3953613,15.1718421 13.8527731,14.6184211 C13.3238319,14.6442105 12.741916,14.3877632 12.1191261,13.8114474 C11.7300168,13.4509211 11.4145882,12.8635526 11.0990252,12.425 L11.0991597,12.425 Z M4.92988235,17.3101316 C4.92988235,17.3101316 0.875294118,15.9460526 1.64571429,14.5648684 C2.41573109,13.1830263 1.80302521,12.4302632 1.80302521,12.4302632 C1.80302521,12.4302632 -0.461176471,14.0842105 0.115630252,15.8423684 C0.470319328,16.9213158 1.06514286,17.7028947 4.33142857,19.2002632 C5.89808403,22.0476316 4.65492437,27.1739474 4.72941176,27.1976316 C4.85351261,27.2371053 6.92907563,26.1936842 6.78736134,21.3976316 C6.74433613,19.9239474 6.62467227,17.9147368 4.93055462,17.3081579 L4.92988235,17.3101316 Z M10.2432269,2.64171053 C8.54305882,3.48697368 6.21391597,4.66407895 6.21391597,4.66407895 L7.13062185,5.11276316 C7.04322689,5.25157895 7.00087395,5.33434211 7.00087395,5.33434211 L7.94070588,5.75302632 C7.94070588,5.75302632 10.2371765,7.38131579 11.6449076,8.42802632 C11.1756639,7.01421053 9.79751261,4.79289474 9.79751261,4.79289474 C9.79751261,4.79289474 9.4062521,3.77223684 10.2412101,2.64157895 L10.2432269,2.64171053 Z M15.8910924,37.0969737 C10.6655462,37.0969737 8.89546218,34.5009211 8.89546218,34.5009211 L9.71213445,36.4469737 C10.0208403,37.2890789 13.3138824,39.9088158 15.8832941,39.9088158 L15.8910924,37.0969737 Z" fillRule="evenodd" />,
<path d="M9.46823529,32.7460526 C9.46823529,32.7460526 9.94890756,35.6217105 11.8740168,35.6217105 C13.509916,35.6217105 13.9919328,33.1927632 13.9919328,32.6907895 L9.46810084,32.7460526 L9.46823529,32.7460526 Z M6.26447059,28.4094737 C6.4354958,27.9486842 7.03435294,26.0857895 7.2267563,24.3903947 C7.45667227,22.3598684 7.37331092,19.39 7.37331092,19.39 C7.37331092,19.39 6.85969748,21.3367105 6.40927731,21.6513158 C5.96020168,21.9651316 5.1252437,24.1 5.1252437,24.1 C5.1252437,24.1 4.67751261,27.2784211 4.46507563,28.3467105 C5.05398319,28.4621053 5.54877311,28.1226316 6.26137815,28.4094737 L6.26447059,28.4094737 Z M1.61559664,15.8107895 C1.61559664,15.8107895 2.70601681,15.4336842 3.02736134,13.1105263 C3.34803361,10.7868421 2.64201681,8.77736842 2.64201681,8.77736842 C2.64201681,8.77736842 2.70615126,11.98 2.32134454,12.6081579 C1.936,13.2357895 1.61546218,13.4243421 1.16611765,14.2410526 C0.716638655,15.0576316 1.35838655,15.5594737 1.61559664,15.8107895 Z" fillRule="evenodd" />,
<path d="M4.49985578,5.5 L4.26116534,5 C3.55692037,5.07904762 4.5,5.5 4.5,5.5 L4.49985578,5.5 Z" fillRule="evenodd" />,
<path d="M13.1694557,6.66092028 C13.1694557,6.66092028 12.0711273,6.46938656 11.5215315,5.60718365 C10.9719357,4.74467959 9.41580268,3.01967147 6.9348524,3.00039764 C4.45447761,2.98082265 2,3.69049123 2,3.69049123 L4.14227266,5.1059134 C4.3690169,5.09838456 4.76524382,5.10139609 5.42044259,5.12398262 C8.10914584,5.21734025 8.52306918,8 8.52306918,8 L18,6.63426819" fillRule="evenodd" />,
<path d="M12.9985422,20.0448547 C12.9985422,20.0448547 11.8177115,21.3319393 10.0044538,20.9179343 C8.19106365,20.5045071 7.0945212,19.6311386 7.01023294,18.1140834 C6.92594469,16.597317 7.39006019,16 7.39006019,16 C7.39006019,16 9.41509871,16.6904898 10.3852088,17.6092169 C11.3553189,18.5293884 12.0722991,19.9999295 13,20.0461548 L12.9985422,20.0448547 Z" fillRule="evenodd" />,
<path d="M11.8441389,18.7896686 C11.8441389,18.7896686 10.841519,19.214348 9.72082158,18.8683486 C8.25380705,18.4147958 8.15597148,17 8.15597148,17 C8.15597148,17 7.25611779,19.4488239 9.77921151,19.9201819 C11.8031362,20.2981826 13,19.2108591 13,19.2108591 L11.8441389,18.7897889 L11.8441389,18.7896686 Z" fillRule="evenodd" />,
<path d="M11.7058896,5.26989474 C11.5986994,3.0000743 13.442319,1.19212384 14.0810798,1.11540557 C14.1163804,1.49990712 14.0455215,3.00020433 14.6840245,3.46155418 C14.8700613,2.23653251 15.498773,0.885510836 17.981411,0 C17.4497117,1.42331889 17.9105521,2.61557276 18.1298282,3.16820433 C19.8252883,1.61511455 20.9674049,1.87179567 20.9674049,1.87179567 C20.9674049,1.87179567 19.7894724,3.92329412 20.250184,5.26950464 C16.8468957,5.0000805 11.7223804,5.63437152 11.7058896,5.26989474 Z M4.49077914,8.72741796 C3.6787362,8.04735604 4.284,7.41631579 4.21984049,6.64380186 C4.18505521,6.23290402 4.15284663,5.84489164 4.01847239,5.63086068 C3.27123313,4.44003715 1.50877914,4.07868111 1.49074233,4.07491022 L0.663625767,3.91133127 L1.21117178,3.26468731 C1.28203067,3.18094737 3.53147853,1.0151517 7.01258282,2.14902167 C9.44755215,2.9416904 11.2499448,5.62917028 11.3169387,5.73787616 L10.0968773,6.31716409 C10.0827055,6.29427864 8.65779755,3.76816718 6.56939264,3.08849536 C4.88166258,2.5384644 3.32534356,3.06157895 2.6579816,3.40447059 C3.36657055,3.69001858 4.29288957,4.21001238 4.85203067,5.09955418 C5.1161411,5.51955418 5.15994479,6.04878019 5.20246012,6.56084211 C5.25914724,7.23895356 5.31196933,7.87909598 5.80669325,8.29363467 L4.49258282,8.72728793 L4.49077914,8.72741796 Z M2.3219816,18.6529412 C2.3219816,18.6529412 3.34492638,17.3725263 3.64807362,14.8810031 C3.76711656,13.8996594 3.55569939,11.9640186 3.21738037,11.2193313 C3.27883436,13.0501672 2.8177362,14.8810031 2.8177362,14.8810031 C2.8177362,14.8810031 2.5072454,18.2805325 2.32301227,18.6529412 L2.3219816,18.6529412 Z" fillRule="evenodd" />,
<path d="M7.71717791,7.43413003 C7.71666258,7.43152941 7.38890798,5.9858452 6.4803681,5.25611146 C5.19846626,4.22704644 3.6333865,4.77447678 3.61831288,4.77928793 L3.39156442,4.0706192 C3.46757669,4.04591331 5.25708589,3.47702786 6.9048773,4.64665635 C8.56297546,5.82291641 8.76266871,6.88917028 8.77941718,7.00697833 L7.71782209,7.43413003 L7.71717791,7.43413003 Z M5.5357546,17.7346625 C5.5357546,17.7346625 4.99903067,16.9591579 5.09552761,16.1062848 C5.14358282,15.6849845 5.33696319,15.2527616 5.68223926,15.0993251 C6.32383436,14.8158576 6.60855828,15.5492322 6.60855828,15.5492322 C6.60855828,15.5492322 5.70542945,15.7741858 5.53665644,17.7350526 L5.5357546,17.7346625 Z" fillRule="evenodd" />,
<path d="M11.4288957,18.916904 C11.4513129,18.9591641 11.4627791,18.9828297 11.4627791,18.9828297 C11.4627791,18.9828297 9.78870552,20.2508916 8.07314724,18.9641053 C7.15455828,18.2749412 7.24139264,16.5702353 7.52276687,15.8472632 C8.25454601,16.0150031 8.87501227,16.3166749 9.39369939,16.6690588 C8.73819018,16.0787183 8.16436196,15.6444149 8.16590798,15.6340124 L7.4208589,15.4207616 L5.97276074,14.9201424 C5.95420859,15.031969 5.42598773,17.5311641 6.9506135,19.2332693 C7.62634969,19.9887492 10.7943865,21.6791517 12.2985276,18.7885635 L11.4288957,18.9198947 L11.4288957,18.916904 Z" fillRule="evenodd" />,
<path d="M11.2717178,19.1028483 C12.2142699,20.550743 14.5924233,19.723356 14.551454,18.1926316 C14.551454,18.1926316 12.962411,19.0777523 11.5586319,17.4480743 C10.7388589,16.497548 8.11231288,13.8735232 4.55068712,14.746031 C7.01039264,15.292161 10.266681,17.5599009 11.2717178,19.1046687 L11.2717178,19.1028483 Z" fillRule="evenodd" />,
<path d="M4.21803681,23.1884211 C4.44478528,23.3206625 5.24433129,24.1565015 5.24484663,25.4067492 C5.24484663,26.0334985 5.18300613,29.1828483 4.87560736,31.1066563 C5.3381227,31.4098885 5.66020859,31.4743839 6.12053374,31.7834675 C6.35114724,29.555257 6.51631288,26.325808 6.43926994,25.0221176 C6.35166258,23.5358638 5.56319632,22.5385263 4.83270552,22.1133251 C4.60466871,21.9804334 4.36503681,21.8497523 4.12411656,21.718291 C2.87184663,21.0353684 1.57706135,20.3289102 1.57706135,19.122613 C1.57706135,18.1789783 1.94037423,17.883808 2.32558896,17.5709536 L2.36681595,17.5371455 C2.62190798,17.3288359 2.91178528,17.0926997 3.08313497,16.7049474 C3.55080368,15.644805 3.62681595,12.944452 3.08313497,12.2587988 C2.81258282,11.9168173 2.08595706,10.7673437 2.29466871,9.99626006 C2.37454601,9.70108978 2.55877914,9.48263777 2.85767485,9.32790093 C3.17460736,9.16406192 3.60233742,9.08084211 4.12926994,9.08084211 C5.16380982,9.08084211 6.31172393,9.39811765 6.90307362,9.58796285 C9.01853374,10.2641238 11.5707423,12.2145882 12.3025215,12.7971269 L12.3385951,12.8244334 L12.8062638,13.1534118 L12.5138098,12.6579938 C12.495773,12.6267864 10.6418466,9.54895356 7.32565031,8.42028483 C6.68019018,8.20053251 5.41374847,7.83254489 4.16792025,7.83254489 C3.4271227,7.83254489 2.7971227,7.96257585 2.29853374,8.22003715 C1.69172393,8.53341176 1.28074233,9.03403096 1.10939264,9.66598142 C0.690680982,11.2159505 2.05503681,12.9414613 2.10141718,12.9973746 C2.26117178,13.2834427 2.32816564,15.3639381 1.96098773,16.1974365 C1.91074233,16.3118638 1.77288957,16.4249907 1.5963865,16.5680248 C1.54227607,16.6122353 1.48043558,16.6590464 1.41473006,16.7084582 C0.896815951,17.102452 0.113503067,17.6992941 0.113503067,19.0737214 C0.113503067,20.953969 2.00350307,21.9747121 3.52117178,22.7939071 C3.77111043,22.9291393 4.00816564,23.0565697 4.22331902,23.1813994 L4.21803681,23.1884211 Z" fillRule="evenodd" />,
<path d="M4.49077914,8.72728793 C3.6787362,8.04722601 4.284,7.41631579 4.21984049,6.64380186 C4.18505521,6.23290402 4.15284663,5.84489164 4.01847239,5.63086068 C3.27123313,4.44003715 1.50877914,4.07868111 1.49074233,4.07491022 L0.663625767,3.91133127 L1.21117178,3.26468731 C1.28203067,3.18094737 3.53147853,1.0151517 7.01258282,2.14902167 C9.44755215,2.9416904 11.2499448,5.62917028 11.3169387,5.73787616 L10.0968773,6.31716409 C10.0827055,6.29427864 8.65779755,3.76816718 6.56939264,3.08849536 C4.88166258,2.5384644 3.32534356,3.06157895 2.6579816,3.40447059 C3.36657055,3.69001858 4.29288957,4.21001238 4.85203067,5.09955418 C5.1161411,5.51955418 5.15994479,6.04878019 5.20246012,6.56084211 C5.25914724,7.23895356 5.31196933,7.87909598 5.80669325,8.29363467 L4.49258282,8.72728793 L4.49077914,8.72728793 Z" fillRule="evenodd" />,
<path d="M4.4643681,8.86655108 L4.41193252,8.82273065 C3.80976074,8.31951084 3.91656442,7.82149226 4.0200184,7.34167802 C4.06704294,7.12062539 4.11664417,6.89047059 4.09654601,6.65511455 C4.06369325,6.25982043 4.03212883,5.88663158 3.91411656,5.69808669 C3.20295092,4.56421672 1.48301227,4.20143034 1.4662638,4.19752941 L0.43301227,3.9920805 L1.11841104,3.18458824 C1.13129448,3.17028483 2.57552761,1.69833437 5.02080368,1.69833437 C5.68816564,1.69833437 6.37098773,1.81016099 7.04994479,2.03251393 C9.59055828,2.85951084 11.404546,5.6460743 11.4212945,5.6733808 L11.4947301,5.79170898 L10.0504969,6.47827245 L9.99252147,6.38595046 C9.83792025,6.119387 8.46841104,3.83994427 6.53074233,3.20929412 C6.05534356,3.05325697 5.55417791,2.97523839 5.04141718,2.97523839 C4.11380982,2.97523839 3.36141718,3.23139938 2.96074233,3.40173994 C3.63068098,3.70601238 4.44104908,4.21833437 4.95509816,5.0362291 C5.23466871,5.48223529 5.27976074,6.02576471 5.32356442,6.55108978 C5.37767485,7.20514551 5.42920859,7.82019195 5.88399387,8.20118266 L6.05534356,8.34421672 L4.46552761,8.87084211 L4.4643681,8.86655108 Z" fillRule="evenodd" />,
<path d="M7.71717791,7.43413003 C7.71666258,7.43152941 7.38890798,5.9858452 6.4803681,5.25611146 C5.19846626,4.22704644 3.6333865,4.77447678 3.61831288,4.77928793 L3.39156442,4.0706192 C3.46757669,4.04591331 5.25708589,3.47702786 6.9048773,4.64665635 C8.56297546,5.82291641 8.76266871,6.88917028 8.77941718,7.00697833 L7.71782209,7.43413003 L7.71717791,7.43413003 Z" fillRule="evenodd" />,
<path d="M7.62828221,7.60317028 L7.59633129,7.46091641 C7.5929816,7.4470031 7.27166871,6.05086068 6.40255215,5.35350464 C5.90731288,4.95560991 5.31003681,4.75406192 4.62850307,4.75406192 C4.09641718,4.75406192 3.70089571,4.88279257 3.6577362,4.89709598 L3.54023926,4.93740557 L3.23619018,3.9920805 L3.35342945,3.95437152 C3.40625153,3.93746749 3.88036196,3.78793189 4.5528773,3.78793189 C5.43925767,3.78793189 6.27668098,4.05059443 6.97625153,4.54731269 C8.67686503,5.754 8.88428834,6.86836533 8.90232515,6.99189474 L8.91778528,7.08941796 L7.6320184,7.60694118 L7.62828221,7.60317028 Z M4.62850307,4.50557276 C5.35667485,4.50557276 6.02377914,4.73156656 6.55586503,5.1588483 C7.32758282,5.77909598 7.6905092,6.87395666 7.80040491,7.26665015 L8.63653988,6.93026006 C8.56091411,6.6322291 8.2274908,5.73787616 6.8328589,4.74834056 C6.1657546,4.27502786 5.39828834,4.03525077 4.55120245,4.03525077 C4.0863681,4.03525077 3.72537423,4.10988854 3.54680982,4.15539938 L3.69754601,4.62611146 C3.87276074,4.57852012 4.20927607,4.50557276 4.62850307,4.50557276 Z M12.2022883,38.421548 C11.8389755,38.421548 11.4681902,38.2885263 11.2111656,38.0639628 C11.0144356,37.8928421 10.3492638,37.2759752 10.0557791,36.5204954 C9.94626994,36.2379381 9.97074847,36.0120743 10.1297301,35.8492755 C10.2392393,35.737839 10.4665031,35.6045573 10.9278589,35.6045573 L11.2561288,35.6040372 C11.6477853,35.6036471 12.3061288,35.6036471 12.869135,35.6036471 L13.4089509,35.6036471 C13.7606687,35.6036471 14.0118957,35.6803653 14.1561902,35.8299009 C14.3417117,36.0223467 14.2824479,36.2681053 14.2309141,36.3968359 C14.1407301,36.6230898 13.7671104,37.359065 13.1332454,38.0417276 C12.9064969,38.2874861 12.576681,38.4227183 12.2043497,38.4227183 L12.2022883,38.421548 Z M12.5829939,19.1873684 L11.2714601,19.1021981 C11.2714601,19.1021981 11.6066871,19.6987802 11.8239018,20.4703839 C12.0692025,21.3428916 11.5997301,22.6184954 11.5997301,22.6184954 C11.5997301,22.6184954 13.3486564,20.6199195 12.5831227,19.1869783 L12.5829939,19.1873684 Z M10.9455092,41.9167802 C6.27680982,41.554644 4.63417178,37.1019938 4.63417178,36.174613 L5.85346012,36.1751331 L5.24381595,36.1751331 L5.85346012,36.1751331 C5.85951534,36.5769288 7.10031902,40.3855356 11.0390429,40.6911084 L10.945638,41.9186006 L10.9455092,41.9167802 Z" fillRule="evenodd" />,
<path d="M9.97146964,34.5973237 C9.89529896,34.1226632 9.88735891,33.6725115 9.98035173,33.2301912 C9.6097262,32.9299934 8.94464582,32.8183256 8.44563366,32.6428477 C8.03651906,32.3644034 5.94922712,32.9270929 4.43388816,30.9518787 C2.53500426,28.4777851 2.93469846,27 2.93469846,27 C2.4475291,27.5829927 1.97650899,27.3596572 1.233643,30.0773896 C0.490777014,32.795122 1.58219788,34.6891233 3.61700472,36.5903757 C4.57788573,37.4880686 5.93711517,37.8578774 7.10524503,38 C6.71362546,37.5765326 7.77409357,37.5330257 8.50484762,37.2386289 C8.44563366,36.6019776 8.543875,35.9856295 8.98394235,35.4882004 C9.24905938,35.1880026 9.5908854,35.0096243 9.94482336,34.8660514 C9.96500994,34.8167436 9.9811592,34.7717864 10,34.7239288 C9.98788805,34.6804219 9.97712188,34.636915 9.96904725,34.5905076 L9.97146964,34.5973237 Z" fillRule="evenodd" />,
<path d="M9.88149182,37.0950887 C9.83518338,36.9690408 9.80011916,36.8402526 9.76564674,36.7110535 C9.72865917,36.5699346 9.54372131,36.1695953 9.77156475,36.6265191 C9.71297644,36.5095137 9.67465731,36.3889461 9.64639881,36.2675565 C6.02457571,36.2631722 2.87323454,33.9603307 3.48278973,29.1184449 C3.00934881,28.5354731 2.34505201,30.2939792 2.34505201,30.2939792 C2.34505201,30.2939792 0.532660956,35.1698431 5.21528763,37.0594665 C6.77616319,37.6897063 8.15505989,38.1415608 8.48055052,37.9592023 C9.15816285,38.0866203 9.77067705,37.6491517 10,37.3614335 C9.95709442,37.273063 9.91862734,37.1846924 9.88459877,37.0949517 L9.88149182,37.0950887 Z" fillRule="evenodd" />,
<path d="M10.6504258,33.0849348 C10.6559263,32.7091303 10.7440798,32.345168 10.9529559,31.9825916 C10.967431,31.9573951 10.9843669,31.9334586 11,31.90927 C9.63644341,31.8991914 8.06589257,31.7854296 6.7283912,31.3196738 C5.25916622,30.8078086 3.4208256,29.0570355 3.10382041,27 C3.10382041,27 0.336176889,28.8592436 1.1496788,32.8387658 C1.91251778,36.5756465 5.50524331,37.7938933 9.60315063,38 C9.60604566,37.9758114 9.14284172,37.1433218 9.28904046,36.6337243 C6.9628882,36.7811233 4.36026108,35.9987745 3.10526792,34.1997503 C1.95594315,32.5544243 2.27873839,29.7437639 2.7506274,29.3318025 C3.90429471,32.4977323 8.05141745,33.1415008 10.652597,33.0860687 L10.6504258,33.0849348 Z" fillRule="evenodd" />,
<path d="M11.365401,31.4086309 C10.5880234,33.3937297 9,35 9,35 C9,35 11.1844097,34.9123635 11.3049689,34.5764237 C11.3942437,34.3281204 13.2772555,30.4933609 14,26 C13.320138,26.9719681 11.4319375,31.2369431 11.365401,31.4069047 L11.365401,31.4086309 Z" fillRule="evenodd" />,
<path d="M5.87191667,22.8210526 C5.87191667,22.8210526 8.17045833,26.0861842 9.857425,28.4032895 C10.118375,28.7617105 8.17045833,28.7865789 8.17045833,28.7865789 L5.87191667,22.8210526 Z M4.77683333,16.0517105 C4.77683333,16.0517105 5.47015,17.6575 5.84925,18.5088158 C6.2615,19.4343421 7.83258333,19.8947368 7.83258333,19.8947368 C7.83258333,19.8947368 7.018,19.1013158 7.018,17.0913158 C7.018,16.2492105 5.84613333,15.9136842 5.84613333,15.9136842 L4.77796667,16.0531579 L4.77683333,16.0517105 Z" fillRule="evenodd" />,
<path d="M4.47666667,16.9592105 C4.47666667,16.9592105 5.89659167,18.5289474 8.53371667,17.65 C11.1708417,16.7710526 11.441,13.6307895 11.441,12.7515789 C11.441,11.8723684 6.43775833,13.6307895 5.76158333,14.0076316 C5.085125,14.3844737 3.80091667,15.8914474 4.47666667,16.9592105 Z M14.4358333,0.184210526 C14.4358333,0.184210526 12.002,-0.255789474 10.3790667,0.9375 C8.75556667,2.13052632 8.2824,3.07276316 8.2824,3.07276316 L11.0165667,5.08618421 C11.0165667,5.08618421 12.3383167,4.51710526 12.7434833,2.88421053 C13.14865,1.25157895 12.8780667,0.498157895 14.4335667,0.184210526 L14.4358333,0.184210526 Z" fillRule="evenodd" />,
<path d="M5.18783333,12.425 C6.23574167,11.0434211 7.96209167,10.4407895 9.3415,10.3407895 C11.6927417,10.1701316 12.8083667,10.9421053 12.8083667,10.9421053 C12.8083667,10.9421053 8.95786667,11.0934211 7.84790833,12.4473684 C5.7817,14.9671053 2.76859167,15.1718421 2.28664167,14.6184211 C2.84339167,14.6442105 3.45680833,14.3877632 4.112725,13.8114474 C4.52214167,13.4509211 4.85505833,12.8635526 5.18655833,12.425 L5.18783333,12.425 Z M11.6877833,17.3101316 C11.6877833,17.3101316 15.9596,15.9460526 15.148275,14.5647368 C14.3370917,13.1818421 14.9822417,12.4292105 14.9822417,12.4292105 C14.9822417,12.4292105 17.3683333,14.0831579 16.759875,15.8410526 C16.3863,16.92 15.7597083,17.7015789 12.3180583,19.1989474 C10.666225,22.0463158 11.9766417,27.1726316 11.898725,27.1963158 C11.766975,27.2357895 9.58105833,26.1923684 9.72980833,21.3963158 C9.77514167,19.9239474 9.901225,17.9134211 11.686225,17.3068421 L11.6877833,17.3101316 Z M6.08968333,2.64171053 C7.88035,3.48697368 10.3350083,4.66407895 10.3350083,4.66407895 L9.37025833,5.11276316 C9.46234167,5.25157895 9.507675,5.33434211 9.507675,5.33434211 L8.517425,5.75302632 C8.517425,5.75302632 6.09775833,7.38131579 4.61450833,8.42802632 C5.108925,7.01421053 6.55959167,4.79289474 6.55959167,4.79289474 C6.55959167,4.79289474 6.97184167,3.77223684 6.09209167,2.64157895 L6.08968333,2.64171053 Z M0.138833333,37.0969737 C5.644,37.0969737 7.50904167,34.5009211 7.50904167,34.5009211 L6.649125,36.4469737 C6.32385833,37.2890789 2.853875,39.9088158 0.147191667,39.9088158 L0.138833333,37.0969737 Z" fillRule="evenodd" />,
<path d="M7.90625,32.7460526 C7.90625,32.7460526 7.39908333,35.6217105 5.37126667,35.6217105 C3.64789167,35.6217105 3.14001667,33.1927632 3.14001667,32.6907895 L7.90625,32.7460526 Z M11.2817417,28.4094737 C11.1015417,27.9486842 10.4705583,26.0857895 10.2674083,24.3903947 C10.0243083,22.3598684 10.1134167,19.39 10.1134167,19.39 C10.1134167,19.39 10.6545833,21.3367105 11.1271833,21.6513158 C11.6009167,21.9651316 12.4795333,24.1 12.4795333,24.1 C12.4795333,24.1 12.9504333,27.2784211 13.17455,28.3467105 C12.554475,28.4621053 12.0327167,28.1226316 11.2818833,28.4094737 L11.2817417,28.4094737 Z M16.180575,15.8107895 C16.180575,15.8107895 15.0308083,15.4336842 14.693075,13.1105263 C14.3550583,10.7868421 15.0988083,8.77736842 15.0988083,8.77736842 C15.0988083,8.77736842 15.0308083,11.98 15.435975,12.6081579 C15.8411417,13.2361842 16.179725,13.4243421 16.6528917,14.2410526 C17.1260583,15.0575 16.4488917,15.5594737 16.179725,15.8107895 L16.180575,15.8107895 Z" fillRule="evenodd" />,
<path d="M29,5.5 L29.2391857,5 C29.9427662,5.07904762 29,5.5 29,5.5 Z" fillRule="evenodd" />,
<path d="M21.8292086,6.66092028 C21.8292086,6.66092028 22.9282014,6.46938656 23.4772662,5.60718365 C24.0269065,4.74467959 25.583741,3.01967147 28.0647482,3.00039764 C30.5456115,2.98082265 33,3.69049123 33,3.69049123 L30.857554,5.1059134 C30.6307914,5.09838456 30.2345324,5.10139609 29.578705,5.12398262 C26.8902158,5.21734025 26.476259,8 26.476259,8 L17,6.63426819" fillRule="evenodd" />,
<path d="M20,20.0448547 C20,20.0448547 21.1811477,21.3319393 22.994627,20.9179343 C24.8086366,20.5045071 25.9053409,19.6311386 25.9897843,18.1140834 C26.0739626,16.597317 25.6102528,16 25.6102528,16 C25.6102528,16 23.5853335,16.6904898 22.6152281,17.6092169 C21.6451227,18.5279439 20.9282151,19.9999295 20,20.0461548 L20,20.0448547 Z" fillRule="evenodd" />,
<path d="M21.1558371,18.7896686 C21.1558371,18.7896686 22.1588254,19.214348 23.2791102,18.8683486 C24.7466133,18.4147958 24.8441873,17 24.8441873,17 C24.8441873,17 25.743633,19.4488239 23.220462,19.9201819 C21.1970984,20.2981826 20,19.2108591 20,19.2108591 L21.1558371,18.7897889 L21.1558371,18.7896686 Z" fillRule="evenodd" />,
<path d="M21.5127363,7.07536749 C22.3279204,6.39158657 21.7207363,5.75722615 21.7851542,4.98048763 C21.8195622,4.56734276 21.8519005,4.17720848 21.9869453,3.96200707 C22.737194,2.76467138 24.507005,2.40133922 24.5252438,2.3975477 L25.3556915,2.2330742 L24.8059403,1.58289399 C24.734796,1.49869611 22.4762886,-0.678943463 18.9811642,0.461127208 C16.5363881,1.25813074 14.7267363,3.96030742 14.6594726,4.06960777 L15.8844478,4.6520636 C15.8986766,4.629053 17.3293234,2.08912721 19.4274328,1.40573852 C21.1219602,0.852699647 22.6845473,1.37867491 23.3533035,1.7234417 C22.6418607,2.01055124 21.7118109,2.53338869 21.1504179,3.42779505 C20.8852438,3.85009187 20.8412637,4.38221201 20.7985771,4.8970742 C20.7416617,5.57889399 20.6873333,6.2225371 20.1906169,6.63934276 L21.5087264,7.07536749 L21.5127363,7.07536749 Z M23.6897512,17.0553004 C23.6897512,17.0553004 22.6630746,15.7678834 22.3587065,13.262735 C22.2393134,12.2760247 22.451194,10.3297986 22.7907463,9.58103887 C22.7290448,11.4218869 23.1923881,13.262735 23.1923881,13.262735 C23.1923881,13.262735 23.5046468,16.6808551 23.6897512,17.0553004 Z" fillRule="evenodd" />,
<path d="M18.2737313,5.77513781 C18.2743781,5.77252297 18.6035821,4.31893286 19.5159104,3.58520848 C20.8027164,2.5505159 22.3742289,3.10093993 22.3888458,3.10577739 L22.617801,2.39323322 C22.5414826,2.36839223 20.7455423,1.79639576 19.0898209,2.97242049 C17.4237512,4.15511307 17.2245473,5.22719788 17.2064378,5.34565018 L18.2723085,5.77513781 L18.2737313,5.77513781 Z M20.4640697,16.132 C20.4640697,16.132 21.0029552,15.3522544 20.9055522,14.4947173 C20.8576915,14.0711131 20.6636617,13.6365265 20.316995,13.4822509 C19.6728159,13.1972332 19.387204,13.9346184 19.387204,13.9346184 C19.387204,13.9346184 20.2939701,14.1608021 20.4640697,16.1323922 L20.4640697,16.132 Z" fillRule="evenodd" />,
<path d="M14.5470647,17.3207067 C14.5246866,17.3631979 14.5130448,17.3869929 14.5130448,17.3869929 C14.5130448,17.3869929 16.1933433,18.6619894 17.9159403,17.3681661 C18.8386169,16.6752332 18.7515622,14.9612049 18.4682786,14.2342792 C17.734199,14.4029364 17.1113632,14.706258 16.5900697,15.0605689 C17.2484776,14.467 17.8246169,14.0303216 17.8225473,14.0198622 L18.5711144,13.8054452 L20.0237512,13.3020883 C20.0418607,13.4145265 20.572209,15.9273887 19.0406667,17.6388021 C18.3615622,18.3984134 15.1807662,20.0980601 13.6712139,17.1916643 L14.5443483,17.3237138 L14.5470647,17.3207067 Z" fillRule="evenodd" />,
<path d="M14.7035821,17.5076678 C13.7572338,18.9634806 11.3701493,18.1315689 11.4115423,16.5924735 C11.4115423,16.5924735 13.0064677,17.4824346 14.4159005,15.8438445 C15.2388458,14.8881201 17.8763582,12.2497456 21.4523284,13.1270247 C18.9829751,13.6761413 15.7131841,15.9562827 14.7035821,17.5094982 L14.7035821,17.5076678 Z" fillRule="evenodd" />,
<path d="M21.7869652,21.615583 C21.5593035,21.7485477 20.7560199,22.5889576 20.7560199,23.8460424 C20.7555025,24.4762191 20.8177214,27.6427915 21.1267463,29.5771201 C20.6623682,29.8820106 20.3389851,29.9468587 19.8766766,30.2576325 C19.6451343,28.0172367 19.4787861,24.7701272 19.5566567,23.4593074 C19.645005,21.9649258 20.4362587,20.9621343 21.170209,20.5346078 C21.4000697,20.4009894 21.640408,20.2695936 21.8829453,20.1374134 C23.1402587,19.4507562 24.4402587,18.7404346 24.4402587,17.5275406 C24.4402587,16.5787456 24.0749652,16.2819611 23.6887164,15.9673958 L23.6473234,15.9334028 C23.391204,15.7239541 23.1004179,15.4865265 22.9290249,15.0966537 C22.4594726,14.0307138 22.3818607,11.3155936 22.9277313,10.6261908 C23.1993731,10.2823392 23.9289254,9.12657951 23.7193731,8.35127915 C23.6391741,8.0544947 23.454199,7.83484806 23.1540995,7.67926502 C22.8358905,7.51453004 22.4064378,7.43085512 21.8773831,7.43085512 C20.8386766,7.43085512 19.6861393,7.74986572 19.092408,7.94074912 C16.9684279,8.62060777 14.4059403,10.5817385 13.6699204,11.1674629 C13.6492239,11.1831519 13.6362886,11.1936113 13.6337015,11.1949187 L13.1628557,11.5256961 L13.4564876,11.0275689 C13.474597,10.9961908 15.33599,7.9015265 18.6655423,6.76668551 C19.313602,6.54573145 20.5851443,6.17573145 21.83599,6.17573145 C22.5797711,6.17573145 23.2110149,6.3064735 23.7116119,6.56534276 C24.3208657,6.8804311 24.7335025,7.38378799 24.9055423,8.01919435 C25.3259403,9.57763958 23.9573831,11.3125866 23.9095224,11.3688057 C23.7491244,11.6564382 23.6818607,13.748311 24.0505174,14.5863675 C24.1009652,14.7014205 24.2406667,14.8151661 24.4165871,14.9589823 C24.472209,15.0034346 24.533005,15.0505018 24.5989751,15.1001837 C25.1189751,15.4963322 25.9054428,16.0964382 25.9054428,17.4783816 C25.9054428,19.3689117 24.0091244,20.3952367 22.4853433,21.2189117 C22.2356915,21.3548834 21.9963881,21.4830106 21.7816617,21.608523 L21.7869652,21.615583 Z" fillRule="evenodd" />,
<path d="M19.5245771,6.85284452 C19.2229254,6.33641343 18.4514627,5.33924382 16.6733731,4.46287986 C14.6890945,3.4854523 12.3925572,2.98941696 9.84649751,2.98810954 L9.84649751,2.98758657 L9.83744279,2.98758657 L9.83744279,2.98889399 C7.29177114,2.99020141 4.99445771,3.4870212 3.0101791,4.46366431 C1.23286567,5.34094346 0.461920398,6.33719788 0.159233831,6.85362898 L0.029880597,7.0275159 L1.55223881,7.36992933 L1.60113433,7.30848057 L1.62661692,7.25173852 C1.6499005,7.14975972 1.85427861,6.60064311 3.55191045,5.76389399 C5.36673632,4.86935689 7.48295522,4.41594346 9.84235821,4.41463604 C12.2017612,4.41568198 14.3179801,4.86922615 16.132806,5.76389399 C17.8299204,6.60064311 18.035592,7.14975972 18.0588756,7.25147703 L18.0834527,7.30808834 L18.1313134,7.3695371 L19.653801,7.02699293 L19.5244478,6.85389046 L19.5245771,6.85284452 Z" fillRule="evenodd" />,
<path d="M21.5127363,7.07536749 C22.3279204,6.39158657 21.7207363,5.75722615 21.7851542,4.98048763 C21.8195622,4.56734276 21.8519005,4.17720848 21.9869453,3.96200707 C22.737194,2.76467138 24.507005,2.40133922 24.5252438,2.3975477 L25.3556915,2.2330742 L24.8059403,1.58289399 C24.734796,1.49869611 22.4762886,-0.678943463 18.9811642,0.461127208 C16.5363881,1.25813074 14.7267363,3.96030742 14.6594726,4.06960777 L15.8844478,4.6520636 C15.8986766,4.629053 17.3293234,2.08912721 19.4274328,1.40573852 C21.1219602,0.852699647 22.6845473,1.37867491 23.3533035,1.7234417 C22.6418607,2.01055124 21.7118109,2.53338869 21.1504179,3.42779505 C20.8852438,3.85009187 20.8412637,4.38221201 20.7985771,4.8970742 C20.7416617,5.57889399 20.6873333,6.2225371 20.1906169,6.63934276 L21.5087264,7.07536749 L21.5127363,7.07536749 Z" fillRule="evenodd" />,
<path d="M19.9436816,6.6870636 L20.115204,6.54272438 C20.5718209,6.15991166 20.6230448,5.54163251 20.6781493,4.88439223 C20.7223881,4.35488693 20.7680498,3.80838516 21.0483582,3.35993993 C21.5634428,2.53757244 22.3788856,2.02375618 23.0507463,1.71651237 C22.6484577,1.54393286 21.8927761,1.28767845 20.9609154,1.28767845 C20.4460896,1.28767845 19.9439403,1.36612367 19.4661095,1.52170671 C17.5206368,2.15580565 16.1461294,4.44640636 15.9903881,4.71573498 L15.9321791,4.80856184 L14.4821294,4.11955124 L14.5558607,4.00057597 C14.5730647,3.97312014 16.3926766,1.17131802 18.9441692,0.339798587 C19.6271542,0.116229682 20.3127264,0.00379151943 20.9827761,0.00379151943 C23.439194,0.00379151943 24.8892438,1.48379152 24.9008856,1.49817314 L25.5890448,2.31138869 L24.5516318,2.51665371 C24.5348159,2.51926855 22.8079502,2.88534629 22.0939204,4.02541696 C21.976209,4.21499293 21.9451642,4.59022261 21.9115323,4.98767845 C21.8921294,5.22432155 21.9412836,5.45442756 21.9891443,5.67799647 C22.0926269,6.16043463 22.19999,6.66117668 21.5959104,7.16714841 L21.5441692,7.21029329 L19.9479502,6.68078799 L19.9436816,6.6870636 Z" fillRule="evenodd" />,
<path d="M18.2737313,5.77513781 C18.2743781,5.77252297 18.6035821,4.31893286 19.5159104,3.58520848 C20.8027164,2.5505159 22.3742289,3.10093993 22.3888458,3.10577739 L22.617801,2.39323322 C22.5414826,2.36839223 20.7455423,1.79639576 19.0898209,2.97242049 C17.4237512,4.15511307 17.2245473,5.22719788 17.2064378,5.34565018 L18.2723085,5.77513781 L18.2737313,5.77513781 Z" fillRule="evenodd" />,
<path d="M17.0720398,5.42514134 L17.0862687,5.32734629 C17.1043781,5.20366431 17.3130249,4.08268198 19.0195821,2.87018021 C19.7219701,2.37153004 20.5640597,2.10769258 21.4527164,2.10769258 C22.1279403,2.10769258 22.6039602,2.25804594 22.656995,2.2750424 L22.7747065,2.31426502 L22.4694328,3.26475972 L22.3517214,3.2255371 C22.3077413,3.21115548 21.9106269,3.08172085 21.3776915,3.08172085 C20.6934129,3.08172085 20.0945075,3.28567845 19.597791,3.68574912 C18.7259502,4.38783392 18.4025672,5.79069611 18.3999801,5.80507774 L18.3689353,5.94889399 L17.07799,5.42854064 L17.0720398,5.42514134 Z M22.3095522,2.95150177 L22.4615423,2.47847703 C22.2822587,2.43245583 21.9192935,2.35767138 21.4525871,2.35767138 C20.6022189,2.35767138 19.831403,2.5990212 19.1617413,3.07466078 C17.7612338,4.06960777 17.4264677,4.96885159 17.3505373,5.26851237 L18.1909453,5.60674205 C18.3008955,5.21190106 18.6648955,4.11079152 19.4399801,3.48741343 C19.9755025,3.05779505 20.6442587,2.83056537 21.3751045,2.83056537 C21.7955025,2.83056537 22.134408,2.90378092 22.3103284,2.95163251 L22.3095522,2.95150177 Z M12.8379204,36.5495936 C12.2018905,35.8621519 11.825602,35.1225442 11.7345373,34.8953145 C11.682796,34.7658799 11.6232935,34.5191696 11.8099502,34.3252792 C11.9553433,34.175318 12.2073234,34.098311 12.5596816,34.098311 L13.1029652,34.098311 C13.6682388,34.098311 14.3292338,34.098311 14.7224677,34.0996184 L15.0523184,34.1009258 C15.515403,34.1009258 15.7443582,34.2355901 15.8530149,34.3467208 C16.0134129,34.5101484 16.03799,34.7376396 15.9280398,35.0226572 C15.6331144,35.7822686 14.9656517,36.4032933 14.7677413,36.5745654 C14.5090348,36.8007491 14.137791,36.934106 13.7730149,36.934106 C13.3991841,36.934106 13.0680398,36.7981343 12.8403781,36.5523392 L12.8379204,36.5495936 Z M13.3884478,17.5919965 L14.7047463,17.5063604 C14.7047463,17.5063604 14.3684279,18.1062049 14.1504677,18.8820283 C13.903403,19.7593074 14.3755423,21.0418869 14.3755423,21.0418869 C14.3755423,21.0418869 12.6189254,19.0323816 13.3872836,17.5916042 L13.3884478,17.5919965 Z" fillRule="evenodd" />,
<path d="M18,14.6505627 C17.0858297,14.6505627 15.8941685,14.6262696 15,14 C15,14 16.1708142,16 17.9984506,16 L17.9998591,15.7469119 L18.0015494,16 C19.8293267,16 21,14.0002745 21,14.0002745 C20.1058315,14.6261323 18.9131843,14.6508372 18,14.6508372 L18,14.6505627 Z" fillRule="evenodd" />,
<path d="M18.0102347,15 C17.097473,15.5222743 16.2825772,15.7032145 15.5051174,15.7192539 C14.7275173,15.7033471 13.9127617,15.5222743 13,15.0001326 C13,15.0001326 14.329183,16.5338162 15.4985275,16.5457463 L15.4985275,16.5470719 L15.5049772,16.5470719 C15.5070803,16.5470719 15.5091834,16.5483975 15.511567,16.5483975 C16.6809115,16.5364674 18.0114966,15.0041093 18.0114966,15.0041093 L18.0102347,15 Z M21.1305899,43 L21.0287981,41.7493254 C25.3149926,41.4378166 26.665207,37.5548265 26.6722175,37.1461535 L27.9999992,37.1461535 C28.0014004,38.0912844 26.2123314,42.630829 21.1325529,42.9998674 L21.1305899,43 Z" fillRule="evenodd" />,
<path d="M23.0281336,34.5973237 C23.1045924,34.1226632 23.1119959,33.6725115 23.0191147,33.2301912 C23.3903704,32.9299934 24.0550771,32.8183256 24.5542128,32.6428477 C24.9623519,32.3644034 27.0515068,32.9270929 28.5669518,30.9518787 C30.4653637,28.4777851 30.0651667,27 30.0651667,27 C30.5524567,27.5829927 31.0238627,27.3596572 31.7663742,30.0773896 C32.5094241,32.795122 31.4170599,34.6891233 29.382153,36.5903757 C28.421034,37.4880686 27.0617372,37.8578774 25.8927796,38 C26.2844962,37.5765326 25.2251116,37.5330257 24.4941765,37.2386289 C24.5534052,36.6019776 24.4551395,35.9856295 24.0149632,35.4882004 C23.7511266,35.1880026 23.4092159,35.0096243 23.0551903,34.8660514 C23.0349987,34.8167436 23.0188455,34.7717864 23,34.7239288 C23.0121149,34.6804219 23.0228838,34.636915 23.0309604,34.5905076 L23.0281336,34.5973237 Z" fillRule="evenodd" />,
<path d="M24.1155631,37.0950887 C24.1626169,36.9690408 24.1969455,36.8402526 24.23157,36.7110535 C24.2693019,36.5699346 24.454262,36.1695953 24.2259472,36.6265191 C24.2845426,36.5095137 24.3228663,36.3889461 24.3511282,36.2675565 C27.9736825,36.2631722 31.1251064,33.9603307 30.5157739,29.1184449 C30.9900115,28.5354731 31.6545361,30.2939792 31.6545361,30.2939792 C31.6545361,30.2939792 33.4681807,35.1698431 28.7843995,37.0594665 C27.2237803,37.6897063 25.8447179,38.1415608 25.5191882,37.9592023 C24.8407546,38.0866203 24.2289066,37.6491517 24,37.3614335 C24.0429107,37.273063 24.0828621,37.1846924 24.1168948,37.0949517 L24.1155631,37.0950887 Z" fillRule="evenodd" />,
<path d="M15.2860541,7.68130435 C15.2816432,7.29221739 15.2021189,6.9153913 15.0155676,6.54 C15.0023351,6.51391304 14.987027,6.48913043 14.9732757,6.46408696 C16.1953297,6.45365217 17.6028973,6.33586957 18.8016,5.85365217 C20.1188757,5.32369565 21.7668324,3.51104348 22.0500324,1.38130435 C22.0500324,1.38130435 24.5312432,3.30626087 23.8021622,7.42643478 C23.1171892,11.2953913 19.8976865,12.5566957 16.225427,12.770087 C16.2234811,12.7450435 16.6386162,11.8831304 16.5073297,11.3555217 C18.5920865,11.5081304 20.924627,10.6981304 22.0506811,8.83552174 C23.0807351,7.13204348 22.7914378,4.22204348 22.3685189,3.79552174 C21.3358703,7.07334783 17.6178162,7.73986957 15.286573,7.68247826 L15.2860541,7.68130435 Z" fillRule="evenodd" />,
<path d="M16.7688649,8.65173913 C16.3301189,8.17486957 15.5234595,7.60643478 13.6635243,7.60643478 L8.71044324,7.60343478 L8.69876757,7.60343478 C7.27174054,7.60447826 3.74438919,7.60643478 3.74438919,7.60643478 C1.88536216,7.60643478 1.07844324,8.17513043 0.639956757,8.65173913 C0.000389189189,9.34565217 -0.0995027027,10.3112609 0.342875676,11.5180435 C1.51822703,14.7301304 3.17098378,17.9934783 8.70006486,17.9980435 L8.70006486,17.9985652 L8.70655135,17.9985652 C8.70914595,17.9985652 8.71044324,17.9998696 8.71303784,17.9998696 C14.2421189,17.9959565 15.8948757,14.7324783 17.070227,11.5198696 C17.5126054,10.3133478 17.4127135,9.34813043 16.7731459,8.65421739 L16.7688649,8.65173913 Z M15.9079784,11.2927826 C15.3479351,12.9057391 13.8426811,16.809913 8.70278919,16.8166957 C3.56237838,16.809913 2.05777297,12.9058696 1.4976,11.2927826 C1.18780541,10.398 1.21141622,9.73565217 1.57024865,9.32426087 C1.81543784,9.04304348 2.37846486,8.70730435 3.66149189,8.70730435 L5.00198919,8.70691304 C5.99091892,8.706 7.23256216,8.70495652 8.70317838,8.70430435 C10.1730162,8.70495652 11.4153081,8.706 12.4039784,8.70691304 L13.7440865,8.70743478 C15.0275027,8.70743478 15.5904,9.04265217 15.8355892,9.32308696 C16.1940324,9.73395652 16.2179027,10.3965652 15.9079784,11.2913478 L15.9079784,11.2927826 Z" fillRule="evenodd" />,
<path d="M14.9007568,5.33478261 C15.5616,7.28478261 16.9113081,8.86265217 16.9113081,8.86265217 C16.9113081,8.86265217 15.0548757,8.77656522 14.9523892,8.44656522 C14.8771459,8.20265217 13.2762811,4.43569565 12.6626595,0.0217826087 C13.2412541,0.976565217 14.8460108,5.16613043 14.9030919,5.33308696 L14.9007568,5.33478261 Z" fillRule="evenodd" /></svg>
);
