#!/bin/sh

set -eux

. ./extra/travis/env.sh

export CFLAGS=" -m64 -I/workdir/cache/usr/include -isystem /workdir/cache/usr/include -isystem /workdir/cache/usr/include/opus -isysroot /usr/osxcross/bin/../SDK/MacOSX10.10.sdk -mmacosx-version-min=10.10 -m64 -arch x86_64 -DNDEBUG -O3 -Wall"
export LDFLAGS="-L/workdir/cache/usr/lib -isysroot /usr/osxcross/bin/../SDK/MacOSX10.10.sdk -mmacosx-version-min=10.10 -m64 -arch x86_64"

# brew install yasm

# install libopus, needed for audio encoding/decoding
if ! [ -f $CACHE_DIR/usr/lib/pkgconfig/opus.pc ]; then
  curl https://ftp.osuosl.org/pub/xiph/releases/opus/opus-1.2.1.tar.gz -o opus.tar.gz
  tar xzf opus.tar.gz
  cd opus-1.2.1
  ./configure --prefix=$CACHE_DIR/usr --host="x86_64-apple-darwin14" --disable-extra-programs --disable-doc --disable-shared
  make -j8
  make install
  cd ..
  # rm -rf opus**
fi

# install libvpx, needed for video encoding/decoding
if ! [ -d libvpx ]; then
  git clone --depth=1 --branch=v1.6.0 https://chromium.googlesource.com/webm/libvpx
fi
cd libvpx
git rev-parse HEAD > libvpx.sha
if ! ([ -f "$CACHE_DIR/libvpx.sha" ] && diff "$CACHE_DIR/libvpx.sha" libvpx.sha); then
  ./configure --target="x86_64-darwin14-gcc" --prefix=$CACHE_DIR/usr --enable-static --disable-examples --disable-unit-tests --disable-shared
  make -j8
  make install
  mv libvpx.sha "$CACHE_DIR/libvpx.sha"
fi
cd ..
# rm -rf libvpx

# install toxcore
if ! [ -d toxcore ]; then
  git clone --depth=1 --branch=$TOXCORE_REPO_BRANCH $TOXCORE_REPO_URI toxcore
fi
cd toxcore
git rev-parse HEAD > toxcore.sha
if ! ([ -f "$CACHE_DIR/toxcore.sha" ] && diff "$CACHE_DIR/toxcore.sha" toxcore.sha); then
  if [ -d _build ]; then
    rm -rf _build
  fi
  cmake -B_build -H. -DCMAKE_INSTALL_PREFIX:PATH=$CACHE_DIR/usr -DENABLE_STATIC=ON -DENABLE_SHARED=OFF -DCMAKE_SYSTEM_NAME=Darwin -DBUILD_TOXAV=ON
  # mkdir _build
  # autoreconf -fi
  # (cd _build && ../configure --prefix=$CACHE_DIR/usr)
  make -C_build -j8 VERBOSE=1
  make -C_build install
  mv toxcore.sha "$CACHE_DIR/toxcore.sha"
fi
cd ..
# rm -rf toxcore

ls -la $CACHE_DIR

cmake . -DCMAKE_SYSTEM_NAME=Darwin \
        -DENABLE_ASAN=OFF \
        -DENABLE_FILTERAUDIO=OFF \
        -DSTATIC_ALL=OFF \
        -DSTATIC_TOXCORE=ON \
        -DENABLE_TESTS=OFF \
        -DENABLE_WERROR=OFF

make || make VERBOSE=1
