# μTox [![IRC: #utox on libera.chat](https://img.shields.io/badge/libera.chat-%23utox-brightgreen.svg)](https://web.libera.chat/?channels=#utox) ![Actions Build Status](https://github.com/uTox/uTox/workflows/.github/workflows/ci.yaml/badge.svg) [![AppVeyor Build Status](https://ci.appveyor.com/api/projects/status/github/utox/utox?branch=develop&svg=true)](https://ci.appveyor.com/project/utox/utox)

The lightweight [Tox](https://github.com/TokTok/toxcore) client.

[**Installing**](docs/INSTALL.md) **|** [**Compiling**](docs/BUILD.md) **|** [**Screenshots**](screenshots/INDEX.md) **|** [**Release Notes**](release_notes/INDEX.md) **|** [**TokTok Site**](http://toktok.github.io/) **|** [**Toxcore Spec**](https://toktok.github.io/spec)

Tox is a peer-to-peer, end-to-end encrypted, instant messaging protocol, with end-to-end encryption as its default and *only* mode.

µTox is **cross-platform**: Primary support for Windows 7+ and Linux, secondary support for OpenBSD, FreeBSD, NetBSD, and DragonFlyBSD. MacOS is unmaintained (needs your contributions).

µTox is **multi-lingual**: Complete translations for German, Russian, Swedish, Polish, Spanish, Hungarian, Estonian, Ukrainian, and Bulgarian. Partial translations to many more languages.

## Features
- Themes
- Avatars
- Text
  - Chat History
- Audio
- Video (Webcam or Desktop sharing)
- Screenshots
- File transfers, with inline images support
- Group chats
  - Text
- Tox URI support (clickable Tox links)

Just like Toxcore, µTox is still alpha software, so you may encounter bugs, or maybe a crash or two. µTox also needs your help, if you do encounter any bugs or problems please [open an issue](https://github.com/uTox/uTox/issues/new).
If you do not have a GitHub account, you may also [send an email](#team) directly to avoidr.

## Downloads
- **Windows**
  - [x64](https://github.com/uTox/uTox/releases/download/v0.18.1/utox_x86_64.exe)
- **Linux/Posix**
  - [Install](docs/INSTALL.md) via your package manager, or [build](docs/BUILD.md).
- **macOS**
  - [Last Updated .dmg](https://github.com/uTox/uTox/releases/download/v0.16.1/uTox-0.16.1.dmg) (out of date)
- **Android**
  - [uTox Android on Google Play](https://play.google.com/apps/testing/tox.client.utox) ** uTox isn't designed to work well on Android,
    you should use [aTox](https://github.com/evilcorpltd/aTox/) instead!
  - [Direct apk](https://build.tox.chat/view/uTox/job/uTox_build_android_armhf_release/lastSuccessfulBuild/artifact/uTox.apk) (You may need to uninstall the previous version.)

## Team
GitHub | IRC | Email | Fingerprint
--- | --- | --- | ---
[cebe](https://github.com/cebe) | CeBe | mail@cebe.cc | `E592 6050 AE9C 234A FF84 96FE BE4F 41DE 1DEE EED0`
[endoffile78](https://github.com/endoffile78) | e0f/endoffile | endoffile78@yahoo.com | `2D8C F71C 404A 1688 5B02  1461 BF80 7C5D F95E C4E3`
[GrayHatter](https://github.com/GrayHatter) | grayhatter | greg@grayhatter.com | `9D1D 5990 88E2 23DD 9900 7DE2 AEA1 0D4E A053 0876`
[robinlinden](https://github.com/robinlinden) | robinli | dev@robinlinden.eu | `B700 8FF1 2C07 9BF6 E6EA 19D1 601A 604B 7E60 5776`
[dkmoz](https://github.com/dkmoz) | dkmoz | dkmoz@airmail.cc | `E28E 7252 B1E7 FCFE D358  CF8E 3763 B3A7 93AA FA0F`
[redmanmale](https://github.com/redmanmale) | redmanmale | redmanmale@gmail.com | `BCEE 99DC A339 ABF9 CC36  428D 61A9 B9AF D2E5 3885`
[avoidr](https://github.com/avoidr) | avoidr | avoidr@posteo.de | `A251 56FC 7AFB 5C03 65A0  407E 6F5D D1C5 371D E665`
