<?php
/* Copyright (C) 2018 Michael Giesler
 *
 * This file is part of Dembelo.
 *
 * Dembelo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dembelo is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License 3 for more details.
 *
 * You should have received a copy of the GNU Affero General Public License 3
 * along with Dembelo. If not, see <http://www.gnu.org/licenses/>.
 */

namespace AdminBundle\IntegrationTests\Controller;

use DembeloMain\Document\Importfile;
use DembeloMain\Document\Licensee;
use DembeloMain\Document\Textnode;
use DembeloMain\Document\TextnodeHitch;
use DembeloMain\Document\Topic;
use DembeloMain\IntegrationTests\WebTestCase;

/**
 * @group integration
 */
class ImportfileControllerTest extends WebTestCase
{
    private const TMP_PATH = '/tmp/dembelotest/';

    /**
     * @throws \Doctrine\ODM\MongoDB\MongoDBException
     */
    public function tearDown(): void
    {
        parent::tearDown(); // TODO: Change the autogenerated stub
        @unlink(self::TMP_PATH);
        @rmdir(self::TMP_PATH);
    }

    /**
     * @return void
     */
    public function testImportAction(): void
    {
        $teststorySourcePath = __DIR__.'/../Fixtures/teststory.html';
        @mkdir(self::TMP_PATH);
        $teststoryPath = self::TMP_PATH.'teststory.html';
        copy($teststorySourcePath, $teststoryPath);

        $licensee = new Licensee();
        $licensee->setName('some Licensee');
        $this->getMongo()->persist($licensee);

        $topic = new Topic();
        $topic->setName('some Topic');
        $this->getMongo()->persist($topic);

        $importfile = new Importfile();
        $importfile->setTopicId($topic->getId());
        $importfile->setName('some importfile name');
        $importfile->setOriginalname('some importfile original name');
        $importfile->setFilename($teststoryPath);
        $importfile->setAuthor('some author name');
        $importfile->setPublisher('some publisher name');
        $importfile->setLicenseeId($licensee->getId());
        $this->getMongo()->persist($importfile);

        $this->getMongo()->flush();

        $parameters = [
            'importfileId' => $importfile->getId(),
        ];
        $client = static::createClient();
        $client->request('POST', '/admin/import', $parameters);
        $response = $client->getResponse();
        self::assertEquals(200, $response->getStatusCode());

        $textnodes = $this->getMongo()->getRepository(Textnode::class)->findAll();
        self::assertCount(4, $textnodes);
        $textnodeHitches = $this->getMongo()->getRepository(TextnodeHitch::class)->findAll();
        self::assertCount(4, $textnodeHitches);

        $accessTextnodes = $this->getMongo()->getRepository(Textnode::class)->findBy(['access' => true]);
        self::assertCount(1, $accessTextnodes);
        $accessTextnode = $accessTextnodes[0];
        self::assertEquals('1', $accessTextnode->getTwineId());
        self::assertEquals(2, $accessTextnode->getChildHitches()->count());
        self::assertEquals(0, $accessTextnode->getParentHitches()->count());
    }
}
