package com.perflyst.twire.activities;

import static com.perflyst.twire.misc.Utils.getSystemLanguage;

import android.content.Intent;

import com.perflyst.twire.R;
import com.perflyst.twire.activities.main.LazyMainActivity;
import com.perflyst.twire.adapters.MainActivityAdapter;
import com.perflyst.twire.adapters.StreamsAdapter;
import com.perflyst.twire.model.Game;
import com.perflyst.twire.model.StreamInfo;
import com.perflyst.twire.service.JSONService;
import com.perflyst.twire.service.Service;
import com.perflyst.twire.views.recyclerviews.AutoSpanRecyclerView;
import com.perflyst.twire.views.recyclerviews.auto_span_behaviours.AutoSpanBehaviour;
import com.perflyst.twire.views.recyclerviews.auto_span_behaviours.StreamAutoSpanBehaviour;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;

public class GameActivity extends LazyMainActivity<StreamInfo> {
    private Game game;

    @Override
    protected MainActivityAdapter<StreamInfo, ?> constructAdapter(AutoSpanRecyclerView recyclerView) {
        return new StreamsAdapter(recyclerView, this);
    }

    @Override
    public void customizeActivity() {
        Intent intent = getIntent();
        game = intent.getParcelableExtra(getString(R.string.game_intent_key));
        assert game != null;
        mTitleView.setText(game.getGameTitle());
    }

    @Override
    protected int getActivityIconRes() {
        return R.drawable.ic_sports_esports;
    }

    @Override
    protected int getActivityTitleRes() {
        return R.string.my_streams_activity_title;
    }

    @Override
    protected AutoSpanBehaviour constructSpanBehaviour() {
        return new StreamAutoSpanBehaviour();
    }

    @Override
    public void addToAdapter(List<StreamInfo> streamsToAdd) {
        mAdapter.addList(streamsToAdd);
    }

    @Override
    public List<StreamInfo> getVisualElements() throws JSONException, MalformedURLException, UnsupportedEncodingException {
        String languageFilter = settings.getGeneralFilterTopStreamsByLanguage() ? "&language=" + getSystemLanguage() : "";

        String url = "https://api.twitch.tv/helix/streams?game_id=" + game.getGameId() + "&first=" + getLimit() + (getCursor() != null ? "&after=" + getCursor() : "") + languageFilter;

        List<StreamInfo> mResultList = new ArrayList<>();
        String jsonString = Service.urlToJSONStringHelix(url, this);
        JSONObject fullDataObject = new JSONObject(jsonString);
        JSONArray topStreamsArray = fullDataObject.getJSONArray("data");
        setCursor(fullDataObject.getJSONObject("pagination").getString("cursor"));

        for (int i = 0; i < topStreamsArray.length(); i++) {
            JSONObject streamObject = topStreamsArray.getJSONObject(i);
            mResultList.add(JSONService.getStreamInfo(getBaseContext(), streamObject, false));
        }

        return mResultList;
    }
}
