# Contributing to Twire
Thanks for contributing, contributions are highly appreciated. This document should help give information if you want to contribute to any part of Twire.

## Problems
Notice something wrong or have an idea for how something can be better? Check the following things before submitting an issue so that we can effectively tackle the problem.
### Is there another issue / discussion about this?
It's very likely that someone may be experiencing the same problem as you and has already opened an issue / discussion about it. This includes closed issues that might have already addressed the problem.

If there is an open issue about the problem, avoid adding noise to the issue. You can do this by using [reactions](https://github.blog/2016-03-10-add-reactions-to-pull-requests-issues-and-comments/) instead of leaving a comment. If you just want to say that you also have a problem or agree with a suggestion, try using the thumbs up reaction (👍). Information that can help reproduce the issue is not noise and should be mentioned in a comment.
### Is this happening on the latest version?
Be sure to check that you're running the very latest version, as we may have already addressed the problem.
### Is this better for multiple issues?
Consider if it would be better to have multiple issues for the problem. Discussions can get messy when multiple things are being discussed on the same issue.

## Localization
All localization is done over on [Weblate](https://hosted.weblate.org/engage/twire/).

## Development
It's recommended to use [Android Studio](https://developer.android.com/studio/) when developing Twire.  JDK 11 is required but should be included with the latest versions of Android Studio. Setting up should be as simple as cloning this repository and opening it up in Android Studio.
