---
title: 静的コンテンツ
page_id: "070.030"
---

## 静的コンテンツ

ブラウザからアクセス可能な静的コンテンツは、public ディレクトリに置きます。公開するファイルのみここに保存してください。

例えば、HTMLファイルが *public/sample.html* にあるとします。<br>
アプリケーションサーバ（APサーバ）を起動した状態で、ブラウザから *http://URL:PORT/sample.html* にアクセスすると、その内容が表示されます。

ジェネレータコマンドでアプリケーションのスケルトンを作成した直後は、次のサブディレクトリが作成されます。

<div class="table-div" markdown="1">

| ディレクトリ      | ファイルの種類                    | URLパス    |
|----------------|------------------------------|-------------|
| public/images/ | 画像ファイル                  | /images/... |
| public/js/     | Javascript ファイル             | /js/...     |
| public/css/    | カスケーディングスタイルシート (CSS) | /css/...    |

</div><br>

public ディレクトリには、自由にサブディレクトリを作って構いません。

## インターネットメディアタイプ（MIMEタイプ）

Webサーバが静的コンテンツを返す際、レスポンスのContent-Typeヘッダフィールドにインターネットメディアタイプ（MIMEタイプ）を設定するのがお約束になっています。"text/html" とか ”image/jpg” という文字列のことです。この情報のおかげで、ブラウザは送られてきたデータが何のフォーマットなのか判断することができるのです。

TreeFrog Framework は、ファイル拡張子を config/initializers/internet_media_types.ini ファイルに定義されている内容と照らしあわせて、このタイプを返します。ファイルには、１行毎にファイル拡張子とインターネットメディアタイプを”=”でつなげて定義します。次のようになります。

```
 pdf=application/pdf
 js=application/javascript
 zip=application/zip
   :
```

**インターネットメディアタイプが足りない場合、このファイルに追記します。**その後、追加した定義情報を反映させるためにAPサーバを再起動してください。

## エラー表示

アプリケーションサーバはエラーや例外が発生したとしても何らかのレスポンスを返さなければならない宿命にあります。レスポンスのためのステータスコードは [RFC](http://www.ietf.org/rfc/rfc2616.txt){:target="_blank"} で定義されています。<br>
本フレームワークでは、エラー／例外発生時のレスポンスとして次のファイルの内容が返されます。

<div class="table-div" markdown="1">

| 原因                    | 静的ファイル     |
|--------------------------|-----------------|
| リソース未検出                | public/404.html |
| リクエストエンティティ過大 | public/413.html |
| その他エラー    | public/500.html |

</div><br>

これらの静的ファイルを編集することで、表示する内容を変更することができます。

アクションの中から次のように関数を呼び出すことで、エラーを示す静的ファイルを返却することができます。こうすることで、レスポンスのステータスコードに 401 がセットされ、public/401.html の内容が返されます。

```c++
renderErrorResponse(401);
```

また、ブラウザへエラー画面を表示させる別の方法としては、該当する URL へリダイレクトさせることです。

```c++
redirect(QUrl("/401.html"));
```

## ファイルの送信

コントローラからファイルを送信するには、sendFile メソッドを使います。その第１引数にファイルパス、第２引数にはコンテントタイプを指定します。送信するファイルは、public ディレクトリになくとも構いません。

```c++
sendFile("filepath.jpg", "image/jpeg");
```

この関数でファイルを送ると、Webブラウザ側ではファイルのダウンロード処理が実行されることになります。ダイヤログが表示され、ファイルを開くか保存するかを尋ねられます。<br>
この関数は HTTP レスポンスとしてファイルを送ることから、render() メソッドと同等の処理が行われます。したがって、コントローラはもう render() メソッドでテンプレートを出力することはできません。

ちなみに、ここでのファイルパスは絶対パスで指定する方が確実に動作します。<br>Tf::app()->webRootPath() 関数を使えば、アプリケーションルートディレクトリの絶対パスが取得できるので、簡単にファイルへの絶対パスを作りだせるでしょう。この関数を使うには、TWebApplication ヘッダファイルをインクルードしてください。

```c++
#include <TWebApplication>
```

## データの送信

ファイルではなく、メモリ上のデータを送るには、次のように sendData() メソッドを使います。ファイルアクセス処理が省略されるので、sendFile() メソッドよりオーバヘッドが抑えられるでしょう。

```c++
QByteArray data;
data = ...
sendFile(data, "text/plain");
```

同様に、Webブラウザ側ではファイルのダウンロード処理が実行されることになり、このあと render() メソッドは呼べません（呼んでも動作しない）。