---
title: セキュリティ
page_id: "100.0"
---

## セキュリティ

Web サイトを公開するからには、その脅威を理解し、セキュリティ対策を講じなければなりません。アプリ開発者は、Webの脆弱性を埋め込んでしまわないよう慎重にプログラミングしていく必要があります。詳しい内容はネット上にたくさん記事が見つかるので、ここでは割愛します。

TreeFrog にはセキュリティに関する仕組みが実装されているので、正しく使いこなすことで安全な Web サイトを構築することができます。

## SQL インジェクション対策

ご存じのとおり、SQL インジェクションとは SQL 文の組み立て方法に問題があり、データベースを攻撃されたり不正利用されてしまうことです。TreeFrog を通じてできる SQL インジェクション対策は次のとおりです。

* ORM オブジェクトを使う → 内部で安全なSQLクエリ文が作成される
* SQL 文を組み立てる場合は、TSqlQuery のプレースホルダを使う → 値は自動的にエスケープ処理が施される
* 文字列連結などにより SQL 文を組み立てる場合は、フイールド名にはTSqlQuery::escapeIdentifier() メソッドを使い、値に対しては TSqlQuery::formatValue()メソッドを使う  → それぞれエスケープ処理が施される

## クロスサイト・スクリプティング対策 (CSRF)

Web ページの生成処理の中に不備があると、悪意のあるスクリプトの混入を許し、クロスサイト・スクリプティング攻撃が成立する場合があります。この対策をするには、ビューの中で動的に出力する全ての値や属性に対してエスケープ処理を施すことです。TreeFrog では次を行います。

* eh() メソッドか、<%= … %> を使って値を出力する。

エスケープ処理を**せず**に出力する箇所（echoメソッドと <%== … %>）については、慎重を期すべきです。

基本的に \<script> … \</script> 要素のコンテントにおいては、外部からの入力に依存した情報を動的に出力しないようお勧めします。

## CSRF 対策

利用者からのリクエストを何も検証せずに受け付けてしまうサイトには、CSRF（クロスサイト・リクエスト・フォージェリ）の脆弱性が存在する可能性があります。HTTPリクエストが第３者によって捏造されたものならば、破棄されなければなりません。

この対策として、次の２つを実施します。

* フォームの情報は、POSTメソッドのリクエストだけ受け付けるようにする。
* フォームの情報の１つに、hidden パラメータとして予測困難な文字列を入れておき、受け付けた際にでそれを検証する。<br>→ formTag() メソッドを使って form タグを生成することで、その hidden パラメータが自動的に付与されます。

この hidden パラメータが容易に推測されるようだと CSRF 対策としては不十分だと言えます。このパラメータは、application.ini 設定ファイルにある Session.Secret パラメータをソルトにしてセッション情報をハッシュ関数で変換した文字列なので、Session.Secret を知らずに推測するのは十分に困難だと考えられます。

CSRF 対策を有効にするには、application.ini ファイルで次のように設定します。

```
 EnableCsrfProtectionModule=true
```

あとは、フレームワークがその処理をしてくれます。フレームワークが CSRF を検知すると、リクエストは破棄され、その旨のログが出力されます。ただし、アプリの開発中はオフにしておいてよいでしょうね。

##### 結論： フォームは formTag() メソッドで生成せよ。

## セッションハイジャック対策

セッションIDが容易に推測されたり、あるいは盗まれたりすると、第三者による成りすましが可能になります。このような成りすまし行為をセッションハイジャックと呼びます。

TreeFrog Frameworkでは、セッションハイジャックに対する防衛策として、乱数とハッシュ関数を使った十分に長いIDをアクセスのたびに再生成しています。これにより、セッションIDを推測するのは極めて困難であり、一般的なサイトではこれで十分と考えられます。

セッションIDは推測が困難なのですが、ネットワークを盗聴されて奪われてしまっては元も子もありません。この対策として、リバースプロキシ(Apacheや nginxなど)で通信路を暗号化(SSL)することが有効です。

##### 結論： 重要な情報を扱うサイトは SSL で暗号化せよ。
