---
title: 独自ヘルパーの作成
page_id: "080.090"
---

## 独自ヘルパーの作成

ヘルパーを作成すると、モデル／コントローラ／ビューからアクセス可能なものになります。同じようなコードが何回か現れたら、ヘルパーとして切り出すことを検討してみてください。

## ヘルパーの作り方

helpers ディレクトリに好きなようにクラスを実装していきますが、T_HELPER_EXPORT というおまじないだけ付けてください。あとは自由です。

```c++
#include <TGlobal>

class T_HELPER_EXPORT SampleHelper
{
    // Write as you like.
};
```

作成したヘッダとソースのファイル名をプロジェクトファイル（helpers.pro）に追加し、make を実行してください。

## ヘルパーの使い方

ヘッダファイルをインクルードして、通常のクラスと同じように使ってください。通常のクラスを使用する場合と、特に変わりありません。