---
title: Webサーバ・リバースプロキシとの連携
page_id: "140.0"
---

## Webサーバ・リバースプロキシとの連携

TreeFrog Framework には、個々のリクエストに応じて動的なコンテンツを送り返すアプリケーションサーバ（APサーバ）があります。すでに説明したとおり、このアプリケーションサーバはWebサーバの機能も持っており、静的なコンテンツも処理することが可能です。Web サーバ機能と言っても、単に１機能に特化しており、静的コンテンツを高速に返すだけの実装です。

中小規模の Webサイトであればこれで十分なのですが、大規模な Web システムになると Apache や nginx のWebサーバ（リバースプロキシ）と連携させて、負荷分散と安定稼働を図ることが必要になってきます。
また、SSL や圧縮レスポンスに対応したい場合も、別途Webサーバを立ち上げなければなりません。

##### 結論：  規模の大きいサイトでは Web サーバもたてろ。

<div class="center aligned" markdown="1">

**サーバサイドの役割分担**

</div>

<div class="table-div" markdown="1">

| サーバ                        | 役割                                                   |
|-------------------------------|--------------------------------------------------------|
| Webサーバ（リバースプロキシ） | 負荷分散、暗号化、圧縮、キャッシュ、静的コンテンツなど |
| APサーバ,（TreeFrog）         | 動的コンテンツ（静的コンテンツ）                       |
| DBサーバ,（RDB）              | データストア、永続化                                   |

</div><br>

Apache や nginx のリバースプロキシ設定については、ネット上に記事がたくさん見つかるので詳しくは書きませんが、基本的な考え方としてはリバースプロキシは80番ポートでリッスンし、受けたリクエストをアプリケーションサーバへ転送させるのです。当然ながら、アプリケーションサーバは、他のサービスと重複しないポート番号を割り当てる必要があります。ポート番号の設定は、application.ini ファイルの ListenPort パラメータで行います。

同一ホストでリバースプロキシとアプリケーションサーバを稼働させる場合は、それらのコネクションに UNIX ドメインソケットを使うことができます。UNIX ドメインソケットを使うメリットとして、TCPソケットよりオーバーヘッドが少ないこと、外部ホストから接続できないのでセキュリティ面でちょっと安心であることです。

アプリケーションサーバをUNIXドメインソケットに対応させる設定は、次のように ListenPort パラメータで行います。

```
 ListenPort=unix:/tmp/foo
```

※ ファイル名は適宜変更してください。

nginx でUNIXドメインソケットへのリバースプロキシをするためには、例えば次のエントリを追加します。

```
upstream backend  {
    server unix:/tmp/foo;
}
server {
    listen 80;
    server_name localhost;
    location / {
        proxy_pass        http://backend;
    }
}
```

このように設定し保存すれば完了です。あとは Web サーバと AP サーバを起動し、正常に動作するかブラウザからアクセスしてみて下さい。<br>
正常に動作しない場合は、アクセスログなどを調べてみて下さい。