---
title: セッション
page_id: "050.010"
---

## セッション

Webサイトでは、様々な情報がページ間で引き継がれます。例えば、ショッピングカートが分かりやすい例で、選択した商品、個数がページをまたいで引き継がれていますね。

HTTPはひとつひとつの通信において情報を保持しないプロトコル（ステートレス）であるので、これを実現するためには何らかの仕組みが必要になってきます。このソフトウェアの仕組みがセッションと呼ばれ、フレームワーク（あるいは言語）によって提供されます。

※ また別の意味として、Webサイトに訪れたユーザがそこを去るまでの"一連の通信"を指す場合もあります。

## セッションにデータを追加する

セッションへデータを追加するには次のとおりです。セッションへのアクセスはアクションの中で行なってください。

```
 session().insert("name", "foo");
  or
 session().insert("index", 123);
```

あるいは、次にようにも書けます。

```
 session()["name"] = "foo";
  or
 session()["index"] = 123;
```

## セッションからデータを読み込む

セッションからデータを読み込むには次のとおりです。

```
 QString name = session().value("name").toString();
  or
 int index = session().value("index").toInt();
```

あるいは、次のようにも書けます。

```
 QString name = session()["name"].toString();
  or
 int index = session()["index"].toInt();
```

## セッションの保存先を設定する

これまで見てきたように、セッションは文字列をキー、データを値とした「連想配列（ハッシュ）」と考えることができます。セッション自体もひとつのオブジェクトなわけですが、ページ間で引き継ぐためにはどこかに保存（永続化）する必要があります。

TreeFrog Frameworkでは、セッションの保存先としてファイル、RDB（SqlObject）、クッキーから１つ選択することができます。この設定は application.ini の Session.StoreType で行います。

## セッションの保存先をクッキーに設定

保存先をクッキーに設定するには、次のように記述するだけです。

```
 Session.StoreType=cookie
```

クッキーに保存するということはセッションの内容がクライアント（ブラウザ）側に保存されることになるので、その気になればユーザは中身を見ることが可能です。ユーザに見せるべきでない情報についてはサーバサイド（RDBなど）に保存し、必要最低限の情報だけをセッションに置くようにするべきです。

## セッションの保存先をファイルに設定

保存先をファイルに設定するには、次のように記述するだけです。セッションファイルは、アプリケーションルートディレクトリ下の tmp ディレクトリに作られていきます。

```
 Session.StoreType=file
```

この方式は、APサーバが複数のマシンで並列化されている場合にはあまり使われません。というのも、あるユーザのリクエストがいつも同じAPサーバに届くわけではないことから、そのセッションファイルの保存先として共有ファイルサーバが必要になります。さらに、安全かつ正常に動作させるためには、ファイルロック機構も持っている必要があるのです。

## セッションの保存先をRDBに設定

前提として、database.ini ファイルでデータベース情報の設定が済んでいるとします。<br>
RDBにセッションを保存するためには、テーブルが必要です。次のようなSQL文でデータベースに 'session' テーブルを作りましょう。
MySQLの例：

```sql
 > CREATE TABLE session (id VARCHAR(50) PRIMARY KEY, data BLOB, updated_at TIMESTAMP);
```

*application.ini* ファイルも編集します。

```
 Session.StoreType=sqlobject
```

これで設定は完了です。あとは必要に応じて、システムがセッションをDBに保存してくれます。

## セッションの有効期間

セッションの有効期間は、設定ファイルの Session.LifeTime に秒単位で設定します。有効期限が過ぎると、そのセッションは破棄または消去されるので、ゴミが残ることはありません。<br>
また、ブラウザが起動している間のみ有効とするには 0 を指定します。この場合、ブラウザを閉じるとそのセッションは破棄されます。

### コラム

セッションはブラウザ毎に１つずつ割り当てられます。PCが異なればセッションは異なるし、同じPCであってもブラウザが変わればセッションも異なります。

フレームワークは、数あるセッションの中からどのようにしてその１つを見つけ出しているのでしょうか。

セッションには、一意でかつ推測されづらいIDが割り振られます。IDはクッキーとしてPC（ブラウザ）に保存され、有効期限内であればHTTPリクエストに乗って再び送られてきます。フレームワークは、このIDをキーにして保存先からセッションを見つけ出しているのです。